/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.IncludeItemsOperation;
import com.nuix.automate.workflow.core.execution.options.general.ToInclude;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import nuix.BulkAnnotater;

public class IncludeItemsOperationImplementation
extends IncludeItemsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(IncludeItemsOperation.class);
    private transient int stageCount;
    private transient int stageId;
    private transient String stageName;

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.startTriggerThread = new Thread(() -> {
            try {
                String query;
                this.executionContext.closeAllTabs();
                this.stageId = 0;
                this.addExecutionLog(this.iu.getFormattedString("IncludeItemsOperation.Log.ScopeQuery", (Object)this.scope));
                long scopeCount = this.executionContext.nuixCase.count(this.scope);
                this.addExecutionLog(this.iu.getNumeralString("IncludeItemsOperation.Log.ScopeCount", scopeCount));
                this.addExecutionLog(this.iu.getFormattedString("IncludeItemsOperation.Log.Include", (Object)this.exclusionsToInclude.toString()));
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                if (this.exclusionsToInclude == ToInclude.ALL) {
                    this.stageCount = 1;
                    query = NuixUtils.addAndQuery(this.scope, "has-exclusion:1");
                } else {
                    this.stageCount = this.inclusions.size() + 1;
                    this.addExecutionLog(this.iu.getFormattedString("IncludeItemsOperation.Log.SearchedFor", (Object)this.inclusions.size()));
                    StringBuilder stringBuilder = new StringBuilder("exclusion:(");
                    for (Object[] inclusion : this.inclusions) {
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        String inclusionName = (String)inclusion[0];
                        try {
                            inclusionName = this.executionContext.evalParameters(inclusionName, this);
                            if (inclusionName.length() == 0) {
                                this.addExecutionLog(this.iu.getString("IncludeItemsOperation.Log.SkippedBlankInclusionName"));
                                continue;
                            }
                            this.stageName = this.iu.getString("IncludeItemsOperation.Stage.SearchingForItems");
                            String exclusionQuery = NuixUtils.addAndQuery(this.scope, "exclusion:\"" + inclusionName + "\"");
                            long excludedCount = this.executionContext.nuixCase.count(exclusionQuery);
                            this.addExecutionLog(this.iu.getNumeralFormattedString("IncludeItemsOperation.Log.InclusionName", excludedCount, (Object)inclusionName));
                            stringBuilder.append("\"");
                            stringBuilder.append(inclusionName);
                            stringBuilder.append("\" OR ");
                            ++this.stageId;
                        }
                        catch (ParameterException e) {
                            this.addWarning(e.getLocalizedMessage());
                        }
                        catch (IOException e) {
                            LOGGER.error("Error running query ", (Throwable)e);
                            this.exception = e;
                            this.executionState = ExecutionState.ERROR;
                            return;
                        }
                    }
                    String queryRight = stringBuilder.substring(0, stringBuilder.length() - 4) + ")";
                    query = NuixUtils.addAndQuery(this.scope, queryRight);
                }
                this.stageName = this.iu.getString("IncludeItemsOperation.Stage.IncludingItems");
                try {
                    BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                    Set excludedItems = this.executionContext.nuixCase.searchUnsorted(query);
                    bulkAnnotater.include((Collection)excludedItems);
                    this.addExecutionLog(this.iu.getNumeralString("IncludeItemsOperation.Log.TotalIncluded", (long)excludedItems.size()));
                    ++this.stageId;
                }
                catch (IOException e) {
                    LOGGER.error("Error applying inclusion", (Throwable)e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.stageCount > 0) {
            percentageComplete = (double)this.stageId / (double)this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        return result;
    }
}

