/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.services.metrics.Activity;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.formbuilder.ComparisonOperator;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroups;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ConfigureRelativityConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.NuixQueryMimeTypeVolumesUtilizationOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RelativitySetWorkspaceOperation;
import com.nuix.automate.workflow.core.execution.operations.RemoteWorkerBasedOperation;
import com.nuix.automate.workflow.core.execution.options.export.LegalExportType;
import com.nuix.automate.workflow.core.execution.options.legalexport.ExportMode;
import com.nuix.automate.workflow.core.execution.options.legalexport.ExportScheme;
import com.nuix.automate.workflow.core.execution.options.legalexport.MailType;
import java.util.List;

@FormFieldRows(value={@FormFieldRow(name="mailTypeRow", children={"mailTypeEnabled", "mailType"}), @FormFieldRow(name="exportSchemeRow", children={"exportSchemeEnabled", "exportScheme"}), @FormFieldRow(name="exportSplitRow", children={"exportSplit", "exportSplitAt", "exportConsolidateSplits"}), @FormFieldRow(name="tagFailedItemsRow", children={"tagFailedItems", "failedItemTagName", "untagSuccessfulItems"})})
@FormFieldGroups(value={@FormFieldGroup(name="RingtailMappingFileGroup", children={"metadataMappingFile"}, visibleOn={@OnField(name="legalExportType", value={"RINGTAIL"})}), @FormFieldGroup(name="RelativityMappingFileGroup", children={"relativityMappingLocation"}, visibleOn={@OnField(name="legalExportType", value={"RELATIVITY"})}), @FormFieldGroup(name="fileTypesGroup", children={"exportFileTypeNative", "exportFileTypeText", "exportFileTypePdf", "exportFileTypeImage", "exportFileTypeXhtmlReport", "exportFileTypeThumbnail"})})
@OperationMetadata(alias=OperationAlias.LEGAL_EXPORT, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"EXPORT", "PRODUCTION"})})
@OperationLicenseModule(module=ModuleType.WORKFLOW_LEGAL)
public class LegalExportOperation
extends NuixQueryMimeTypeVolumesUtilizationOperation
implements RemoteWorkerBasedOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LegalExportOperation.class);
    @FormField(visibleOn={@OnField(name="exportMode", comparisonOperator=ComparisonOperator.NOT_EQUAL, value={"ANY_PRODUCTION_SET"})})
    public String productionSetName = "{last_production_set_name}";
    @FormField
    public ExportMode exportMode;
    @FormField(required=false)
    public String scope = "";
    @FormField
    public LegalExportType legalExportType = LegalExportType.CONCORDANCE;
    @FormField(componentType=FieldComponentType.NUIX_PROFILE, allowedValuesDynamicType=DynamicValuesType.METADATA_PROFILES)
    public String metadataProfile = "Default";
    @FormField
    @ExcludeFromPrintableOptions
    public Boolean mailTypeEnabled = false;
    @FormField(enableOn={@OnField(name="mailTypeEnabled")})
    @ExcludeFromPrintableOptions
    public MailType mailType = MailType.NATIVE;
    @FormField
    @ExcludeFromPrintableOptions
    public Boolean exportSchemeEnabled = false;
    @FormField(enableOn={@OnField(name="exportSchemeEnabled")})
    @ExcludeFromPrintableOptions
    public ExportScheme exportScheme = ExportScheme.LEAVE_ATTACHMENTS_ON_EMAILS;
    @FormField
    public String metadataMappingFile = "";
    @FormField
    public String relativityMappingLocation;
    @FormField
    public Boolean exportFileTypeNative = true;
    @FormField
    public Boolean exportFileTypeText = true;
    @FormField
    public Boolean exportFileTypePdf = false;
    @FormField
    public Boolean exportFileTypeImage = false;
    @FormField
    public Boolean exportFileTypeXhtmlReport = false;
    @FormField
    public Boolean exportFileTypeThumbnail = false;
    @FormField(componentType=FieldComponentType.NUIX_PROFILE, allowedValuesDynamicType=DynamicValuesType.IMAGING_PROFILES, required=false)
    public String imagingProfile = "";
    @FormField(componentType=FieldComponentType.NUIX_PROFILE, allowedValuesDynamicType=DynamicValuesType.PRODUCTION_PROFILES, required=false)
    public String productionProfile = "";
    @FormField
    public String exportFolder = "{case_folder}/Export/{export_production_set_name}";
    @FormField
    public Boolean exportSplit = true;
    @FormField(min=1.0, enableOn={@OnField(name="exportSplit")}, positionLabel=@PositionLabel(right="items"))
    @ExcludeFromPrintableOptions
    public int exportSplitAt = 100000;
    @FormField(enableOn={@OnField(name="exportSplit")})
    @ExcludeFromPrintableOptions
    public Boolean exportConsolidateSplits = false;
    @FormField
    public Boolean tagFailedItems = true;
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public String failedItemTagName = "Automate|Failed Items|Legal Export|{export_production_set_name}";
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public Boolean untagSuccessfulItems = true;

    public boolean getDisplayMailType() {
        return this.mailTypeEnabled;
    }

    public boolean getDisplayExportScheme() {
        return this.exportSchemeEnabled;
    }

    public boolean getDisplayExportSplitAt() {
        return this.exportSplit;
    }

    public boolean getDisplayExportConsolidateSplits() {
        return this.exportSplit;
    }

    public boolean getDisplayFailedItemTagName() {
        return this.tagFailedItems;
    }

    public boolean getDisplayUntagSuccessfulItems() {
        return this.tagFailedItems;
    }

    public LegalExportOperation() {
        this.exportMode = ExportMode.PRODUCTION_SET;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("LegalExportOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.LEGAL_EXPORT;
    }

    @Override
    public void normalize() {
        super.normalize();
        if (this.exportMode == null) {
            this.exportMode = ExportMode.PRODUCTION_SET;
        }
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (activity == Operation.PrerequisitesActivity.RUN_INTERACTIVE || activity == Operation.PrerequisitesActivity.RUN_UNATTENDED) {
            Version requiredNuixVersion;
            int requiredVersionSatisfied;
            if (this.imagingProfile != null && this.imagingProfile.length() > 0 && (requiredVersionSatisfied = this.executionContext.nuixVersion.compareTo(requiredNuixVersion = new Version("7.2.0"))) < 0) {
                prerequisites.add(this.iu.getString("LegalExportOperation.Prerequisites.CannotUseImagingProfile"));
            }
            if (this.productionProfile != null && this.productionProfile.length() > 0 && (requiredVersionSatisfied = this.executionContext.nuixVersion.compareTo(requiredNuixVersion = new Version("7.2.0"))) < 0) {
                prerequisites.add(this.iu.getString("LegalExportOperation.Prerequisites.CannotUseProductionProfile"));
            }
        }
        if (this.legalExportType == LegalExportType.RELATIVITY) {
            boolean detectedConfigureRelativityConnectionOperation = false;
            boolean detectedSetRelativityWorkspaceOperation = false;
            for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
                Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
                if (o instanceof ConfigureRelativityConnectionOperation) {
                    detectedConfigureRelativityConnectionOperation = true;
                }
                if (o instanceof RelativitySetWorkspaceOperation) {
                    detectedSetRelativityWorkspaceOperation = true;
                }
                if (o == this) break;
            }
            if (!detectedConfigureRelativityConnectionOperation) {
                prerequisites.add(this.iu.getString("ConfigureRelativityConnectionOperation.Prerequisites.Missing"));
            }
            if (!detectedSetRelativityWorkspaceOperation) {
                prerequisites.add(this.iu.getString("RelativitySetWorkspaceOperation.Prerequisites.Missing"));
            }
        }
        if (this.productionSetName.startsWith("production-set:")) {
            prerequisites.add(this.iu.getString("LegalExportOperation.Prerequisites.ProductionSetCannotStart"));
        }
        if (this.legalExportType.equals((Object)LegalExportType.RINGTAIL) && this.metadataMappingFile.trim().length() == 0) {
            prerequisites.add(this.iu.getString("LegalExportOperation.Prerequisites.RingtailMetadataMapping"));
        }
        if (this.exportMode != ExportMode.PRODUCTION_SET && this.exportMode != ExportMode.ANY_PRODUCTION_SET && this.exportSplit.booleanValue()) {
            prerequisites.add(this.iu.getString("LegalExportOperation.Prerequisites.CannotUseBoth"));
        }
        if (this.exportMode != ExportMode.ANY_PRODUCTION_SET && this.productionSetName.trim().length() == 0) {
            prerequisites.add(this.iu.getString("LegalExportOperation.Prerequisites.ProductionSetNameMustBeSpecified"));
        }
        if (this.exportMode == ExportMode.ANY_PRODUCTION_SET && this.scope.trim().length() == 0) {
            prerequisites.add(this.iu.getString("LegalExportOperation.Prerequisites.ScopeMustBeSpecified"));
        }
        return prerequisites;
    }

    @Override
    public String getUtilizationScopeQuery() {
        return null;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.LEGAL_EXPORT;
    }

    @Override
    public String getProcessingJobGuid() {
        return null;
    }

    @Override
    public Activity getActivity() {
        return Activity.EXPORT;
    }

    @Override
    public Integer getWorkerMemory() {
        return null;
    }

    @Override
    public Integer getAddedWorkerCount() {
        return null;
    }
}

