/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.security.WinDPAPIEncyptor;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.utils.utilization.consumption.ConsumptionEvent;
import com.nuix.automate.utils.utilization.consumption.ConsumptionPlatformType;
import com.nuix.automate.utils.utilization.consumption.ConsumptionType;
import com.nuix.automate.utils.utilization.consumption.ResourceType;
import com.nuix.automate.utils.utilization.consumption.UnitType;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.LegalExportOperation;
import com.nuix.automate.workflow.core.execution.operations.RelativityLoadDetails;
import com.nuix.automate.workflow.core.execution.operations.RemoteWorkerBasedOperation;
import com.nuix.automate.workflow.core.execution.options.export.LegalExportType;
import com.nuix.automate.workflow.core.execution.options.legalexport.ExportMode;
import com.nuix.automate.workflow.core.execution.options.legalexport.ExportScheme;
import com.nuix.automate.workflow.core.utils.general.ConfigurationParser;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixWorkerUtils;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import com.nuix.automate.workflow.core.utils.relativity.mapping.Field;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nuix.AddedWorkers;
import nuix.BatchExporter;
import nuix.BulkAnnotater;
import nuix.ExportProcessingJob;
import nuix.Item;
import nuix.ItemEventInfo;
import nuix.LicenceException;
import nuix.MetadataProfile;
import nuix.ParallelProcessingConfigurable;
import nuix.ProcessingJob;
import nuix.ProductionSet;
import nuix.profile.FileNamingStrategy;
import nuix.profile.ImagingProfile;
import nuix.profile.ProductionProfile;
import org.apache.commons.io.FilenameUtils;

public class LegalExportOperationImplementation
extends LegalExportOperation
implements RemoteWorkerBasedOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LegalExportOperation.class);
    transient Map<String, Integer> stageNameToId;
    transient double maxPercentage = 0.0;
    private transient ExportProcessingJob exportProcessingJob;
    private transient double partStartPercentage;
    private transient double partSizePercentage;
    private transient int exportPart;
    private transient int loadPart;
    private transient long failedExportItemCount;
    private transient Set<Item> failedItems;
    private transient Set<Item> itemsToUntag;
    private transient long itemsInScopeCount;
    private transient long itemsInProductionSet;
    private transient List<AddedWorkers> addedWorkersList;
    private transient File settingsFile;
    private transient String relativityUsername;
    private transient String relativityPassword;
    private transient String relativityWorkspaceId;
    private transient String relativityFolderId;
    private transient String relativityHostname;
    private transient String relativityEndpointType;
    private transient String relativityImportThreads;
    private transient String relativityImportThreadTimeout;
    private transient String relativityImportThreadRetries;
    private transient String relativityPatchInvalidEntries;
    private transient int itemsLoadedIntoRelativity;
    private transient int totalItemsLoadedIntoRelativity;
    private transient Set<Integer> relativityLoadItemIdsWithErrors;
    private transient List<Item> itemsInScope;
    private transient Process relativityLoadProcess;
    private transient Thread relativityLoadQueueThread;
    private transient Semaphore relativityLoadsPending;
    private transient AtomicLong relativityLoadsQueued;
    private transient AtomicLong relativityLoadsCompleted;
    private transient BlockingQueue<RelativityLoadDetails> relativityLoadQueue;
    private transient int exportProductionSetAt = 0;
    private transient int exportProductionSetTotal = 1;
    private transient int exportedProductionSets = 0;
    private transient boolean relativityFatalErrorEncountered;
    private transient int workersPendingCount;
    private transient boolean isPaused;
    private transient boolean isProductionProfileExportOptionsUsed;
    private transient boolean isProductionProfileExportingNative;
    private transient String productionProfileExportType;
    private transient Integer workerMemory = null;
    private transient AtomicInteger addedWorkerCount = new AtomicInteger(0);
    private transient Thread readStandardOutputThread;
    private transient Thread readStandardErrorThread;

    public List<Item> getItemsInScope() {
        if (this.itemsInScope != null) {
            return this.itemsInScope;
        }
        return new ArrayList<Item>();
    }

    private void exportItems(String exportFolder, String consolidateToFolder, ProductionSet productionSet, List<Item> items) throws Exception {
        String effectiveLegalExportType = this.legalExportType.toNuixString();
        String effectiveLegalExportName = this.legalExportType.toString();
        if (this.legalExportType.equals((Object)LegalExportType.RELATIVITY)) {
            effectiveLegalExportType = LegalExportType.CONCORDANCE.toNuixString();
            effectiveLegalExportName = LegalExportType.CONCORDANCE.toString();
        }
        BatchExporter batchExporter = this.executionContext.nuixUtilities.createBatchExporter(exportFolder);
        ConfigurationParser configurationParser = new ConfigurationParser();
        ArrayList<String> stageNames = new ArrayList<String>();
        stageNames.add("work_queue");
        Map numberingOptions = new HashMap();
        try {
            numberingOptions = productionSet.getNumberingOptions();
        }
        catch (Exception e) {
            this.addWarning(this.iu.getString("LegalExportOperation.Warning.CouldNotDetectProductionSetNumberingOptions"));
            LOGGER.error("Could not detect Production Set numbering options", (Throwable)e);
        }
        boolean numberingSchemeDocumentIdBased = false;
        boolean numberingSchemePageBased = false;
        boolean numberingSchemeFolderBased = false;
        LOGGER.info("Production " + productionSet.getName() + " numbering options:");
        for (String numberingOptionName : numberingOptions.keySet()) {
            LOGGER.info("# " + numberingOptionName + ": " + String.valueOf(numberingOptions.get(numberingOptionName)));
            switch (numberingOptionName) {
                case "documentId": {
                    numberingSchemeDocumentIdBased = true;
                    break;
                }
                case "page": {
                    numberingSchemePageBased = true;
                    break;
                }
                case "folder": {
                    numberingSchemeFolderBased = true;
                }
            }
        }
        HashSet<String> allowedNamingSchemes = new HashSet<String>();
        String defaultNamingScheme = "";
        if (numberingSchemeDocumentIdBased) {
            LOGGER.info("Setting document_id product naming restrictions");
            allowedNamingSchemes.add("document_id");
            allowedNamingSchemes.add("document_id_with_page");
            allowedNamingSchemes.add("guid");
            allowedNamingSchemes.add("md5");
            allowedNamingSchemes.add("item_name");
            allowedNamingSchemes.add("item_name_with_path");
            defaultNamingScheme = "document_id";
        } else if (numberingSchemePageBased || numberingSchemeFolderBased) {
            LOGGER.info("Setting page product naming restrictions");
            allowedNamingSchemes.add("page_only");
            allowedNamingSchemes.add("full");
            allowedNamingSchemes.add("full_with_periods");
            allowedNamingSchemes.add("item_name");
            allowedNamingSchemes.add("item_name_with_path");
            allowedNamingSchemes.add("guid");
            allowedNamingSchemes.add("md5");
            defaultNamingScheme = numberingSchemeFolderBased ? "full_with_periods" : "full";
        }
        String nodePath = "com/nuix/investigator/export/legal/Concordance";
        Preferences node = Preferences.userRoot().node(nodePath);
        String namingStrategy = node.get("nativeFileNamingStrategy", "x");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Strategy before export: " + namingStrategy);
        }
        if (!this.isProductionProfileExportOptionsUsed) {
            Object namingScheme;
            Map<String, Object> productOptions;
            if (this.exportFileTypeNative.booleanValue()) {
                productOptions = configurationParser.getExportProductProperties(effectiveLegalExportName, "native");
                namingScheme = (String)productOptions.get("naming");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Strategy actual: " + (String)namingScheme);
                }
                if (numberingSchemeDocumentIdBased || numberingSchemePageBased) {
                    if (!allowedNamingSchemes.contains(namingScheme)) {
                        try {
                            if (this.executionContext.evalParameters("{wfn_use_configuration_profile}", this).equalsIgnoreCase("true")) {
                                this.addWarning(this.iu.getFormattedString("LegalExportOperation.Warning.ProfileSpecifiedNativeNamingScheme", new Object[]{namingScheme, this.productionSetName, defaultNamingScheme}));
                            }
                        }
                        catch (ParameterException parameterException) {
                            // empty catch block
                        }
                        productOptions.put("naming", defaultNamingScheme);
                    } else {
                        productOptions.put("naming", namingScheme);
                    }
                }
                if (this.mailTypeEnabled.booleanValue()) {
                    productOptions.put("mailFormat", this.mailType.toNuixString());
                    LOGGER.info("Converting mail, contacts, calendars to: " + this.mailType.name());
                    this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.MailFormat", (Object)this.mailType.toString()));
                }
                if (this.exportSchemeEnabled.booleanValue()) {
                    productOptions.put("includeAttachments", this.exportScheme == ExportScheme.LEAVE_ATTACHMENTS_ON_EMAILS);
                    LOGGER.info("Export scheme: " + this.exportScheme.name());
                    this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.ExportScheme", (Object)this.exportScheme.toString()));
                }
                batchExporter.addProduct("native", productOptions);
                stageNames.add("native");
                stageNames.add("stored_email_fixup");
            }
            if (this.exportFileTypePdf.booleanValue()) {
                productOptions = configurationParser.getExportProductProperties(effectiveLegalExportName, "pdf");
                namingScheme = (String)productOptions.get("naming");
                if (numberingSchemeDocumentIdBased || numberingSchemePageBased) {
                    if (!allowedNamingSchemes.contains(namingScheme)) {
                        try {
                            if (this.executionContext.evalParameters("{wfn_use_configuration_profile}", this).equalsIgnoreCase("true")) {
                                this.addWarning(this.iu.getFormattedString("LegalExportOperation.Warning.ProfileSpecifiedPDFNamingScheme", new Object[]{namingScheme, this.productionSetName, defaultNamingScheme}));
                            }
                        }
                        catch (ParameterException parameterException) {
                            // empty catch block
                        }
                        productOptions.put("naming", defaultNamingScheme);
                    } else {
                        productOptions.put("naming", namingScheme);
                    }
                }
                batchExporter.addProduct("pdf", productOptions);
                stageNames.add("stamping");
                stageNames.add("pdf");
            }
            stageNames.add("numbering");
            stageNames.add("binary_store");
            stageNames.add("print_store");
            if (this.exportFileTypeThumbnail.booleanValue()) {
                productOptions = configurationParser.getExportProductProperties(effectiveLegalExportName, "thumbnail");
                namingScheme = (String)productOptions.get("naming");
                if (numberingSchemeDocumentIdBased || numberingSchemePageBased) {
                    if (!allowedNamingSchemes.contains(namingScheme)) {
                        try {
                            if (this.executionContext.evalParameters("{wfn_use_configuration_profile}", this).equalsIgnoreCase("true")) {
                                this.addWarning(this.iu.getFormattedString("LegalExportOperation.Warning.ProfileSpecifiedThumbnailNamingScheme", new Object[]{namingScheme, this.productionSetName, defaultNamingScheme}));
                            }
                        }
                        catch (ParameterException parameterException) {
                            // empty catch block
                        }
                        productOptions.put("naming", defaultNamingScheme);
                    } else {
                        productOptions.put("naming", namingScheme);
                    }
                }
                batchExporter.addProduct("thumbnail", productOptions);
                stageNames.add("thumbnails");
            }
            stageNames.add("markup");
            if (this.exportFileTypeText.booleanValue()) {
                productOptions = configurationParser.getExportProductProperties(effectiveLegalExportName, "text");
                namingScheme = (String)productOptions.get("naming");
                if (numberingSchemeDocumentIdBased || numberingSchemePageBased) {
                    if (!allowedNamingSchemes.contains(namingScheme)) {
                        try {
                            if (this.executionContext.evalParameters("{wfn_use_configuration_profile}", this).equalsIgnoreCase("true")) {
                                this.addWarning(this.iu.getFormattedString("LegalExportOperation.Warning.ProfileSpecifiedTextNamingScheme", new Object[]{namingScheme, this.productionSetName, defaultNamingScheme}));
                            }
                        }
                        catch (ParameterException parameterException) {
                            // empty catch block
                        }
                        productOptions.put("naming", defaultNamingScheme);
                    } else {
                        productOptions.put("naming", namingScheme);
                    }
                }
                batchExporter.addProduct("text", productOptions);
                stageNames.add("text");
            }
            if (this.exportFileTypeImage.booleanValue()) {
                productOptions = configurationParser.getExportProductProperties(effectiveLegalExportName, "image");
                namingScheme = (String)productOptions.get("naming");
                if (numberingSchemeDocumentIdBased || numberingSchemePageBased) {
                    if (!allowedNamingSchemes.contains(namingScheme)) {
                        try {
                            if (this.executionContext.evalParameters("{wfn_use_configuration_profile}", this).equalsIgnoreCase("true")) {
                                this.addWarning(this.iu.getFormattedString("LegalExportOperation.Warning.ProfileSpecifiedImageNamingScheme", new Object[]{namingScheme, this.productionSetName, defaultNamingScheme}));
                            }
                        }
                        catch (ParameterException parameterException) {
                            // empty catch block
                        }
                        productOptions.put("naming", defaultNamingScheme);
                    } else {
                        productOptions.put("naming", namingScheme);
                    }
                }
                batchExporter.addProduct("tiff", productOptions);
                stageNames.add("stamping");
                stageNames.add("image");
            }
            stageNames.add("file_naming");
            stageNames.add("set_file_times");
            stageNames.add("digest");
            if (this.exportFileTypeXhtmlReport.booleanValue()) {
                productOptions = configurationParser.getExportProductProperties(effectiveLegalExportName, "xhtmlItem");
                namingScheme = (String)productOptions.get("naming");
                if (numberingSchemeDocumentIdBased || numberingSchemePageBased) {
                    if (!allowedNamingSchemes.contains(namingScheme)) {
                        try {
                            if (this.executionContext.evalParameters("{wfn_use_configuration_profile}", this).equalsIgnoreCase("true")) {
                                this.addWarning(this.iu.getFormattedString("LegalExportOperation.Warning.ProfileSpecifiedXHTMLNamingScheme", new Object[]{namingScheme, this.productionSetName, defaultNamingScheme}));
                            }
                        }
                        catch (ParameterException parameterException) {
                            // empty catch block
                        }
                        productOptions.put("naming", defaultNamingScheme);
                    } else {
                        productOptions.put("naming", namingScheme);
                    }
                }
                batchExporter.addProduct("xhtml_report", productOptions);
                stageNames.add("xhtml_reports");
            }
            if (this.exportFileTypeThumbnail.booleanValue()) {
                stageNames.add("thumbnail_report");
            }
            stageNames.add("load_files");
            this.stageNameToId = new HashMap<String, Integer>();
            int id = 0;
            for (String stageName : stageNames) {
                this.stageNameToId.put(stageName, id);
                ++id;
            }
            HashMap<String, Object> loadFileOptions = new HashMap<String, Object>();
            MetadataProfile mp = NuixUtils.getMetadataProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.metadataProfile);
            if (mp != null) {
                loadFileOptions.put("metadataProfile", mp);
            } else {
                this.addWarning(this.iu.getFormattedString("LegalExportOperation.Warning.MetadataProfile", (Object)this.metadataProfile));
                loadFileOptions.put("metadataProfile", NuixUtils.getDefaultMetadataProfileName());
            }
            if (this.legalExportType.equals((Object)LegalExportType.RINGTAIL)) {
                Map<String, Object> ringtailExportSettings = configurationParser.getRingtailExportSettings();
                if (ringtailExportSettings != null && ringtailExportSettings.get("version") != null && ringtailExportSettings.get("version").equals("L2005")) {
                    ringtailExportSettings.put("version", "2005");
                }
                for (String propertyName : ringtailExportSettings.keySet()) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Ringtail property " + propertyName + ":\t" + String.valueOf(ringtailExportSettings.get(propertyName)) + "\t(" + ringtailExportSettings.get(propertyName).getClass().toString() + ")");
                }
                loadFileOptions.putAll(ringtailExportSettings);
                if (this.metadataMappingFile.trim().length() > 0) {
                    this.metadataMappingFile = this.executionContext.evalParameters(this.metadataMappingFile, this);
                    loadFileOptions.put("mappingLocation", this.metadataMappingFile);
                }
            }
            batchExporter.addLoadFile(effectiveLegalExportType, loadFileOptions);
        } else {
            ProductionProfile profile;
            this.addExecutionLog(this.iu.getString("LegalExportOperation.Log.UsedProductionProfileExportOptions"));
            if (this.exportFileTypeNative.booleanValue() || this.exportFileTypePdf.booleanValue() || this.exportFileTypeText.booleanValue() || this.exportFileTypeImage.booleanValue() || this.exportFileTypeXhtmlReport.booleanValue() || this.exportFileTypeThumbnail.booleanValue()) {
                this.addWarning(this.iu.getString("LegalExportOperation.Warning.ProductionProfileExportOptionsTakePrecedenceOverSelectedOperationFiletypes"));
            }
            if ((this.mailTypeEnabled.booleanValue() || this.exportSchemeEnabled.booleanValue()) && this.isProductionProfileExportingNative && this.productionProfile != null && this.productionProfile.length() > 0 && (profile = NuixUtils.getProductionProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.productionProfile)) != null) {
                HashMap<String, Object> productOptions = new HashMap<String, Object>();
                productOptions.put("path", ((FileNamingStrategy)profile.getFileNamingMap().get("NATIVE")).getSubFolder());
                productOptions.put("naming", configurationParser.getNamingStrategyFromType(((FileNamingStrategy)profile.getFileNamingMap().get("NATIVE")).getNamingType()));
                productOptions.put("suffix", ((FileNamingStrategy)profile.getFileNamingMap().get("NATIVE")).getFileNameSuffix());
                if (this.mailTypeEnabled.booleanValue()) {
                    productOptions.put("mailFormat", this.mailType.toNuixString());
                    LOGGER.info("Converting mail, contacts, calendars to: " + this.mailType.name());
                    this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.MailFormat", (Object)this.mailType.toString()));
                }
                if (this.exportSchemeEnabled.booleanValue()) {
                    productOptions.put("includeAttachments", this.exportScheme == ExportScheme.LEAVE_ATTACHMENTS_ON_EMAILS);
                    LOGGER.info("Export scheme: " + this.exportScheme.name());
                    this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.ExportScheme", (Object)this.exportScheme.toString()));
                }
                batchExporter.addProduct("native", productOptions);
            }
            if (this.legalExportType == LegalExportType.RELATIVITY && !this.productionProfileExportType.equals(LegalExportType.RELATIVITY.name()) && !this.productionProfileExportType.equals(LegalExportType.CONCORDANCE.name())) {
                throw new IllegalArgumentException(this.iu.getFormattedString("LegalExportOperation.Exception.ExportType", new Object[]{this.legalExportType, LegalExportType.RELATIVITY, LegalExportType.CONCORDANCE}));
            }
        }
        batchExporter.setParallelProcessingSettings(configurationParser.getParallelProcessingLegalExportSettings());
        NuixWorkerUtils.setWorkerSettings(this.executionContext, this, (ParallelProcessingConfigurable)batchExporter, true);
        this.workerMemory = NuixWorkerUtils.getProcessorWorkerMemory((ParallelProcessingConfigurable)batchExporter);
        if (this.imagingProfile != null && this.imagingProfile.length() > 0) {
            ImagingProfile imagingProfileObject = NuixUtils.getImagingProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.imagingProfile);
            if (imagingProfileObject != null) {
                productionSet.setImagingProfileObject(imagingProfileObject);
            } else {
                LOGGER.warn("Cannot use imaging profile. Does not exist on system");
                this.addWarning(this.iu.getFormattedString("LegalExportOperation.Warning.CannotUseImagingProfile", (Object)this.iu.getFormattedString("General.Warning.ProfileNotExist", (Object)this.imagingProfile)));
            }
        }
        if (this.productionProfile != null && this.productionProfile.length() > 0) {
            try {
                productionSet.setProductionProfile(this.productionProfile);
                productionSet.setProductionSettingsSource("PRODUCTION_PROFILE");
            }
            catch (Exception e) {
                LOGGER.warn("Cannot use production profile.", (Throwable)e);
                this.addWarning(this.iu.getFormattedString("LegalExportOperation.Warning.CannotUseProductionProfile", (Object)e.getLocalizedMessage()));
            }
        }
        batchExporter.whenItemEventOccurs(this::itemProcessed);
        if (productionSet.getItems().size() > 0) {
            if (this.stopRequested) {
                this.trackStopped();
                return;
            }
            if (this.exportMode != ExportMode.PRODUCTION_SET && this.exportMode != ExportMode.ANY_PRODUCTION_SET) {
                if (!productionSet.isFrozen()) {
                    productionSet.freeze();
                }
                batchExporter.setNumberingOptions(productionSet.getNumberingOptions());
                HashMap<String, String> traversalOptions = new HashMap<String, String>();
                traversalOptions.put("sortOrder", "none");
                if (this.imagingProfile != null && this.imagingProfile.length() > 0) {
                    ImagingProfile imagingProfileObject = NuixUtils.getImagingProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.imagingProfile);
                    if (imagingProfileObject != null) {
                        batchExporter.setImagingProfileObject(imagingProfileObject);
                    } else {
                        LOGGER.warn("Cannot use imaging profile. Does not exist on system");
                        this.addWarning(this.iu.getFormattedString("LegalExportOperation.Warning.CannotUseImagingProfile", (Object)this.iu.getFormattedString("General.Warning.ProfileNotExist", (Object)this.imagingProfile)));
                    }
                }
                if (this.productionProfile != null && this.productionProfile.length() > 0) {
                    try {
                        batchExporter.setProductionProfile(this.productionProfile);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot use production profile.", (Throwable)e);
                        this.addWarning(this.iu.getFormattedString("LegalExportOperation.Warning.CannotUseProductionProfile", (Object)e.getLocalizedMessage()));
                    }
                }
                if (this.exportMode == ExportMode.PRODUCTION_SET_ITEMS) {
                    traversalOptions.put("strategy", "items");
                } else if (this.exportMode == ExportMode.PRODUCTION_SET_TOP_LEVEL_ITEMS_AND_DESCENDANTS) {
                    traversalOptions.put("strategy", "top_level_items_and_descendants");
                }
                batchExporter.setTraversalOptions(traversalOptions);
                this.exportProcessingJob = batchExporter.exportItemsAsync(items);
            } else {
                this.exportProcessingJob = batchExporter.exportItemsAsync(productionSet, items);
            }
            String processingJobGuid = this.exportProcessingJob.getJobGuid().replace("-", "");
            LOGGER.info("Job Guid: " + processingJobGuid);
            NuixWorkerUtils.addRemoteWorkers(this.executionContext, this, (ProcessingJob)this.exportProcessingJob, this.addedWorkerCount);
            NuixUtils.waitForProcessingJobToComplete((ProcessingJob)this.exportProcessingJob);
            if (this.executionState == ExecutionState.STOPPING) {
                this.stopLoad();
                this.trackStopped();
            } else {
                try {
                    Path loadfilePath;
                    if (consolidateToFolder != null) {
                        LOGGER.info("Consolidating part " + this.exportPart);
                        Path partialExportPath = Paths.get(exportFolder, new String[0]);
                        Path mainExportPath = Paths.get(consolidateToFolder, new String[0]);
                        this.consolidateExportPart(mainExportPath, partialExportPath, this.exportPart);
                        loadfilePath = mainExportPath.resolve("loadfile_" + this.exportPart + ".dat");
                    } else {
                        loadfilePath = Paths.get(exportFolder, "loadfile.dat");
                    }
                    if (this.legalExportType.equals((Object)LegalExportType.RELATIVITY)) {
                        this.queueLoadLoadfile(loadfilePath.toAbsolutePath().toString(), this.exportPart, items.size());
                    }
                    if (this.exportMode == ExportMode.PRODUCTION_SET_TOP_LEVEL_ITEMS_AND_DESCENDANTS) {
                        this.addExecutionLog(this.iu.getNumeralString("LegalExportOperation.Log.TraversedCount", this.exportProcessingJob.getTotalItemCount()));
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot finalize export part", (Throwable)e);
                    this.addWarning(FormattingUtils.getExceptionPrintableMessage((Exception)e));
                }
            }
        } else {
            this.addWarning(this.iu.getFormattedString("General.Warning.NoItemsWereFoundInProduction", (Object)this.productionSetName));
            LOGGER.warn("No items were found in production " + this.productionSetName);
        }
        try {
            this.failedExportItemCount += this.exportProcessingJob.getFailedItemCount();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot get job failed items", (Throwable)e);
        }
    }

    private void queueLoadLoadfile(String loadfilePath, int exportPart, int itemsCount) {
        if (this.relativityLoadQueue == null) {
            LOGGER.info("Queuing first load");
            this.relativityLoadQueue = new LinkedBlockingQueue<RelativityLoadDetails>();
        }
        LOGGER.info("Queuing load " + exportPart + " with " + itemsCount + " items from " + loadfilePath);
        RelativityLoadDetails relativityLoadDetails = new RelativityLoadDetails(loadfilePath, exportPart, itemsCount);
        this.relativityLoadsQueued.incrementAndGet();
        this.relativityLoadQueue.add(relativityLoadDetails);
        LOGGER.info("Load queue: " + this.relativityLoadQueue.size() + ", Total queued: " + this.relativityLoadsQueued.get() + ", Total completed: " + this.relativityLoadsCompleted.get());
        if (this.relativityLoadQueueThread == null) {
            this.relativityLoadQueueThread = new Thread(this::relativityLoad);
            this.relativityLoadQueueThread.setName("Automate - Operation " + this.getOperationName() + " - Relativity Load Queue");
            this.relativityLoadQueueThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void relativityLoad() {
        int previousTotalItemsLoadedIntoRelativity = 0;
        while (true) {
            RelativityLoadDetails relativityLoadDetails;
            try {
                relativityLoadDetails = this.relativityLoadQueue.take();
            }
            catch (InterruptedException e) {
                LOGGER.info("Received interrupt while waiting for queue");
                return;
            }
            this.loadPart = relativityLoadDetails.exportPart;
            String loadfilePath = relativityLoadDetails.loadfilePath;
            LOGGER.info("Starting loading part " + this.loadPart + " to Relativity");
            try {
                long beforeLoadItemsFailedCount = 0L;
                if (this.relativityLoadItemIdsWithErrors != null) {
                    beforeLoadItemsFailedCount = this.relativityLoadItemIdsWithErrors.size();
                }
                this.loadLoadfile(loadfilePath, previousTotalItemsLoadedIntoRelativity, relativityLoadDetails.itemsCount);
                long afterLoadItemsFailedCount = 0L;
                if (this.relativityLoadItemIdsWithErrors != null) {
                    afterLoadItemsFailedCount = (long)this.relativityLoadItemIdsWithErrors.size() - beforeLoadItemsFailedCount;
                }
                if (afterLoadItemsFailedCount > 0L && this.loadPart > 0) {
                    if (this.exportConsolidateSplits.booleanValue()) {
                        this.addWarning(this.iu.getNumeralFormattedString("LegalExportOperation.Warning.CouldNotBeFullyLoadedErrorReport", afterLoadItemsFailedCount, (Object)this.loadPart));
                    } else {
                        this.addWarning(this.iu.getNumeralFormattedString("LegalExportOperation.Warning.CouldNotBeFullyLoaded", afterLoadItemsFailedCount, (Object)this.loadPart));
                    }
                }
                previousTotalItemsLoadedIntoRelativity += relativityLoadDetails.itemsCount;
            }
            catch (InterruptedException e) {
                LOGGER.info("Received interrupt while waiting for load to complete");
                LOGGER.info("Attempting to destroy load process");
                Process loadProcess = this.relativityLoadProcess.destroyForcibly();
                LOGGER.info("Waiting for load process to be destroyed");
                try {
                    int returnCode = loadProcess.waitFor();
                    LOGGER.info("Load process destroyed with code " + returnCode);
                }
                catch (InterruptedException e1) {
                    LOGGER.error("Cannot wait for load process to be destroyed", (Throwable)e1);
                }
                return;
            }
            catch (Exception e) {
                LOGGER.error("Cannot load to Relativity", (Throwable)e);
                if (this.executionState != ExecutionState.STOPPED) {
                    this.addWarning(this.iu.getFormattedString("LegalExportOperation.Warning.LoadingToRelativityEncounteredFatalError", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                }
            }
            finally {
                this.relativityLoadsPending.release();
            }
            LOGGER.info("Finished loading part " + this.loadPart + " to Relativity");
        }
    }

    private void waitForRelativityLoad() {
        if (this.relativityLoadQueueThread != null) {
            LOGGER.info("Waiting for Relativity load thread to complete, queue size: " + this.relativityLoadQueue.size());
            try {
                while (this.relativityLoadsCompleted.get() < this.relativityLoadsQueued.get()) {
                    LOGGER.info("Load queue: " + this.relativityLoadQueue.size() + ", Total queued: " + this.relativityLoadsQueued.get() + ", Total completed: " + this.relativityLoadsCompleted.get());
                    LOGGER.info("Waiting for a load to complete");
                    this.relativityLoadsPending.acquire();
                    LOGGER.info("Finished waiting for load to complete");
                    this.relativityLoadsCompleted.incrementAndGet();
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted while waiting for Relativity upload to complete");
            }
            LOGGER.info("Load queue: " + this.relativityLoadQueue.size() + ", Total queued: " + this.relativityLoadsQueued.get() + ", Total completed: " + this.relativityLoadsCompleted.get());
            LOGGER.info("Loads completed, interrupting Relativity load thread");
            this.relativityLoadQueueThread.interrupt();
            try {
                this.relativityLoadQueueThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.error("Cannot wait for Relativity load thread to complete", (Throwable)e);
            }
        }
        this.relativityLoadQueueThread = null;
    }

    private void stopLoad() {
        if (this.relativityLoadQueueThread != null) {
            LOGGER.info("Stopping Relativity load");
            if (this.relativityLoadQueueThread.isAlive()) {
                LOGGER.info("Relativity Load thread is alive, interrupting");
                this.relativityLoadQueueThread.interrupt();
                if (this.relativityLoadProcess != null) {
                    LOGGER.info("Attempting to destroy Relativity load process");
                    try {
                        this.relativityLoadProcess.destroyForcibly();
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot destroy Relativity load process", (Throwable)e);
                    }
                }
                LOGGER.info("Waiting for Relativity load thread to complete");
                try {
                    this.relativityLoadQueueThread.join();
                    this.relativityLoadQueueThread = null;
                    LOGGER.info("Relativity load thread completed");
                }
                catch (InterruptedException e) {
                    LOGGER.error("Cannot wait for Relativity Load thread to complete", (Throwable)e);
                }
            } else {
                LOGGER.info("Relativity Load thread is already stopped");
            }
        }
    }

    private void readOutputStream(BufferedReader standardInputReader, int previousTotalItemsLoadedIntoRelativity, int itemsCount) throws IOException {
        String line;
        int lastObservedProgress = 0;
        String notMapped = "[NOT MAPPED";
        String ignoreNotMapped = "Source field [parent folder identifier]";
        Pattern progressPattern = Pattern.compile("\\[Progress Info: ?(\\d+)");
        Pattern errorLinePattern = Pattern.compile("error: line: (\\d+)");
        Pattern totalLinesPattern = Pattern.compile("Loadfile records count: (\\d+)");
        Pattern transferModePattern = Pattern.compile("Status - Created transfer client '([^\\']+)' using a best-fit strategy.");
        boolean transferModePatternPrinted = false;
        int lineNumber = 0;
        boolean enableVerboseLogging = Boolean.parseBoolean(System.getProperty("automate.relativity.verbose_logging"));
        while ((line = standardInputReader.readLine()) != null) {
            Matcher transferModeMatcher;
            Matcher errorMatcher;
            Matcher progressMatcher;
            if (enableVerboseLogging || lineNumber < 1000) {
                LOGGER.info(line);
                if (++lineNumber == 1000 && !enableVerboseLogging) {
                    LOGGER.info("Relativity verbose logging is disabled, to enable verbose logging use the command-line flag -Dautomate.relativity.verbose_logging=true");
                }
            }
            if ((progressMatcher = progressPattern.matcher(line)).find()) {
                try {
                    lastObservedProgress = Integer.parseInt(progressMatcher.group(1));
                    this.itemsLoadedIntoRelativity = Math.max(this.itemsLoadedIntoRelativity, Integer.parseInt(progressMatcher.group(1)));
                    this.totalItemsLoadedIntoRelativity = previousTotalItemsLoadedIntoRelativity + this.itemsLoadedIntoRelativity;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Progress: " + lastObservedProgress + ", Max: " + this.itemsLoadedIntoRelativity + ", Total: " + this.totalItemsLoadedIntoRelativity);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot extract progress from line", (Throwable)e);
                }
            }
            if ((errorMatcher = errorLinePattern.matcher(line)).find()) {
                try {
                    int lineId = Integer.parseInt(errorMatcher.group(1));
                    if (this.relativityLoadItemIdsWithErrors == null) {
                        this.relativityLoadItemIdsWithErrors = new HashSet<Integer>();
                    }
                    int itemId = previousTotalItemsLoadedIntoRelativity + (lineId - 1);
                    this.relativityLoadItemIdsWithErrors.add(itemId);
                    LOGGER.info("Detected error on itemId " + itemId);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot extract line with error", (Throwable)e);
                }
            }
            if (line.startsWith("Unhandled Exception:") || line.startsWith("exception:") || line.contains("fatal error: ")) {
                String message = line.substring(line.indexOf(58) + 1).trim();
                if (!this.relativityFatalErrorEncountered) {
                    if (this.relativityLoadItemIdsWithErrors == null) {
                        this.relativityLoadItemIdsWithErrors = new HashSet<Integer>();
                    }
                    for (int lineId = lastObservedProgress; lineId < itemsCount; ++lineId) {
                        int itemId = previousTotalItemsLoadedIntoRelativity + (lineId - 1);
                        this.relativityLoadItemIdsWithErrors.add(itemId);
                    }
                    this.relativityFatalErrorEncountered = true;
                    this.addWarning(this.iu.getFormattedString("LegalExportOperation.Warning.LoadingToRelativityEncounteredFatalErrorExplained", (Object)message));
                } else {
                    this.addWarning(message);
                }
            }
            if (!transferModePatternPrinted && (transferModeMatcher = transferModePattern.matcher(line)).find()) {
                this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.RelativityTransferMode", (Object)transferModeMatcher.group(1)));
                transferModePatternPrinted = true;
            }
            if (!line.contains("[NOT MAPPED") || line.contains("Source field [parent folder identifier]")) continue;
            this.addTransientWarning(line, false);
        }
    }

    private void readErrorStream(BufferedReader errorReader) throws IOException {
        String line;
        while ((line = errorReader.readLine()) != null) {
            if (line.trim().length() > 0 && !line.startsWith(" ")) {
                if (line.startsWith("Unhandled Exception:") || line.startsWith("exception:") || line.contains("fatal error: ")) {
                    String message = line.substring(line.indexOf(58) + 1).trim();
                    if (!this.relativityFatalErrorEncountered) {
                        this.relativityFatalErrorEncountered = true;
                        this.addWarning(this.iu.getFormattedString("RelativityLoadfileUploadOperation.Warning.LoadingToRelativityFatalErrors", (Object)message));
                    } else {
                        this.addWarning(message);
                    }
                } else {
                    this.addWarning(line);
                }
            }
            LOGGER.warn(line);
        }
    }

    private void loadLoadfile(String loadfilePath, int previousTotalItemsLoadedIntoRelativity, int itemsCount) throws IOException, InterruptedException, ParameterException {
        this.itemsLoadedIntoRelativity = 0;
        LOGGER.info("Loading loadfile " + loadfilePath);
        String relativityServiceEndpoint = this.executionContext.evalParameters("{wfn_relativity_service_endpoint}", this);
        String relativityClientVersion = this.executionContext.evalParameters("{wfn_relativity_client_version}", this);
        ThirdPartyAuthenticationMethod authenticationMethod = ThirdPartyAuthenticationMethod.USERNAME_PASSWORD;
        String authenticationMethodString = this.executionContext.evalParameters("{wfn_relativity_authentication_method}", this);
        try {
            authenticationMethod = ThirdPartyAuthenticationMethod.valueOf((String)authenticationMethodString);
            if (authenticationMethod == ThirdPartyAuthenticationMethod.OIDC_AUTHORIZATION_CODE) {
                this.relativityUsername = "none";
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse authentication method with value " + String.valueOf(authenticationMethodString) + " for relativity", (Throwable)e);
        }
        CharSequence[] relativityClientCommandArray = new String[]{"\"" + RelativityUtils.getRelativityClientPath(relativityClientVersion) + "\"", "import", this.relativityEndpointType + "://" + this.relativityHostname + relativityServiceEndpoint, this.relativityUsername, "\"" + this.relativityPassword + "\"", "\"" + (this.relativityMappingLocation.length() > 0 ? this.relativityMappingLocation : "none") + "\"", "\"" + this.settingsFile.getAbsolutePath() + "\"", "\"" + loadfilePath + "\"", this.relativityWorkspaceId, this.relativityFolderId, this.relativityImportThreads, this.relativityImportThreadTimeout, this.relativityImportThreadRetries, this.relativityPatchInvalidEntries};
        String commandLine = String.join((CharSequence)" ", relativityClientCommandArray);
        LOGGER.info("Running: " + commandLine.replace(this.relativityPassword, "[password]"));
        this.relativityLoadProcess = Runtime.getRuntime().exec((String[])relativityClientCommandArray);
        BufferedReader standardInputReader = new BufferedReader(new InputStreamReader(this.relativityLoadProcess.getInputStream()));
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(this.relativityLoadProcess.getErrorStream()));
        this.readStandardOutputThread = new Thread(() -> {
            try {
                this.readOutputStream(standardInputReader, previousTotalItemsLoadedIntoRelativity, itemsCount);
            }
            catch (IOException e) {
                LOGGER.error("Cannot read standard output stream", (Throwable)e);
                this.addWarning(e.getLocalizedMessage());
            }
            finally {
                try {
                    standardInputReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot close stream", (Throwable)e);
                }
            }
        });
        this.readStandardOutputThread.setName("Automate Relativity Standard Output Thread");
        this.readStandardOutputThread.start();
        this.readStandardErrorThread = new Thread(() -> {
            try {
                this.readErrorStream(errorReader);
            }
            catch (IOException e) {
                LOGGER.error("Cannot read standard error stream", (Throwable)e);
                this.addWarning(e.getLocalizedMessage());
            }
            finally {
                try {
                    errorReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot close stream", (Throwable)e);
                }
            }
        });
        this.readStandardErrorThread.setName("Automate Relativity Standard Error Thread");
        this.readStandardErrorThread.start();
        int returnCode = this.relativityLoadProcess.waitFor();
        if (returnCode != 0) {
            this.addWarning(this.iu.getFormattedString("LegalExportOperation.Warning.LoadingToRelativityEncounteredErrorCode", (Object)returnCode));
        }
        this.relativityLoadProcess = null;
        LOGGER.info("Finished queuing loadfile " + loadfilePath);
    }

    @Override
    public void startTriggered() throws Exception {
        String evaluatedMetadataProfileParameter;
        String metadataProfileParameterName;
        this.addedWorkersList = new ArrayList<AddedWorkers>();
        this.partStartPercentage = 0.0;
        this.partSizePercentage = 1.0;
        this.failedExportItemCount = 0L;
        this.relativityLoadsPending = new Semaphore(0);
        this.relativityLoadsQueued = new AtomicLong(0L);
        this.relativityLoadsCompleted = new AtomicLong(0L);
        this.relativityMappingLocation = this.executionContext.evalParameters(this.relativityMappingLocation, this);
        this.scope = this.executionContext.evalParameters(this.scope, this);
        if (this.exportMode != ExportMode.PRODUCTION_SET) {
            this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.ExportMode", (Object)this.exportMode));
        }
        if (this.scope.trim().length() > 0) {
            this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.ScopeQuery", (Object)this.scope));
        }
        this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.ExportFormat", (Object)this.legalExportType.toString()));
        if (this.legalExportType == LegalExportType.RELATIVITY) {
            this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.RelativityMappingFile", (Object)this.relativityMappingLocation));
        }
        if (!(metadataProfileParameterName = "{metadata_profile}").equals(evaluatedMetadataProfileParameter = this.executionContext.evalParameters(metadataProfileParameterName, this))) {
            this.metadataProfile = evaluatedMetadataProfileParameter;
            this.metadataProfile = this.executionContext.evalParameters(this.metadataProfile, this);
            this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.CustomMetadataProfile", new Object[]{metadataProfileParameterName, this.metadataProfile}));
        } else {
            this.metadataProfile = this.executionContext.evalParameters(this.metadataProfile, this);
            this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.MetadataProfile", (Object)this.metadataProfile));
        }
        ArrayList<String> fileTypes = new ArrayList<String>();
        if (this.exportFileTypeNative.booleanValue()) {
            fileTypes.add("Native");
        }
        if (this.exportFileTypeText.booleanValue()) {
            fileTypes.add("Text");
        }
        if (this.exportFileTypePdf.booleanValue()) {
            fileTypes.add("PDF");
        }
        if (this.exportFileTypeImage.booleanValue()) {
            fileTypes.add("Images");
        }
        if (this.exportFileTypeXhtmlReport.booleanValue()) {
            fileTypes.add("XHTML Report");
        }
        if (this.exportFileTypeThumbnail.booleanValue()) {
            fileTypes.add("Thumbnail");
        }
        this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.FileTypes", (Object)String.join((CharSequence)"; ", fileTypes)));
        if (this.imagingProfile != null && this.imagingProfile.length() > 0) {
            this.imagingProfile = this.executionContext.evalParameters(this.imagingProfile, this);
            this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.ImagingProfile", (Object)this.imagingProfile));
        }
        if (this.productionProfile != null && this.productionProfile.length() > 0) {
            this.productionProfile = this.executionContext.evalParameters(this.productionProfile, this);
            this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.ProductionProfile", (Object)this.productionProfile));
        }
        try {
            this.executionContext.workflowLocalWorkersCount = Integer.parseInt(this.executionContext.evalParameters("{local_worker_count}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingLocalWorkerCountFromParameter", new Object[]{"{local_worker_count}", this.executionContext.workflowLocalWorkersCount}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.workflowLocalWorkersMemoryMb = Integer.parseInt(this.executionContext.evalParameters("{local_worker_memory}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingLocalWorkerMemoryFromParameter", new Object[]{"{local_worker_memory}", this.executionContext.workflowLocalWorkersMemoryMb}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.workflowBrokerWorkersCount = Integer.parseInt(this.executionContext.evalParameters("{broker_worker_count}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingBrokerWorkerCountFromParameter", new Object[]{"{broker_worker_count}", this.executionContext.workflowBrokerWorkersCount}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.jobBrokerPort = Integer.parseInt(this.executionContext.evalParameters("{job_worker_broker_port}", this));
            this.executionContext.jobBrokerIp = this.executionContext.evalParameters("{job_worker_broker_ip}", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executionContext.workflowLocalWorkersTempFolder = this.executionContext.evalParameters(this.executionContext.workflowLocalWorkersTempFolder, this);
        this.executionContext.closeAllTabs();
        this.startTriggerThread = new Thread(() -> {
            try {
                ArrayList<ProductionSet> productionSetsInScope = new ArrayList<ProductionSet>();
                if (this.exportMode == ExportMode.ANY_PRODUCTION_SET) {
                    productionSetsInScope.addAll(this.executionContext.nuixCase.getProductionSets());
                } else {
                    this.productionSetName = this.executionContext.evalParameters(this.productionSetName, this);
                    for (ProductionSet productionSet : this.executionContext.nuixCase.getProductionSets()) {
                        if (!productionSet.getName().equals(this.productionSetName)) continue;
                        productionSetsInScope.add(productionSet);
                        LOGGER.info("Got production set " + String.valueOf(productionSet));
                        break;
                    }
                }
                this.exportedProductionSets = 0;
                String unevaluatedExportFolder = this.exportFolder;
                this.exportProductionSetTotal = productionSetsInScope.size();
                this.exportProductionSetAt = -1;
                for (ProductionSet exportProductionSet : productionSetsInScope) {
                    ProductionProfile profile;
                    ++this.exportProductionSetAt;
                    if (this.exportProductionSetAt > 0) {
                        this.addExecutionLog(this.iu.getString("LegalExportOperation.Log.Separator"));
                    }
                    this.productionSetName = exportProductionSet.getName();
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{export_production_set_name}", this.productionSetName)));
                    this.exportFolder = this.executionContext.evalParameters(unevaluatedExportFolder, this);
                    if (this.productionProfile != null && this.productionProfile.length() > 0 && (profile = NuixUtils.getProductionProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.productionProfile)) != null) {
                        this.isProductionProfileExportOptionsUsed = profile.isExportOutputEnabled();
                        this.productionProfileExportType = profile.getExportType();
                        this.isProductionProfileExportingNative = profile.getFileNamingMap().containsKey("NATIVE");
                    }
                    this.failedItemTagName = this.executionContext.evalParameters(this.failedItemTagName, this);
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_failed_items_tag_name}", this.failedItemTagName)));
                    File exportFolderFile = new File(this.exportFolder);
                    this.exportFolder = exportFolderFile.getCanonicalPath();
                    LOGGER.info("Canonical export folder: " + this.exportFolder);
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_export_folder}", this.exportFolder)));
                    this.failedItems = new HashSet<Item>();
                    this.itemsToUntag = new HashSet<Item>();
                    if (this.legalExportType.equals((Object)LegalExportType.RELATIVITY)) {
                        this.relativityUsername = this.executionContext.evalParameters("{wfn_relativity_username}", this);
                        this.relativityWorkspaceId = this.executionContext.evalParameters("{relativity_workspace_id}", this);
                        this.relativityFolderId = this.executionContext.evalParameters("{relativity_folder_id}", this);
                        this.relativityMappingLocation = this.executionContext.evalParameters(this.relativityMappingLocation, this);
                        this.relativityHostname = this.executionContext.evalParameters("{wfn_relativity_hostname}", this);
                        this.relativityEndpointType = this.executionContext.evalParameters("{wfn_relativity_endpoint_type}", this);
                        this.relativityImportThreads = this.executionContext.evalParameters("{wfn_relativity_import_threads}", this);
                        this.relativityImportThreadTimeout = this.executionContext.evalParameters("{wfn_relativity_import_thread_timeout}", this);
                        this.relativityImportThreadRetries = this.executionContext.evalParameters("{wfn_relativity_import_thread_retries}", this);
                        this.relativityPatchInvalidEntries = this.executionContext.evalParameters("{wfn_relativity_patch_invalid_entries}", this);
                        this.relativityMappingLocation = this.executionContext.evalParameters(this.relativityMappingLocation, this);
                        this.relativityPassword = this.executionContext.evalProtectedParameter("{wfn_relativity_password}");
                        try {
                            this.relativityPassword = new WinDPAPIEncyptor().encrypt(this.relativityPassword);
                        }
                        catch (IOException e) {
                            LOGGER.warn("Cannot encrypt password", (Throwable)e);
                        }
                        Object nativeSettings = "\"NativeCopyMode\":\"CopyFiles\",";
                        boolean customNativeSettings = false;
                        String relativityNativeCopyModeParameterName = "{relativity_native_copy_mode}";
                        String relativityNativeCopyMode = this.executionContext.evalParameters(relativityNativeCopyModeParameterName, this);
                        if (!relativityNativeCopyMode.equals(relativityNativeCopyModeParameterName)) {
                            customNativeSettings = true;
                            nativeSettings = "\"NativeCopyMode\":\"" + (String)relativityNativeCopyMode + "\",";
                            this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.RelativityNativeCopyMode", (Object)relativityNativeCopyMode));
                        }
                        boolean useNativeFiles = true;
                        if (this.relativityMappingLocation.length() > 0) {
                            try {
                                Map<String, Field> fields = RelativityUtils.getInstance().parseFieldMappingFile(Paths.get(this.relativityMappingLocation, new String[0]));
                                useNativeFiles = fields.containsKey("File");
                            }
                            catch (Exception e) {
                                LOGGER.error("Cannot parse mapping file", (Throwable)e);
                            }
                        } else {
                            useNativeFiles = this.exportFileTypeNative != false || customNativeSettings;
                        }
                        this.settingsFile = FileUtils.createTempFile((String)"AutomateRelativitySettings", (String)".json");
                        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.settingsFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
                        String overwriteMode = "Append";
                        String relativityOverwriteModeParameterName = "{relativity_overwrite_mode}";
                        String relativityOverwriteMode = this.executionContext.evalParameters(relativityOverwriteModeParameterName, this);
                        if (!relativityOverwriteMode.equals(relativityOverwriteModeParameterName)) {
                            overwriteMode = relativityOverwriteMode;
                            this.addExecutionLog(this.iu.getFormattedString("RelativityLoadfileUploadOperation.Log.RelativityOverwriteMode", (Object)overwriteMode));
                        }
                        String settings = "{" + (String)(useNativeFiles ? nativeSettings : "") + "\"OverwriteMode\":\"" + overwriteMode + "\",\"SendEmailOnCompletion\":\"False\",\"TextFieldIsFilePath\":\"True\"}";
                        bufferedWriter.write(settings);
                        bufferedWriter.close();
                        LOGGER.info("Relativity settings: " + settings);
                    }
                    if (exportProductionSet == null) {
                        throw new Exception(this.iu.getFormattedString("General.Exception.ProductionSetNotInCase", (Object)this.productionSetName));
                    }
                    if (exportFolderFile.exists() && exportFolderFile.list().length > 0 && (this.exportMode != ExportMode.ANY_PRODUCTION_SET || this.exportedProductionSets == 0)) {
                        LOGGER.error("Folder has " + exportFolderFile.list().length + " items");
                        this.exception = new IOException(this.iu.getFormattedString("General.Exception.FolderNotEmpty", (Object)exportFolderFile.getCanonicalPath()));
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                    List<Item> sortedItemsToExport = new ArrayList();
                    if (this.scope.trim().length() == 0) {
                        LOGGER.info("Getting all items from production set");
                        sortedItemsToExport = exportProductionSet.getItems();
                        this.itemsInProductionSet = sortedItemsToExport.size();
                    } else {
                        this.itemsInProductionSet = this.executionContext.nuixCase.count("production-set:\"" + this.productionSetName + "\"");
                        String itemsToExportQuery = NuixUtils.addAndQuery("production-set:\"" + this.productionSetName + "\"", this.scope);
                        LOGGER.info("Getting items " + itemsToExportQuery);
                        Set itemsToExport = this.executionContext.nuixCase.searchUnsorted(itemsToExportQuery);
                        for (Item productionSetItem : exportProductionSet.getItems()) {
                            if (!itemsToExport.contains(productionSetItem)) continue;
                            sortedItemsToExport.add(productionSetItem);
                        }
                    }
                    this.itemsInScopeCount = sortedItemsToExport.size();
                    this.addExecutionLog(this.iu.getFormattedString("General.Log.ProductionSetName", (Object)this.productionSetName));
                    this.addExecutionLog(this.iu.getNumeralString("General.Log.ProductionSetCount", this.itemsInProductionSet));
                    this.addExecutionLog(this.iu.getNumeralString("General.Log.ScopeCount", this.itemsInScopeCount));
                    if (this.exportMode != ExportMode.ANY_PRODUCTION_SET && this.itemsInScopeCount != this.itemsInProductionSet) {
                        this.addWarning(this.iu.getNumeralFormattedString("LegalExportOperation.Warning.PerformingPartialExportOf", this.itemsInScopeCount, (Object)this.iu.getNumeralString("LegalExportOperation.Warning.ItemsInProductionSet", this.itemsInProductionSet)));
                    }
                    if (this.itemsInScopeCount == 0L) continue;
                    this.itemsInScope = new ArrayList<Item>(sortedItemsToExport);
                    if (this.exportSplit.booleanValue() && this.itemsInScopeCount > (long)this.exportSplitAt) {
                        this.addExecutionLog(this.iu.getNumeralString("General.Log.SplitExportAt", (long)this.exportSplitAt));
                        if (this.exportConsolidateSplits.booleanValue()) {
                            this.addExecutionLog(this.iu.getString("LegalExportOperation.Log.ConsolidateExportParts"));
                        }
                        LOGGER.info("Exporting in parts");
                        int addedForExport = 0;
                        this.exportPart = 0;
                        while (addedForExport < this.itemsInScope.size()) {
                            long itemsFailedInPart;
                            if (this.stopRequested) {
                                this.stopLoad();
                                this.trackStopped();
                                return;
                            }
                            ArrayList<Item> partProductionSetItems = new ArrayList<Item>();
                            this.partStartPercentage = (double)addedForExport / (double)this.itemsInScope.size();
                            LOGGER.info("Exported in parts: " + addedForExport + " of " + this.itemsInScope.size());
                            ++this.exportPart;
                            int nextItemId = Math.min(addedForExport + this.exportSplitAt, this.itemsInScope.size());
                            partProductionSetItems.addAll(this.itemsInScope.subList(addedForExport, nextItemId));
                            LOGGER.info("Exporting part from " + addedForExport + " to " + (nextItemId - 1));
                            addedForExport = nextItemId;
                            LOGGER.info("Added to export: " + addedForExport);
                            String lastTlGuid = ((Item)partProductionSetItems.get(partProductionSetItems.size() - 1)).getTopLevelItem().getGuid();
                            LOGGER.info("Last TL Guid: " + lastTlGuid);
                            while (this.itemsInScope.size() > addedForExport) {
                                Item nextItem = this.itemsInScope.get(addedForExport);
                                String nextTlGuid = nextItem.getTopLevelItem().getGuid();
                                LOGGER.info("Next TL Guid: " + nextTlGuid);
                                if (!lastTlGuid.equals(nextTlGuid)) break;
                                partProductionSetItems.add(nextItem);
                                LOGGER.info("Adding to export, total: " + ++addedForExport + " of " + this.itemsInScope.size());
                            }
                            double trancheEndPercentage = (double)addedForExport / (double)this.itemsInScope.size();
                            this.partSizePercentage = trancheEndPercentage - this.partStartPercentage;
                            LOGGER.info("Exporting part " + this.exportPart);
                            this.addExecutionLog(this.iu.getNumeralFormattedString("General.Log.ExportFolderParts", (long)partProductionSetItems.size(), new Object[]{this.exportFolder, this.exportPart}));
                            long oldItemsFailedCount = this.failedExportItemCount;
                            if (this.exportConsolidateSplits.booleanValue()) {
                                this.exportItems(this.exportFolder + "/Part" + this.exportPart, this.exportFolder, exportProductionSet, partProductionSetItems);
                            } else {
                                this.exportItems(this.exportFolder + "/Part" + this.exportPart, null, exportProductionSet, partProductionSetItems);
                            }
                            if ((itemsFailedInPart = this.failedExportItemCount - oldItemsFailedCount) <= 0L) continue;
                            if (this.exportConsolidateSplits.booleanValue()) {
                                this.addWarning(this.iu.getNumeralFormattedString("LegalExportOperation.Warning.FailedExportingPartExplained", itemsFailedInPart, (Object)this.exportPart));
                                continue;
                            }
                            this.addWarning(this.iu.getNumeralFormattedString("LegalExportOperation.Warning.FailedExportingPartDetailed", itemsFailedInPart, (Object)this.exportPart));
                        }
                        LOGGER.info("Exported in parts: " + addedForExport + " of " + this.itemsInScope.size());
                    } else {
                        this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.ExportFolder", (Object)this.exportFolder));
                        this.exportItems(this.exportFolder, null, exportProductionSet, this.itemsInScope);
                        if (this.failedExportItemCount > 0L) {
                            this.addWarning(this.iu.getNumeralString("LegalExportOperation.Warning.FailedExportingPart", this.failedExportItemCount));
                        }
                    }
                    if (!this.stopRequested) {
                        this.waitForRelativityLoad();
                        if (this.relativityLoadItemIdsWithErrors == null) {
                            this.relativityLoadItemIdsWithErrors = new HashSet<Integer>();
                        }
                        if (this.relativityLoadItemIdsWithErrors.size() > 0 || this.relativityFatalErrorEncountered) {
                            if (this.relativityFatalErrorEncountered) {
                                this.addWarning(this.iu.getNumeralString("LegalExportOperation.Warning.ItemsMoreCouldNotBeLoaded", (long)this.relativityLoadItemIdsWithErrors.size()));
                            } else {
                                this.addWarning(this.iu.getNumeralString("LegalExportOperation.Warning.ItemsCouldNotBeLoaded", (long)this.relativityLoadItemIdsWithErrors.size()));
                            }
                            if (this.tagFailedItems.booleanValue()) {
                                for (int lineId : this.relativityLoadItemIdsWithErrors) {
                                    Item failedItem = this.itemsInScope.get(lineId);
                                    if (failedItem == null) continue;
                                    this.failedItems.add(failedItem);
                                }
                            }
                        }
                        if (this.tagFailedItems.booleanValue() && this.failedItems.size() > 0) {
                            LOGGER.info("Tagging " + this.failedItems.size() + " items with tag " + this.failedItemTagName);
                            BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                            bulkAnnotater.addTag(this.failedItemTagName, this.failedItems);
                            this.addExecutionLog(this.iu.getNumeralFormattedString("LegalExportOperation.Log.Tagged", (long)this.failedItems.size(), (Object)this.failedItemTagName));
                        }
                        if (this.tagFailedItems.booleanValue() && this.untagSuccessfulItems.booleanValue()) {
                            String query = "tag:\"" + this.failedItemTagName + "\" and production-set:\"" + this.productionSetName + "\"";
                            LOGGER.info("Searching: " + query);
                            Set previouslyTaggedItems = this.executionContext.nuixCase.searchUnsorted(query);
                            this.itemsToUntag = this.executionContext.nuixUtilities.getItemUtility().difference((Collection)previouslyTaggedItems, this.failedItems);
                            if (this.itemsToUntag.size() > 0) {
                                LOGGER.info("Untagging " + this.itemsToUntag.size() + " items with tag " + this.failedItemTagName);
                                BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                                bulkAnnotater.removeTag(this.failedItemTagName, this.itemsToUntag);
                                this.addExecutionLog(this.iu.getNumeralFormattedString("LegalExportOperation.Log.Untagged", (long)this.itemsToUntag.size(), (Object)this.failedItemTagName));
                            }
                        }
                    } else {
                        this.stopLoad();
                        this.trackStopped();
                        return;
                    }
                    ++this.exportedProductionSets;
                }
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                if (this.relativityFatalErrorEncountered) {
                    this.exception = new Exception(this.iu.getFormattedString("RelativityOperation.Error.CriticalError", new Object[0]));
                    this.executionState = ExecutionState.ERROR;
                } else {
                    this.trackFinished();
                }
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                if (this.legalExportType == LegalExportType.RELATIVITY) {
                    String message = ExceptionUtils.getExceptionPrintableMessage((Throwable)e);
                    if (message != null && this.relativityPassword != null) {
                        message = message.replace(this.relativityPassword, Parameter.MASKED_VALUE);
                    }
                    this.exception = new Exception(message);
                } else {
                    this.exception = e;
                }
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void consolidateExportPart(Path mainExportPath, Path partExportPath, int exportPart) {
        try {
            Files.createDirectories(mainExportPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Cannot create main export path folder", (Throwable)e);
        }
        try {
            Stream<Path> filesList = Files.list(partExportPath);
            for (Path path : filesList.collect(Collectors.toList())) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Path destinationPath = Paths.get(mainExportPath.toString(), path.getFileName().toString());
                    try {
                        FileUtils.moveMergeDirectories((Path)path, (Path)destinationPath);
                    }
                    catch (IOException e) {
                        this.addWarning(this.iu.getFormattedString("LegalExportOperation.Warning.CannotConsolidatePartialExport", new Object[]{exportPart, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                        LOGGER.error("Cannot consolidate partial export " + exportPart + " folder " + path.toString(), (Throwable)e);
                    }
                    continue;
                }
                File exportFile = path.toFile();
                String extension = FilenameUtils.getExtension((String)exportFile.getName());
                String filename = exportFile.getName();
                String filenameWithPart = filename.substring(0, filename.length() - extension.length() - 1) + "_" + exportPart + "." + extension;
                Path destinationPath = Paths.get(mainExportPath.toString(), filenameWithPart);
                try {
                    Files.move(path, destinationPath, new CopyOption[0]);
                }
                catch (IOException e) {
                    this.addWarning(this.iu.getFormattedString("LegalExportOperation.Warning.CannotConsolidatePartialExport", new Object[]{exportPart, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                    LOGGER.error("Cannot consolidate partial export " + exportPart + " file " + exportFile.toString(), (Throwable)e);
                }
            }
            filesList.close();
            LOGGER.info("Deleting partial export folder " + String.valueOf(partExportPath));
            org.apache.commons.io.FileUtils.deleteDirectory((File)partExportPath.toFile());
        }
        catch (IOException e) {
            this.addWarning(this.iu.getFormattedString("LegalExportOperation.Warning.CannotConsolidatePartialExport", new Object[]{exportPart, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
            LOGGER.error("Cannot consolidate partial export " + exportPart, (Throwable)e);
        }
    }

    @Override
    protected void stopTriggered() {
        LOGGER.info("Stop triggered");
        Thread thread = new Thread(() -> {
            while (this.executionState == ExecutionState.STOPPING) {
                try {
                    if (this.exportProcessingJob != null) {
                        LOGGER.info("Sending stop command while job is in state " + this.exportProcessingJob.getCurrentStage());
                        this.exportProcessingJob.stop();
                    }
                }
                catch (LicenceException e) {
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot stop job");
                }
                if (this.legalExportType.equals((Object)LegalExportType.RELATIVITY)) {
                    this.stopLoad();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        thread.setName("Automate - Operation " + this.getOperationName() + " Stop request");
        thread.start();
    }

    @Override
    public synchronized void updateState() {
        if (this.exportProcessingJob != null) {
            if (!this.isPaused && this.exportProcessingJob.hasPaused()) {
                this.isPaused = true;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", false);
            }
            if (this.isPaused && !this.exportProcessingJob.hasPaused()) {
                this.isPaused = false;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", true);
            }
            if (this.exportProcessingJob.hasFinished() && this.executionState == ExecutionState.STOPPING) {
                this.trackStopped();
            }
        }
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete;
        block9: {
            percentageComplete = 0.0;
            if (this.exportProcessingJob != null) {
                try {
                    int stageCount = this.stageNameToId.size();
                    if (this.legalExportType.equals((Object)LegalExportType.RELATIVITY)) {
                        ++stageCount;
                    }
                    int currentStage = 0;
                    long itemsExported = 0L;
                    long itemsCount = this.exportProcessingJob.getTotalItemCount();
                    String exportStage = this.exportProcessingJob.getCurrentStage().toLowerCase();
                    if (this.stageNameToId.containsKey(exportStage)) {
                        currentStage = this.stageNameToId.get(exportStage);
                    }
                    itemsExported = this.exportProcessingJob.getCurrentStageExportedItemsCount();
                    double stageExportPercentageComplete = 0.0;
                    if (itemsCount > 0L) {
                        stageExportPercentageComplete = (double)itemsExported / (double)itemsCount;
                    }
                    percentageComplete = (stageExportPercentageComplete + (double)currentStage) / (double)stageCount;
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block9;
                    LOGGER.debug("Cannot get progress.", (Throwable)e);
                }
            }
        }
        if (this.partSizePercentage > 0.0) {
            percentageComplete = percentageComplete * this.partSizePercentage + this.partStartPercentage;
        }
        if (this.legalExportType.equals((Object)LegalExportType.RELATIVITY)) {
            double loadPercentageComplete = 0.0;
            if (this.itemsInScopeCount > 0L) {
                loadPercentageComplete = (double)this.totalItemsLoadedIntoRelativity / (double)this.itemsInScopeCount;
            }
            percentageComplete = (percentageComplete + loadPercentageComplete) / 2.0;
        }
        return (percentageComplete + (double)this.exportProductionSetAt) / (double)this.exportProductionSetTotal;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result;
        block14: {
            result = "";
            double percentageComplete = -1.0;
            percentageComplete = this.getNormalizedPercentageComplete();
            if (!Double.isNaN(percentageComplete)) {
                result = String.format("%.2f%%", percentageComplete * 100.0);
            }
            if (this.exportProcessingJob != null) {
                try {
                    Object exportStage = "";
                    if (!this.exportProcessingJob.hasFinished() || this.executionState == ExecutionState.STOPPED) {
                        if (this.exportPart > 0) {
                            exportStage = this.iu.getFormattedString("General.Progress.Part", (Object)this.exportPart);
                        }
                        try {
                            exportStage = (String)exportStage + FormattingUtils.stageToString((String)this.exportProcessingJob.getCurrentStage().toLowerCase());
                        }
                        catch (Exception e) {
                            exportStage = (String)exportStage + this.iu.getString("General.Progress.Discovering");
                        }
                        exportStage = (String)exportStage + this.iu.getNumeralString("General.Progress.ItemsProcessed", this.exportProcessingJob.getCurrentStageExportedItemsCount());
                    } else {
                        exportStage = "";
                    }
                    if (this.relativityLoadProcess != null) {
                        Object loadStage = "";
                        if (this.loadPart > 0) {
                            loadStage = (String)loadStage + this.iu.getFormattedString("General.Progress.Part", (Object)this.loadPart);
                        }
                        loadStage = (String)loadStage + this.iu.getString("LegalExportOperation.Progress.Loading");
                        loadStage = (String)loadStage + this.iu.getNumeralString("General.Progress.ItemsProcessed", (long)this.itemsLoadedIntoRelativity);
                        exportStage = ((String)exportStage).length() > 0 ? (String)loadStage + " | " + (String)exportStage : loadStage;
                    }
                    if (((String)result).length() > 0 && ((String)exportStage).length() > 0) {
                        result = (String)result + " / ";
                    }
                    result = (String)result + (String)exportStage;
                }
                catch (Exception e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Cannot get job stage.", (Throwable)e);
                    }
                    break block14;
                }
            }
            String exportStage = this.iu.getString("General.Progress.Initializing");
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + exportStage;
        }
        return result;
    }

    public int getExportParts() {
        return this.exportPart;
    }

    @Override
    public String getUtilizationScopeQuery() {
        String query;
        if (this.exportMode == ExportMode.ANY_PRODUCTION_SET) {
            query = this.scope;
            query = NuixUtils.addAndQuery(query, "has-exclusion:0");
        } else {
            query = this.scope;
            query = NuixUtils.addAndQuery(query, "production-set:\"" + this.productionSetName + "\"");
            query = NuixUtils.addAndQuery(query, "has-exclusion:0");
        }
        return query;
    }

    @Override
    public String getProcessingJobGuid() {
        if (this.exportProcessingJob != null) {
            return this.exportProcessingJob.getJobGuid();
        }
        return null;
    }

    public void itemProcessed(ItemEventInfo itemEventInfo) {
        this.trackIncrementVolumeProcessed(itemEventInfo.getItem().getAuditedSize());
        Item processedItem = itemEventInfo.getItem();
        String mimeType = "unknown";
        String pathName = "N/A";
        if (processedItem != null) {
            pathName = String.join((CharSequence)"/", processedItem.getPathNames());
            mimeType = processedItem.getType().getName();
        }
        String stage = itemEventInfo.getStage() == null ? "exported" : itemEventInfo.getStage();
        String translatedStage = this.iu.getString("MimeType.Stage." + stage);
        this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.ExportedStage", new Object[]{translatedStage, pathName}));
        this.trackItemProcessedFailed(mimeType, stage, itemEventInfo.getFailure() != null);
        if (this.tagFailedItems.booleanValue() && itemEventInfo.getFailure() != null) {
            this.failedItems.add(itemEventInfo.getItem());
        }
    }

    @Override
    public Consumption getOperationConsumption() {
        if (this.legalExportType.equals((Object)LegalExportType.RELATIVITY) && !this.relativityFatalErrorEncountered) {
            Consumption consumption = new Consumption();
            ConsumptionEvent consumptionEvent = new ConsumptionEvent();
            consumptionEvent.setConsumptionEventId(UidUtils.getRandom());
            consumptionEvent.setLicenseId(this.executionContext.licenceSession.getLicenceInfo().getId());
            consumptionEvent.setConsumptionStartEpoch(this.startDateTime.getMillis());
            if (this.finishedDateTime != null) {
                consumptionEvent.setConsumptionEndEpoch(this.finishedDateTime.getMillis());
            } else {
                consumptionEvent.setConsumptionEndEpoch(this.startDateTime.getMillis());
            }
            consumptionEvent.setPlatformType(ConsumptionPlatformType.RELATIVITY_REVIEW);
            consumptionEvent.setPlatformId(this.relativityHostname);
            consumptionEvent.setConsumptionType(ConsumptionType.DATA_LOADED);
            consumptionEvent.setUnitType(UnitType.AUDITED_BYTES);
            consumptionEvent.setUnits(this.getVolume(this.executionContext.workflowExecution));
            consumptionEvent.setResourceType(ResourceType.RELATIVITY_WORKSPACE_ID);
            consumptionEvent.setResourceId(this.relativityWorkspaceId);
            if (this.executionContext.getEngine() != null) {
                consumptionEvent.setJobId(this.executionContext.getEngine().getJobId());
            }
            consumption.add(consumptionEvent);
            return consumption;
        }
        return null;
    }

    @Override
    public Integer getWorkerMemory() {
        if (this.executionContext.workflowBrokerWorkersCount <= 0) {
            return null;
        }
        return this.workerMemory;
    }

    @Override
    public Integer getAddedWorkerCount() {
        if (this.addedWorkerCount == null) {
            return 0;
        }
        return this.addedWorkerCount.get();
    }
}

