/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.LogicalImageExportOperation;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Item;
import nuix.LogicalImageExporter;

public class LogicalImageExportOperationImplementation
extends LogicalImageExportOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LogicalImageExportOperation.class);
    transient Map<String, Integer> stageNameToId;
    private transient AtomicLong stageCount;
    private transient long stageTotal;
    private transient AtomicLong failedCount;

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.exportFolder = this.executionContext.evalParameters(this.exportFolder, this);
        this.name = this.executionContext.evalParameters(this.name, this);
        this.evidenceNumber = this.executionContext.evalParameters(this.evidenceNumber, this);
        this.failedCount = new AtomicLong(0L);
        this.stageCount = new AtomicLong(0L);
        File exportFolderFile = new File(this.exportFolder);
        if (!exportFolderFile.exists()) {
            exportFolderFile.mkdirs();
        }
        this.exportFolder = exportFolderFile.getCanonicalPath();
        LOGGER.info("Canonical export folder: " + this.exportFolder);
        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_export_folder}", this.exportFolder)));
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                HashMap options = new HashMap();
                LogicalImageExporter logicalImageExporter = this.executionContext.nuixUtilities.createLogicalImageExporter(this.exportFolder, this.name, options);
                String scopeQuery = NuixUtils.addAndQuery(this.scope, "has-exclusion:0");
                LOGGER.info("Searching for " + scopeQuery);
                this.addExecutionLog(this.iu.getFormattedString("LogicalImageExportOperation.Log.ScopeQuery", (Object)this.scope));
                Set items = this.executionContext.nuixCase.searchUnsorted(scopeQuery);
                long itemsInScope = items.size();
                this.addExecutionLog(this.iu.getNumeralString("LogicalImageExportOperation.Log.ScopeCount", itemsInScope));
                if (this.includeFamilies.booleanValue()) {
                    items = this.executionContext.nuixUtilities.getItemUtility().findFamilies((Collection)items);
                    this.addExecutionLog(this.iu.getString("LogicalImageExportOperation.Log.IncludeFamilyMembers"));
                }
                this.stageTotal = items.size();
                this.addExecutionLog(this.iu.getNumeralString("LogicalImageExportOperation.Log.EffectiveCount", this.stageTotal));
                if (items.size() > 0) {
                    for (Item item : items) {
                        if (this.stopRequested) {
                            throw new WorkflowExecutionStopRequested();
                        }
                        try {
                            logicalImageExporter.addItem(item);
                            this.trackItemProcessed(item.getType().getName(), false);
                            this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.Exported", (Object)String.join((CharSequence)"/", item.getPathNames())));
                        }
                        catch (Throwable e) {
                            this.failedCount.incrementAndGet();
                            this.trackItemProcessed(item.getType().getName(), true);
                            this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.Failed", (Object)String.join((CharSequence)"/", item.getPathNames())));
                            LOGGER.error("Cannot export item " + item.getGuid(), e);
                        }
                        this.stageCount.incrementAndGet();
                    }
                    this.addExecutionLog(this.iu.getNumeralString("LogicalImageExportOperation.Log.ExportedCount", this.stageCount.get()));
                    logicalImageExporter.close();
                    if (this.failedCount.longValue() != 0L) {
                        this.addWarning(this.iu.getNumeralString("LogicalImageExportOperation.Warning.ErrorsDuringExport", this.failedCount.longValue()));
                    }
                    if (this.stageCount.get() > 0L) {
                        this.addExecutionLog(this.iu.getFormattedString("LogicalImageExportOperation.Log.ExportName", (Object)this.name));
                        this.addExecutionLog(this.iu.getFormattedString("LogicalImageExportOperation.Log.ExportFolder", (Object)this.exportFolder));
                    }
                } else {
                    this.addWarning(this.iu.getString("LogicalImageExportOperation.Warning.NoItemsMatchedSearchQuery"));
                    LOGGER.warn("No items matched search query");
                    this.trackFinished();
                    return;
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        double stagePercentageComplete = 0.0;
        if (this.stageTotal > 0L && this.stageCount != null) {
            stagePercentageComplete = (double)this.stageCount.get() / (double)this.stageTotal;
        }
        percentageComplete = stagePercentageComplete;
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (((String)result).length() > 0) {
            result = (String)result + " / ";
        }
        if (this.stageCount == null || this.stageCount.get() == 0L) {
            String exportStage = this.iu.getString("LogicalImageExportOperation.Progress.Initializing");
            result = (String)result + exportStage;
        } else {
            String exportStage = this.iu.getString("LogicalImageExportOperation.Progress.Exporting");
            result = (String)result + exportStage;
            result = (String)result + this.iu.getNumeralString("LogicalImageExportOperation.Progress.ItemsProcessed", this.stageCount.get());
        }
        return result;
    }
}

