/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.utils.digestlist.DigestLocation;
import com.nuix.automate.workflow.core.utils.digestlist.DigestOperation;
import java.util.List;

@OperationMetadata(alias=OperationAlias.MANAGE_DIGEST_LISTS, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"CULLING"})})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class ManageDigestListsOperation
extends Operation {
    @FormField
    public String digestListA = "";
    @FormField
    public String digestListB = "";
    @FormField
    public DigestOperation digestOperation = DigestOperation.ADD;
    @FormField
    public String resultName = "";
    @FormField
    public DigestLocation resultLocation = DigestLocation.CASE;
    @FormField
    public boolean overwriteIfExists = false;

    @Override
    public String getOperationName() {
        return this.iu.getString("ManageDigestListsOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.MANAGE_DIGEST_LISTS;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.digestListA.trim().length() == 0) {
            prerequisites.add(this.iu.getString("ManageDigestListsOperation.Prerequisites.DigestListAMustBeSpecified"));
        }
        if (this.digestListB.trim().length() == 0) {
            prerequisites.add(this.iu.getString("ManageDigestListsOperation.Prerequisites.DigestListBMustBeSpecified"));
        }
        if (this.resultName.trim().length() == 0) {
            prerequisites.add(this.iu.getString("ManageDigestListsOperation.Prerequisites.ResultDigestListNameMustBeSpecified"));
        }
        if (this.resultLocation == DigestLocation.LOCAL_COMPUTER && !System.getProperty("os.name").contains("Windows")) {
            prerequisites.add(this.iu.getFormattedString("ManageDigestListsOperation.Prerequisites.LocationNotSupported", (Object)DigestLocation.LOCAL_COMPUTER));
        }
        this.requiresCase = this.resultLocation == DigestLocation.CASE;
        return prerequisites;
    }
}

