/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.ManageDigestListsOperation;
import com.nuix.automate.workflow.core.utils.digestlist.DigestHelper;
import java.io.IOException;

public class ManageDigestListsOperationImplementation
extends ManageDigestListsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ManageDigestListsOperation.class);
    private transient DigestHelper digestHelper;
    private transient String stageName;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                this.digestHelper = new DigestHelper(this.executionContext.nuixCase);
                this.digestListA = this.executionContext.evalParameters(this.digestListA, this);
                this.digestListB = this.executionContext.evalParameters(this.digestListB, this);
                this.resultName = this.executionContext.evalParameters(this.resultName, this);
                this.addExecutionLog(this.iu.getFormattedString("ManageDigestListsOperation.Log.DigestListA", (Object)this.digestListA));
                this.addExecutionLog(this.iu.getFormattedString("ManageDigestListsOperation.Log.DigestListB", (Object)this.digestListB));
                this.addExecutionLog(this.iu.getFormattedString("ManageDigestListsOperation.Log.Operation", (Object)this.digestOperation));
                this.addExecutionLog(this.iu.getFormattedString("ManageDigestListsOperation.Log.ResultingDigestListName", (Object)this.resultName));
                this.addExecutionLog(this.iu.getFormattedString("ManageDigestListsOperation.Log.ResultingDigestListLocation", (Object)this.resultLocation));
                if (this.overwriteIfExists && this.digestHelper.getDigestListExists(this.resultName, this.resultLocation)) {
                    this.addExecutionLog(this.iu.getString("ManageDigestListsOperation.Log.OverwritingExistingDigestList"));
                }
                this.stageName = this.iu.getString("ManageDigestListsOperation.Stage.PerformingOperationAndWritingResultingList");
                int resultCount = this.digestHelper.manageDigestLists(this.digestListA, this.digestListB, this.digestOperation, this.resultName, this.resultLocation, this.overwriteIfExists);
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                this.addExecutionLog(this.iu.getNumeralString("ManageDigestListsOperation.Log.ResultingDigestListSize", (long)resultCount));
                this.trackFinished();
            }
            catch (ParameterException e) {
                LOGGER.error("Error evaluating parameters", (Throwable)e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            catch (IOException | IllegalArgumentException e) {
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected void stopTriggered() {
        this.digestHelper.requestStop();
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        long itemsProcessed = 0L;
        if (this.digestHelper != null) {
            itemsProcessed = this.digestHelper.getItemsProcessed();
        }
        if (itemsProcessed > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("ManageDigestListsOperation.Progress.ItemsProcessed", itemsProcessed);
        }
        return result;
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.digestHelper != null) {
            percentageComplete = this.digestHelper.getExecutionProgress();
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }
}

