/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.MatchItemsOperation;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import nuix.BulkAnnotater;
import nuix.DocumentNumber;
import nuix.Item;
import nuix.ProductionSetItem;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class MatchItemsOperationImplementation
extends MatchItemsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(MatchItemsOperation.class);
    private transient long countItemsToProcess;
    private transient AtomicLong countItemsProcessed;
    private transient AtomicLong countItemsMatched;

    @Override
    public void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                long nonMatchedKeywords;
                String header;
                this.scope = this.executionContext.evalParameters(this.scope, this);
                this.tag = this.executionContext.evalParameters(this.tag, this);
                this.sourceTextFile = this.executionContext.evalParameters(this.sourceTextFile, this);
                this.executionContext.closeAllTabs();
                this.countItemsProcessed = new AtomicLong(0L);
                this.countItemsMatched = new AtomicLong(0L);
                this.addExecutionLog(this.iu.getFormattedString("MatchItemsOperation.Log.MatchItemsBy", (Object)this.getMatchBy()));
                this.addExecutionLog(this.iu.getFormattedString("MatchItemsOperation.Log.SourceTextFile", (Object)this.sourceTextFile));
                List fileLines = FileUtils.readFileNonBlankLinesWithAutodetectEncoding((File)new File(this.sourceTextFile), (boolean)true, (boolean)true);
                if (this.fileHasHeader) {
                    header = (String)fileLines.get(0);
                    fileLines.remove(0);
                } else {
                    header = null;
                }
                AtomicBoolean headerMatched = new AtomicBoolean(false);
                Map keywords = fileLines.stream().collect(Collectors.toConcurrentMap(value -> value, value -> false));
                this.addExecutionLog(this.iu.getFormattedString("MatchItemsOperation.Log.ScopeQuery", (Object)this.scope));
                Set items = this.executionContext.nuixCase.searchUnsorted(this.scope);
                this.countItemsToProcess = items.size();
                this.addExecutionLog(this.iu.getNumeralString("MatchItemsOperation.Log.ScopeCount", this.countItemsToProcess));
                Set itemsToTag = Collections.newSetFromMap(new ConcurrentHashMap());
                Set matchedItems = Collections.newSetFromMap(new ConcurrentHashMap());
                FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner((Iterable)items, ItemsUtils.getPartitionerChunkSize(1000, this));
                Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                    while (iterator.hasNext()) {
                        Item item = (Item)iterator.next();
                        boolean match = false;
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        try {
                            if (this.matchItemsByMD5) {
                                String md5 = item.getDigests().getMd5();
                                if (header != null && md5 != null && header.equals(md5.toLowerCase())) {
                                    match = true;
                                    headerMatched.set(true);
                                    keywords.put(md5.toLowerCase(), true);
                                }
                                if (md5 != null && keywords.containsKey(md5.toLowerCase())) {
                                    match = true;
                                    keywords.put(md5.toLowerCase(), true);
                                }
                            }
                            if (this.matchItemsByDocID) {
                                for (ProductionSetItem productionSetItem : item.getProductionSetItems()) {
                                    DocumentNumber docNumber = productionSetItem.getDocumentNumber();
                                    if (docNumber == null) continue;
                                    String docId = docNumber.toString().trim().toLowerCase();
                                    if (header != null && docId.length() > 0 && header.equals(docId)) {
                                        match = true;
                                        headerMatched.set(true);
                                        keywords.put(docId, true);
                                    }
                                    if (docId.length() <= 0 || !keywords.containsKey(docId)) continue;
                                    match = true;
                                    keywords.put(docId, true);
                                    break;
                                }
                            }
                            if (this.matchItemsByGUID) {
                                String guid = item.getGuid();
                                if (header != null) {
                                    if (header.equals(guid)) {
                                        match = true;
                                        headerMatched.set(true);
                                        keywords.put(guid, true);
                                    } else if (header.equals(guid.replace("-", ""))) {
                                        match = true;
                                        headerMatched.set(true);
                                        keywords.put(guid.replace("-", ""), true);
                                    }
                                }
                                if (keywords.containsKey(guid)) {
                                    match = true;
                                    keywords.put(guid, true);
                                } else if (keywords.containsKey(guid.replace("-", ""))) {
                                    match = true;
                                    keywords.put(guid.replace("-", ""), true);
                                }
                            }
                            if (match) {
                                matchedItems.add(item);
                                this.countItemsMatched.incrementAndGet();
                            }
                            this.countItemsProcessed.incrementAndGet();
                        }
                        catch (Throwable e) {
                            LOGGER.error("Cannot process item " + item.getGuid(), e);
                        }
                    }
                }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                if (headerMatched.get()) {
                    this.addWarning(this.iu.getString("MatchItemsOperation.Warning.HeaderMatched"));
                }
                if ((nonMatchedKeywords = keywords.values().stream().filter(value -> value == false).count()) > 0L) {
                    this.addWarning(this.iu.getNumeralString("MatchItemsOperation.Warning.KeywordsNotMatched", nonMatchedKeywords));
                }
                this.addExecutionLog(this.iu.getNumeralString("MatchItemsOperation.Log.MatchCount", this.countItemsMatched.get()));
                this.addExecutionLog(this.iu.getFormattedString("MatchItemsOperation.Log.TagScope", (Object)this.tagScope));
                this.addExecutionLog(this.iu.getFormattedString("MatchItemsOperation.Log.TagName", (Object)this.tag));
                switch (this.tagScope) {
                    case MATCHES: {
                        itemsToTag = matchedItems;
                        break;
                    }
                    case ALL_FAMILIES: {
                        itemsToTag = this.executionContext.nuixUtilities.getItemUtility().findFamilies(matchedItems);
                        break;
                    }
                    case ALL_DESCENDANTS: {
                        itemsToTag = this.executionContext.nuixUtilities.getItemUtility().findDescendants(matchedItems);
                        break;
                    }
                    case MATCHES_DESCENDANTS: {
                        itemsToTag = this.executionContext.nuixUtilities.getItemUtility().findItemsAndDescendants(matchedItems);
                        break;
                    }
                    case TOP_LEVEL: {
                        itemsToTag = this.executionContext.nuixUtilities.getItemUtility().findTopLevelItems(matchedItems);
                    }
                }
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                if (itemsToTag.size() > 0) {
                    Set finalItemsToTag = itemsToTag;
                    this.executionContext.nuixCase.withWriteAccess(() -> {
                        LOGGER.info("Tagging " + finalItemsToTag.size() + " items with " + this.tag);
                        BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                        try {
                            bulkAnnotater.addTag(this.tag, (Collection)finalItemsToTag);
                        }
                        catch (IOException e) {
                            LOGGER.error("Failed to tag items", (Throwable)e);
                        }
                    });
                }
                this.addExecutionLog(this.iu.getNumeralString("MatchItemsOperation.Log.TagCount", (long)itemsToTag.size()));
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.countItemsToProcess > 0L) {
            percentageComplete = (double)this.countItemsProcessed.get() / (double)this.countItemsToProcess;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.countItemsMatched != null) {
            result = (String)result + this.iu.getNumeralString("MatchItemsOperation.Progress.MatchedItems", this.countItemsMatched.get());
        }
        return result;
    }

    private String getMatchBy() {
        ArrayList<String> matchBy = new ArrayList<String>();
        if (this.matchItemsByMD5) {
            matchBy.add("MD5");
        }
        if (this.matchItemsByGUID) {
            matchBy.add("GUID");
        }
        if (this.matchItemsByDocID) {
            matchBy.add("DocID");
        }
        return String.join((CharSequence)";", matchBy);
    }
}

