/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.services.metrics.Activity;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.utilization.MimeTypeVolume;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.NativeMimeTypeVolumesUtilizationOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldRow(name="assemblePagesRow", children={"assemblePagesEnabled", "assemblePagesRegex"})
@OperationMetadata(alias=OperationAlias.NATIVE_OCR_IMAGES, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_AUTOMATE"}), @OperationTag(name="Category", value={"OCR"})})
@OperationLicenseModule(module=ModuleType.NATIVE_OCR)
public class NativeOcrImagesOperation
extends NativeMimeTypeVolumesUtilizationOperation {
    @FormField
    public String sourceImagesFolder;
    @FormField
    public boolean scanFolderRecursively;
    @FormField
    public boolean skipImagesWithExistingText;
    @FormField
    public boolean assemblePagesEnabled;
    @FormField(enableOn={@OnField(name="assemblePagesEnabled")})
    @ExcludeFromPrintableOptions
    public String assemblePagesRegex;
    @FormField
    public String destinationTextFolder;
    @FormField
    public boolean keepIncompleteFiles;
    @FormField
    public boolean createSearchablePdf;
    @FormField(enableOn={@OnField(name="createSearchablePdf")})
    @ExcludeFromPrintableOptions
    public String destinationPdfFolder;

    public boolean getDisplayAssemblePagesRegex() {
        return this.assemblePagesEnabled;
    }

    public boolean getDisplayDestinationPdfFolder() {
        return this.createSearchablePdf;
    }

    public NativeOcrImagesOperation() {
        this.requiresCase = false;
        this.sourceImagesFolder = "";
        this.scanFolderRecursively = false;
        this.destinationTextFolder = "";
        this.destinationPdfFolder = "";
        this.skipImagesWithExistingText = true;
        this.assemblePagesEnabled = false;
        this.assemblePagesRegex = "(.*\\d+)(_\\d+)";
        this.createSearchablePdf = true;
        this.keepIncompleteFiles = false;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("NativeOcrImagesOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.NATIVE_OCR_IMAGES;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.sourceImagesFolder.trim().length() == 0) {
            prerequisites.add(this.iu.getString("NativeOcrImagesOperation.Prerequisites.SourceImagesFolderMustBeSpecified"));
        }
        if (this.destinationTextFolder.trim().length() == 0) {
            prerequisites.add(this.iu.getString("NativeOcrImagesOperation.Prerequisites.DestinationTextFolderMustBeSpecified"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }

    @Override
    public List<MimeTypeVolume> getMimeTypeVolumes() {
        return null;
    }

    @Override
    public Activity getActivity() {
        return Activity.OCR;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.OCR;
    }

    @Override
    public long getVolume(WorkflowExecution workflowExecution) {
        return 0L;
    }
}

