/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.workflow.core.execution.operations.OcrImagesOperationImplementation;
import com.nuix.automate.workflow.core.execution.options.nativeocr.WorkersAssignmentMode;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import com.nuix.automate.workflow.core.utils.ocr.ComputeConsumption;
import com.nuix.automate.workflow.core.utils.ocr.Consumption;
import com.nuix.automate.workflow.core.utils.ocr.OcrUtils;
import com.nuix.automate.workflow.core.utils.ocr.TesseractOcrUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class NativeOcrImagesOperationImplementation
extends OcrImagesOperationImplementation {
    protected final transient Set<String> supportedImageExtensions = new HashSet<String>(Arrays.asList("bmp", "pnm", "png", "jfif", "jpg", "jpeg", "tiff", "tif", "pdf", "txt"));

    @Override
    protected OcrUtils initializeOcrUtils() throws IOException {
        return new TesseractOcrUtils(this.executionContext, this, this.destinationPath.resolve("OCRTemp"));
    }

    @Override
    protected int evalEffectiveWorkers() {
        int effectiveWorkers;
        WorkersAssignmentMode workersAssignment = null;
        Double workersPerCore = null;
        Integer workersCount = null;
        try {
            String workersAssignmentString = this.executionContext.evalStringParameter("{wfn_native_ocr_workers_assignment_mode}", this);
            if (workersAssignmentString != null) {
                workersAssignment = WorkersAssignmentMode.valueOf(workersAssignmentString);
            }
            if (WorkersAssignmentMode.PREDETERMINED.equals((Object)workersAssignment)) {
                workersCount = this.executionContext.evalIntParameter("{wfn_native_ocr_predetermined_worker_count}", this);
            } else if (WorkersAssignmentMode.PER_CPU_CORE.equals((Object)workersAssignment)) {
                workersPerCore = this.executionContext.evalDoubleParameter("{wfn_native_ocr_workers_per_cpu_core}", this);
            }
        }
        catch (ParameterException e) {
            LOGGER.warn("Cannot read workersAssignment from parameter", (Throwable)e);
        }
        if (workersAssignment == null) {
            workersAssignment = WorkersAssignmentMode.PER_CPU_CORE;
        }
        if (workersPerCore == null) {
            workersPerCore = 0.9;
        }
        if (workersCount == null) {
            workersCount = 1;
        }
        if (workersAssignment.equals((Object)WorkersAssignmentMode.PREDETERMINED)) {
            effectiveWorkers = workersCount;
        } else {
            int cores = Runtime.getRuntime().availableProcessors();
            this.addExecutionLog(this.iu.getFormattedString("NativeOcrImagesOperation.Log.CpuCores", (Object)cores));
            Double weightedWorkers = (double)cores * workersPerCore;
            weightedWorkers = Math.floor(weightedWorkers);
            effectiveWorkers = weightedWorkers.intValue();
            effectiveWorkers = Math.max(1, effectiveWorkers);
        }
        this.addExecutionLog(this.iu.getFormattedString("NativeOcrImagesOperation.Log.OcrWorkers", (Object)effectiveWorkers));
        return effectiveWorkers;
    }

    @Override
    protected void logConsumption() {
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("NativeOcrImagesOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.NATIVE_OCR_IMAGES;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }

    @Override
    protected void logHeader(BufferedWriter reportWriter) {
        try {
            reportWriter.append("Time,File Path,File Size (b),File Pages,Page Index,Document Name,Document Pages,Text Path,Text Size (b),PDF Path,Duration (ms),Status,Details");
            reportWriter.append("\r\n");
            reportWriter.flush();
        }
        catch (IOException e) {
            LOGGER.warn("Error creating new summary OCR file.", (Throwable)e);
        }
    }

    @Override
    protected boolean getExtensionSupported(String extension) {
        return this.supportedImageExtensions.contains(extension.toLowerCase());
    }

    @Override
    protected Consumption getNullConsumption() {
        return new ComputeConsumption(0L);
    }
}

