/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldColumn;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldHelper;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.models.internal.formbuilder.SensitiveField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldGroup(name="emailNotificationGroup", styled=false, visibleOn={@OnField(name="email")}, children={"smtpServiceId", "emailFrom", "emailTo", "emailCc", "emailBcc", "emailSubject", "emailSmtpServerRow", "smtpAuthenticationRow", "emailMessage", "emailMessageIsHtml", "attachWorkflowLog", "attachReport", "additionalAttachments"})
@FormFieldRows(value={@FormFieldRow(name="emailSmtpServerRow", children={"emailSmtpServer", "emailSmtpPort", "emailTLS"}, visibleOn={@OnField(name="useSmtpService", value={"false"})}), @FormFieldRow(name="smtpAuthenticationRow", children={"smtpAuthentication", "smtpUsername", "smtpPassword"}, visibleOn={@OnField(name="useSmtpService", value={"false"})})})
@OperationMetadata(alias=OperationAlias.NOTIFY, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_AUTOMATE"}), @OperationTag(name="Category", value={"REPORTING"})})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class NotifyOperation
extends Operation {
    public boolean interactive = false;
    public String interractiveTitle = "Workflow {workflow_name} notification";
    public String interactiveMessage = "Notification message\n\n";
    public boolean interactiveShowWorkbench = false;
    @FormField
    public boolean email = true;
    @FormField(helpers={@FormFieldHelper(location="#_notification")}, visibleOn={@OnField(name="email")})
    public boolean useSmtpService;
    @FormField(visibleOn={@OnField(name="useSmtpService")})
    public String smtpServiceId;
    @FormField(visibleOn={@OnField(name="useSmtpService", value={"false"})})
    public String emailFrom = "automate@example.com";
    @FormField
    public String emailTo = "";
    @FormField(required=false)
    public String emailCc = "";
    @FormField(required=false)
    public String emailBcc = "";
    @FormField
    public String emailSubject = "{workflow_name} status";
    @FormField
    public String emailSmtpServer = "{smtp_server}";
    @FormField(positionLabel=@PositionLabel(left="port"))
    public int emailSmtpPort = 25;
    @FormField
    public boolean emailTLS = true;
    @FormField
    public boolean smtpAuthentication;
    @FormField(enableOn={@OnField(name="smtpAuthentication")}, positionLabel=@PositionLabel(left="username"))
    public String smtpUsername;
    @SensitiveField
    @ExcludeFromPrintableOptions
    @FormField(enableOn={@OnField(name="smtpAuthentication")}, positionLabel=@PositionLabel(left="password"))
    public String smtpPassword;
    @ExcludeFromPrintableOptions
    @FormField(componentType=FieldComponentType.SCRIPT_PANE, scriptLanguage="html")
    public String emailMessage = "<!DOCTYPE html>\n<html>\n<style>{simple_style_html}</style>\n<body>\n{automate_logo_html}\n\n<h2>Workflow {workflow_name} status</h2>\n{workflow_status_html}\n\n</body>\n</html>\n";
    @FormField
    public boolean emailMessageIsHtml = true;
    @FormField
    public boolean attachWorkflowLog = true;
    @FormField
    public boolean attachReport = true;
    @FormField(required=false, columnFields={@FormFieldColumn(label="attachment")})
    public List<Object[]> additionalAttachments;

    public boolean getDisplayInterractiveTitle() {
        return this.interactive;
    }

    public boolean getDisplayInteractiveMessage() {
        return this.interactive;
    }

    public boolean getDisplayInteractiveShowWorkbench() {
        return this.interactive;
    }

    public boolean getDisplaySmtpService() {
        return this.email;
    }

    public boolean getDisplaySmtpServiceId() {
        return this.email && !this.useSmtpService;
    }

    public boolean getDisplayEmailFrom() {
        return this.email && !this.useSmtpService;
    }

    public boolean getDisplayEmailTo() {
        return this.email;
    }

    public boolean getDisplayEmailCc() {
        return this.email;
    }

    public boolean getDisplayEmailBcc() {
        return this.email;
    }

    public boolean getDisplayEmailSubject() {
        return this.email;
    }

    public boolean getDisplayEmailSmtpServer() {
        return this.email && !this.useSmtpService;
    }

    public boolean getDisplayEmailSmtpPort() {
        return this.email && !this.useSmtpService;
    }

    public boolean getDisplayEmailTLS() {
        return this.email && !this.useSmtpService;
    }

    public boolean getDisplaySmtpAuthentication() {
        return this.email && !this.useSmtpService;
    }

    public boolean getDisplaySmtpUsername() {
        return this.email && this.smtpAuthentication && !this.useSmtpService;
    }

    public boolean getDisplaySmtpPassword() {
        return this.email && this.smtpAuthentication && !this.useSmtpService;
    }

    public boolean getDisplayEmailMessage() {
        return this.email;
    }

    public boolean getDisplayEmailMessageIsHtml() {
        return this.email;
    }

    public boolean getDisplayAttachWorkflowLog() {
        return this.email;
    }

    public boolean getDisplayAttachReport() {
        return this.email;
    }

    public boolean getDisplayAdditionalAttachments() {
        return this.email;
    }

    public NotifyOperation() {
        this.requiresCase = false;
        this.smtpServiceId = "{smtp_service_id}";
        this.smtpAuthentication = false;
        this.smtpUsername = "{smtp_username}";
        this.smtpPassword = "{smtp_password}";
        this.additionalAttachments = new ArrayList<Object[]>();
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("NotifyOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.NOTIFY;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if ((activity == Operation.PrerequisitesActivity.RUN_UNATTENDED || activity == Operation.PrerequisitesActivity.SUBMIT_UNATTENDED) && this.interactive) {
            prerequisites.add(this.iu.getString("NotifyOperation.Prerequisites.CannotUseInteractiveSetting"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

