/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.EmailUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.smtp.SmtpEmail;
import com.nuix.automate.utils.models.api.thirdparty.SmtpService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.internal.smtp.EmailModel;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.workflow.core.execution.operations.NotifyOperation;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.utils.smtp.SmtpRestClient;
import com.nuix.automate.workflow.core.utils.thirdparty.ThirdPartyUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.Semaphore;

public class NotifyOperationImplementation
extends NotifyOperation
implements ThirdPartyServiceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NotifyOperation.class);
    private transient Map<String, ThirdPartyService> thirdPartyServices;
    private transient SmtpService smtpService;
    private transient SmtpRestClient client;
    public transient Semaphore interractiveWindowClosed;
    private transient double percentageComplete = 0.0;

    private void initializeSmtpClient() throws ParameterException, GeneralSecurityException {
        ThirdPartyUtils.getInstance().verifyThirdPartyServiceSettings(this, this.thirdPartyServices.values(), SmtpService.class.getSimpleName(), ParameterType.SMTP_SERVICE);
        this.smtpServiceId = this.executionContext.evalParameters(this.smtpServiceId, this);
        if (this.thirdPartyServices == null || this.thirdPartyServices.get(this.smtpServiceId) == null) {
            throw new IllegalStateException(this.iu.getFormattedString("NotifyOperation.Error.MissingSmtpService", (Object)this.smtpServiceId));
        }
        this.smtpService = (SmtpService)this.thirdPartyServices.get(this.smtpServiceId);
        this.addExecutionLog(this.iu.getFormattedString("NotifyOperation.Log.SmtpService", (Object)this.smtpService.getName()));
        String schedulerUrl = this.executionContext.evalParametersIfSet("{scheduler_url}", this).trim();
        String bearerToken = this.executionContext.evalProtectedParameter("{job_bearer_token_protected}").trim();
        HashSet<String> whitelistedCertFingerprints = new HashSet<String>();
        if (this.smtpService.getWhitelistedCertFingerprints() != null) {
            try {
                whitelistedCertFingerprints.addAll(this.smtpService.getWhitelistedCertFingerprints());
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
            }
        }
        try {
            whitelistedCertFingerprints.add(this.executionContext.evalParametersIfSet("{scheduler_cert_fingerprint}", this).trim());
        }
        catch (ParameterException e) {
            LOGGER.info("Not using custom Scheduler cert fingerprint", (Throwable)e);
        }
        this.client = new SmtpRestClient(this.smtpServiceId, schedulerUrl, bearerToken, whitelistedCertFingerprints);
        this.smtpAuthentication = this.smtpService.getAuthenticationMethod() == ThirdPartyAuthenticationMethod.USERNAME_PASSWORD || this.smtpService.getAuthenticationMethod() == ThirdPartyAuthenticationMethod.OIDC_AUTHORIZATION_CODE;
        this.emailSmtpServer = this.smtpService.getHost();
        this.emailSmtpPort = this.smtpService.getPort();
        this.emailFrom = this.smtpService.getFrom();
        this.emailTLS = this.smtpService.getTls();
    }

    @Override
    public void startTriggered() throws Exception {
        LOGGER.info("Starting execution");
        NotifyOperationImplementation currentOperation = this;
        this.startTriggerThread = new Thread(() -> {
            try {
                if (this.email) {
                    if (this.useSmtpService) {
                        this.initializeSmtpClient();
                    } else {
                        this.emailSmtpServer = this.executionContext.evalParameters(this.emailSmtpServer, this);
                        this.emailFrom = this.executionContext.evalParameters(this.emailFrom, this);
                        this.smtpUsername = this.executionContext.evalParameters(this.smtpUsername, this);
                        this.smtpPassword = this.executionContext.evalProtectedParameter(this.smtpPassword);
                    }
                    this.emailTo = this.executionContext.evalParameters(this.emailTo, this);
                    this.emailCc = this.executionContext.evalParameters(this.emailCc, this);
                    this.emailBcc = this.executionContext.evalParameters(this.emailBcc, this);
                    try {
                        this.emailSubject = this.executionContext.evalParameters(this.emailSubject, this, true);
                    }
                    catch (ParameterException e) {
                        this.addWarning(e.getLocalizedMessage());
                    }
                    this.emailSubject = this.emailSubject.replace("Case Case", "Case");
                    try {
                        this.emailMessage = this.executionContext.evalParameters(this.emailMessage, currentOperation, true);
                    }
                    catch (Throwable e) {
                        this.addWarning(e.getLocalizedMessage());
                    }
                    this.emailMessage = this.emailMessage.replace("Case Case", "Case");
                    this.addExecutionLog(this.iu.getString("NotifyOperation.Log.EmailNotification"));
                    this.addExecutionLog(this.iu.getFormattedString("NotifyOperation.Log.EmailServer", new Object[]{this.emailSmtpServer, this.emailSmtpPort}));
                    if (this.emailTLS || this.smtpAuthentication) {
                        ArrayList<String> smtpOptions = new ArrayList<String>();
                        if (this.emailTLS) {
                            smtpOptions.add("TLS");
                        }
                        if (this.smtpAuthentication) {
                            smtpOptions.add("Authenticated");
                        }
                        this.addExecutionLog(this.iu.getFormattedString("NotifyOperation.Log.SMTPOptions", (Object)String.join((CharSequence)", ", smtpOptions)));
                    }
                    this.addExecutionLog(this.iu.getFormattedString("NotifyOperation.Log.EmailFrom", (Object)this.emailFrom));
                    this.addExecutionLog(this.iu.getFormattedString("NotifyOperation.Log.EmailTo", (Object)this.emailTo));
                    if (!FormattingUtils.isTextEmpty((String)this.emailCc)) {
                        this.addExecutionLog(this.iu.getFormattedString("NotifyOperation.Log.EmailCc", (Object)this.emailCc));
                    }
                    if (!FormattingUtils.isTextEmpty((String)this.emailBcc)) {
                        this.addExecutionLog(this.iu.getFormattedString("NotifyOperation.Log.EmailBcc", (Object)this.emailBcc));
                    }
                    this.addExecutionLog(this.iu.getFormattedString("NotifyOperation.Log.EmailSubject", (Object)this.emailSubject));
                    String workflowLog = null;
                    if (this.attachWorkflowLog) {
                        this.addExecutionLog(this.iu.getString("NotifyOperation.Log.AttachWorkflowLogToEmail"));
                        workflowLog = this.executionContext.evalParameters("{workflow_log}", currentOperation, true);
                    }
                    String reportFilePath = null;
                    if (this.attachReport) {
                        this.addExecutionLog(this.iu.getString("NotifyOperation.Log.AttachReportToEmail"));
                        try {
                            reportFilePath = this.executionContext.evalParameters("{last_report_file}", this);
                            File reportFile = new File(reportFilePath);
                            if (!reportFile.exists()) {
                                this.addWarning(this.iu.getFormattedString("NotifyOperation.Warning.CannotAttachReportBecauseFileDoesNotExist", (Object)reportFilePath));
                                reportFilePath = null;
                            }
                        }
                        catch (ParameterException e) {
                            this.addWarning(this.iu.getString("NotifyOperation.Warning.CannotAttachNoReportingOperationExecuted"));
                        }
                    }
                    LinkedHashSet<String> attachments = new LinkedHashSet<String>();
                    for (Object[] attachment : this.additionalAttachments) {
                        String attachmentName = (String)attachment[0];
                        if (attachmentName == null || attachmentName.trim().length() <= 0) continue;
                        if (Files.exists(Paths.get(attachmentName = this.executionContext.evalParameters(attachmentName, this), new String[0]), new LinkOption[0])) {
                            this.addExecutionLog(this.iu.getFormattedString("NotifyOperation.Log.AttachFile", (Object)attachmentName));
                            attachments.add(attachmentName);
                            continue;
                        }
                        this.addWarning(this.iu.getFormattedString("NotifyOperation.Warning.CannotAttachFileBecauseFileDoesNotExist", (Object)attachmentName));
                    }
                    try {
                        SmtpEmail emailModel;
                        if (this.useSmtpService) {
                            emailModel = new SmtpEmail();
                            emailModel.setFrom(this.emailFrom);
                            emailModel.setTo(this.emailTo);
                            emailModel.setCc(this.emailCc);
                            emailModel.setBcc(this.emailBcc);
                            emailModel.setSubject(this.emailSubject);
                            emailModel.setMessage(this.emailMessage);
                            emailModel.setAdditionalAttachments(attachments);
                            emailModel.setReportFilePath(reportFilePath);
                            emailModel.setWorkflowLog(workflowLog);
                            emailModel.setHtmlFormat(Boolean.valueOf(this.emailMessageIsHtml));
                            this.client.sendEmail(emailModel);
                        } else {
                            emailModel = new EmailModel(this.emailSmtpServer, this.emailSmtpPort, this.emailMessageIsHtml, this.emailTLS);
                            if (this.smtpAuthentication) {
                                emailModel.setSmtpUser(this.smtpUsername, this.smtpPassword);
                            }
                            emailModel.setParticipants(this.emailFrom, this.emailTo, this.emailCc, this.emailBcc);
                            emailModel.setMessage(this.emailSubject, this.emailMessage);
                            emailModel.setAdditionalMessages(attachments, reportFilePath, workflowLog);
                            EmailUtils.sendEmail((EmailModel)emailModel);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot send email", (Throwable)e);
                        this.addWarning(this.iu.getFormattedString("NotifyOperation.Warning.CannotSendEmail", (Object)e.getLocalizedMessage()));
                    }
                }
                this.percentageComplete = 0.5;
                if (this.executionState == ExecutionState.STOPPING) {
                    this.trackStopped();
                    return;
                }
            }
            catch (Throwable e) {
                LOGGER.error("Error execution operation", e);
                this.addWarning(this.iu.getFormattedString("NotifyOperation.Warning.ErrorExecutionOperation", (Object)e.getLocalizedMessage()));
            }
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double result = this.percentageComplete;
        if (this.executionState != ExecutionState.FINISHED) {
            result = Math.min(result, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            result = Math.max(result, 1.0E-4);
        }
        return result;
    }

    @Override
    public void setThirdPartyServices(Map<String, ThirdPartyService> thirdPartyServices) {
        this.thirdPartyServices = thirdPartyServices;
    }
}

