/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.utilization.MimeType;
import com.nuix.automate.utils.utilization.MimeTypeVolume;
import com.nuix.automate.workflow.core.execution.operations.GeneratePrintedImagesOperation;
import com.nuix.automate.workflow.core.execution.operations.MimeTypeVolumesUtilizationOperation;
import com.nuix.automate.workflow.core.execution.operations.NativeOcrItemsOperation;
import com.nuix.automate.workflow.core.execution.operations.OcrOperation;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import nuix.CaseStatistics;
import nuix.Item;
import nuix.ItemKind;
import nuix.ItemType;
import nuix.ItemTypeUtility;
import nuix.MutablePrintedImage;
import nuix.Utilities;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public abstract class NuixQueryMimeTypeVolumesUtilizationOperation
extends MimeTypeVolumesUtilizationOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NuixQueryMimeTypeVolumesUtilizationOperation.class);
    private Long volumeBytes;

    public abstract String getUtilizationScopeQuery();

    @Override
    public List<MimeTypeVolume> getMimeTypeVolumes() {
        boolean enableAllMimeTypesDigest;
        ArrayList<MimeTypeVolume> volumes = new ArrayList<MimeTypeVolume>();
        String disableAllMimeTypesAllProperty = System.getProperty("automate.utilization.disableMimeTypes.all");
        boolean disableAllMimeTypesAll = disableAllMimeTypesAllProperty != null;
        String enabledMimeTypesDigestProperty = System.getProperty("automate.utilization.enableMimeTypes.digest");
        boolean bl = enableAllMimeTypesDigest = enabledMimeTypesDigestProperty != null;
        if (disableAllMimeTypesAll) {
            LOGGER.info("Mimetype utilization disabled");
        } else {
            String utilizationScopeQuery;
            if (enableAllMimeTypesDigest) {
                LOGGER.info("Mimetype utilization digest enabled");
            }
            if ((utilizationScopeQuery = this.getUtilizationScopeQuery()) != null) {
                try {
                    LOGGER.info("Setting utilization from query " + utilizationScopeQuery);
                    CaseStatistics caseStatistics = this.executionContext.nuixCase.getStatistics();
                    for (ItemKind itemKind : this.executionContext.nuixUtilities.getItemTypeUtility().getAllKinds()) {
                        long kindCount;
                        String kindCountQuery = NuixUtils.addAndQuery(utilizationScopeQuery, "kind:" + itemKind.getName());
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Get count: " + kindCountQuery);
                        }
                        if ((kindCount = this.executionContext.nuixCase.count(kindCountQuery)) <= 0L) continue;
                        for (ItemType itemType : itemKind.getTypes()) {
                            long count;
                            String countQuery = NuixUtils.addAndQuery(utilizationScopeQuery, "mime-type:" + itemType.getName());
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Get count: " + countQuery);
                            }
                            if ((count = this.executionContext.nuixCase.count(countQuery)) <= 0L) continue;
                            MimeTypeVolume mimeTypeVolume = new MimeTypeVolume();
                            mimeTypeVolume.setItemsCount(count);
                            mimeTypeVolume.setMimeTypeId(itemType.getName());
                            String physicalQuery = NuixUtils.addAndQuery(countQuery, "flag:physical_file");
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Get count: " + physicalQuery);
                            }
                            long physicalCount = this.executionContext.nuixCase.count(physicalQuery);
                            long physicalSize = 0L;
                            if (physicalCount > 0L) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Get file size: " + physicalQuery);
                                }
                                physicalSize = caseStatistics.getFileSize(physicalQuery);
                            }
                            mimeTypeVolume.setPhysicalCount(physicalCount);
                            mimeTypeVolume.setPhysicalSize(physicalSize);
                            String auditedQuery = NuixUtils.addAndQuery(countQuery, "flag:audited");
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Get count: " + auditedQuery);
                            }
                            long auditedCount = this.executionContext.nuixCase.count(auditedQuery);
                            long auditedSize = 0L;
                            if (auditedCount > 0L) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Get audited size: " + auditedQuery);
                                }
                                auditedSize = caseStatistics.getAuditSize(auditedQuery);
                            }
                            mimeTypeVolume.setAuditedCount(auditedCount);
                            mimeTypeVolume.setAuditedSize(auditedSize);
                            if (enableAllMimeTypesDigest) {
                                mimeTypeVolume.setDigestSize(NuixUtils.getDigestSize(this.executionContext.nuixCase, countQuery, null));
                            }
                            if (this instanceof OcrOperation || this instanceof NativeOcrItemsOperation || this instanceof GeneratePrintedImagesOperation) {
                                Set itemsInScope = this.executionContext.nuixCase.searchUnsorted(countQuery);
                                FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner((Iterable)itemsInScope, ItemsUtils.getPartitionerChunkSize(1000, this));
                                Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                                    while (iterator.hasNext()) {
                                        Item item = (Item)iterator.next();
                                        Integer itemPages = null;
                                        try {
                                            Object pageCount = item.getProperties().get("Page Count");
                                            if (pageCount != null) {
                                                itemPages = Integer.parseInt(pageCount.toString());
                                            }
                                        }
                                        catch (Exception e) {
                                            LOGGER.error("Cannot get pages", (Throwable)e);
                                        }
                                        if (itemPages == null) {
                                            itemPages = 1;
                                        }
                                        try {
                                            MutablePrintedImage printedImage;
                                            if (itemPages == null && (printedImage = item.getPrintedImage()) != null) {
                                                itemPages = printedImage.getPageCount();
                                            }
                                        }
                                        catch (Exception e) {
                                            LOGGER.error("Cannot get pages", (Throwable)e);
                                        }
                                        if (itemPages == null) {
                                            itemPages = 1;
                                        }
                                        mimeTypeVolume.addPagesCount(Long.valueOf(itemPages.intValue()).longValue());
                                    }
                                }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                            }
                            volumes.add(mimeTypeVolume);
                        }
                    }
                    LOGGER.info("Finished computing utilization");
                }
                catch (Exception e) {
                    LOGGER.error("Cannot get utilization", (Throwable)e);
                }
            }
        }
        return volumes;
    }

    private List<MimeType> getMimeTypes() {
        Utilities nuixUtilities;
        ArrayList<MimeType> mimeTypes = new ArrayList<MimeType>();
        if (this.executionContext != null && (nuixUtilities = this.executionContext.nuixUtilities) != null) {
            ItemTypeUtility itemTypeUtility = nuixUtilities.getItemTypeUtility();
            for (ItemType itemType : itemTypeUtility.getAllTypes()) {
                MimeType mimeTypeModel = new MimeType();
                mimeTypeModel.setMimeTypeId(itemType.getName());
                mimeTypeModel.setFileType(itemType.getLocalisedName());
                mimeTypeModel.setFileKind(itemType.getKind().getLocalisedName());
                mimeTypeModel.setFilePreferredExtension(itemType.getPreferredExtension());
                mimeTypes.add(mimeTypeModel);
            }
        }
        return mimeTypes;
    }

    @Override
    public long getVolume(WorkflowExecution workflowExecution) {
        if (this.volumeBytes == null) {
            try {
                String utilizationScope = this.getUtilizationScopeQuery();
                if (utilizationScope != null) {
                    this.volumeBytes = workflowExecution.getExecutionContext().nuixCase.getStatistics().getAuditSize(utilizationScope);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Cannot get operation utilization volume", (Throwable)e);
                return 0L;
            }
        }
        if (this.volumeBytes == null) {
            this.volumeBytes = 0L;
        }
        return this.volumeBytes;
    }
}

