/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.MimeTypeUtils;
import com.nuix.automate.utils.licence.services.metrics.Activity;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.utilization.MimeTypeVolume;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.operations.NativeMimeTypeVolumesUtilizationOperation;
import com.nuix.automate.workflow.core.execution.operations.NativeOcrImagesOperation;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import com.nuix.automate.workflow.core.utils.ocr.Consumption;
import com.nuix.automate.workflow.core.utils.ocr.OcrDocument;
import com.nuix.automate.workflow.core.utils.ocr.OcrResult;
import com.nuix.automate.workflow.core.utils.ocr.OcrStatus;
import com.nuix.automate.workflow.core.utils.ocr.OcrUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class OcrImagesOperationImplementation
extends NativeMimeTypeVolumesUtilizationOperation {
    protected static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NativeOcrImagesOperation.class);
    private transient long countFilesToProcess;
    private transient AtomicLong countFilesProcessed;
    private transient AtomicLong countPagesProcessed;
    private transient AtomicLong countFilesProcessedSuccessfully;
    private transient AtomicLong countFilesWithErrors;
    private transient Map<String, OcrDocument> ocrDocuments;
    private transient Set<String> unsupportedFileExtensions;
    private transient long unsupportedFilesCount;
    private transient AtomicLong imagesWithExistingTextFilesCount;
    private transient Map<String, MimeTypeVolume> mimeTypeVolumes;
    private transient Set<String> usedFileNames;
    protected transient Path destinationPath;
    private transient Path destinationPdfPath;
    private transient OcrUtils ocrUtils;
    private transient BufferedWriter reportWriter;
    private transient int effectiveWorkers;
    protected transient Consumption totalConsumption;
    @FormField
    public String sourceImagesFolder;
    @FormField
    public boolean scanFolderRecursively;
    @FormField
    public boolean skipImagesWithExistingText;
    @FormField
    public boolean assemblePagesEnabled;
    @FormField(enableOn={@OnField(name="assemblePagesEnabled")})
    @ExcludeFromPrintableOptions
    public String assemblePagesRegex;
    @FormField
    public String destinationTextFolder;
    @FormField
    public boolean keepIncompleteFiles;
    @FormField
    public boolean createSearchablePdf;
    @FormField(enableOn={@OnField(name="createSearchablePdf")})
    @ExcludeFromPrintableOptions
    public String destinationPdfFolder;

    public boolean getDisplayAssemblePagesRegex() {
        return this.assemblePagesEnabled;
    }

    public boolean getDisplayDestinationPdfFolder() {
        return this.createSearchablePdf;
    }

    public OcrImagesOperationImplementation() {
        this.requiresCase = false;
    }

    protected abstract OcrUtils initializeOcrUtils() throws IOException;

    protected abstract int evalEffectiveWorkers();

    @Override
    public void startTriggered() throws Exception {
        this.totalConsumption = this.getNullConsumption();
        this.sourceImagesFolder = this.executionContext.evalParameters(this.sourceImagesFolder, this);
        this.destinationTextFolder = this.executionContext.evalParameters(this.destinationTextFolder, this);
        this.destinationPdfFolder = this.executionContext.evalParameters(this.destinationPdfFolder, this);
        this.executionContext.closeAllTabs();
        this.countFilesProcessed = new AtomicLong(0L);
        this.countFilesProcessedSuccessfully = new AtomicLong(0L);
        this.countFilesWithErrors = new AtomicLong(0L);
        this.countPagesProcessed = new AtomicLong(0L);
        this.imagesWithExistingTextFilesCount = new AtomicLong(0L);
        this.addExecutionLog(this.iu.getFormattedString("NativeOcrImagesOperation.Log.SourceFolder", (Object)this.sourceImagesFolder));
        this.addExecutionLog(this.iu.getFormattedString("NativeOcrImagesOperation.Log.DestinationFolder", (Object)this.destinationTextFolder));
        this.usedFileNames = new HashSet<String>();
        this.destinationPath = Paths.get(this.destinationTextFolder, new String[0]);
        this.destinationPdfPath = Paths.get(this.destinationPdfFolder, new String[0]);
        if (this.createSearchablePdf) {
            if (this.destinationPdfFolder.length() == 0) {
                this.destinationPdfFolder = this.destinationTextFolder;
            }
            this.addExecutionLog(this.iu.getFormattedString("NativeOcrImagesOperation.Log.DestinationPdfFolder", (Object)this.destinationPdfFolder));
        }
        this.mimeTypeVolumes = new HashMap<String, MimeTypeVolume>();
        if (this.assemblePagesEnabled) {
            this.addExecutionLog(this.iu.getFormattedString("NativeOcrImagesOperation.Log.AssemblePagesRegex", (Object)this.assemblePagesRegex));
        }
        this.startTriggerThread = new Thread(() -> {
            try {
                Path reportFile;
                boolean reportFileExists;
                if (Files.exists(this.destinationPath, new LinkOption[0])) {
                    if (!Files.isDirectory(this.destinationPath, new LinkOption[0])) {
                        throw new IOException(this.iu.getString("NativeOcrImagesOperation.Error.DestinationPathIsFile"));
                    }
                } else {
                    try {
                        LOGGER.info("Creating folder " + String.valueOf(this.destinationPath));
                        Files.createDirectories(this.destinationPath, new FileAttribute[0]);
                    }
                    catch (IOException ex) {
                        LOGGER.error("Cannot create destination folder path", (Throwable)ex);
                        throw ex;
                    }
                }
                if (this.skipImagesWithExistingText) {
                    this.addExecutionLog(this.iu.getString("NativeOcrImagesOperation.Log.SkipImagesWithExistingText"));
                }
                if (this.createSearchablePdf) {
                    this.addExecutionLog(this.iu.getString("NativeOcrImagesOperation.Log.CreateSearchablePdf"));
                }
                StandardOpenOption openOption = (reportFileExists = Files.exists(reportFile = this.destinationPath.resolve("summary_report.csv"), new LinkOption[0])) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE;
                this.reportWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(reportFile, openOption), StandardCharsets.UTF_8));
                this.ocrUtils = this.initializeOcrUtils();
                this.addExecutionLog(this.iu.getFormattedString("NativeOcrImagesOperation.Log.ReportFile", (Object)reportFile));
                if (!reportFileExists) {
                    this.logHeader(this.reportWriter);
                } else {
                    this.reportWriter.append("---\n");
                }
                if (this.keepIncompleteFiles) {
                    this.addExecutionLog(this.iu.getString("NativeOcrImagesOperation.Log.KeepIncompleteFiles"));
                    this.ocrUtils.setKeepIncompleteFiles(this.keepIncompleteFiles);
                }
                LOGGER.info("Scanning for images");
                Path sourceImagesPath = Paths.get(this.sourceImagesFolder, new String[0]);
                HashSet<Path> exclusions = new HashSet<Path>();
                exclusions.add(reportFile);
                this.countFilesToProcess = this.scanImages(this.reportWriter, sourceImagesPath, this.scanFolderRecursively, exclusions);
                if (this.unsupportedFilesCount > 0L) {
                    this.addWarning(this.iu.getNumeralFormattedString("NativeOcrImagesOperation.Log.UnsupportedSourceFilesCount", this.unsupportedFilesCount, (Object)String.join((CharSequence)", ", this.unsupportedFileExtensions)));
                }
                LOGGER.info("Detected " + this.countFilesToProcess + " images");
                this.addExecutionLog(this.iu.getNumeralString("NativeOcrImagesOperation.Log.ScopeCount", this.countFilesToProcess));
                this.effectiveWorkers = this.evalEffectiveWorkers();
                LOGGER.info("Effective worker count: " + this.effectiveWorkers);
                ConcurrentHashMap<Long, Thread> activeThreads = new ConcurrentHashMap<Long, Thread>();
                AtomicLong threadsCount = new AtomicLong();
                Semaphore semaphore = new Semaphore(this.effectiveWorkers, true);
                for (OcrDocument ocrDocument : this.ocrDocuments.values()) {
                    boolean acquired;
                    if (this.stopRequested) break;
                    Long threadId = threadsCount.getAndIncrement();
                    Thread thread = new Thread(() -> {
                        try {
                            this.handleOcrDocument(ocrDocument, semaphore);
                        }
                        finally {
                            semaphore.release();
                            activeThreads.remove(threadId);
                        }
                    });
                    activeThreads.put(threadId, thread);
                    while (!(acquired = semaphore.tryAcquire(100L, TimeUnit.MILLISECONDS))) {
                    }
                    thread.setName("OCR document handling");
                    thread.start();
                }
                while (activeThreads.size() > 0 && !this.stopRequested) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        this.stopRequested = true;
                    }
                }
                if (this.stopRequested) {
                    for (Thread activeThread : activeThreads.values()) {
                        activeThread.interrupt();
                    }
                    this.closeUtils();
                    this.trackStopped();
                    return;
                }
                this.closeUtils();
                if (this.countPagesProcessed.get() > 0L) {
                    this.addExecutionLog(this.iu.getNumeralString("NativeOcrImagesOperation.Log.OcrPages", this.countPagesProcessed.get()));
                }
                if (this.countFilesProcessedSuccessfully.get() > 0L) {
                    this.addExecutionLog(this.iu.getNumeralString("NativeOcrImagesOperation.Log.SuccessOcrFiles", this.countFilesProcessedSuccessfully.get()));
                }
                if (this.imagesWithExistingTextFilesCount.get() > 0L) {
                    this.addExecutionLog(this.iu.getNumeralString("NativeOcrImagesOperation.Log.SkipCount", this.imagesWithExistingTextFilesCount.get()));
                }
                if (this.countFilesWithErrors.get() > 0L) {
                    this.addWarning(this.iu.getNumeralString("NativeOcrImagesOperation.Warning.FailedToOcrFiles", this.countFilesWithErrors.get()));
                }
                this.logConsumption();
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                this.closeUtils();
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    protected abstract void logConsumption();

    private void closeUtils() {
        if (this.reportWriter != null) {
            try {
                this.reportWriter.close();
            }
            catch (IOException e) {
                LOGGER.warn("Cannot close report writer");
            }
            this.reportWriter = null;
        }
        if (this.ocrUtils != null) {
            try {
                this.ocrUtils.close();
            }
            catch (Exception e) {
                LOGGER.warn("Cannot close OCR utils");
            }
            this.ocrUtils = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void handleOcrDocument(OcrDocument ocrDocument, Semaphore semaphore) {
        for (Path path : ocrDocument.getImagePaths()) {
            this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.Processing", (Object)path.toString()));
        }
        boolean fileNameOverload = false;
        Set<String> set = this.usedFileNames;
        synchronized (set) {
            if (this.usedFileNames.contains(ocrDocument.getBaseName().toLowerCase())) {
                fileNameOverload = true;
            }
            this.usedFileNames.add(ocrDocument.getBaseName().toLowerCase());
        }
        if (ocrDocument.getImagePaths().size() == 1) {
            OcrResult result;
            Path path = ocrDocument.getImagePaths().get(0);
            String fileExtension = ocrDocument.getFileExtension();
            Path destinationTextPathWithExtension = null;
            Path destinationPdfPathWithExtension = null;
            if (!fileNameOverload) {
                Path destinationTextPath = this.destinationPath.resolve(ocrDocument.getBaseName());
                Path destinationPdfFilePath = this.destinationPdfPath.resolve(ocrDocument.getBaseName());
                destinationTextPathWithExtension = this.destinationPath.resolve(ocrDocument.getBaseName() + ".txt");
                destinationPdfPathWithExtension = this.destinationPdfPath.resolve(ocrDocument.getBaseName() + ".pdf");
                boolean nonEmptyTextFileExists = false;
                try {
                    if (Files.exists(destinationTextPathWithExtension, new LinkOption[0]) && Files.size(destinationTextPathWithExtension) > 0L) {
                        nonEmptyTextFileExists = true;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Cannot get destination text file size", (Throwable)e);
                }
                if (this.skipImagesWithExistingText && nonEmptyTextFileExists) {
                    this.countFilesProcessed.incrementAndGet();
                    this.imagesWithExistingTextFilesCount.incrementAndGet();
                    this.trackStats(path, fileExtension, false);
                    return;
                }
                result = this.ocrUtils.ocrFile(path, destinationTextPath, this.createSearchablePdf, destinationPdfFilePath, semaphore, this.countPagesProcessed);
                OcrImagesOperationImplementation e = this;
                synchronized (e) {
                    if (result != null) {
                        this.totalConsumption.add(result.getConsumption());
                    }
                }
                if (!Files.exists(destinationTextPathWithExtension, new LinkOption[0])) {
                    destinationTextPathWithExtension = null;
                }
                if (!Files.exists(destinationPdfPathWithExtension, new LinkOption[0])) {
                    destinationPdfPathWithExtension = null;
                }
                if (!OcrStatus.SUCCESS.equals((Object)result.getStatus())) {
                    this.countFilesWithErrors.incrementAndGet();
                    this.trackStats(path, fileExtension, true);
                } else {
                    this.countFilesProcessedSuccessfully.incrementAndGet();
                    this.trackStats(path, fileExtension, false);
                }
            } else {
                result = new OcrResult("The image file has the same stem \"" + ocrDocument.getBaseName() + "\" as another file", this.getNullConsumption(), OcrStatus.FAILED, null);
                this.countFilesWithErrors.incrementAndGet();
                this.trackStats(path, fileExtension, true);
            }
            Integer filePages = result.getPages();
            Integer fileIndex = null;
            if (filePages != null) {
                fileIndex = 1;
            }
            this.trackMimeTypeVolume(path, result.getPages(), result);
            this.logResult(this.reportWriter, path, filePages, fileIndex, ocrDocument.getBaseName(), filePages, destinationTextPathWithExtension, destinationPdfPathWithExtension, result);
            this.countFilesProcessed.incrementAndGet();
        } else {
            Path destinationTextPathWithExtension = null;
            Path destinationPdfPathWithExtension = null;
            if (!fileNameOverload) {
                Path destinationTextPath = this.destinationPath.resolve(ocrDocument.getBaseName());
                Path destinationPdfFilePath = this.destinationPdfPath.resolve(ocrDocument.getBaseName());
                destinationTextPathWithExtension = this.destinationPath.resolve(ocrDocument.getBaseName() + ".txt");
                destinationPdfPathWithExtension = this.destinationPdfPath.resolve(ocrDocument.getBaseName() + ".pdf");
                boolean nonEmptyTextFileExists = false;
                try {
                    if (Files.exists(destinationTextPathWithExtension, new LinkOption[0]) && Files.size(destinationTextPathWithExtension) > 0L) {
                        nonEmptyTextFileExists = true;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Cannot get destination text file size", (Throwable)e);
                }
                if (this.skipImagesWithExistingText && nonEmptyTextFileExists) {
                    this.countFilesProcessed.incrementAndGet();
                    this.imagesWithExistingTextFilesCount.incrementAndGet();
                    this.trackStats(ocrDocument.getImagePaths(), false);
                    return;
                }
                List<OcrResult> list = this.ocrUtils.ocrImageFiles(ocrDocument.getImagePaths(), destinationTextPath, this.createSearchablePdf, destinationPdfFilePath, semaphore, this.countPagesProcessed);
                if (list.size() > 0 && !Files.exists(destinationTextPathWithExtension, new LinkOption[0])) {
                    destinationTextPathWithExtension = null;
                }
                if (!Files.exists(destinationPdfPathWithExtension, new LinkOption[0])) {
                    destinationPdfPathWithExtension = null;
                }
                for (int i = 0; i < ocrDocument.getImagePaths().size(); ++i) {
                    Path imageFilePath = ocrDocument.getImagePaths().get(i);
                    if (list.size() <= i) continue;
                    OcrResult result = list.get(i);
                    if (!OcrStatus.SUCCESS.equals((Object)result.getStatus())) {
                        this.countFilesWithErrors.incrementAndGet();
                        this.trackStats(imageFilePath, true);
                        continue;
                    }
                    this.countFilesProcessedSuccessfully.incrementAndGet();
                    this.trackStats(imageFilePath, false);
                }
            } else {
                ArrayList<OcrResult> arrayList = new ArrayList<OcrResult>();
                OcrResult result = new OcrResult("The image file has the same stem \"" + ocrDocument.getBaseName() + "\" as another file", this.getNullConsumption(), OcrStatus.FAILED, null);
                for (Path imageFilePath : ocrDocument.getImagePaths()) {
                    arrayList.add(result);
                    this.countFilesWithErrors.incrementAndGet();
                }
                this.trackStats(ocrDocument.getImagePaths(), true);
            }
            for (int i = 0; i < ocrDocument.getImagePaths().size(); ++i) {
                void var4_10;
                Path imageFilePath = ocrDocument.getImagePaths().get(i);
                if (var4_10.size() <= i) continue;
                OcrResult result = (OcrResult)var4_10.get(i);
                Integer documentPages = result.getPages();
                this.trackMimeTypeVolume(imageFilePath, 1, result);
                this.logResult(this.reportWriter, imageFilePath, 1, i + 1, ocrDocument.getBaseName(), documentPages, destinationTextPathWithExtension, destinationPdfPathWithExtension, result);
                this.countFilesProcessed.incrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackMimeTypeVolume(Path sourceFile, Integer filePages, OcrResult result) {
        block10: {
            try {
                if (!OcrStatus.SUCCESS.equals((Object)result.getStatus())) break block10;
                String fileExtension = FileUtils.getFileExtension((String)sourceFile.getFileName().toString()).toLowerCase();
                String mimeType = MimeTypeUtils.getInstance().getMimeType(fileExtension);
                MimeTypeVolume mimeTypeVolume = null;
                Map<String, MimeTypeVolume> map = this.mimeTypeVolumes;
                synchronized (map) {
                    mimeTypeVolume = this.mimeTypeVolumes.get(mimeType);
                    if (mimeTypeVolume == null) {
                        mimeTypeVolume = new MimeTypeVolume();
                        mimeTypeVolume.setMimeTypeId(mimeType);
                        this.mimeTypeVolumes.put(mimeType, mimeTypeVolume);
                    }
                }
                mimeTypeVolume.incrementAuditedCount();
                mimeTypeVolume.incrementPhysicalCount();
                mimeTypeVolume.incrementItemsCount();
                if (filePages != null) {
                    mimeTypeVolume.addPagesCount((long)filePages.intValue());
                } else {
                    mimeTypeVolume.addPagesCount(1L);
                }
                try {
                    long size = Files.size(sourceFile);
                    this.trackIncrementVolumeProcessed(size);
                    mimeTypeVolume.addAuditedSize(size);
                    mimeTypeVolume.addDigestSize(size);
                    mimeTypeVolume.addPhysicalSize(size);
                }
                catch (IOException iOException) {}
            }
            catch (Exception e) {
                LOGGER.error("Cannot handle mime-type utilization", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logResult(BufferedWriter reportWriter, Path sourceFile, Integer filePages, Integer fileIndex, String documentName, Integer documentPages, Path destinationFile, Path destinationPdfFile, OcrResult result) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(FormattingUtils.dateTimeToExcelDateTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)));
            stringBuilder.append(",");
            if (sourceFile != null) {
                stringBuilder.append(FormattingUtils.encodeForCsv((String)sourceFile.toString()));
            }
            stringBuilder.append(",");
            if (sourceFile != null) {
                try {
                    stringBuilder.append("" + Files.size(sourceFile));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            stringBuilder.append(",");
            if (filePages != null) {
                stringBuilder.append(filePages);
            }
            stringBuilder.append(",");
            if (fileIndex != null) {
                stringBuilder.append(fileIndex);
            }
            stringBuilder.append(",");
            if (documentName != null) {
                stringBuilder.append(FormattingUtils.encodeForCsv((String)documentName));
            }
            stringBuilder.append(",");
            if (documentPages != null) {
                stringBuilder.append(documentPages);
            }
            stringBuilder.append(",");
            if (destinationFile != null) {
                stringBuilder.append(FormattingUtils.encodeForCsv((String)destinationFile.toString()));
            }
            stringBuilder.append(",");
            if (destinationFile != null) {
                try {
                    stringBuilder.append("" + Files.size(destinationFile));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            stringBuilder.append(",");
            if (destinationPdfFile != null) {
                stringBuilder.append(FormattingUtils.encodeForCsv((String)destinationPdfFile.toString()));
            }
            stringBuilder.append(",");
            if (result.getConsumption() != null) {
                stringBuilder.append(String.join((CharSequence)",", result.getConsumption().toStringList()));
            }
            stringBuilder.append(",");
            stringBuilder.append(result.getStatus().getLocalizedString());
            stringBuilder.append(",");
            if (result.getMessage() != null) {
                stringBuilder.append(FormattingUtils.encodeForCsv((String)result.getMessage()));
            }
            stringBuilder.append("\r\n");
            BufferedWriter bufferedWriter = reportWriter;
            synchronized (bufferedWriter) {
                reportWriter.append(stringBuilder);
                reportWriter.flush();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error writing message to summary file.", (Throwable)e);
        }
    }

    protected abstract void logHeader(BufferedWriter var1);

    protected abstract boolean getExtensionSupported(String var1);

    protected abstract Consumption getNullConsumption();

    private long scanImages(BufferedWriter reportWriter, Path sourcePath, boolean recursive, Set<Path> exclusions) throws IOException {
        this.unsupportedFilesCount = 0L;
        this.unsupportedFileExtensions = new TreeSet<String>();
        AtomicLong fileCount = new AtomicLong(0L);
        LinkedHashSet imageFilePaths = new LinkedHashSet();
        int maxDepth = 1;
        if (recursive) {
            maxDepth = 100;
        }
        try (Stream<Path> paths = Files.find(sourcePath, maxDepth, (path, attributes) -> attributes.isRegularFile(), new FileVisitOption[0]);){
            paths.forEach(path -> {
                if (!exclusions.contains(path)) {
                    String extension = FileUtils.getFileExtension((String)path.getFileName().toString()).toLowerCase();
                    if (this.getExtensionSupported(extension)) {
                        imageFilePaths.add(path);
                        fileCount.incrementAndGet();
                    } else {
                        LOGGER.warn("Detected unsupported file type: " + String.valueOf(path.getFileName()));
                        ++this.unsupportedFilesCount;
                        this.unsupportedFileExtensions.add(extension);
                        this.logResult(reportWriter, (Path)path, null, null, null, null, null, null, new OcrResult("Unsupported file extension " + extension, this.getNullConsumption(), OcrStatus.UNSUPPORTED, null));
                        this.trackStats((Path)path, extension, true);
                    }
                }
            });
        }
        catch (IOException e) {
            LOGGER.warn("Path " + sourcePath.toString() + " is not valid", (Throwable)e);
            throw e;
        }
        Pattern pattern = null;
        if (this.assemblePagesEnabled) {
            pattern = Pattern.compile(this.assemblePagesRegex);
        }
        this.ocrDocuments = new LinkedHashMap<String, OcrDocument>();
        for (Path path2 : imageFilePaths) {
            Path relativePath = sourcePath.relativize(path2);
            String fileName = FileUtils.getFileNameWithoutExtension((String)relativePath.toString());
            String fileExtension = FileUtils.getFileExtension((String)path2.getFileName().toString()).toLowerCase();
            if (this.assemblePagesEnabled) {
                Matcher matcher = pattern.matcher(fileName);
                String baseName = matcher.find() ? matcher.group(1) : fileName;
                OcrDocument ocrDocument = this.ocrDocuments.get(baseName);
                if (ocrDocument == null) {
                    ocrDocument = new OcrDocument();
                    ocrDocument.setBaseName(baseName);
                    ocrDocument.setFileExtension(fileExtension);
                    this.ocrDocuments.put(baseName, ocrDocument);
                }
                ocrDocument.getImagePaths().add(path2);
                continue;
            }
            OcrDocument ocrDocument = new OcrDocument();
            ocrDocument.setBaseName(fileName);
            ocrDocument.setFileExtension(fileExtension);
            ocrDocument.getImagePaths().add(path2);
            this.ocrDocuments.put(relativePath.toString(), ocrDocument);
        }
        if (this.assemblePagesEnabled) {
            for (OcrDocument ocrDocument : this.ocrDocuments.values()) {
                if (ocrDocument.getImagePaths().size() <= 1) continue;
                Collections.sort(ocrDocument.getImagePaths(), (o1, o2) -> {
                    String fileName1 = FileUtils.getFileNameWithoutExtension((String)o1.getFileName().toString());
                    fileName1 = fileName1.replace(ocrDocument.getBaseName(), "");
                    fileName1 = fileName1.replace("_", "");
                    String fileName2 = FileUtils.getFileNameWithoutExtension((String)o2.getFileName().toString());
                    fileName2 = fileName2.replace(ocrDocument.getBaseName(), "");
                    if (fileName1.equals(fileName2 = fileName2.replace("_", ""))) {
                        return 0;
                    }
                    boolean pageNumbersInteger = true;
                    int fileName1Int = 0;
                    if (fileName1.length() > 0) {
                        try {
                            fileName1Int = Integer.parseInt(fileName1);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("Cannot get page number from " + fileName1 + " for " + o1.getFileName().toString());
                            pageNumbersInteger = false;
                        }
                    }
                    int fileName2Int = 0;
                    if (fileName2.length() > 0) {
                        try {
                            fileName2Int = Integer.parseInt(fileName2);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("Cannot get page number from " + fileName2 + " for " + o1.getFileName().toString());
                            pageNumbersInteger = false;
                        }
                    }
                    if (pageNumbersInteger) {
                        return Integer.compare(fileName1Int, fileName2Int);
                    }
                    return fileName1.compareTo(fileName2);
                });
            }
        }
        return fileCount.get();
    }

    @Override
    public void stopTriggered() {
        this.stopRequested = true;
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.countFilesToProcess > 0L) {
            percentageComplete = (double)this.countFilesProcessed.get() / (double)this.countFilesToProcess;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.countFilesProcessed != null && this.countFilesProcessed.get() > 0L) {
            result = (String)result + " / ";
            result = (String)result + this.iu.getNumeralString("NativeOcrImagesOperation.Progress.FilesProcessed", this.countFilesProcessed.get());
        }
        if (this.countPagesProcessed != null && this.countPagesProcessed.get() > 0L) {
            result = (String)result + " / ";
            result = (String)result + this.iu.getNumeralString("NativeOcrImagesOperation.Progress.PagesProcessed", this.countPagesProcessed.get());
        }
        return result;
    }

    private void trackStats(List<Path> paths, boolean failed) {
        String stage = "ocr";
        for (Path path : paths) {
            String fileExtension = FileUtils.getFileExtension((String)path.getFileName().toString()).toLowerCase();
            String mimeType = MimeTypeUtils.getInstance().getMimeType(fileExtension);
            this.trackItemProcessedFailed(mimeType, stage, failed);
        }
    }

    private void trackStats(Path path, boolean failed) {
        String fileExtension = FileUtils.getFileExtension((String)path.getFileName().toString()).toLowerCase();
        this.trackStats(path, fileExtension, failed);
    }

    private void trackStats(Path path, String fileExtension, boolean failed) {
        String stage = "ocr";
        String mimeType = MimeTypeUtils.getInstance().getMimeType(fileExtension);
        this.trackItemProcessedFailed(mimeType, stage, failed);
    }

    @Override
    public List<MimeTypeVolume> getMimeTypeVolumes() {
        return new ArrayList<MimeTypeVolume>(this.mimeTypeVolumes.values());
    }

    @Override
    public Activity getActivity() {
        return Activity.OCR;
    }

    @Override
    public long getVolume(WorkflowExecution workflowExecution) {
        long volume = 0L;
        for (MimeTypeVolume mimeTypeVolume : this.getMimeTypeVolumes()) {
            volume += mimeTypeVolume.getAuditedSize();
        }
        return volume;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.OCR;
    }
}

