/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.PopulateBinaryStoreOperation;
import com.nuix.automate.workflow.core.execution.operations.RemoteWorkerBasedOperation;
import com.nuix.automate.workflow.core.utils.general.ConfigurationParser;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixWorkerUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import nuix.BatchExporter;
import nuix.ExportProcessingJob;
import nuix.Item;
import nuix.ItemEventInfo;
import nuix.ParallelProcessingConfigurable;
import nuix.ProcessingJob;
import org.apache.commons.io.FileUtils;

public class PopulateBinaryStoreOperationImplementation
extends PopulateBinaryStoreOperation
implements RemoteWorkerBasedOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PopulateBinaryStoreOperation.class);
    private static final transient List<String> exportStages = Arrays.asList("NATIVE", "STORED_EMAIL_FIXUP", "NUMBERING", "BINARY_STORE", "FILE_NAMING", "SET_FILE_TIMES", "DIGEST");
    private transient ExportProcessingJob exportProcessingJob;
    private transient String exportFolder;
    private transient boolean isPaused;
    private transient double partStartPercentage;
    private transient double partSizePercentage;
    private transient int workPart;
    private transient long totalFailedItems;
    private transient Integer workerMemory = null;
    private transient AtomicInteger addedWorkerCount = new AtomicInteger(0);

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                try {
                    this.executionContext.workflowLocalWorkersCount = Integer.parseInt(this.executionContext.evalParameters("{local_worker_count}", this));
                    this.executionContext.workflowParallelSettings = true;
                    this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingLocalWorkerCountFromParameter", new Object[]{"{local_worker_count}", this.executionContext.workflowLocalWorkersCount}));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.executionContext.workflowLocalWorkersMemoryMb = Integer.parseInt(this.executionContext.evalParameters("{local_worker_memory}", this));
                    this.executionContext.workflowParallelSettings = true;
                    this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingLocalWorkerMemoryFromParameter", new Object[]{"{local_worker_memory}", this.executionContext.workflowLocalWorkersMemoryMb}));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.executionContext.workflowBrokerWorkersCount = Integer.parseInt(this.executionContext.evalParameters("{broker_worker_count}", this));
                    this.executionContext.workflowParallelSettings = true;
                    this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingBrokerWorkerCountFromParameter", new Object[]{"{broker_worker_count}", this.executionContext.workflowBrokerWorkersCount}));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.executionContext.jobBrokerPort = Integer.parseInt(this.executionContext.evalParameters("{job_worker_broker_port}", this));
                    this.executionContext.jobBrokerIp = this.executionContext.evalParameters("{job_worker_broker_ip}", this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.executionContext.workflowLocalWorkersTempFolder = this.executionContext.evalParameters(this.executionContext.workflowLocalWorkersTempFolder, this);
                this.executionContext.closeAllTabs();
                this.scope = this.executionContext.evalParameters(this.scope, this);
                this.addExecutionLog(this.iu.getFormattedString("PopulateBinaryStoreOperation.Log.ScopeQuery", (Object)this.scope));
                List itemsInScope = this.executionContext.nuixCase.search(this.scope);
                long itemsInScopeCount = itemsInScope.size();
                this.addExecutionLog(this.iu.getNumeralString("PopulateBinaryStoreOperation.Log.ScopeCount", itemsInScopeCount));
                if (itemsInScope.size() == 0) {
                    this.trackFinished();
                    return;
                }
                if (this.tempFolder == null || this.tempFolder.length() == 0) {
                    this.exportFolder = this.executionContext.workflowLocalWorkersTempFolder;
                    if (this.exportFolder == null || this.exportFolder.trim().length() == 0) {
                        LOGGER.info("Using worker temp folder inside case");
                        this.exportFolder = String.valueOf(this.executionContext.nuixCase.getLocation()) + "/temp";
                    } else {
                        LOGGER.info("Using worker temp folder from last configuration operation");
                    }
                } else {
                    this.exportFolder = this.tempFolder;
                }
                this.exportFolder = this.exportFolder + "/populate-binary-store";
                if (this.splitWork.booleanValue() && itemsInScopeCount > (long)this.splitWorkAt) {
                    this.addExecutionLog(this.iu.getNumeralString("General.Log.SplitWorkAt", (long)this.splitWorkAt));
                    LOGGER.info("Performing work in parts");
                    int addedForWork = 0;
                    this.workPart = 0;
                    while (addedForWork < itemsInScope.size()) {
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        ArrayList<Item> partItems = new ArrayList<Item>();
                        this.partStartPercentage = (double)addedForWork / (double)itemsInScope.size();
                        LOGGER.info("Exported in parts: " + addedForWork + " of " + itemsInScope.size());
                        ++this.workPart;
                        int nextItemId = Math.min(addedForWork + this.splitWorkAt, itemsInScope.size());
                        partItems.addAll(itemsInScope.subList(addedForWork, nextItemId));
                        LOGGER.info("Preparing work on part from " + addedForWork + " to " + (nextItemId - 1));
                        addedForWork = nextItemId;
                        LOGGER.info("Added to part: " + addedForWork);
                        double trancheEndPercentage = (double)addedForWork / (double)itemsInScope.size();
                        this.partSizePercentage = trancheEndPercentage - this.partStartPercentage;
                        LOGGER.info("Starting work on part " + this.workPart);
                        this.addExecutionLog(this.iu.getNumeralFormattedString("General.Log.WorkPart", (long)partItems.size(), (Object)this.workPart));
                        this.runItems(partItems, this.workPart);
                    }
                    LOGGER.info("Exported in parts: " + addedForWork + " of " + itemsInScope.size());
                } else {
                    this.runItems(itemsInScope, 0);
                }
                if (this.totalFailedItems > 0L) {
                    this.addWarning(this.iu.getNumeralString("PopulateBinaryStoreOperation.Warning.FailedToPopulateBinaryStoresOf", this.totalFailedItems));
                }
                this.addExecutionLog(this.iu.getNumeralString("PopulateBinaryStoreOperation.Log.PopulatedBinaryStoresOf", itemsInScopeCount - this.totalFailedItems));
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void runItems(List<Item> partItemsInScope, int partId) throws Exception {
        BatchExporter batchExporter = this.executionContext.nuixUtilities.createBatchExporter(this.exportFolder);
        batchExporter.whenItemEventOccurs(this::itemProcessed);
        HashMap<String, Object> productOptions = new HashMap<String, Object>();
        productOptions.put("regenerateStored", true);
        productOptions.put("naming", "guid");
        batchExporter.addProduct("native", productOptions);
        HashMap<String, Boolean> numberingOptions = new HashMap<String, Boolean>();
        numberingOptions.put("createProductionSet", false);
        batchExporter.setNumberingOptions(numberingOptions);
        ConfigurationParser configurationParser = new ConfigurationParser();
        batchExporter.setParallelProcessingSettings(configurationParser.getParallelProcessingLegalExportSettings());
        NuixWorkerUtils.setWorkerSettings(this.executionContext, this, (ParallelProcessingConfigurable)batchExporter, partId <= 1);
        this.workerMemory = NuixWorkerUtils.getProcessorWorkerMemory((ParallelProcessingConfigurable)batchExporter);
        this.exportProcessingJob = batchExporter.exportItemsAsync(partItemsInScope);
        String processingJobGuid = this.exportProcessingJob.getJobGuid().replace("-", "");
        LOGGER.info("Job Guid: " + processingJobGuid);
        if (this.stopRequested) {
            this.trackStopped();
        }
        NuixWorkerUtils.addRemoteWorkers(this.executionContext, this, (ProcessingJob)this.exportProcessingJob, this.addedWorkerCount);
        NuixUtils.waitForProcessingJobToComplete((ProcessingJob)this.exportProcessingJob);
        if (this.executionState == ExecutionState.STOPPING) {
            this.trackStopped();
        }
        this.totalFailedItems += this.exportProcessingJob.getFailedItemCount();
        try {
            LOGGER.info("Deleting temporary folder " + this.exportFolder);
            FileUtils.deleteDirectory((File)new File(this.exportFolder));
        }
        catch (IOException e) {
            LOGGER.warn("Cannot delete temporary folder.", (Throwable)e);
        }
    }

    @Override
    protected void resumeTriggered() {
        if (this.exportProcessingJob != null) {
            try {
                this.exportProcessingJob.resume();
            }
            catch (Exception e) {
                LOGGER.error("Cannot resume job", (Throwable)e);
            }
        }
    }

    @Override
    protected void pauseTriggered() {
        if (this.exportProcessingJob != null) {
            try {
                this.exportProcessingJob.pause();
            }
            catch (Exception e) {
                LOGGER.error("Cannot pause job", (Throwable)e);
            }
        }
    }

    @Override
    protected void stopTriggered() {
        if (this.exportProcessingJob != null) {
            try {
                LOGGER.info("Sending stop command while job is in state " + this.exportProcessingJob.getCurrentStage());
                this.exportProcessingJob.stop();
            }
            catch (Exception e) {
                LOGGER.error("Cannot stop job", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void updateState() {
        if (this.exportProcessingJob != null) {
            if (!this.isPaused && this.exportProcessingJob.hasPaused()) {
                this.isPaused = true;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", false);
            }
            if (this.isPaused && !this.exportProcessingJob.hasPaused()) {
                this.isPaused = false;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", true);
            }
        }
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete;
        block6: {
            percentageComplete = 0.0;
            if (this.exportProcessingJob != null) {
                try {
                    String exportStage = this.exportProcessingJob.getCurrentStage();
                    double currentStageIndex = exportStages.indexOf(exportStage);
                    double totalStages = exportStages.size();
                    long totalItems = this.exportProcessingJob.getTotalItemCount();
                    long itemsExported = this.exportProcessingJob.getCurrentStageExportedItemsCount();
                    double stagePercentComplete = totalItems > 0L ? (double)itemsExported / (double)totalItems : 0.0;
                    percentageComplete = (stagePercentComplete + currentStageIndex) / totalStages;
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block6;
                    LOGGER.debug("Cannot get progress.", (Throwable)e);
                }
            }
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        if (this.partSizePercentage > 0.0) {
            percentageComplete = percentageComplete * this.partSizePercentage + this.partStartPercentage;
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.exportProcessingJob != null && this.exportProcessingJob.getCurrentStage() != null) {
            if (this.workPart > 0) {
                result = (String)result + " / " + this.iu.getFormattedString("General.Progress.Part", (Object)this.workPart);
            }
            try {
                String currentStage = this.exportProcessingJob.getCurrentStage();
                int currentStageIndex = exportStages.indexOf(currentStage);
                String exportStage = currentStageIndex < 3 ? this.iu.getString("PopulateBinaryStoreOperation.Progress.PreparingItems") : (currentStageIndex == 3 ? this.iu.getNumeralFormattedString("PopulateBinaryStoreOperation.Progress.ExportStage", this.exportProcessingJob.getCurrentStageExportedItemsCount(), (Object)FormattingUtils.stageToString((String)currentStage.toLowerCase())) : this.iu.getString("PopulateBinaryStoreOperation.Progress.CleanUp"));
                result = this.iu.getFormattedString("PopulateBinaryStoreOperation.Progress.ExportStageResult", new Object[]{result, exportStage});
            }
            catch (Exception e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Cannot get job stage.", (Throwable)e);
                }
            }
        } else {
            String exportStage = this.iu.getString("PopulateBinaryStoreOperation.Progress.Initializing");
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + exportStage;
        }
        return result;
    }

    @Override
    public String getProcessingJobGuid() {
        if (this.exportProcessingJob != null) {
            return this.exportProcessingJob.getJobGuid();
        }
        return null;
    }

    public void itemProcessed(ItemEventInfo itemEventInfo) {
        Item processedItem = itemEventInfo.getItem();
        String mimeType = "unknown";
        String pathName = "N/A";
        if (processedItem != null) {
            pathName = String.join((CharSequence)"/", processedItem.getPathNames());
            mimeType = processedItem.getType().getName();
        }
        String stage = itemEventInfo.getStage() == null ? "exported" : itemEventInfo.getStage();
        String translatedStage = this.iu.getString("MimeType.Stage." + stage);
        this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.ExportedStage", new Object[]{translatedStage, pathName}));
        this.trackItemProcessedFailed(mimeType, stage, itemEventInfo.getFailure() != null);
    }

    @Override
    public Integer getWorkerMemory() {
        if (this.executionContext.workflowBrokerWorkersCount <= 0) {
            return null;
        }
        return this.workerMemory;
    }

    @Override
    public Integer getAddedWorkerCount() {
        if (this.addedWorkerCount == null) {
            return 0;
        }
        return this.addedWorkerCount.get();
    }
}

