/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.PowerShellOperation;
import com.nuix.automate.workflow.core.utils.general.OsUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.types.Commandline;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class PowerShellOperationImplementation
extends PowerShellOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PowerShellOperationImplementation.class);
    private transient boolean externalApplicationFatalErrorOccurred = false;
    private transient Process externalApplicationLoadProcess;
    private transient Thread readStandardOutputThread;
    private transient Thread readStandardErrorThread;
    private transient String applicationLocation;
    private transient Path temporaryPowerShellScript;
    private transient Path effectivePowerShellScript;
    private transient String maskedPowerShellArguments;

    @Override
    protected void startTriggered() throws Exception {
        File externalApplication;
        this.applicationLocation = OsUtils.getOsWindows() ? "C:\\Windows\\System32\\WindowsPowerShell\\v1.0\\powershell.exe" : "/usr/local/bin/pwsh";
        String parametersTempDir = Files.createTempDirectory("powershell_" + FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)), new FileAttribute[0]).toFile().getAbsolutePath();
        LOGGER.info("Parameters folder: " + parametersTempDir);
        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{powershell_parameters}", parametersTempDir)));
        this.powerShellFileName = this.executionContext.evalParameters(this.powerShellFileName, this);
        this.powerShellCode = this.executionContext.evalParameters(this.powerShellCode, this);
        this.maskedPowerShellArguments = this.powerShellArguments;
        if (this.powerShellArguments != null && !this.powerShellArguments.equals("")) {
            this.maskedPowerShellArguments = this.executionContext.evalParameters(this.powerShellArguments, this, false, false);
            this.powerShellArguments = this.executionContext.evalParameters(this.powerShellArguments, this);
        }
        if (!(externalApplication = new File(this.applicationLocation)).exists()) {
            throw new FileNotFoundException(this.iu.getFormattedString("RunExternalApplicationOperation.Exception.FileNotFound", (Object)externalApplication.getAbsolutePath()));
        }
        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_exit_code}", "")));
        this.startTriggerThread = new Thread(() -> {
            try {
                if (externalApplication.isFile()) {
                    if (this.usePowerShellFile) {
                        this.effectivePowerShellScript = Paths.get(this.powerShellFileName, new String[0]);
                    } else {
                        this.effectivePowerShellScript = this.temporaryPowerShellScript = com.nuix.automate.utils.general.FileUtils.createTempFilePath((String)"Automate", (String)".ps1", (FileAttribute[])new FileAttribute[0]);
                        LOGGER.info("Creating temporary PowerShell script file " + String.valueOf(this.effectivePowerShellScript));
                        com.nuix.automate.utils.general.FileUtils.writeToFile((String)this.powerShellCode, (Path)this.effectivePowerShellScript);
                    }
                    this.runExternalApplication();
                    this.waitForIo();
                    if (this.externalApplicationFatalErrorOccurred) {
                        this.addWarning(this.iu.getString("PowerShellOperation.Warning.FatalError"));
                    } else if (this.externalApplicationLoadProcess != null) {
                        int exitValue = this.externalApplicationLoadProcess.exitValue();
                        if (exitValue != 0) {
                            this.addWarning(this.iu.getFormattedString("PowerShellOperation.Log.ExitValue", (Object)exitValue));
                        } else {
                            this.addExecutionLog(this.iu.getFormattedString("PowerShellOperation.Log.ExitValue", (Object)exitValue));
                        }
                        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_exit_code}", "" + exitValue)));
                    }
                }
                if (!externalApplication.isFile() || !externalApplication.canExecute()) {
                    this.exception = new IllegalArgumentException(this.iu.getFormattedString("RunExternalApplicationOperation.Exception.NotValidFile", (Object)externalApplication.getAbsolutePath()));
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                this.stopLoad(true);
                return;
            }
            finally {
                if (!this.usePowerShellFile) {
                    LOGGER.info("Deleting temporary PowerShell script file " + String.valueOf(this.temporaryPowerShellScript));
                    try {
                        com.nuix.automate.utils.general.FileUtils.deleteRecursively((Path)this.temporaryPowerShellScript);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Cannot delete temporary PowerShell script " + String.valueOf(this.temporaryPowerShellScript));
                    }
                }
            }
            try (Stream<Path> paths = Files.walk(Paths.get(parametersTempDir, new String[0]), new FileVisitOption[0]);){
                paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                    String filename = path.getFileName().toString();
                    String parameterName = com.nuix.automate.utils.general.FileUtils.getFileNameWithoutExtension((String)filename);
                    try {
                        String parameterValue = com.nuix.automate.utils.general.FileUtils.readFileWithAutodetectEncoding((File)path.toFile());
                        String normalizedParameterName = FormattingUtils.normalizeParameterName((String)parameterName);
                        StaticParameter parameter = new StaticParameter(normalizedParameterName, parameterValue);
                        this.trackParameter((Parameter)parameter);
                        this.addExecutionLog("Setting parameter " + normalizedParameterName);
                        this.executionContext.getExecutionCustomParameters().put((Parameter)parameter);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Cannot read parameter file " + filename, (Throwable)e);
                        this.addWarning(this.iu.getFormattedString("PowerShellOperation.Warning.CannotSetParameter", new Object[]{parameterName, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                    }
                });
            }
            catch (IOException e) {
                LOGGER.warn("Cannot read parameters folder " + parametersTempDir, (Throwable)e);
                this.addWarning(this.iu.getFormattedString("PowerShellOperation.Warning.CannotSetParameters", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
            }
            try {
                FileUtils.deleteDirectory((File)Paths.get(parametersTempDir, new String[0]).toFile());
            }
            catch (IOException e) {
                LOGGER.warn("Cannot delete parameters folder", (Throwable)e);
            }
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    public void readOutputStream(BufferedReader standardInputReader) throws IOException {
        String line = "";
        while ((line = standardInputReader.readLine()) != null) {
            if (Thread.interrupted()) {
                return;
            }
            line = FormattingUtils.removeAnsiColors((String)line);
            this.addExecutionLog(line);
        }
    }

    public void readErrorStream(BufferedReader errorReader) throws IOException {
        String line;
        while ((line = errorReader.readLine()) != null) {
            if (Thread.interrupted()) {
                return;
            }
            if ((line = FormattingUtils.removeAnsiColors((String)line)).trim().length() > 0 && !line.startsWith("#< CLIXML") && !line.startsWith("<Objs")) {
                this.addWarning(line);
            }
            LOGGER.warn(line);
        }
    }

    private void waitForIo() {
        try {
            this.externalApplicationLoadProcess.waitFor();
            this.readStandardOutputThread.join();
            this.readStandardErrorThread.join();
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread interrupted");
        }
    }

    public void runExternalApplication() throws IOException, InterruptedException {
        this.addExecutionLog(this.iu.getFormattedString("RunExternalApplicationOperation.Log.PowerShellApplication", (Object)this.applicationLocation));
        if (this.usePowerShellFile) {
            this.addExecutionLog(this.iu.getFormattedString("PowerShellOperation.Log.ScriptPath", (Object)this.effectivePowerShellScript));
        }
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.applicationLocation);
        commandLine.add(this.effectivePowerShellScript.toAbsolutePath().toString());
        if (this.usePowerShellFile && this.powerShellArguments.length() > 0) {
            String[] arguments;
            LOGGER.info("Command: " + String.join((CharSequence)" ", commandLine) + " " + this.maskedPowerShellArguments);
            for (String argument : arguments = Commandline.translateCommandline((String)this.powerShellArguments)) {
                if (OsUtils.getOsWindows() && argument.contains(" ")) {
                    commandLine.add("'" + argument + "'");
                    continue;
                }
                commandLine.add(argument);
            }
        } else {
            LOGGER.info("Command: " + String.join((CharSequence)" ", commandLine));
        }
        ProcessBuilder builder = new ProcessBuilder(commandLine);
        this.externalApplicationLoadProcess = builder.start();
        LOGGER.info("Application Running");
        BufferedReader standardInputReader = new BufferedReader(new InputStreamReader(this.externalApplicationLoadProcess.getInputStream()));
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(this.externalApplicationLoadProcess.getErrorStream()));
        this.readStandardOutputThread = new Thread(() -> {
            try {
                this.readOutputStream(standardInputReader);
            }
            catch (IOException e) {
                LOGGER.error("Cannot read standard output stream", (Throwable)e);
                this.addWarning(this.iu.getFormattedString("General.Log.ExceptionMessage", (Object)e.getLocalizedMessage()));
            }
            finally {
                try {
                    standardInputReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot close stream", (Throwable)e);
                }
            }
        });
        this.readStandardOutputThread.setName("Automate Run External Application Standard Output Thread");
        this.readStandardOutputThread.start();
        this.readStandardErrorThread = new Thread(() -> {
            try {
                this.readErrorStream(errorReader);
            }
            catch (IOException e) {
                LOGGER.error("Cannot read standard error stream", (Throwable)e);
                this.addWarning(this.iu.getFormattedString("General.Log.ExceptionMessage", (Object)e.getLocalizedMessage()));
            }
            finally {
                try {
                    errorReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot close stream", (Throwable)e);
                }
            }
        });
        this.readStandardErrorThread.setName("Automate Run External Application Standard Error Thread");
        this.readStandardErrorThread.start();
    }

    @Override
    protected void stopTriggered() {
        LOGGER.info("Stop triggered");
        Thread thread = new Thread(() -> {
            while (this.executionState == ExecutionState.STOPPING) {
                this.stopLoad(false);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Thread interrupted, attempting to stop process", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        });
        thread.setName("Automate - Operation " + this.getOperationName() + " Stop request");
        thread.start();
    }

    private void stopLoad(boolean silent) {
        if (this.externalApplicationLoadProcess != null) {
            LOGGER.info("Attempting to destroy external application load process");
            try {
                this.startTriggerThread.interrupt();
            }
            catch (Exception e) {
                LOGGER.error("Cannot interrupt thread", (Throwable)e);
            }
            try {
                this.externalApplicationLoadProcess.descendants().forEach(ProcessHandle::destroyForcibly);
                this.externalApplicationLoadProcess.destroyForcibly();
            }
            catch (Exception e) {
                LOGGER.error("Cannot destroy external application process", (Throwable)e);
            }
            this.readStandardErrorThread.interrupt();
            this.readStandardOutputThread.interrupt();
            if (!silent && !this.externalApplicationLoadProcess.isAlive()) {
                this.trackStopped();
            }
        }
    }

    @Override
    public void abort() {
        super.abort();
        if (this.externalApplicationLoadProcess != null) {
            try {
                this.externalApplicationLoadProcess.descendants().forEach(ProcessHandle::destroyForcibly);
                this.externalApplicationLoadProcess.destroyForcibly();
            }
            catch (Exception e) {
                LOGGER.error("Cannot destroy external application process", (Throwable)e);
            }
        }
    }

    @Override
    protected double getPercentageComplete() {
        return 0.0;
    }

    @Override
    public String getPrintablePercentageComplete() {
        String result = "";
        if (this.externalApplicationLoadProcess == null) {
            result = this.iu.getString("RunExternalApplicationOperation.Progress.StartingApplication");
        } else if (!(this.externalApplicationLoadProcess.isAlive() || this.readStandardErrorThread.isAlive() || this.readStandardOutputThread.isAlive())) {
            result = this.iu.getString("RunExternalApplicationOperation.Progress.Finished");
        }
        return result;
    }
}

