/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.aspose.cells.AutoFitterOptions;
import com.aspose.cells.Cell;
import com.aspose.cells.CellArea;
import com.aspose.cells.CellsException;
import com.aspose.cells.Chart;
import com.aspose.cells.ChartCollection;
import com.aspose.cells.ConditionalFormattingCollection;
import com.aspose.cells.FindOptions;
import com.aspose.cells.FormatConditionCollection;
import com.aspose.cells.LoadOptions;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.aspose.cells.Title;
import com.aspose.cells.Workbook;
import com.aspose.cells.Worksheet;
import com.ibm.icu.util.ULocale;
import com.nuix.automate.utils.exceptions.InvalidCustomDigestSizeException;
import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.ProcessingReportOperation;
import com.nuix.automate.workflow.core.execution.options.report.ExcludeDates;
import com.nuix.automate.workflow.core.execution.options.report.ReportMeasure;
import com.nuix.automate.workflow.core.execution.options.report.ReportStats;
import com.nuix.automate.workflow.core.execution.options.report.ReportView;
import com.nuix.automate.workflow.core.execution.options.report.ReportViewFieldType;
import com.nuix.automate.workflow.core.execution.options.report.ReportViewProperty;
import com.nuix.automate.workflow.core.execution.options.report.ReportViewSummarizeBy;
import com.nuix.automate.workflow.core.execution.options.report.SingleDimensionReportStats;
import com.nuix.automate.workflow.core.execution.options.report.SizeMethod;
import com.nuix.automate.workflow.core.execution.options.report.SizeUnit;
import com.nuix.automate.workflow.core.execution.options.report.TemplateWorksheetName;
import com.nuix.automate.workflow.core.execution.options.report.TwoDimensionReportStats;
import com.nuix.automate.workflow.core.execution.options.sorting.SortOrder;
import com.nuix.automate.workflow.core.persistance.ProcessingReportLinePersistence;
import com.nuix.automate.workflow.core.persistance.ProcessingReportPersistence;
import com.nuix.automate.workflow.core.persistance.ProcessingReportViewPersistence;
import com.nuix.automate.workflow.core.utils.general.AsposeUtils;
import com.nuix.automate.workflow.core.utils.general.ItemSortablePathNameExpression;
import com.nuix.automate.workflow.core.utils.general.NuixEmailUtils;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.MetadataItemUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nuix.Address;
import nuix.Case;
import nuix.CaseFactory;
import nuix.Communication;
import nuix.Item;
import nuix.ItemExpression;
import nuix.ItemSet;
import nuix.MetadataItem;
import nuix.MetadataProfile;
import nuix.ProductionSet;
import nuix.ProductionSetItem;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class ProcessingReportOperationImplementation
extends ProcessingReportOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ProcessingReportOperation.class);
    private final transient String NA_VALUE = "[n/a]";
    private final transient String NA_VALUE_SIMPLIFIED = "n/a";
    private final transient String categorySeparator = "\u001f";
    private final transient int MAX_EXTENSION_LENGTH = 20;
    private final transient int IMAGE_SIZE_STEP = 100;
    private final transient int IMAGE_MAX_SIZE1 = 1000;
    private final transient int IMAGE_MAX_SIZE2 = 5000;
    private final transient int CELL_MAX_SIZE = Short.MAX_VALUE;
    private transient int stageCount;
    private transient int stageId;
    private transient AtomicLong stageProcessedItems;
    private transient long stageTotalItems;
    private transient String stageName;
    private transient Map<String, ReportStats> reportsStats;
    private transient ConcurrentHashMap<String, Long> largeTextFilesSize;
    private transient List<Case> cases;
    private transient String caseNames;
    private transient String caseFolders;
    private transient double reportViewProgress;
    private transient Set<String> processingStageNamesExcludedFromOverview;
    private transient DateTimeZone caseDateTimeZone;
    private transient ProcessingReportPersistence reportPersistence;
    private transient Map<String, String> productionSetGuidToName;
    private transient Set<String> rubyFieldNames;
    private transient String customDigestSizeMetadataFieldName;
    private transient boolean logCustomDigestSizeWarnings;

    public ProcessingReportPersistence getReportPersistence() {
        return this.reportPersistence;
    }

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        try {
            this.customDigestSizeMetadataFieldName = this.executionContext.evalParametersIfSet("{custom_digest_size_metadata_field_name}", this);
            this.addExecutionLog(this.iu.getFormattedString("ProcessingReportOperation.Log.InferCustomDigestSizeMetadataFieldName", (Object)this.customDigestSizeMetadataFieldName));
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
        try {
            Boolean parameter = this.executionContext.evalBooleanParameter("{log_custom_digest_size_warnings}", this);
            if (parameter != null) {
                this.logCustomDigestSizeWarnings = parameter;
            }
            if (this.logCustomDigestSizeWarnings) {
                this.addExecutionLog(this.iu.getString("ProcessingReportOperation.Log.LogCustomDigestSizeMetadataWarnings"));
            }
        }
        catch (ParameterException parameter) {
            // empty catch block
        }
        this.customReportTemplatePath = this.executionContext.evalParameters(this.customReportTemplatePath, this);
        this.largeTextFilesSize = new ConcurrentHashMap();
        this.caseDateTimeZone = DateTimeZone.forID((String)this.executionContext.nuixCase.getInvestigationTimeZone());
        AtomicLong itemsWithFailedCustomDigestSize = new AtomicLong(0L);
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                this.stageCount = 10;
                this.stageId = 0;
                this.stageProcessedItems = new AtomicLong(0L);
                this.processingStageNamesExcludedFromOverview = new HashSet<String>();
                for (Object[] processingStageDetails : this.processingStages) {
                    if (processingStageDetails.length != 4) continue;
                    String stageName = (String)processingStageDetails[0];
                    boolean stageExcluded = (Boolean)processingStageDetails[3];
                    if (!stageExcluded) continue;
                    this.processingStageNamesExcludedFromOverview.add(stageName);
                }
                for (int i = 0; i < this.reportViews.size(); ++i) {
                    String reportViewName = ((Object[])this.reportViews.get(i))[0].toString();
                    reportViewName = this.executionContext.evalParameters(reportViewName, this);
                    ((Object[])this.reportViews.get((int)i))[0] = reportViewName;
                }
                HashMap<String, String> irregularQueries = new HashMap<String, String>();
                irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.Poisoned"), "flag:poison");
                irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.Unrecognized"), "kind:unrecognised");
                irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.Decrypted"), "flag:decrypted");
                irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.Inaccessible"), "mime-type:filesystem/inaccessible");
                irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.Archived"), "properties:(\"MAPI-content-class: urn:kvsplc-com:cc:vault:shortcut\" OR \"MAPI-message-class: IPM.Note.EnterpriseVault.Shortcut\") OR \nproperties:(\"MAPI-content-class: urn:cintent-classes-MsiStub\" OR \"MAPI-message-class: IPM.Note.MimosaStub*\")");
                irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.CorruptedPST"), "file-extension:pst AND NOT mime-type:application/vnd.ms-outlook");
                if (this.executionContext.nuixVersion.getMajor() >= 7) {
                    irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.Corrupted"), "properties:FailureDetail AND NOT flag:encrypted");
                    irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.CorruptedContainer"), "properties:FailureDetail AND NOT flag:encrypted AND has-text:0 AND ( has-embedded-data:1 OR kind:container OR kind:database )");
                    irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.UnsupportedItems"), "NOT flag:encrypted AND has-embedded-data:0 AND ( ( has-text:0 AND has-image:0 AND NOT flag:not_processed AND NOT kind:multimedia AND NOT mime-type:application/vnd.ms-shortcut AND NOT mime-type:application/x-contact AND NOT kind:system AND NOT mime-type:( application/vnd.apache-error-log-entry OR application/vnd.linux-syslog-entry OR application/vnd.logstash-log-entry OR application/vnd.ms-iis-log-entry OR application/vnd.ms-windows-event-log-record OR application/vnd.ms-windows-event-logx-record OR application/vnd.ms-windows-setup-api-win7-win8-log-boot-entry OR application/vnd.ms-windows-setup-api-win7-win8-log-section-entry OR application/vnd.ms-windows-setup-api-xp-log-entry OR application/vnd.squid-access-log-entry OR application/vnd.tcpdump.record OR application/vnd.tcpdump.tcp.stream OR application/vnd.tcpdump.udp.stream OR application/x-pcapng-entry OR filesystem/x-linux-login-logfile-record OR filesystem/x-ntfs-logfile-record OR server/dropbox-log-event OR text/x-common-log-entry OR text/x-log-entry ) AND NOT kind:log AND NOT mime-type:application/vnd.ms-exchange-stm ) OR mime-type:application/vnd.lotus-notes )");
                    irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.UnsupportedContainers"), "kind:( container OR database ) AND NOT flag:encrypted AND has-embedded-data:0 AND NOT flag:partially_processed AND NOT flag:not_processed AND NOT properties:FailureDetail");
                    irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.Deleted"), "flag:deleted");
                    irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.Encrypted"), "flag:encrypted");
                    irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.NonSearchablePDFs"), "mime-type:application/pdf AND NOT content:*");
                } else {
                    irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.Corrupted"), "properties:FailureDetail AND NOT encrypted:1");
                    irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.CorruptedContainer"), "properties:FailureDetail AND NOT encrypted:1 AND has-text:0 AND ( has-embedded-data:1 OR kind:container OR kind:database )");
                    irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.UnsupportedItems"), "encrypted:0 AND has-embedded-data:0 AND ( ( has-text:0 AND has-image:0 AND NOT flag:not_processed AND NOT kind:multimedia AND NOT mime-type:application/vnd.ms-shortcut AND NOT mime-type:application/x-contact AND NOT kind:system AND NOT mime-type:( application/vnd.apache-error-log-entry OR application/vnd.linux-syslog-entry OR application/vnd.logstash-log-entry OR application/vnd.ms-iis-log-entry OR application/vnd.ms-windows-event-log-record OR application/vnd.ms-windows-event-logx-record OR application/vnd.ms-windows-setup-api-win7-win8-log-boot-entry OR application/vnd.ms-windows-setup-api-win7-win8-log-section-entry OR application/vnd.ms-windows-setup-api-xp-log-entry OR application/vnd.squid-access-log-entry OR application/vnd.tcpdump.record OR application/vnd.tcpdump.tcp.stream OR application/vnd.tcpdump.udp.stream OR application/x-pcapng-entry OR filesystem/x-linux-login-logfile-record OR filesystem/x-ntfs-logfile-record OR server/dropbox-log-event OR text/x-common-log-entry OR text/x-log-entry ) AND NOT kind:log AND NOT mime-type:application/vnd.ms-exchange-stm ) OR mime-type:application/vnd.lotus-notes )");
                    irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.UnsupportedContainers"), "kind:( container OR database ) AND encrypted:0 AND has-embedded-data:0 AND NOT flag:partially_processed AND NOT flag:not_processed AND NOT properties:FailureDetail");
                    irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.Deleted"), "deleted:1");
                    irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.Encrypted"), "encrypted:1");
                    irregularQueries.put(this.iu.getString("ProcessingReportOperation.Queries.NonSearchablePDFs"), "mime-type:application/pdf AND contains-text:0");
                }
                this.stageTotalItems = (this.processingStages.size() * 2 + irregularQueries.size() + 1) * (this.additionalCasesLocations.size() + 1) + this.additionalCasesLocations.size();
                String timeZoneId = null;
                String timezoneIdParameter = "{case_timezone_id}";
                String evaluatedTimezoneIdParameter = this.executionContext.evalParameters(timezoneIdParameter, this);
                if (!timezoneIdParameter.equals(evaluatedTimezoneIdParameter)) {
                    if (evaluatedTimezoneIdParameter.length() > 0) {
                        try {
                            DateTimeZone dateTimeZone = DateTimeZone.forID((String)evaluatedTimezoneIdParameter);
                            timeZoneId = dateTimeZone.getID();
                            LOGGER.info("Parsed specified timezone " + FormattingUtils.timeZoneToDisplayName((DateTimeZone)dateTimeZone) + " from ID " + timezoneIdParameter);
                        }
                        catch (Exception e) {
                            LOGGER.error("Cannot set timezone " + evaluatedTimezoneIdParameter, (Throwable)e);
                        }
                    } else {
                        timeZoneId = "";
                    }
                }
                for (Object[] processingStageDetails : this.processingStages) {
                    String processingStageName = processingStageDetails[0].toString();
                    this.itemProcessed(processingStageName);
                }
                this.cases = new ArrayList<Case>();
                this.cases.add(this.executionContext.nuixCase);
                for (Object[] additionalCaseLocationsDetails : this.additionalCasesLocations) {
                    if (this.stopRequested) {
                        this.closeAdditionalCases();
                        this.trackStopped();
                        return;
                    }
                    String additionalCaseLocation = (String)additionalCaseLocationsDetails[0];
                    if ((additionalCaseLocation = this.executionContext.evalParameters(additionalCaseLocation, this)).trim().length() <= 0) continue;
                    try {
                        CaseFactory caseFactory = this.executionContext.nuixUtilities.getCaseFactory();
                        this.stageName = this.iu.getFormattedString("ProcessingReportOperation.Stage.OpeningCase", (Object)additionalCaseLocation);
                        LOGGER.info("Opening case " + additionalCaseLocation);
                        if (NuixUtils.disablePreviousProcessingQueue(additionalCaseLocation)) {
                            this.addWarning(this.iu.getFormattedString("ProcessingReportOperation.Warning.CaseContainsIncompleteProcessingQueue", (Object)additionalCaseLocation));
                        }
                        if (NuixUtils.disablePreviousPersistentQueue(additionalCaseLocation)) {
                            this.addWarning(this.iu.getFormattedString("AddToCompoundCaseOperation.Warning.CaseIncompletePersistentQueue", (Object)additionalCaseLocation));
                        }
                        Case additionalCase = caseFactory.open(additionalCaseLocation);
                        if (timeZoneId != null && timeZoneId.length() > 0) {
                            this.executionContext.nuixCase.setInvestigationTimeZone(timeZoneId);
                        }
                        this.cases.add(additionalCase);
                        this.stageProcessedItems.incrementAndGet();
                    }
                    catch (Throwable e) {
                        LOGGER.error("Cannot open case", e);
                        this.addWarning(e.getLocalizedMessage());
                    }
                }
                Set allItems = null;
                HashMap<String, Set> processingStagesItems = new HashMap<String, Set>();
                HashMap<String, Object> irregularItems = new HashMap<String, Object>();
                this.caseNames = "";
                this.caseFolders = "";
                this.addExecutionLog(this.iu.getFormattedString("ProcessingReportOperation.Log.ScopeQuery", (Object)this.scope));
                long scopeCount = this.executionContext.nuixCase.count(this.scope);
                this.addExecutionLog(this.iu.getNumeralString("ProcessingReportOperation.Log.ScopeCount", scopeCount));
                for (Case currentCase : this.cases) {
                    Object processingStageDetails2;
                    if (this.caseNames.length() > 0) {
                        this.caseNames = this.caseNames + ", ";
                    }
                    this.caseNames = this.caseNames + currentCase.getName();
                    if (this.caseFolders.length() > 0) {
                        this.caseFolders = this.caseFolders + ", ";
                    }
                    this.caseFolders = this.caseFolders + String.valueOf(currentCase.getLocation());
                    Object prefix = "";
                    if (this.cases.size() > 1) {
                        prefix = "Case " + currentCase.getName() + " - ";
                    }
                    LOGGER.info("Discovering items from case " + String.valueOf(currentCase.getLocation()));
                    for (Object processingStageDetails2 : this.processingStages) {
                        if (this.stopRequested) {
                            this.closeAdditionalCases();
                            this.trackStopped();
                            return;
                        }
                        String processingStageName = processingStageDetails2[0].toString();
                        String processingStageQuery = processingStageDetails2[1].toString();
                        try {
                            processingStageQuery = this.executionContext.evalParameters(processingStageQuery, this);
                        }
                        catch (ParameterException e) {
                            LOGGER.error("Error evaluating processing stage query", (Throwable)e);
                            this.exception = e;
                            this.addWarning(this.iu.getFormattedString("ProcessingReportOperation.Warning.CannotEvaluateStageQuery", (Object)processingStageQuery));
                            this.trackFinished();
                            return;
                        }
                        if (processingStageName.length() == 0) {
                            this.addWarning(this.iu.getString("ProcessingReportOperation.Warning.SkippedProcessingStageDueToBlankName"));
                            continue;
                        }
                        if (processingStageQuery.length() == 0) {
                            LOGGER.warn("Processing stage " + processingStageName + " has blank query");
                        }
                        this.stageName = this.iu.getFormattedString("ProcessingReportOperation.Stage.SearchingFor", (Object)processingStageName);
                        String query = NuixUtils.addAndQuery(this.scope, processingStageQuery);
                        LOGGER.info(this.stageName + ": " + query);
                        try {
                            Set items = currentCase.searchUnsorted(query);
                            LOGGER.info("Count " + FormattingUtils.itemsCountToDisplay((long)items.size()));
                            Set existingItems = (Set)processingStagesItems.get(processingStageName);
                            if (existingItems == null) {
                                processingStagesItems.put(processingStageName, items);
                            } else {
                                LOGGER.info("Adding to existing " + existingItems.size() + " items in this category");
                                Set mergedItems = this.executionContext.nuixUtilities.getItemUtility().union((Collection)existingItems, (Collection)items);
                                processingStagesItems.put(processingStageName, mergedItems);
                            }
                            this.addExecutionLog(this.iu.getNumeralFormattedString("ProcessingReportOperation.Log.PrefixProcessingStageName", (long)items.size(), new Object[]{prefix, processingStageName}));
                        }
                        catch (IOException e) {
                            LOGGER.error("Error running query " + query, (Throwable)e);
                            this.exception = e;
                            this.addWarning(this.iu.getFormattedString("ProcessingReportOperation.Warning.CannotRunQuery", (Object)processingStageQuery));
                            this.trackFinished();
                            return;
                        }
                        this.stageProcessedItems.incrementAndGet();
                    }
                    boolean irregularSearchesRequired = false;
                    for (Object[] reportViewDetails : this.reportViews) {
                        String reportViewName = reportViewDetails[0].toString();
                        ReportView reportView = (ReportView)reportViewDetails[1];
                        if (reportView.verticalFieldType == ReportViewFieldType.IRREGULAR || reportView.verticalFieldType == ReportViewFieldType.IRREGULAR_AND_TYPE) {
                            irregularSearchesRequired = true;
                            break;
                        }
                        if (reportView.horizontalFieldType != ReportViewFieldType.IRREGULAR && reportView.horizontalFieldType != ReportViewFieldType.IRREGULAR_AND_TYPE) continue;
                        irregularSearchesRequired = true;
                        break;
                    }
                    if (irregularSearchesRequired) {
                        for (String irregularCategory : irregularQueries.keySet()) {
                            this.stageName = this.iu.getFormattedString("ProcessingReportOperation.Stage.SearchingFor", (Object)irregularCategory);
                            String query = NuixUtils.addAndQuery(this.scope, (String)irregularQueries.get(irregularCategory));
                            LOGGER.info(this.stageName + ": " + query);
                            try {
                                Set items = currentCase.searchUnsorted(query);
                                LOGGER.info("Count " + FormattingUtils.itemsCountToDisplay((long)items.size()));
                                Set existingItems = (Set)irregularItems.get(irregularCategory);
                                if (existingItems == null) {
                                    irregularItems.put(irregularCategory, items);
                                } else {
                                    LOGGER.info("Adding to existing " + existingItems.size() + " items in this category");
                                    Set mergedItems = this.executionContext.nuixUtilities.getItemUtility().union((Collection)existingItems, (Collection)items);
                                    irregularItems.put(irregularCategory, mergedItems);
                                }
                            }
                            catch (IOException e) {
                                LOGGER.error("Error running query " + query, (Throwable)e);
                                this.exception = e;
                                this.addWarning(this.iu.getFormattedString("ProcessingReportOperation.Warning.CannotRunQuery", (Object)query));
                                this.trackFinished();
                                return;
                            }
                            this.stageProcessedItems.incrementAndGet();
                        }
                    } else {
                        LOGGER.info("Skipping irregular queries");
                        this.stageProcessedItems.addAndGet(irregularQueries.size());
                    }
                    this.stageName = this.iu.getString("ProcessingReportOperation.Stage.MergingSearches");
                    LOGGER.info(this.stageName);
                    processingStageDetails2 = this.processingStages.iterator();
                    while (processingStageDetails2.hasNext()) {
                        Object[] processingStageDetails3 = (Object[])processingStageDetails2.next();
                        String processingStageName = processingStageDetails3[0].toString();
                        Set processingStageItems = (Set)processingStagesItems.get(processingStageName);
                        LOGGER.info("Processing stage " + processingStageName + " has " + processingStageItems.size() + " items");
                        if (allItems == null) {
                            LOGGER.info("Setting as current allItems");
                            allItems = (Set)processingStagesItems.get(processingStageName);
                        } else {
                            LOGGER.info("Merging with " + allItems.size() + " current items");
                            allItems = this.executionContext.nuixUtilities.getItemUtility().union(allItems, (Collection)processingStageItems);
                            LOGGER.info("Merge resulted in " + allItems.size() + " items");
                        }
                        this.stageProcessedItems.incrementAndGet();
                    }
                }
                if (allItems == null) {
                    this.addWarning(this.iu.getString("ProcessingReportOperation.Warning.NoItemsWereFoundInScope"));
                    allItems = new HashSet();
                }
                ++this.stageId;
                this.stageName = this.iu.getString("ProcessingReportOperation.Stage.ComputingStats");
                LOGGER.info("Computing stats on " + allItems.size() + " items");
                this.stageProcessedItems.set(0L);
                this.stageTotalItems = (long)Math.ceil((double)allItems.size() / 8.0);
                this.reportsStats = new HashMap<String, ReportStats>();
                for (Object[] reportViewDetails : this.reportViews) {
                    String reportViewName = reportViewDetails[0].toString();
                    ReportView reportView = (ReportView)reportViewDetails[1];
                    if (reportView.horizontalFieldType == ReportViewFieldType.NONE) {
                        this.reportsStats.put(reportViewName, new SingleDimensionReportStats());
                        continue;
                    }
                    this.reportsStats.put(reportViewName, new TwoDimensionReportStats());
                }
                boolean reportComputeTextSize = false;
                boolean reportComputeAuditedSize = false;
                boolean reportComputeDigestSize = false;
                boolean reportComputeAttachmentSize = false;
                boolean reportComputeFileSize = false;
                block35: for (Object[] processingStageDetails : this.processingStages) {
                    String processingStageName = processingStageDetails[0].toString();
                    boolean processingStageUsed = false;
                    for (Object[] reportViewDetails : this.reportViews) {
                        String reportViewName = reportViewDetails[0].toString();
                        ReportView reportView = (ReportView)reportViewDetails[1];
                        if (reportView.processingStage != null && !reportView.processingStage.equals(processingStageName)) continue;
                        processingStageUsed = true;
                        break;
                    }
                    if (!processingStageUsed) {
                        LOGGER.info("Processing stage " + processingStageName + " defined but not used in any processing report view");
                        continue;
                    }
                    String processingStageQuery = processingStageDetails[1].toString();
                    Object sizeMethod = (SizeMethod)((Object)((Object)processingStageDetails[2]));
                    if (sizeMethod == null) continue;
                    switch (sizeMethod) {
                        case FILE_SISE: {
                            reportComputeFileSize = true;
                            continue block35;
                        }
                        case AUDITED_SIZE: {
                            reportComputeAuditedSize = true;
                            continue block35;
                        }
                        case AUDITED_TEXT_SIZE: {
                            reportComputeAuditedSize = true;
                            reportComputeTextSize = true;
                            continue block35;
                        }
                        case AUDITED_ATTACHMENTS_2X: {
                            reportComputeAuditedSize = true;
                            reportComputeAttachmentSize = true;
                            continue block35;
                        }
                        case AUDITED_ATTACHMENTS_2X_TEXT_SIZE: {
                            reportComputeAuditedSize = true;
                            reportComputeTextSize = true;
                            reportComputeAttachmentSize = true;
                            continue block35;
                        }
                        case TEXT_SIZE: {
                            reportComputeTextSize = true;
                            continue block35;
                        }
                        case DIGEST_SIZE: {
                            reportComputeDigestSize = true;
                            continue block35;
                        }
                    }
                    throw new Exception(this.iu.getFormattedString("ProcessingReportOperation.Exception.UnsupportedSizeMethod", sizeMethod));
                }
                boolean computeTextSize = reportComputeTextSize;
                boolean computeAuditedSize = reportComputeAuditedSize;
                boolean computeDigestSize = reportComputeDigestSize;
                boolean computeAttachmentSize = reportComputeAttachmentSize;
                boolean computeFileSize = reportComputeFileSize;
                LOGGER.info("Compute text size required: " + computeTextSize);
                LOGGER.info("Compute audited size required: " + computeAuditedSize);
                LOGGER.info("Compute file size required: " + computeFileSize);
                LOGGER.info("Compute digest size required: " + computeDigestSize);
                for (Object[] reportViewDetails : this.reportViews) {
                    String[] endSplits;
                    String[] startSplits;
                    String reportViewName = reportViewDetails[0].toString();
                    ReportView reportView = (ReportView)reportViewDetails[1];
                    if (reportView.horizontalFieldType == ReportViewFieldType.TOP_LEVEL_YEAR || reportView.horizontalFieldType == ReportViewFieldType.ITEM_YEAR) {
                        reportView.horizontalFieldComputedProperties = new HashMap<ReportViewProperty, Object>();
                        reportView.horizontalFieldComputedProperties.put(ReportViewProperty.START_YEAR, reportView.horizontalStartYear);
                        reportView.horizontalFieldComputedProperties.put(ReportViewProperty.END_YEAR, reportView.horizontalEndYear);
                        reportView.horizontalFieldComputedProperties.put(ReportViewProperty.EXCLUDE, (Object)reportView.horizontalExcludeDates);
                    } else if (reportView.horizontalFieldType == ReportViewFieldType.TOP_LEVEL_YEAR_MONTH || reportView.horizontalFieldType == ReportViewFieldType.ITEM_YEAR_MONTH) {
                        startSplits = reportView.horizontalStartMonthYear.split("-");
                        endSplits = reportView.horizontalEndMonthYear.split("-");
                        reportView.horizontalFieldComputedProperties = new HashMap<ReportViewProperty, Object>();
                        reportView.horizontalFieldComputedProperties.put(ReportViewProperty.START_YEAR, Integer.parseInt(startSplits[0]));
                        reportView.horizontalFieldComputedProperties.put(ReportViewProperty.START_MONTH, Integer.parseInt(startSplits[1]));
                        reportView.horizontalFieldComputedProperties.put(ReportViewProperty.END_YEAR, Integer.parseInt(endSplits[0]));
                        reportView.horizontalFieldComputedProperties.put(ReportViewProperty.END_MONTH, Integer.parseInt(endSplits[1]));
                        reportView.horizontalFieldComputedProperties.put(ReportViewProperty.EXCLUDE, (Object)reportView.horizontalExcludeDates);
                    } else if (reportView.horizontalFieldType == ReportViewFieldType.TAG) {
                        reportView.horizontalFieldComputedProperties = new HashMap<ReportViewProperty, Object>();
                        reportView.horizontalFieldComputedProperties.put(ReportViewProperty.TAG_NAME, reportView.horizontalName);
                    }
                    if (reportView.verticalFieldType == ReportViewFieldType.TOP_LEVEL_YEAR || reportView.verticalFieldType == ReportViewFieldType.ITEM_YEAR) {
                        reportView.verticalFieldComputedProperties = new HashMap<ReportViewProperty, Object>();
                        reportView.verticalFieldComputedProperties.put(ReportViewProperty.START_YEAR, reportView.verticalStartYear);
                        reportView.verticalFieldComputedProperties.put(ReportViewProperty.END_YEAR, reportView.verticalEndYear);
                        reportView.verticalFieldComputedProperties.put(ReportViewProperty.EXCLUDE, (Object)reportView.verticalExcludeDates);
                    } else if (reportView.verticalFieldType == ReportViewFieldType.TOP_LEVEL_YEAR_AND_MONTH || reportView.verticalFieldType == ReportViewFieldType.TOP_LEVEL_YEAR_MONTH || reportView.verticalFieldType == ReportViewFieldType.ITEM_YEAR_MONTH) {
                        startSplits = reportView.verticalStartMonthYear.split("-");
                        endSplits = reportView.verticalEndMonthYear.split("-");
                        reportView.verticalFieldComputedProperties = new HashMap<ReportViewProperty, Object>();
                        reportView.verticalFieldComputedProperties.put(ReportViewProperty.START_YEAR, Integer.parseInt(startSplits[0]));
                        reportView.verticalFieldComputedProperties.put(ReportViewProperty.START_MONTH, Integer.parseInt(startSplits[1]));
                        reportView.verticalFieldComputedProperties.put(ReportViewProperty.END_YEAR, Integer.parseInt(endSplits[0]));
                        reportView.verticalFieldComputedProperties.put(ReportViewProperty.END_MONTH, Integer.parseInt(endSplits[1]));
                        reportView.verticalFieldComputedProperties.put(ReportViewProperty.EXCLUDE, (Object)reportView.verticalExcludeDates);
                    } else if (reportView.verticalFieldType == ReportViewFieldType.TAG) {
                        reportView.verticalFieldComputedProperties = new HashMap<ReportViewProperty, Object>();
                        reportView.verticalFieldComputedProperties.put(ReportViewProperty.TAG_NAME, reportView.verticalName);
                    }
                    if (reportView.verticalFieldType2 == ReportViewFieldType.TOP_LEVEL_YEAR || reportView.verticalFieldType2 == ReportViewFieldType.ITEM_YEAR) {
                        reportView.verticalFieldComputedProperties2 = new HashMap<ReportViewProperty, Object>();
                        reportView.verticalFieldComputedProperties2.put(ReportViewProperty.START_YEAR, reportView.vertical2StartYear);
                        reportView.verticalFieldComputedProperties2.put(ReportViewProperty.END_YEAR, reportView.vertical2EndYear);
                        reportView.verticalFieldComputedProperties2.put(ReportViewProperty.EXCLUDE, (Object)reportView.vertical2ExcludeDates);
                        continue;
                    }
                    if (reportView.verticalFieldType2 == ReportViewFieldType.TOP_LEVEL_YEAR_AND_MONTH || reportView.verticalFieldType2 == ReportViewFieldType.TOP_LEVEL_YEAR_MONTH || reportView.verticalFieldType2 == ReportViewFieldType.ITEM_YEAR_MONTH) {
                        startSplits = reportView.vertical2StartMonthYear.split("-");
                        endSplits = reportView.vertical2EndMonthYear.split("-");
                        reportView.verticalFieldComputedProperties2 = new HashMap<ReportViewProperty, Object>();
                        reportView.verticalFieldComputedProperties2.put(ReportViewProperty.START_YEAR, Integer.parseInt(startSplits[0]));
                        reportView.verticalFieldComputedProperties2.put(ReportViewProperty.START_MONTH, Integer.parseInt(startSplits[1]));
                        reportView.verticalFieldComputedProperties2.put(ReportViewProperty.END_YEAR, Integer.parseInt(endSplits[0]));
                        reportView.verticalFieldComputedProperties2.put(ReportViewProperty.END_MONTH, Integer.parseInt(endSplits[1]));
                        reportView.verticalFieldComputedProperties2.put(ReportViewProperty.EXCLUDE, (Object)reportView.vertical2ExcludeDates);
                        continue;
                    }
                    if (reportView.verticalFieldType2 != ReportViewFieldType.TAG) continue;
                    reportView.verticalFieldComputedProperties2 = new HashMap<ReportViewProperty, Object>();
                    reportView.verticalFieldComputedProperties2.put(ReportViewProperty.TAG_NAME, reportView.vertical2Name);
                }
                this.productionSetGuidToName = new HashMap<String, String>();
                for (ProductionSet productionSet : this.executionContext.nuixCase.getProductionSets()) {
                    this.productionSetGuidToName.put(productionSet.getGuid(), productionSet.getName());
                }
                boolean count = false;
                FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner(allItems, ItemsUtils.getPartitionerChunkSize(256, this));
                try {
                    Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                        if (this.stopRequested) {
                            throw new WorkflowExecutionStopRequested();
                        }
                        while (iterator.hasNext()) {
                            long itemDigestSize;
                            long itemTextSize;
                            long itemAttachedAuditedSize;
                            long itemAuditedSize;
                            Item item;
                            block34: {
                                if (this.stopRequested) {
                                    throw new WorkflowExecutionStopRequested();
                                }
                                item = (Item)iterator.next();
                                itemAuditedSize = 0L;
                                itemAttachedAuditedSize = 0L;
                                if (computeAuditedSize) {
                                    itemAuditedSize = this.getItemAuditedSize(item);
                                    if (computeAttachmentSize) {
                                        itemAttachedAuditedSize = this.getIsItemNonEmbeddedAttachment(item) * itemAuditedSize;
                                    }
                                }
                                itemTextSize = 0L;
                                if (computeTextSize) {
                                    itemTextSize = this.getItemTextSize(item);
                                }
                                itemDigestSize = 0L;
                                if (computeDigestSize) {
                                    try {
                                        itemDigestSize = NuixUtils.getItemDigestSize(item, this.customDigestSizeMetadataFieldName);
                                    }
                                    catch (InvalidCustomDigestSizeException e) {
                                        if (!this.logCustomDigestSizeWarnings) break block34;
                                        LOGGER.warn("Cannot compute digest for item " + item.getGuid() + ", " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                                        itemsWithFailedCustomDigestSize.incrementAndGet();
                                    }
                                }
                            }
                            long itemFileSize = 0L;
                            if (computeFileSize) {
                                itemFileSize = this.getItemFileSize(item);
                            }
                            for (Object[] reportViewDetails : this.reportViews) {
                                ReportMeasure previousMeasure;
                                List<String> categories2;
                                List<String> categories1;
                                Set processingStageItems;
                                String reportViewName = reportViewDetails[0].toString();
                                ReportView reportView = (ReportView)reportViewDetails[1];
                                boolean itemInScope = true;
                                if (reportView.processingStage != null && reportView.processingStage.length() > 0 && (processingStageItems = (Set)processingStagesItems.get(reportView.processingStage)) != null && !processingStageItems.contains(item)) {
                                    itemInScope = false;
                                }
                                if (!itemInScope) continue;
                                if (reportView.horizontalFieldType == ReportViewFieldType.NONE) {
                                    List<String> categories = this.getItemStatsCategories(item, reportView.verticalFieldType, reportView.verticalName, reportView.verticalFieldComputedProperties, processingStagesItems, irregularItems);
                                    if (reportView.verticalFieldType2 != ReportViewFieldType.NONE) {
                                        categories1 = categories;
                                        categories2 = this.getItemStatsCategories(item, reportView.verticalFieldType2, reportView.vertical2Name, reportView.verticalFieldComputedProperties2, processingStagesItems, irregularItems);
                                        categories = new ArrayList<String>();
                                        for (String category1 : categories1) {
                                            for (String category2 : categories2) {
                                                categories.add(category1 + "\u001f" + category2);
                                            }
                                        }
                                    }
                                    SingleDimensionReportStats reportStats = (SingleDimensionReportStats)this.reportsStats.get(reportViewName);
                                    if (categories.size() > 0) {
                                        reportStats.totals.count.incrementAndGet();
                                        reportStats.totals.auditedSize.addAndGet(itemAuditedSize);
                                        reportStats.totals.fileSize.addAndGet(itemFileSize);
                                        reportStats.totals.digestSize.addAndGet(itemDigestSize);
                                        reportStats.totals.attachmentsAuditedSize.addAndGet(itemAttachedAuditedSize);
                                        reportStats.totals.textSize.addAndGet(itemTextSize);
                                    }
                                    for (String category : categories) {
                                        ReportMeasure previousMeasure2 = reportStats.stats.putIfAbsent(category, new ReportMeasure());
                                        if (previousMeasure2 == null) {
                                            previousMeasure2 = reportStats.stats.get(category);
                                        }
                                        previousMeasure2.count.incrementAndGet();
                                        previousMeasure2.auditedSize.addAndGet(itemAuditedSize);
                                        previousMeasure2.fileSize.addAndGet(itemFileSize);
                                        previousMeasure2.digestSize.addAndGet(itemDigestSize);
                                        previousMeasure2.attachmentsAuditedSize.addAndGet(itemAttachedAuditedSize);
                                        previousMeasure2.textSize.addAndGet(itemTextSize);
                                    }
                                    continue;
                                }
                                List<String> verticalCategories = this.getItemStatsCategories(item, reportView.verticalFieldType, reportView.verticalName, reportView.verticalFieldComputedProperties, processingStagesItems, irregularItems);
                                if (reportView.verticalFieldType2 != ReportViewFieldType.NONE) {
                                    categories1 = verticalCategories;
                                    categories2 = this.getItemStatsCategories(item, reportView.verticalFieldType2, reportView.vertical2Name, reportView.verticalFieldComputedProperties2, processingStagesItems, irregularItems);
                                    verticalCategories = new ArrayList<String>();
                                    for (String category1 : categories1) {
                                        for (String category2 : categories2) {
                                            verticalCategories.add(category1 + "\u001f" + category2);
                                        }
                                    }
                                }
                                List<String> horizontalCategories = this.getItemStatsCategories(item, reportView.horizontalFieldType, reportView.horizontalName, reportView.horizontalFieldComputedProperties, processingStagesItems, irregularItems);
                                TwoDimensionReportStats reportStats = (TwoDimensionReportStats)this.reportsStats.get(reportViewName);
                                if (verticalCategories.size() > 0 && horizontalCategories.size() > 0) {
                                    reportStats.totals.count.incrementAndGet();
                                    reportStats.totals.auditedSize.addAndGet(itemAuditedSize);
                                    reportStats.totals.fileSize.addAndGet(itemFileSize);
                                    reportStats.totals.digestSize.addAndGet(itemDigestSize);
                                    reportStats.totals.attachmentsAuditedSize.addAndGet(itemAttachedAuditedSize);
                                    reportStats.totals.textSize.addAndGet(itemTextSize);
                                }
                                if (horizontalCategories.size() > 0) {
                                    for (String category : verticalCategories) {
                                        previousMeasure = reportStats.verticalTotals.putIfAbsent(category, new ReportMeasure());
                                        if (previousMeasure == null) {
                                            previousMeasure = reportStats.verticalTotals.get(category);
                                        }
                                        previousMeasure.count.incrementAndGet();
                                        previousMeasure.auditedSize.addAndGet(itemAuditedSize);
                                        previousMeasure.fileSize.addAndGet(itemFileSize);
                                        previousMeasure.digestSize.addAndGet(itemDigestSize);
                                        previousMeasure.attachmentsAuditedSize.addAndGet(itemAttachedAuditedSize);
                                        previousMeasure.textSize.addAndGet(itemTextSize);
                                    }
                                }
                                if (verticalCategories.size() > 0) {
                                    for (String category : horizontalCategories) {
                                        previousMeasure = reportStats.horizontalTotals.putIfAbsent(category, new ReportMeasure());
                                        if (previousMeasure == null) {
                                            previousMeasure = reportStats.horizontalTotals.get(category);
                                        }
                                        previousMeasure.count.incrementAndGet();
                                        previousMeasure.auditedSize.addAndGet(itemAuditedSize);
                                        previousMeasure.fileSize.addAndGet(itemFileSize);
                                        previousMeasure.digestSize.addAndGet(itemDigestSize);
                                        previousMeasure.attachmentsAuditedSize.addAndGet(itemAttachedAuditedSize);
                                        previousMeasure.textSize.addAndGet(itemTextSize);
                                    }
                                }
                                for (String verticalCategory : verticalCategories) {
                                    Map<String, ReportMeasure> previousCategoryRecord = reportStats.stats.putIfAbsent(verticalCategory, new ConcurrentHashMap());
                                    if (previousCategoryRecord == null) {
                                        previousCategoryRecord = reportStats.stats.get(verticalCategory);
                                    }
                                    for (String horizontalCategory : horizontalCategories) {
                                        ReportMeasure previousMeasure3 = previousCategoryRecord.putIfAbsent(horizontalCategory, new ReportMeasure());
                                        if (previousMeasure3 == null) {
                                            previousMeasure3 = previousCategoryRecord.get(horizontalCategory);
                                        }
                                        previousMeasure3.count.incrementAndGet();
                                        previousMeasure3.auditedSize.addAndGet(itemAuditedSize);
                                        previousMeasure3.fileSize.addAndGet(itemFileSize);
                                        previousMeasure3.digestSize.addAndGet(itemDigestSize);
                                        previousMeasure3.attachmentsAuditedSize.addAndGet(itemAttachedAuditedSize);
                                        previousMeasure3.textSize.addAndGet(itemTextSize);
                                    }
                                }
                            }
                            for (Object[] processingStageDetails : this.processingStages) {
                                String processingStageName = processingStageDetails[0].toString();
                                if (!((Set)processingStagesItems.get(processingStageName)).contains(item)) continue;
                                this.itemProcessed(item, processingStageName);
                            }
                            this.stageProcessedItems.incrementAndGet();
                        }
                    }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                }
                catch (WorkflowExecutionStopRequested e) {
                    this.closeAdditionalCases();
                    this.trackStopped();
                    return;
                }
                if (this.stopRequested) {
                    this.closeAdditionalCases();
                    this.trackStopped();
                    return;
                }
                if (itemsWithFailedCustomDigestSize.get() > 0L) {
                    this.addWarning(this.iu.getNumeralString("ProcessingReportOperation.Warning.InvalidCustomDigestSize", itemsWithFailedCustomDigestSize.get()));
                }
                this.stageId += 8;
                this.stageName = this.iu.getString("ProcessingReportOperation.Stage.BuildingReport");
                this.stageProcessedItems.set(0L);
                this.stageTotalItems = this.processingStages.size() + 1;
                try {
                    this.writeReport();
                }
                catch (Exception e) {
                    LOGGER.error("Error writing report", (Throwable)e);
                    this.addWarning(this.iu.getFormattedString("ProcessingReportOperation.Warning.CannotWriteReport", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                }
                ++this.stageId;
                this.closeAdditionalCases();
                this.largeTextFilesSize.clear();
                this.addExecutionLog(this.iu.getNumeralString("ProcessingReportOperation.Log.SearchedFor", (long)this.processingStages.size()));
                this.addExecutionLog(this.iu.getFormattedString("ProcessingReportOperation.Log.ReportLocation", (Object)this.reportLocation));
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                this.addWarning(e.getLocalizedMessage());
                this.closeAdditionalCases();
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    public synchronized void itemProcessed(Item processedItem, String stageName) {
        String mimeType = "unknown";
        String pathName = "N/A";
        if (processedItem != null) {
            mimeType = processedItem.getType().getName();
        }
        this.trackItemProcessedRegular(mimeType, stageName + "_asis");
    }

    public synchronized void itemProcessed(String stageName) {
        this.trackItemProcessedStage(stageName + "_asis");
    }

    private void closeAdditionalCases() {
        for (Case currentCase : this.cases) {
            if (currentCase == this.executionContext.nuixCase) continue;
            try {
                LOGGER.info("Closing case " + String.valueOf(currentCase.getLocation()));
                this.stageName = this.iu.getFormattedString("ProcessingReportOperation.Stage.ClosingCase", (Object)currentCase.getName());
                currentCase.close();
            }
            catch (Throwable e) {
                LOGGER.error("Cannot close case.", e);
            }
        }
    }

    private long getItemTextSize(Item item) {
        long size;
        block8: {
            size = 0L;
            try {
                block9: {
                    Long fileSize = this.largeTextFilesSize.get(item.getGuid());
                    if (fileSize != null) {
                        size = fileSize;
                        break block8;
                    }
                    try {
                        if (item.getTextObject().isStored()) {
                            size = org.apache.commons.io.FileUtils.sizeOf((File)item.getTextObject().getStoredPath().toFile());
                        }
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isDebugEnabled()) break block9;
                        LOGGER.debug("Cannot get text size from stored path");
                    }
                }
                if (size == 0L) {
                    size = item.getTextObject().length();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Cannot get file size of item " + item.getGuid(), (Throwable)e);
            }
            catch (OutOfMemoryError e) {
                LOGGER.warn("Cannot get file size of item " + item.getGuid(), (Throwable)e);
                size = this.getItemAuditedSize(item);
            }
        }
        this.largeTextFilesSize.put(item.getGuid(), size);
        return size;
    }

    private long getItemAuditedSize(Item item) {
        long size;
        block2: {
            size = 0L;
            try {
                size = item.getAuditedSize();
            }
            catch (Throwable e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Cannot get audited size of item " + item.getGuid(), e);
            }
        }
        return size;
    }

    private long getIsItemNonEmbeddedAttachment(Item item) {
        if (item.isTopLevel()) {
            return 0L;
        }
        long count = 0L;
        for (Item parent = (Item)item.getParent(); parent != null; parent = (Item)parent.getParent()) {
            String kind;
            if (parent.isAudited() && ((kind = parent.getKind().getName()).equals("email") || kind.equals("calendar"))) {
                ++count;
            }
            if (parent.isTopLevel()) break;
        }
        return count;
    }

    private long getItemFileSize(Item item) {
        long size;
        block2: {
            size = 0L;
            try {
                size = item.getFileSize();
            }
            catch (Throwable e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Cannot get file size of item " + item.getGuid(), e);
            }
        }
        return size;
    }

    String getExtension(Item item) {
        String[] splits;
        Object value = "";
        if (item.getType().toString().equals("application/vnd.ms-ole2")) {
            splits = item.getName().split("\\.");
            value = splits[splits.length - 1];
        } else {
            value = item.getCorrectedExtension();
            if (((String)value).length() == 0) {
                value = item.getOriginalExtension();
            }
        }
        if (value == null || ((String)value).length() == 0) {
            value = "[n/a]";
        } else {
            splits = ((String)value).split(";\\?=&");
            value = splits[0];
        }
        if (((String)value).length() > 20) {
            value = ((String)value).substring(0, 20) + "...";
        }
        return value;
    }

    private List<String> getItemStatsCategories(Item item, ReportViewFieldType reportViewFieldType, String reportViewTagName, Map<ReportViewProperty, Object> reportViewDateProperties, Map<String, Set<Item>> processingStagesItems, Map<String, Set<Item>> irregularItems) {
        ArrayList<String> categories = new ArrayList<String>();
        try {
            switch (reportViewFieldType) {
                case CATEGORY: {
                    categories.add(item.getItemCategory());
                    break;
                }
                case CUSTODIAN: {
                    String value = item.getCustodian();
                    if (value == null || value.length() == 0) {
                        value = "[n/a]";
                    }
                    categories.add(value);
                    break;
                }
                case EXCLUSION: {
                    String value = item.getExclusion();
                    if (value != null && value.length() > 0) {
                        categories.add(value);
                    }
                    break;
                }
                case NAMED_ENTITY_TYPE: {
                    Set<String> values = this.getNamedEntityTypes(item);
                    if (!values.isEmpty()) {
                        categories.addAll(values);
                    }
                    break;
                }
                case NAMED_ENTITY_VALUE: {
                    Set<String> values = this.getNamedEntityValues(item);
                    if (!values.isEmpty()) {
                        categories.addAll(values);
                    }
                    break;
                }
                case NAMED_ENTITY_TYPE_AND_VALUE: {
                    Set<String> values = this.getNamedEntityTypesAndValues(item);
                    if (!values.isEmpty()) {
                        categories.addAll(values);
                    }
                    break;
                }
                case EXCLUSION_AND_TYPE: {
                    String value = item.getExclusion();
                    if (value != null && value.length() > 0) {
                        categories.add(value + "\u001f" + item.getType().getLocalisedName());
                    }
                    break;
                }
                case EXCLUSION_AND_TYPE_FILE_EXTENSION: {
                    String exclusionName = item.getExclusion();
                    if (exclusionName != null && exclusionName.length() > 0) {
                        Object value = this.getExtension(item);
                        value = ((String)value).equals("[n/a]") ? "n/a" : "." + (String)value;
                        categories.add(exclusionName + "\u001f" + item.getType().getLocalisedName() + " (" + ((String)value).toLowerCase() + ")");
                    }
                    break;
                }
                case BATCH_LOAD_DATE: {
                    try {
                        categories.add(FormattingUtils.dateTimeToLocalString((DateTime)item.getBatchLoadDetails().getLoaded().withZone(DateTimeZone.getDefault())));
                    }
                    catch (RuntimeException e) {
                        LOGGER.warn("Cannot get item " + item.getGuid() + " batchload details");
                    }
                    break;
                }
                case CASE_NAME: {
                    categories.add(item.getCaseName());
                    break;
                }
                case CASE_NAME_EVIDENCE_CONTAINER: {
                    categories.add(item.getCaseName() + "\u001f" + ((Item)item.getPath().get(0)).getName());
                    break;
                }
                case EVIDENCE_CONTAINER: {
                    categories.add(((Item)item.getPath().get(0)).getName());
                    break;
                }
                case EVIDENCE_CONTAINER_CUSTODIAN: {
                    String value = item.getCustodian();
                    if (value == null || value.length() == 0) {
                        value = "[n/a]";
                    }
                    categories.add(((Item)item.getPath().get(0)).getName() + "\u001f" + value);
                    break;
                }
                case FILE_EXTENSION: {
                    String value = this.getExtension(item);
                    categories.add(value.toLowerCase());
                    break;
                }
                case IRREGULAR: {
                    for (String irregularCategory : irregularItems.keySet()) {
                        if (!irregularItems.get(irregularCategory).contains(item)) continue;
                        categories.add(irregularCategory);
                    }
                    break;
                }
                case IRREGULAR_AND_TYPE: {
                    for (String irregularCategory : irregularItems.keySet()) {
                        if (!irregularItems.get(irregularCategory).contains(item)) continue;
                        categories.add(irregularCategory + "\u001f" + item.getType().getLocalisedName());
                    }
                    break;
                }
                case IRREGULAR_AND_TYPE_FILE_EXTENSION: {
                    if (irregularItems.keySet().size() > 0) {
                        Object value = this.getExtension(item);
                        value = ((String)value).equals("[n/a]") ? "n/a" : "." + (String)value;
                        for (String irregularCategory : irregularItems.keySet()) {
                            if (!irregularItems.get(irregularCategory).contains(item)) continue;
                            categories.add(irregularCategory + "\u001f" + item.getType().getLocalisedName() + " (" + ((String)value).toLowerCase() + ")");
                        }
                    }
                    break;
                }
                case IMAGE_WIDTH: {
                    if (item.getKind().getName().equals("image")) {
                        try {
                            int size = (Integer)item.getProperties().get("Width");
                            if (size > 5000) {
                                categories.add("> 5000");
                                break;
                            }
                            if (size > 1000) {
                                int lowerBound = size / 1000 * 1000;
                                int upperBound = lowerBound + 1000 - 1;
                                categories.add(lowerBound + " - " + upperBound);
                                break;
                            }
                            int lowerBound = size / 100 * 100;
                            int upperBound = lowerBound + 100 - 1;
                            categories.add(lowerBound + " - " + upperBound);
                        }
                        catch (Exception e) {
                            categories.add("[n/a]");
                        }
                    }
                    break;
                }
                case IMAGE_HEIGHT: {
                    if (item.getKind().getName().equals("image")) {
                        try {
                            int size = (Integer)item.getProperties().get("Height");
                            if (size > 5000) {
                                categories.add("> 5000");
                                break;
                            }
                            if (size > 1000) {
                                int lowerBound = (int)Math.floor(size / 1000) * 1000;
                                int upperBound = lowerBound + 1000 - 1;
                                categories.add(lowerBound + " - " + upperBound);
                                break;
                            }
                            int lowerBound = (int)Math.floor(size / 100) * 100;
                            int upperBound = lowerBound + 100 - 1;
                            categories.add(lowerBound + " - " + upperBound);
                        }
                        catch (Exception e) {
                            categories.add("[n/a]");
                        }
                    }
                    break;
                }
                case KIND: {
                    categories.add(item.getKind().getLocalisedName());
                    break;
                }
                case KIND_AND_TYPE: {
                    categories.add(item.getKind().getLocalisedName() + "\u001f" + item.getType().getLocalisedName());
                    break;
                }
                case KIND_AND_TYPE_FILE_EXTENSION: {
                    Object value = this.getExtension(item);
                    value = ((String)value).equals("[n/a]") ? "n/a" : "." + (String)value;
                    categories.add(item.getKind().getLocalisedName() + "\u001f" + item.getType().getLocalisedName() + " (" + ((String)value).toLowerCase() + ")");
                    break;
                }
                case TYPE: {
                    categories.add(item.getType().getLocalisedName());
                    break;
                }
                case TYPE_FILE_EXTENSION: {
                    Object value = this.getExtension(item);
                    value = ((String)value).equals("[n/a]") ? "n/a" : "." + (String)value;
                    categories.add(item.getType().getLocalisedName() + " (" + ((String)value).toLowerCase() + ")");
                    break;
                }
                case KIND_AND_FILE_EXTENSION: {
                    String value = this.getExtension(item);
                    categories.add(item.getKind().getLocalisedName() + "\u001f" + value.toLowerCase());
                    break;
                }
                case TAG: {
                    String tagName = reportViewTagName;
                    tagName = this.executionContext.evalParameters(tagName, this);
                    boolean match = false;
                    while (tagName.endsWith("|")) {
                        tagName = tagName.substring(0, tagName.length() - 1);
                    }
                    reportViewTagName = tagName;
                    for (String itemTags : item.getTags()) {
                        if (tagName.equals(itemTags)) {
                            categories.add("[root]");
                            match = true;
                            continue;
                        }
                        if (tagName == null || tagName.trim().length() == 0) {
                            match = true;
                            categories.add(itemTags);
                            continue;
                        }
                        if (!itemTags.startsWith(tagName + "|")) continue;
                        match = true;
                        categories.add(itemTags.substring(tagName.length() + 1));
                    }
                    if (!match) {
                        categories.add("[n/a]");
                    }
                    break;
                }
                case PROCESSING_STAGE: {
                    for (String processingStageName : processingStagesItems.keySet()) {
                        if (this.processingStageNamesExcludedFromOverview.contains(processingStageName) || !processingStagesItems.get(processingStageName).contains(item)) continue;
                        categories.add(processingStageName);
                    }
                    break;
                }
                case TOP_LEVEL_YEAR: {
                    int startYear = (Integer)reportViewDateProperties.get((Object)ReportViewProperty.START_YEAR);
                    int endYear = (Integer)reportViewDateProperties.get((Object)ReportViewProperty.END_YEAR);
                    DateTime itemDateTime = this.getTopLevelDateTime(item);
                    if (itemDateTime == null || itemDateTime.getYear() < 1970 || itemDateTime.getYear() > 2099) {
                        categories.add("[n/a]");
                        break;
                    }
                    int itemYear = itemDateTime.getYear();
                    if (itemYear < startYear) {
                        categories.add("[older]");
                        break;
                    }
                    if (itemYear > endYear) {
                        categories.add("[newer]");
                        break;
                    }
                    categories.add(String.valueOf(itemYear));
                    break;
                }
                case TOP_LEVEL_YEAR_MONTH: {
                    int startYear = (Integer)reportViewDateProperties.get((Object)ReportViewProperty.START_YEAR);
                    int endYear = (Integer)reportViewDateProperties.get((Object)ReportViewProperty.END_YEAR);
                    int startMonth = (Integer)reportViewDateProperties.get((Object)ReportViewProperty.START_MONTH);
                    int endMonth = (Integer)reportViewDateProperties.get((Object)ReportViewProperty.END_MONTH);
                    DateTime itemDateTime = this.getTopLevelDateTime(item);
                    if (itemDateTime == null || itemDateTime.getYear() < 1970 || itemDateTime.getYear() > 2099) {
                        categories.add("[n/a]");
                        break;
                    }
                    int itemYear = itemDateTime.getYear();
                    int itemMonth = itemDateTime.getMonthOfYear();
                    if (itemYear < startYear || itemYear == startYear && itemMonth < startMonth) {
                        int olderThanYear = startYear;
                        int olderThanMonth = startMonth - 1;
                        if (olderThanMonth == 0) {
                            olderThanMonth += 12;
                            --olderThanYear;
                        }
                        categories.add("[older]");
                        break;
                    }
                    if (itemYear > endYear || itemYear == endYear && itemMonth > endMonth) {
                        int newerThanYear = endYear;
                        int newerThanMonth = endMonth + 1;
                        if (endMonth == 13) {
                            newerThanMonth -= 12;
                            ++newerThanYear;
                        }
                        categories.add("[newer]");
                        break;
                    }
                    categories.add(itemYear + "-" + String.format("%02d", itemMonth));
                    break;
                }
                case TOP_LEVEL_MONTH: {
                    DateTime itemDateTime = this.getTopLevelDateTime(item);
                    if (itemDateTime == null || itemDateTime.getYear() < 1970 || itemDateTime.getYear() > 2099) {
                        categories.add("[n/a]");
                        break;
                    }
                    categories.add(String.format("%02d", itemDateTime.getMonthOfYear()));
                    break;
                }
                case TOP_LEVEL_DAY: {
                    DateTime itemDateTime = this.getTopLevelDateTime(item);
                    if (itemDateTime == null || itemDateTime.getYear() < 1970 || itemDateTime.getYear() > 2099) {
                        categories.add("[n/a]");
                        break;
                    }
                    categories.add(String.format("%02d", itemDateTime.getDayOfMonth()));
                    break;
                }
                case TOP_LEVEL_YEAR_AND_MONTH: {
                    int startYear = (Integer)reportViewDateProperties.get((Object)ReportViewProperty.START_YEAR);
                    int endYear = (Integer)reportViewDateProperties.get((Object)ReportViewProperty.END_YEAR);
                    int startMonth = (Integer)reportViewDateProperties.get((Object)ReportViewProperty.START_MONTH);
                    int endMonth = (Integer)reportViewDateProperties.get((Object)ReportViewProperty.END_MONTH);
                    DateTime itemDateTime = this.getTopLevelDateTime(item);
                    if (itemDateTime == null || itemDateTime.getYear() < 1970 || itemDateTime.getYear() > 2099) {
                        categories.add("[n/a]\u001f[n/a]");
                        break;
                    }
                    int itemYear = itemDateTime.getYear();
                    int itemMonth = itemDateTime.getMonthOfYear();
                    if (itemYear < startYear || itemYear == startYear && itemMonth < startMonth) {
                        int olderThanYear = startYear;
                        int olderThanMonth = startMonth - 1;
                        if (olderThanMonth == 0) {
                            olderThanMonth += 12;
                            --olderThanYear;
                        }
                        categories.add("[older]");
                        break;
                    }
                    if (itemYear > endYear || itemYear == endYear && itemMonth > endMonth) {
                        int newerThanYear = endYear;
                        int newerThanMonth = endMonth + 1;
                        if (endMonth == 13) {
                            newerThanMonth -= 12;
                            ++newerThanYear;
                        }
                        categories.add("[newer]");
                        break;
                    }
                    categories.add(itemYear + "\u001f" + String.format("%02d", itemMonth));
                    break;
                }
                case ITEM_YEAR: {
                    int startYear = (Integer)reportViewDateProperties.get((Object)ReportViewProperty.START_YEAR);
                    int endYear = (Integer)reportViewDateProperties.get((Object)ReportViewProperty.END_YEAR);
                    DateTime itemDateTime = this.getItemDateTime(item);
                    if (itemDateTime == null || itemDateTime.getYear() < 1970 || itemDateTime.getYear() > 2099) {
                        categories.add("[n/a]");
                        break;
                    }
                    int itemYear = itemDateTime.getYear();
                    if (itemYear < startYear) {
                        categories.add("[older]");
                        break;
                    }
                    if (itemYear > endYear) {
                        categories.add("[newer]");
                        break;
                    }
                    categories.add(String.valueOf(itemYear));
                    break;
                }
                case ITEM_YEAR_MONTH: {
                    int startYear = (Integer)reportViewDateProperties.get((Object)ReportViewProperty.START_YEAR);
                    int endYear = (Integer)reportViewDateProperties.get((Object)ReportViewProperty.END_YEAR);
                    int startMonth = (Integer)reportViewDateProperties.get((Object)ReportViewProperty.START_MONTH);
                    int endMonth = (Integer)reportViewDateProperties.get((Object)ReportViewProperty.END_MONTH);
                    DateTime itemDateTime = this.getItemDateTime(item);
                    if (itemDateTime == null || itemDateTime.getYear() < 1970 || itemDateTime.getYear() > 2099) {
                        categories.add("[n/a]");
                        break;
                    }
                    int itemYear = itemDateTime.getYear();
                    int itemMonth = itemDateTime.getMonthOfYear();
                    if (itemYear < startYear || itemYear == startYear && itemMonth < startMonth) {
                        int olderThanYear = startYear;
                        int olderThanMonth = startMonth - 1;
                        if (olderThanMonth == 0) {
                            olderThanMonth += 12;
                            --olderThanYear;
                        }
                        categories.add("[older]");
                        break;
                    }
                    if (itemYear > endYear || itemYear == endYear && itemMonth > endMonth) {
                        int newerThanYear = endYear;
                        int newerThanMonth = endMonth + 1;
                        if (endMonth == 13) {
                            newerThanMonth -= 12;
                            ++newerThanYear;
                        }
                        categories.add("[newer]");
                        break;
                    }
                    categories.add(itemYear + "-" + String.format("%02d", itemMonth));
                    break;
                }
                case ITEM_MONTH: {
                    DateTime itemDateTime = this.getItemDateTime(item);
                    if (itemDateTime == null || itemDateTime.getYear() < 1970 || itemDateTime.getYear() > 2099) {
                        categories.add("[n/a]");
                        break;
                    }
                    categories.add(String.format("%02d", itemDateTime.getMonthOfYear()));
                    break;
                }
                case ITEM_DAY: {
                    DateTime itemDateTime = this.getItemDateTime(item);
                    if (itemDateTime == null || itemDateTime.getYear() < 1970 || itemDateTime.getYear() > 2099) {
                        categories.add("[n/a]");
                        break;
                    }
                    categories.add(String.format("%02d", itemDateTime.getDayOfMonth()));
                    break;
                }
                case METADATA: {
                    break;
                }
                case LANGUAGE: {
                    String value = item.getLanguage();
                    value = value == null || value.length() == 0 ? "[n/a]" : new ULocale(value).getDisplayLanguage();
                    categories.add(value);
                    break;
                }
                case PRODUCTION_SET: {
                    Set productionSetItems = item.getProductionSetItems();
                    if (productionSetItems.isEmpty()) {
                        categories.add("[n/a]");
                        break;
                    }
                    for (ProductionSetItem productionSetItem : productionSetItems) {
                        String productionSetName = this.productionSetGuidToName.get(productionSetItem.getProductionSetGuid());
                        categories.add(productionSetName);
                    }
                    break;
                }
                case ITEMSET: {
                    Set itemSets = item.getItemSets();
                    if (itemSets.size() == 0) {
                        categories.add("[n/a]");
                        break;
                    }
                    for (ItemSet itemSet : itemSets) {
                        categories.add(itemSet.getName());
                    }
                    break;
                }
                case ITEMSET_ORIGINALS: {
                    Set itemSets = item.getItemSetsAsOriginal();
                    if (itemSets.size() == 0) {
                        categories.add("[n/a]");
                        break;
                    }
                    for (ItemSet itemSet : itemSets) {
                        categories.add(itemSet.getName());
                    }
                    break;
                }
                case ITEMSET_DUPLICATES: {
                    Set itemSets = item.getItemSetsAsOriginal();
                    if (itemSets.size() == 0) {
                        categories.add("[n/a]");
                        break;
                    }
                    for (ItemSet itemSet : itemSets) {
                        categories.add(itemSet.getName());
                    }
                    break;
                }
                case ITEMSET_ORIGINALS_DUPLICATES: {
                    boolean match = false;
                    Set itemSets = item.getItemSetsAsOriginal();
                    for (ItemSet itemSet : itemSets) {
                        categories.add(itemSet.getName() + " (Originals)");
                        match = true;
                    }
                    itemSets = item.getItemSetsAsDuplicate();
                    for (ItemSet itemSet : itemSets) {
                        categories.add(itemSet.getName() + " (Duplicates)");
                        match = true;
                    }
                    if (!match) {
                        categories.add("[n/a]");
                    }
                    break;
                }
                case ITEMSET_ORIGINALS_AND_DUPLICATES: {
                    boolean match = false;
                    Set itemSets = item.getItemSetsAsOriginal();
                    for (ItemSet itemSet : itemSets) {
                        categories.add(itemSet.getName() + "\u001fOriginals");
                        match = true;
                    }
                    itemSets = item.getItemSetsAsDuplicate();
                    for (ItemSet itemSet : itemSets) {
                        categories.add(itemSet.getName() + "\u001fDuplicates");
                        match = true;
                    }
                    if (!match) {
                        categories.add("[n/a]\u001f[n/a]");
                    }
                    break;
                }
                case ALL_DOMAINS: {
                    Communication communication = item.getCommunication();
                    ArrayList<Address> allAddresses = new ArrayList<Address>();
                    if (communication != null) {
                        allAddresses.addAll(communication.getTo());
                        allAddresses.addAll(communication.getFrom());
                        allAddresses.addAll(communication.getCc());
                        allAddresses.addAll(communication.getBcc());
                    }
                    if (allAddresses.size() == 0) {
                        categories.add("[n/a]");
                        break;
                    }
                    categories.addAll(NuixEmailUtils.getDomains(allAddresses));
                    break;
                }
                case SENDER_DOMAINS: {
                    Communication communication = item.getCommunication();
                    if (communication != null) {
                        categories.addAll(NuixEmailUtils.getDomains(communication.getFrom()));
                    }
                    break;
                }
                case RECIPIENT_DOMAINS: {
                    Communication communication = item.getCommunication();
                    ArrayList<Address> allAddresses = new ArrayList<Address>();
                    if (communication != null) {
                        allAddresses.addAll(communication.getTo());
                        allAddresses.addAll(communication.getBcc());
                        allAddresses.addAll(communication.getCc());
                    }
                    if (allAddresses.size() == 0) {
                        categories.add("[n/a]");
                        break;
                    }
                    categories.addAll(NuixEmailUtils.getDomains(allAddresses));
                    break;
                }
                default: {
                    LOGGER.error("Unsupported reporting category " + String.valueOf(reportViewFieldType));
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("Cannot get stats for item " + item.getGuid(), e);
            categories.add("[n/a]");
        }
        return categories;
    }

    private Set<String> getNamedEntityTypes(Item item) {
        TreeSet<String> namedEntities = new TreeSet<String>();
        try {
            Map allEntities = item.getAllEntitiesByType();
            return allEntities.keySet();
        }
        catch (IOException e) {
            LOGGER.error("Cannot get named for item " + item.getGuid(), (Throwable)e);
            namedEntities.add("[n/a]");
            return namedEntities;
        }
    }

    private Set<String> getNamedEntityValues(Item item) {
        TreeSet<String> namedEntities = new TreeSet<String>();
        try {
            Map allEntities = item.getAllEntitiesByType();
            for (Set value : allEntities.values()) {
                namedEntities.addAll(value);
            }
        }
        catch (IOException e) {
            LOGGER.error("Cannot get named for item " + item.getGuid(), (Throwable)e);
            namedEntities.add("[n/a]");
        }
        return namedEntities;
    }

    private Set<String> getNamedEntityTypesAndValues(Item item) {
        TreeSet<String> namedEntities = new TreeSet<String>();
        try {
            Map allEntities = item.getAllEntitiesByType();
            for (Map.Entry entry : allEntities.entrySet()) {
                String namedEntityType = (String)entry.getKey();
                Set values = (Set)entry.getValue();
                for (String value : values) {
                    namedEntities.add(namedEntityType + " - " + value);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Cannot get named for item " + item.getGuid(), (Throwable)e);
            namedEntities.add("[n/a]");
        }
        return namedEntities;
    }

    private Set<String> getSubTags(Item item, String tagName) {
        HashSet<String> subTags = new HashSet<String>();
        Set tags = item.getTags();
        if (tags.contains(tagName)) {
            subTags.add("[root]");
        }
        String tagPrefix = tagName + "|";
        for (String tag : tags) {
            if (!tag.startsWith(tagPrefix)) continue;
            String tagSuffix = tag.substring(tagPrefix.length());
            int indexOfDelimiter = tagSuffix.indexOf(124);
            String subTag = indexOfDelimiter <= 0 ? tagSuffix : tagSuffix.substring(0, indexOfDelimiter);
            subTags.add(subTag);
        }
        return subTags;
    }

    private DateTime getTopLevelDateTime(Item item) {
        try {
            DateTime date = item.getTopLevelItemDate();
            if (date == null) {
                return date;
            }
            return new DateTime((Object)date, this.caseDateTimeZone);
        }
        catch (Throwable e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cannot get date for item " + item.getGuid());
            }
            return null;
        }
    }

    private DateTime getItemDateTime(Item item) {
        try {
            DateTime date = item.getDate();
            if (date == null) {
                return date;
            }
            return new DateTime((Object)date, this.caseDateTimeZone);
        }
        catch (Throwable e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cannot get date for item " + item.getGuid());
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeReport() throws Exception {
        File reportFile;
        Object buffer;
        boolean cellMaxSizeExceeded = false;
        AsposeUtils.applyAsposeCellsLicense();
        LoadOptions loadOptions = new LoadOptions(6);
        File templateFile = null;
        if (this.customReportTemplatePath.length() > 0 && !(templateFile = new File(this.customReportTemplatePath)).exists()) {
            LOGGER.error("Cannot find report template file " + templateFile.getAbsolutePath());
            this.addWarning(this.iu.getFormattedString("ProcessingReportOperation.Warning.CouldNotFindReportTemplateFile", (Object)templateFile.getAbsolutePath()));
        }
        if (templateFile == null || !templateFile.exists()) {
            templateFile = this.executionContext.getReportTemplate();
            LOGGER.info("Cannot find report template file " + templateFile.getAbsolutePath() + ". Creating default file");
            File templateFolder = templateFile.getParentFile();
            if (!templateFolder.exists()) {
                LOGGER.info("Creating folder " + templateFolder.getAbsolutePath());
                templateFolder.mkdirs();
            }
            try (InputStream templateStream = this.getClass().getResourceAsStream("/reports/template.xlsx");
                 OutputStream outputStream = Files.newOutputStream(templateFile.toPath(), new OpenOption[0]);){
                int bytesRead;
                buffer = new byte[1024];
                while ((bytesRead = templateStream.read((byte[])buffer)) != -1) {
                    outputStream.write((byte[])buffer, 0, bytesRead);
                }
                templateStream.close();
                outputStream.flush();
            }
        }
        Workbook workbook = new Workbook(templateFile.getAbsolutePath(), loadOptions);
        this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{case_name}", this.caseNames)));
        this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{case_folder}", this.caseFolders)));
        for (int worksheetId = 0; worksheetId < workbook.getWorksheets().getCount(); ++worksheetId) {
            Worksheet worksheet = workbook.getWorksheets().get(worksheetId);
            LOGGER.info("Pre-processing worksheet " + worksheet.getName());
            buffer = this.executionContext.getParameterNames().iterator();
            while (buffer.hasNext()) {
                String placeholder = (String)buffer.next();
                try {
                    FindOptions findOptions = new FindOptions();
                    findOptions.setLookAtType(0);
                    findOptions.setLookInType(1);
                    Cell matchingCell = null;
                    while ((matchingCell = worksheet.getCells().find((Object)placeholder, matchingCell, findOptions)) != null) {
                        String unpackedPlaceholder = this.executionContext.evalParameters(matchingCell.getStringValue(), this);
                        if (placeholder.equals("{date_spreadsheet}") || placeholder.equals("{date_time_spreadsheet}")) {
                            matchingCell.setValue((Object)Calendar.getInstance());
                        } else if (placeholder.equals("{time_spreadsheet}")) {
                            matchingCell.setValue((Object)new Date());
                        } else {
                            matchingCell.setValue((Object)unpackedPlaceholder);
                        }
                        LOGGER.info("Searching for " + placeholder + ", got " + String.valueOf(matchingCell));
                    }
                }
                catch (Exception e) {
                    LOGGER.info("Cannot evaluate parameter " + placeholder, (Throwable)e);
                }
            }
        }
        this.reportPersistence = new ProcessingReportPersistence();
        this.reportPersistence.setCaseId(this.executionContext.nuixCase.getGuid());
        this.reportPersistence.setCaseName(this.executionContext.nuixCase.getName());
        this.reportPersistence.setGlobalFilter(this.scope);
        this.reportPersistence.setReportDateTime(new DateTime().toDateTime(DateTimeZone.UTC).getMillis());
        this.reportPersistence.setViews(new HashMap<String, ProcessingReportViewPersistence>());
        HashSet usedSheetNames = new HashSet();
        for (Object[] reportViewDetails : this.reportViews) {
            int sheetCopy = 0;
            int itemsOffset = 0;
            boolean moreItemsOffset = true;
            List sortedItems = null;
            while (moreItemsOffset && !this.stopRequested) {
                void var37_140;
                int n;
                Cell matchingCell;
                FindOptions findOptions;
                int sc;
                int sr;
                Worksheet worksheet;
                int templateWorksheetIndex;
                String templateWorksheetName;
                moreItemsOffset = false;
                ++sheetCopy;
                String reportViewName = reportViewDetails[0].toString();
                ReportView reportView = (ReportView)reportViewDetails[1];
                ProcessingReportViewPersistence viewPersistence = new ProcessingReportViewPersistence();
                viewPersistence.setLines(new ArrayList<ProcessingReportLinePersistence>());
                this.reportPersistence.getViews().put(reportViewName, viewPersistence);
                LOGGER.info("Writing view " + reportViewName);
                boolean processingStageNameValid = false;
                if (reportView.processingStage == null) {
                    processingStageNameValid = true;
                } else {
                    for (Object[] processingStageDetails : this.processingStages) {
                        String processingStageName = processingStageDetails[0].toString();
                        String evaluatedProcessingStageName = this.executionContext.evalParameters(processingStageName, this);
                        if (!processingStageName.equals(reportView.processingStage) && !evaluatedProcessingStageName.equals(reportView.processingStage)) continue;
                        processingStageNameValid = true;
                    }
                }
                if (!processingStageNameValid) {
                    this.addWarning(this.iu.getFormattedString("ProcessingReportOperation.Warning.ProcessingStage", new Object[]{reportView.processingStage, reportViewName}));
                    continue;
                }
                if (reportView.horizontalFieldType == ReportViewFieldType.NONE) {
                    int mergeCount2;
                    templateWorksheetName = reportView.templateWorksheetName;
                    try {
                        templateWorksheetIndex = workbook.getWorksheets().addCopy(templateWorksheetName);
                    }
                    catch (CellsException e) {
                        this.addWarning(this.iu.getFormattedString("ProcessingReportOperation.Warning.TemplateFileDoesNotHaveWorksheetNamed", new Object[]{templateWorksheetName, reportViewName}));
                        continue;
                    }
                    worksheet = workbook.getWorksheets().get(templateWorksheetIndex);
                    sr = 0;
                    sc = 0;
                    findOptions = new FindOptions();
                    findOptions.setLookAtType(0);
                    findOptions.setLookInType(1);
                    matchingCell = null;
                    matchingCell = worksheet.getCells().find((Object)"__START__", matchingCell, findOptions);
                    if (matchingCell != null) {
                        sr = matchingCell.getRow();
                        sc = matchingCell.getColumn();
                        matchingCell.setValue(null);
                    }
                    matchingCell = null;
                    matchingCell = worksheet.getCells().find((Object)"{view_name}", matchingCell, findOptions);
                    if (matchingCell != null) {
                        matchingCell.setValue((Object)reportViewName);
                    }
                    Object sheetName = reportViewName;
                    if (sheetCopy > 1) {
                        sheetName = (String)sheetName + " " + sheetCopy;
                    }
                    try {
                        worksheet.setName((String)sheetName);
                    }
                    catch (CellsException e) {
                        this.addWarning(this.iu.getFormattedString("ProcessingReportOperation.Warning.CannotSetSheetName", new Object[]{reportViewName, e.getMessage()}));
                    }
                    ArrayList<Integer> chartHeights = new ArrayList<Integer>();
                    ChartCollection worksheetCharts = worksheet.getCharts();
                    for (int i = 0; i < worksheetCharts.getCount(); ++i) {
                        Chart chart = worksheetCharts.get(i);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Chart has height " + chart.getChartObject().getHeight());
                        }
                        chartHeights.add(chart.getChartObject().getHeight());
                    }
                    if (reportView.verticalFieldType == ReportViewFieldType.METADATA) {
                        void var38_144;
                        int n2;
                        String processingStageQuery = "";
                        for (Object[] processingStageDetails : this.processingStages) {
                            String processingStageName = processingStageDetails[0].toString();
                            if (!processingStageName.equals(reportView.processingStage)) continue;
                            processingStageQuery = processingStageDetails[1].toString();
                        }
                        try {
                            processingStageQuery = this.executionContext.evalParameters(processingStageQuery, this);
                        }
                        catch (ParameterException e) {
                            LOGGER.error("Error evaluating processing stage query", (Throwable)e);
                            this.exception = e;
                            this.executionState = ExecutionState.ERROR;
                            this.addWarning(this.iu.getFormattedString("ProcessingReportOperation.Warning.CannotEvaluateProcessingStageQuery", (Object)processingStageQuery));
                            return;
                        }
                        LOGGER.info("Processing stage query: " + processingStageQuery);
                        String metadataProfileName = reportView.verticalMetadataProfile;
                        MetadataProfile metadataProfile = NuixUtils.getMetadataProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, metadataProfileName);
                        if (metadataProfile == null) {
                            this.addWarning(this.iu.getFormattedString("ProcessingReportOperation.Warning.CannotFindMetadataProfile", (Object)metadataProfile));
                            continue;
                        }
                        this.rubyFieldNames = new TreeSet<String>();
                        for (MetadataItem metadataItem : metadataProfile.getMetadata()) {
                            if (!MetadataItemUtils.isRubyScript(metadataItem)) continue;
                            this.rubyFieldNames.add(metadataItem.getName());
                            LOGGER.info("Field " + metadataItem.getName() + " is scripted Ruby field");
                        }
                        if (this.rubyFieldNames.size() > 0) {
                            this.addWarning(this.iu.getFormattedString("MetadataExportOperation.Warning.RubyFields", (Object)String.join((CharSequence)", ", this.rubyFieldNames)));
                        }
                        List metadata = metadataProfile.getMetadata();
                        int columnId = 0;
                        int rowId = 0;
                        int columnsCount = 0;
                        for (MetadataItem metadataItem : metadata) {
                            ++columnsCount;
                        }
                        if (columnsCount > 3) {
                            for (int i = 0; i < columnsCount - 3; ++i) {
                                worksheet.getCells().insertColumn(sc + 2);
                                worksheet.getCells().copyColumn(worksheet.getCells(), sc + 1, sc + 2);
                            }
                        } else if (columnsCount == 2) {
                            worksheet.getCells().deleteColumn(sc + 1);
                        } else if (columnsCount == 1) {
                            worksheet.getCells().deleteColumn(sc + 1);
                            worksheet.getCells().deleteColumn(sc + 1);
                        }
                        for (MetadataItem metadataItem : metadata) {
                            Object metadataItemRepresentation = null;
                            worksheet.getCells().get(sr, sc + columnId).setValue((Object)metadataItem.getLocalisedName());
                            ++columnId;
                        }
                        SortOrder sortOrder = reportView.verticalSortOrder;
                        List items = null;
                        String effectiveScopeQuery = NuixUtils.addAndQuery(this.scope, processingStageQuery);
                        this.reportViewProgress = 0.0;
                        try {
                            this.executionContext.closeAllTabs();
                            HashMap<String, String> searchOptions = new HashMap<String, String>();
                            LOGGER.info("Searching for " + effectiveScopeQuery);
                            if (sortedItems == null) {
                                if (sortOrder == SortOrder.TOP_LEVEL_ITEM_DATE) {
                                    searchOptions.put("order", "top-level-item-date ASC,top-level-guid ASC");
                                    items = this.executionContext.nuixCase.search(effectiveScopeQuery, searchOptions);
                                } else if (sortOrder == SortOrder.TOP_LEVEL_ITEMS_DESCENDING) {
                                    searchOptions.put("order", "top-level-item-date DESC,top-level-guid ASC");
                                    items = this.executionContext.nuixCase.search(effectiveScopeQuery, searchOptions);
                                } else {
                                    items = this.executionContext.nuixCase.search(effectiveScopeQuery);
                                }
                                if (sortOrder == SortOrder.POSITION) {
                                    LOGGER.info("Sorting items");
                                    items = this.executionContext.versionGreaterOrEqualTo("8.0.0") ? this.executionContext.nuixUtilities.getItemUtility().sortItems((Collection)items, (ItemExpression)new ItemSortablePathNameExpression()) : this.executionContext.nuixUtilities.getItemSorter().sortItems(items, (ItemExpression)new ItemSortablePathNameExpression());
                                }
                            } else {
                                items = sortedItems;
                            }
                        }
                        catch (IOException e) {
                            LOGGER.error("Error searching scope items: " + effectiveScopeQuery, (Throwable)e);
                            this.addWarning(this.iu.getFormattedString("ProcessingReportOperation.Warning.ErrorSearchingScopeItems", new Object[]{effectiveScopeQuery, e}));
                            continue;
                        }
                        int maxReportSize = 1000000;
                        if (items.size() > maxReportSize && sheetCopy == 1) {
                            this.addExecutionLog(this.iu.getNumeralFormattedString("ProcessingReportOperation.Log.ReportView", (long)items.size(), new Object[]{reportView, this.iu.getNumeralString("ProcessingReportOperation.Warning.MaxReportSize", (long)maxReportSize)}));
                        }
                        if ((n2 = Math.min(maxReportSize, items.size() - itemsOffset)) == 2) {
                            worksheet.getCells().deleteRow(sr + 3);
                        } else if (n2 == 1) {
                            worksheet.getCells().deleteRow(sr + 3);
                            worksheet.getCells().deleteRow(sr + 2);
                        } else if (n2 == 0) {
                            worksheet.getCells().deleteRow(sr + 3);
                            worksheet.getCells().deleteRow(sr + 2);
                            worksheet.getCells().deleteRow(sr + 1);
                        }
                        int n3 = itemsOffset;
                        while (var38_144 < itemsOffset + n2) {
                            block269: {
                                String metadataItemRepresentation;
                                Item item = (Item)items.get((int)var38_144);
                                if (++rowId > 2 && rowId != n2) {
                                    worksheet.getCells().insertRow(sr + rowId);
                                }
                                columnId = 0;
                                if (this.stopRequested) {
                                    for (MetadataItem metadataItem : metadata) {
                                        metadataItemRepresentation = null;
                                        metadataItemRepresentation = "[...]";
                                        worksheet.getCells().get(sr + rowId, sc + columnId).setValue((Object)metadataItemRepresentation);
                                        ++columnId;
                                    }
                                    break;
                                }
                                try {
                                    if (this.stopRequested) break block269;
                                    for (MetadataItem metadataItem : metadata) {
                                        metadataItemRepresentation = null;
                                        try {
                                            metadataItemRepresentation = MetadataItemUtils.evaluate(metadataItem, item, this.rubyFieldNames);
                                        }
                                        catch (Exception e) {
                                            metadataItemRepresentation = FormattingUtils.getExceptionPrintableMessage((Exception)e);
                                        }
                                        if (metadataItemRepresentation.length() > Short.MAX_VALUE) {
                                            LOGGER.error("CellsException: Row " + FormattingUtils.cellRowColumnToExcelA1Style((int)(sr + rowId), (int)(sc + columnId)) + " cell size is " + metadataItemRepresentation.length() + ", stripping to 32767");
                                            if (!cellMaxSizeExceeded) {
                                                cellMaxSizeExceeded = true;
                                                this.addWarning(this.iu.getFormattedString("ProcessingReportOperation.Warning.Worksheet", new Object[]{reportViewName, FormattingUtils.cellRowColumnToExcelA1Style((int)(sr + rowId), (int)(sc + columnId))}));
                                            }
                                            metadataItemRepresentation = metadataItemRepresentation.substring(0, 32766);
                                        }
                                        try {
                                            worksheet.getCells().get(sr + rowId, sc + columnId).setValue((Object)metadataItemRepresentation);
                                        }
                                        catch (CellsException e) {
                                            LOGGER.error("Row " + (sr + rowId) + ", column " + (sc + columnId) + " cell size " + metadataItemRepresentation.length(), (Throwable)e);
                                        }
                                        ++columnId;
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.warn("Generator thread interrupted", (Throwable)e);
                                    this.addWarning(ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                                    return;
                                }
                                this.reportViewProgress = (double)rowId / (double)items.size();
                            }
                            ++var38_144;
                        }
                        if (itemsOffset + n2 >= items.size()) continue;
                        moreItemsOffset = true;
                        sortedItems = items;
                        itemsOffset += n2;
                        continue;
                    }
                    SingleDimensionReportStats reportStats = (SingleDimensionReportStats)this.reportsStats.get(reportViewName);
                    int rowId = 0;
                    if (reportView.verticalFieldType2 != ReportViewFieldType.NONE) {
                        String evaluatedVerticalFieldPropertiesName2 = this.executionContext.evalParameters(reportView.verticalName, this);
                        if (reportView.verticalFieldType == ReportViewFieldType.TAG) {
                            worksheet.getCells().get(sr + rowId, sc).setValue((Object)evaluatedVerticalFieldPropertiesName2);
                            viewPersistence.setCat1Name(evaluatedVerticalFieldPropertiesName2);
                        } else {
                            worksheet.getCells().get(sr + rowId, sc).setValue((Object)reportView.verticalFieldType.toString());
                            viewPersistence.setCat1Name(reportView.verticalFieldType.toString());
                        }
                        String evaluatedVerticalFieldProperties2Name = this.executionContext.evalParameters(reportView.vertical2Name, this);
                        if (reportView.verticalFieldType2 == ReportViewFieldType.TAG) {
                            worksheet.getCells().get(sr + rowId, sc + 1).setValue((Object)evaluatedVerticalFieldProperties2Name);
                            viewPersistence.setCat2Name(evaluatedVerticalFieldProperties2Name);
                        } else {
                            worksheet.getCells().get(sr + rowId, sc + 1).setValue((Object)reportView.verticalFieldType2.toString());
                            viewPersistence.setCat2Name(reportView.verticalFieldType2.toString());
                        }
                    } else {
                        worksheet.getCells().get(sr + rowId, sc).setValue((Object)"N/A");
                        String evaluatedVerticalFieldPropertiesName = this.executionContext.evalParameters(reportView.verticalName, this);
                        if (reportView.verticalFieldType == ReportViewFieldType.TAG) {
                            worksheet.getCells().get(sr + rowId, sc + 1).setValue((Object)evaluatedVerticalFieldPropertiesName);
                            viewPersistence.setCat1Name(evaluatedVerticalFieldPropertiesName);
                        } else {
                            worksheet.getCells().get(sr + rowId, sc + 1).setValue((Object)reportView.verticalFieldType.toString());
                            viewPersistence.setCat1Name(reportView.verticalFieldType.toString());
                        }
                    }
                    if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT) {
                        worksheet.getCells().get(sr + rowId, sc + 2).setValue((Object)this.iu.getString("ReportViewSummarizeBy.COUNT"));
                    } else if (reportView.summarizeBy == ReportViewSummarizeBy.SIZE) {
                        worksheet.getCells().get(sr + rowId, sc + 2).setValue((Object)(this.iu.getString("ReportViewSummarizeBy.SIZE") + " (" + String.valueOf((Object)reportView.sizeUnit) + ")"));
                    } else if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                        worksheet.getCells().get(sr + rowId, sc + 2).setValue((Object)this.iu.getString("ReportViewSummarizeBy.COUNT"));
                        worksheet.getCells().get(sr + rowId, sc + 3).setValue((Object)(this.iu.getString("ReportViewSummarizeBy.SIZE") + " (" + String.valueOf((Object)reportView.sizeUnit) + ")"));
                    }
                    String previousMainCategory = null;
                    int previousMainCategoryStart = 4;
                    List<String> categories = new ArrayList<String>(reportStats.stats.keySet());
                    categories.sort(String.CASE_INSENSITIVE_ORDER);
                    HashSet verticalCategories1 = new HashSet();
                    for (String category : categories) {
                        if (reportView.verticalFieldType2 != ReportViewFieldType.NONE) {
                            String[] categorySplits = StringUtils.split((String)category, (String)"\u001f");
                            verticalCategories1.add(categorySplits[0]);
                            continue;
                        }
                        verticalCategories1.add(category);
                    }
                    List<String> normalizedVerticalCategories1 = this.normalizeCategories(reportView.verticalFieldType, reportView.verticalFieldComputedProperties, verticalCategories1);
                    if (reportView.verticalFieldType2 != ReportViewFieldType.NONE) {
                        ArrayList<CallSite> normalizedVerticalCategories12 = new ArrayList<CallSite>();
                        for (String normalizedVerticalCategory1 : normalizedVerticalCategories1) {
                            HashSet<String> verticalCategories2 = new HashSet<String>();
                            for (String string : categories) {
                                String[] categorySplits = StringUtils.split((String)string, (String)"\u001f");
                                if (!normalizedVerticalCategory1.equals(categorySplits[0])) continue;
                                verticalCategories2.add(categorySplits[1]);
                            }
                            List<String> list = this.normalizeCategories(reportView.verticalFieldType2, reportView.verticalFieldComputedProperties2, verticalCategories2, reportView.verticalFieldType, normalizedVerticalCategory1);
                            for (Iterator normalizedVerticalCategory2 : list) {
                                normalizedVerticalCategories12.add((CallSite)((Object)(normalizedVerticalCategory1 + "\u001f" + (String)((Object)normalizedVerticalCategory2))));
                            }
                            if (list.size() != 0) continue;
                            normalizedVerticalCategories12.add((CallSite)((Object)(normalizedVerticalCategory1 + "\u001f[n/a]")));
                        }
                        categories = normalizedVerticalCategories12;
                    } else {
                        categories = normalizedVerticalCategories1;
                    }
                    rowId = 3;
                    for (String category : categories) {
                        reportStats.stats.putIfAbsent(category, new ReportMeasure());
                        if (!reportStats.stats.containsKey(category) && reportView.verticalFieldType == ReportViewFieldType.PROCESSING_STAGE) {
                            reportStats.stats.put(category, new ReportMeasure());
                        }
                        ProcessingReportLinePersistence linePersistence = new ProcessingReportLinePersistence();
                        viewPersistence.getLines().add(linePersistence);
                        if (++rowId > 1) {
                            worksheet.getCells().insertRow(sr + rowId);
                        }
                        if (reportView.verticalFieldType2 != ReportViewFieldType.NONE) {
                            String[] categorySplits = StringUtils.split((String)category, (String)"\u001f");
                            if (categorySplits.length < 2) {
                                LOGGER.error("[" + category + "] only has " + categorySplits.length + " splits");
                            }
                            if (previousMainCategory != null && !categorySplits[0].equals(previousMainCategory)) {
                                worksheet.getCells().copyRow(worksheet.getCells(), sr + 1, sr + rowId);
                                worksheet.getCells().merge(sr + previousMainCategoryStart, sc, rowId - previousMainCategoryStart, 1);
                                previousMainCategoryStart = rowId;
                            } else {
                                worksheet.getCells().copyRow(worksheet.getCells(), sr + 2, sr + rowId);
                            }
                            previousMainCategory = categorySplits[0];
                            worksheet.getCells().get(sr + rowId, sc).setValue((Object)categorySplits[0]);
                            worksheet.getCells().get(sr + rowId, sc + 1).setValue((Object)categorySplits[1]);
                            linePersistence.setCat1(categorySplits[0]);
                            linePersistence.setCat2(categorySplits[1]);
                        } else {
                            worksheet.getCells().copyRow(worksheet.getCells(), sr + 2, sr + rowId);
                            worksheet.getCells().get(sr + rowId, sc).setValue((Object)"N/A");
                            worksheet.getCells().get(sr + rowId, sc + 1).setValue((Object)category);
                            linePersistence.setCat1(category);
                        }
                        double size = 0.0;
                        if (reportView.summarizeBy == ReportViewSummarizeBy.SIZE || reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                            void var38_151;
                            String processingStageName;
                            Object[] processingStageDetails;
                            Iterator normalizedVerticalCategory2;
                            Object var38_147 = null;
                            if (reportView.processingStage != null) {
                                normalizedVerticalCategory2 = this.processingStages.iterator();
                                while (normalizedVerticalCategory2.hasNext()) {
                                    processingStageDetails = (Object[])normalizedVerticalCategory2.next();
                                    processingStageName = processingStageDetails[0].toString();
                                    if (!reportView.processingStage.equals(processingStageName)) continue;
                                    SizeMethod sizeMethod = (SizeMethod)((Object)processingStageDetails[2]);
                                    break;
                                }
                            } else {
                                normalizedVerticalCategory2 = this.processingStages.iterator();
                                while (normalizedVerticalCategory2.hasNext()) {
                                    processingStageDetails = (Object[])normalizedVerticalCategory2.next();
                                    processingStageName = processingStageDetails[0].toString();
                                    if (!category.equals(processingStageName)) continue;
                                    SizeMethod sizeMethod = (SizeMethod)((Object)processingStageDetails[2]);
                                    break;
                                }
                            }
                            ReportMeasure reportMeasure = reportStats.stats.get(category);
                            size = this.getSizeFromReportMeasure(reportMeasure, (SizeMethod)var38_151, reportView.sizeUnit);
                        }
                        if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT) {
                            worksheet.getCells().get(sr + rowId, sc + 2).setValue((Object)reportStats.stats.get((Object)category).count);
                        } else if (reportView.summarizeBy == ReportViewSummarizeBy.SIZE) {
                            worksheet.getCells().get(sr + rowId, sc + 2).setValue((Object)size);
                        } else if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                            worksheet.getCells().get(sr + rowId, sc + 2).setValue((Object)reportStats.stats.get((Object)category).count);
                            worksheet.getCells().get(sr + rowId, sc + 3).setValue((Object)size);
                        }
                        linePersistence.setFileSize(reportStats.stats.get((Object)category).fileSize.get());
                        linePersistence.setAuditedSize(reportStats.stats.get((Object)category).auditedSize.get());
                        linePersistence.setCount(reportStats.stats.get((Object)category).count.get());
                        linePersistence.setTextSize(reportStats.stats.get((Object)category).textSize.get());
                        linePersistence.setDigestSize(reportStats.stats.get((Object)category).digestSize.get());
                    }
                    worksheet.getCells().deleteRow(sr + rowId + 1);
                    worksheet.autoFitColumns(sc, sc + 3);
                    for (int i = 0; i < worksheetCharts.getCount(); ++i) {
                        Chart chart = worksheetCharts.get(i);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Chart has height " + chart.getChartObject().getHeight() + " vs. original " + String.valueOf(chartHeights.get(i)));
                        }
                        chart.getChartObject().setHeight(((Integer)chartHeights.get(i)).intValue());
                    }
                    if (reportView.verticalFieldType2 != ReportViewFieldType.NONE && (mergeCount2 = rowId - previousMainCategoryStart + 1) > 1) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Merging cells from " + previousMainCategoryStart + " count " + mergeCount2);
                        }
                        worksheet.getCells().merge(sr + previousMainCategoryStart, sc, mergeCount2, 1);
                    }
                    ++rowId;
                    boolean includeTotals = true;
                    double size = 0.0;
                    if (reportView.summarizeBy == ReportViewSummarizeBy.SIZE || reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                        SizeMethod sizeMethod = null;
                        if (reportView.processingStage != null) {
                            for (Object[] objectArray : this.processingStages) {
                                String processingStageName = objectArray[0].toString();
                                if (!reportView.processingStage.equals(processingStageName)) continue;
                                sizeMethod = (SizeMethod)((Object)objectArray[2]);
                                break;
                            }
                        } else {
                            LOGGER.info("View " + reportViewName + " has different size methods. Skipping totals.");
                            includeTotals = false;
                        }
                        if (sizeMethod != null) {
                            ReportMeasure reportMeasure = reportStats.totals;
                            size = this.getSizeFromReportMeasure(reportMeasure, sizeMethod, reportView.sizeUnit);
                        }
                    }
                    if (includeTotals) {
                        if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT) {
                            worksheet.getCells().get(sr + rowId, sc + 2).setValue((Object)reportStats.totals.count);
                        } else if (reportView.summarizeBy == ReportViewSummarizeBy.SIZE) {
                            worksheet.getCells().get(sr + rowId, sc + 2).setValue((Object)size);
                        } else if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                            worksheet.getCells().get(sr + rowId, sc + 2).setValue((Object)reportStats.totals.count);
                            worksheet.getCells().get(sr + rowId, sc + 3).setValue((Object)size);
                        }
                    } else {
                        worksheet.getCells().deleteRow(sr + rowId);
                    }
                    if (reportView.verticalFieldType2 == ReportViewFieldType.NONE) {
                        worksheet.getCells().deleteColumn(sc);
                    }
                    worksheet.getCells().deleteRow(sr + 1);
                    worksheet.getCells().deleteRow(sr + 1);
                    worksheet.getCells().deleteRow(sr + 1);
                    continue;
                }
                templateWorksheetName = reportView.templateWorksheetName;
                try {
                    templateWorksheetIndex = workbook.getWorksheets().addCopy(templateWorksheetName);
                }
                catch (CellsException e) {
                    this.addWarning(this.iu.getFormattedString("ProcessingReportOperation.Warning.TemplateFileDoesNotHaveWorksheetNamed", new Object[]{templateWorksheetName, reportViewName}));
                    continue;
                }
                worksheet = workbook.getWorksheets().get(templateWorksheetIndex);
                sr = 0;
                sc = 0;
                findOptions = new FindOptions();
                findOptions.setLookAtType(0);
                findOptions.setLookInType(1);
                matchingCell = null;
                matchingCell = worksheet.getCells().find((Object)"__START__", matchingCell, findOptions);
                if (matchingCell != null) {
                    sr = matchingCell.getRow();
                    sc = matchingCell.getColumn();
                    matchingCell.setValue(null);
                }
                matchingCell = null;
                matchingCell = worksheet.getCells().find((Object)"{view_name}", matchingCell, findOptions);
                if (matchingCell != null) {
                    matchingCell.setValue((Object)reportViewName);
                }
                try {
                    worksheet.setName(reportViewName);
                }
                catch (CellsException e) {
                    this.addWarning(this.iu.getFormattedString("ProcessingReportOperation.Warning.CannotSetSheetName", new Object[]{reportViewName, e.getMessage()}));
                }
                ArrayList<Integer> chartHeights = new ArrayList<Integer>();
                ChartCollection worksheetCharts = worksheet.getCharts();
                for (int i = 0; i < worksheetCharts.getCount(); ++i) {
                    Chart chart = worksheetCharts.get(i);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Chart has height " + chart.getChartObject().getHeight());
                    }
                    chartHeights.add(chart.getChartObject().getHeight());
                }
                TwoDimensionReportStats reportStats = (TwoDimensionReportStats)this.reportsStats.get(reportViewName);
                String previousMainCategory = null;
                int previousMainCategoryStart = 2;
                List<String> verticalCategories = new ArrayList<String>(reportStats.stats.keySet());
                HashSet<String> verticalCategories1 = new HashSet<String>();
                for (String category : verticalCategories) {
                    if (reportView.verticalFieldType2 != ReportViewFieldType.NONE) {
                        String[] categorySplits = StringUtils.split((String)category, (String)"\u001f");
                        verticalCategories1.add(categorySplits[0]);
                        continue;
                    }
                    verticalCategories1.add(category);
                }
                List<String> normalizedVerticalCategories1 = this.normalizeCategories(reportView.verticalFieldType, reportView.verticalFieldComputedProperties, verticalCategories1);
                if (reportView.verticalFieldType2 != ReportViewFieldType.NONE) {
                    ArrayList<CallSite> normalizedVerticalCategories12 = new ArrayList<CallSite>();
                    for (String normalizedVerticalCategory1 : normalizedVerticalCategories1) {
                        HashSet<String> verticalCategories2 = new HashSet<String>();
                        for (String string : verticalCategories) {
                            String[] stringArray = StringUtils.split((String)string, (String)"\u001f");
                            if (!normalizedVerticalCategory1.equals(stringArray[0])) continue;
                            verticalCategories2.add(stringArray[1]);
                        }
                        List<String> normalizedVerticalCategories2 = this.normalizeCategories(reportView.verticalFieldType2, reportView.verticalFieldComputedProperties2, verticalCategories2);
                        for (String string : normalizedVerticalCategories2) {
                            normalizedVerticalCategories12.add((CallSite)((Object)(normalizedVerticalCategory1 + "\u001f" + string)));
                        }
                        if (normalizedVerticalCategories2.size() != 0) continue;
                        normalizedVerticalCategories12.add((CallSite)((Object)(normalizedVerticalCategory1 + "\u001f[n/a]")));
                    }
                    verticalCategories = normalizedVerticalCategories12;
                } else {
                    verticalCategories = normalizedVerticalCategories1;
                }
                HashSet<String> horizontalCategoriesSet = new HashSet<String>();
                for (String verticalCategory : verticalCategories) {
                    Map<String, ReportMeasure> reportLine = reportStats.stats.get(verticalCategory);
                    if (reportLine == null) continue;
                    horizontalCategoriesSet.addAll(reportLine.keySet());
                }
                List<String> horizontalCategories = this.normalizeCategories(reportView.horizontalFieldType, reportView.horizontalFieldComputedProperties, horizontalCategoriesSet);
                for (String verticalCategory : verticalCategories) {
                    reportStats.stats.putIfAbsent(verticalCategory, new HashMap());
                    Map<String, ReportMeasure> reportLine = reportStats.stats.get(verticalCategory);
                    for (String string : horizontalCategories) {
                        reportLine.putIfAbsent(string, new ReportMeasure());
                    }
                }
                Object verticalFieldSuffix = "";
                if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT || reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                    verticalFieldSuffix = " - " + this.iu.getString("ReportViewSummarizeBy.COUNT");
                } else if (reportView.summarizeBy == ReportViewSummarizeBy.SIZE) {
                    verticalFieldSuffix = " - " + this.iu.getString("ReportViewSummarizeBy.SIZE") + " (" + String.valueOf((Object)reportView.sizeUnit) + ")";
                }
                int columnId = 3;
                viewPersistence.setCat3Name(reportView.horizontalFieldType.toString());
                String evaluatedHorizontalFieldPropertiesName = this.executionContext.evalParameters(reportView.horizontalName, this);
                if (reportView.horizontalFieldType == ReportViewFieldType.TAG) {
                    viewPersistence.setCat3Name(evaluatedHorizontalFieldPropertiesName);
                }
                for (String string : horizontalCategories) {
                    worksheet.getCells().insertColumn(sc + ++columnId);
                    worksheet.getCells().copyColumn(worksheet.getCells(), sc + columnId - 1, sc + columnId);
                    worksheet.getCells().get(sr + 1, sc + columnId).setValue((Object)string.replace("\u001f", " - "));
                    worksheet.getCells().get(sr + 1, sc + columnId).setValue((Object)string.replace("\u001f", " - "));
                    worksheet.getCells().get(sr, sc + columnId).setValue((Object)(reportView.horizontalFieldType.toString() + (String)verticalFieldSuffix));
                    if (reportView.horizontalFieldType != ReportViewFieldType.TAG) continue;
                    worksheet.getCells().get(sr, sc + columnId).setValue((Object)(evaluatedHorizontalFieldPropertiesName + (String)verticalFieldSuffix));
                }
                if (reportView.summarizeBy == ReportViewSummarizeBy.SIZE || reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                    void var37_130;
                    boolean bl = false;
                    while (var37_130 < worksheetCharts.getCount()) {
                        Chart chart = worksheetCharts.get((int)var37_130);
                        Title title = chart.getTitle();
                        String text = title.getText().replace(" (GB)", " (" + String.valueOf((Object)reportView.sizeUnit) + ")").replace("__UNIT__", reportView.sizeUnit.toString());
                        title.setText(text);
                        ++var37_130;
                    }
                }
                if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                    verticalFieldSuffix = " - " + this.iu.getString("ReportViewSummarizeBy.SIZE") + " (" + String.valueOf((Object)reportView.sizeUnit) + ")";
                    ++columnId;
                    ++columnId;
                    ++columnId;
                    ++columnId;
                    ++columnId;
                    ++columnId;
                    ++columnId;
                    for (String string : horizontalCategories) {
                        worksheet.getCells().insertColumn(sc + ++columnId);
                        worksheet.getCells().copyColumn(worksheet.getCells(), sc + columnId - 1, sc + columnId);
                        worksheet.getCells().get(1, columnId).setValue((Object)string.replace("\u001f", " - "));
                        worksheet.getCells().get(sr, sc + columnId).setValue((Object)(reportView.horizontalFieldType.toString() + (String)verticalFieldSuffix));
                        if (reportView.horizontalFieldType != ReportViewFieldType.TAG) continue;
                        worksheet.getCells().get(sr, sc + columnId).setValue((Object)(evaluatedHorizontalFieldPropertiesName + (String)verticalFieldSuffix));
                    }
                }
                if (reportView.verticalFieldType2 != ReportViewFieldType.NONE) {
                    String string = this.executionContext.evalParameters(reportView.verticalName, this);
                    if (reportView.verticalFieldType == ReportViewFieldType.TAG) {
                        worksheet.getCells().get(sr + 1, sc).setValue((Object)string);
                        viewPersistence.setCat1Name(string);
                    } else {
                        worksheet.getCells().get(sr + 1, sc).setValue((Object)reportView.verticalFieldType.toString());
                        viewPersistence.setCat1Name(reportView.verticalFieldType.toString());
                    }
                    String string2 = this.executionContext.evalParameters(reportView.vertical2Name, this);
                    if (reportView.verticalFieldType2 == ReportViewFieldType.TAG) {
                        worksheet.getCells().get(sr + 1, sc + 1).setValue((Object)string2);
                        viewPersistence.setCat2Name(string2);
                    } else {
                        worksheet.getCells().get(sr + 1, sc + 1).setValue((Object)reportView.verticalFieldType2.toString());
                        viewPersistence.setCat2Name(reportView.verticalFieldType2.toString());
                    }
                } else {
                    worksheet.getCells().get(sr + 1, sc).setValue((Object)"N/A");
                    String string = this.executionContext.evalParameters(reportView.verticalName, this);
                    if (reportView.verticalFieldType == ReportViewFieldType.TAG) {
                        worksheet.getCells().get(sr + 1, sc + 1).setValue((Object)string);
                        viewPersistence.setCat1Name(string);
                    } else {
                        worksheet.getCells().get(sr + 1, sc + 1).setValue((Object)reportView.verticalFieldType.toString());
                        viewPersistence.setCat1Name(reportView.verticalFieldType.toString());
                    }
                }
                if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                    String string = this.executionContext.evalParameters(reportView.verticalName, this);
                    if (reportView.verticalFieldType2 != ReportViewFieldType.NONE) {
                        if (reportView.verticalFieldType == ReportViewFieldType.TAG) {
                            worksheet.getCells().get(sr + 1, sc + horizontalCategories.size() + 3 + 4).setValue((Object)string);
                        } else {
                            worksheet.getCells().get(sr + 1, sc + horizontalCategories.size() + 3 + 4).setValue((Object)reportView.verticalFieldType.toString());
                        }
                        String string3 = this.executionContext.evalParameters(reportView.vertical2Name, this);
                        if (reportView.verticalFieldType2 == ReportViewFieldType.TAG) {
                            worksheet.getCells().get(sr + 1, sc + 1 + horizontalCategories.size() + 3 + 4).setValue((Object)string3);
                        } else {
                            worksheet.getCells().get(sr + 1, sc + 1 + horizontalCategories.size() + 3 + 4).setValue((Object)reportView.verticalFieldType2.toString());
                        }
                    } else {
                        worksheet.getCells().get(sr + 1, sc + horizontalCategories.size() + 3 + 4).setValue((Object)"N/A");
                        if (reportView.verticalFieldType == ReportViewFieldType.TAG) {
                            worksheet.getCells().get(sr + 1, sc + 1 + horizontalCategories.size() + 3 + 4).setValue((Object)string);
                        } else {
                            worksheet.getCells().get(sr + 1, sc + 1 + horizontalCategories.size() + 3 + 4).setValue((Object)reportView.verticalFieldType.toString());
                        }
                    }
                }
                int rowId = 4;
                for (String string : verticalCategories) {
                    String persistanceCategory1 = null;
                    String persistanceCategory2 = null;
                    if (!reportStats.stats.containsKey(string) && reportView.verticalFieldType == ReportViewFieldType.PROCESSING_STAGE) {
                        reportStats.stats.put(string, new ConcurrentHashMap());
                    }
                    if (reportView.verticalFieldType2 != ReportViewFieldType.NONE && (reportView.verticalFieldType == ReportViewFieldType.EXCLUSION_AND_TYPE || reportView.verticalFieldType == ReportViewFieldType.IRREGULAR_AND_TYPE || reportView.verticalFieldType == ReportViewFieldType.EXCLUSION || reportView.verticalFieldType == ReportViewFieldType.IRREGULAR) && string.equals("[n/a]")) continue;
                    if (++rowId > 1) {
                        worksheet.getCells().insertRow(sr + rowId);
                    }
                    if (reportView.verticalFieldType2 != ReportViewFieldType.NONE) {
                        String[] categorySplits = StringUtils.split((String)string, (String)"\u001f");
                        if (categorySplits.length < 2) {
                            LOGGER.error("[" + string + "] only has " + categorySplits.length + " splits");
                        }
                        if (!categorySplits[0].equals(previousMainCategory)) {
                            worksheet.getCells().copyRow(worksheet.getCells(), sr + 2, sr + rowId);
                            worksheet.getCells().merge(sr + previousMainCategoryStart, sc, rowId - previousMainCategoryStart, 1);
                            if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                                worksheet.getCells().merge(sr + previousMainCategoryStart, sc + horizontalCategories.size() + 3 + 4, rowId - previousMainCategoryStart, 1);
                            }
                            previousMainCategoryStart = rowId;
                        } else {
                            worksheet.getCells().copyRow(worksheet.getCells(), sr + 3, sr + rowId);
                        }
                        previousMainCategory = categorySplits[0];
                        worksheet.getCells().get(sr + rowId, sc).setValue((Object)categorySplits[0]);
                        worksheet.getCells().get(sr + rowId, sc + 1).setValue((Object)categorySplits[1]);
                        persistanceCategory1 = categorySplits[0];
                        persistanceCategory2 = categorySplits[1];
                        if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                            worksheet.getCells().get(sr + rowId, sc + horizontalCategories.size() + 3 + 4).setValue((Object)categorySplits[0]);
                            worksheet.getCells().get(sr + rowId, sc + 1 + horizontalCategories.size() + 3 + 4).setValue((Object)categorySplits[1]);
                        }
                    } else {
                        worksheet.getCells().copyRow(worksheet.getCells(), sr + 3, sr + rowId);
                        worksheet.getCells().get(sr + rowId, sc).setValue((Object)"N/A");
                        worksheet.getCells().get(sr + rowId, sc + 1).setValue((Object)string);
                        persistanceCategory1 = string;
                        if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                            worksheet.getCells().get(sr + rowId, sc + horizontalCategories.size() + 3 + 4).setValue((Object)"N/A");
                            worksheet.getCells().get(sr + rowId, sc + 1 + horizontalCategories.size() + 3 + 4).setValue((Object)string);
                        }
                    }
                    SizeMethod sizeMethod = null;
                    columnId = 3;
                    for (String horizontalCategory : horizontalCategories) {
                        ProcessingReportLinePersistence linePersistance = new ProcessingReportLinePersistence();
                        linePersistance.setCat1(persistanceCategory1);
                        linePersistance.setCat2(persistanceCategory2);
                        linePersistance.setCat3(horizontalCategory);
                        viewPersistence.getLines().add(linePersistance);
                        ++columnId;
                        if (reportView.summarizeBy == ReportViewSummarizeBy.SIZE || reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                            if (reportView.processingStage != null) {
                                for (Object[] processingStageDetails : this.processingStages) {
                                    String processingStageName = processingStageDetails[0].toString();
                                    if (!reportView.processingStage.equals(processingStageName)) continue;
                                    sizeMethod = (SizeMethod)((Object)processingStageDetails[2]);
                                    break;
                                }
                            } else {
                                for (Object[] processingStageDetails : this.processingStages) {
                                    String processingStageName = processingStageDetails[0].toString();
                                    if (reportView.verticalFieldType == ReportViewFieldType.PROCESSING_STAGE) {
                                        if (!string.equals(processingStageName)) continue;
                                        sizeMethod = (SizeMethod)((Object)processingStageDetails[2]);
                                    } else {
                                        if (reportView.horizontalFieldType != ReportViewFieldType.PROCESSING_STAGE || !horizontalCategory.equals(processingStageName)) continue;
                                        sizeMethod = (SizeMethod)((Object)processingStageDetails[2]);
                                    }
                                    break;
                                }
                            }
                        }
                        long count = 0L;
                        double size = 0.0;
                        Map<String, ReportMeasure> reportLine = reportStats.stats.get(string);
                        if (reportLine.containsKey(horizontalCategory)) {
                            ReportMeasure reportMeasure = reportLine.get(horizontalCategory);
                            linePersistance.setFileSize(reportMeasure.fileSize.get());
                            linePersistance.setAuditedSize(reportMeasure.auditedSize.get());
                            linePersistance.setCount(reportMeasure.count.get());
                            linePersistance.setTextSize(reportMeasure.textSize.get());
                            linePersistance.setDigestSize(reportMeasure.digestSize.get());
                            count = reportMeasure.count.get();
                            if (sizeMethod != null) {
                                size = this.getSizeFromReportMeasure(reportMeasure, sizeMethod, reportView.sizeUnit);
                            }
                        }
                        if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT) {
                            worksheet.getCells().get(sr + rowId, sc + columnId).setValue((Object)count);
                            continue;
                        }
                        if (reportView.summarizeBy == ReportViewSummarizeBy.SIZE) {
                            worksheet.getCells().get(sr + rowId, sc + columnId).setValue((Object)size);
                            continue;
                        }
                        if (reportView.summarizeBy != ReportViewSummarizeBy.COUNT_AND_SIZE) continue;
                        worksheet.getCells().get(sr + rowId, sc + columnId).setValue((Object)count);
                        worksheet.getCells().get(sr + rowId, sc + columnId + horizontalCategories.size() + 3 + 4).setValue((Object)size);
                    }
                    if (reportView.horizontalFieldType == ReportViewFieldType.PROCESSING_STAGE) continue;
                    long count = 0L;
                    double size = 0.0;
                    ++columnId;
                    ++columnId;
                    ReportMeasure reportMeasure = reportStats.verticalTotals.get(string);
                    if (reportMeasure != null) {
                        count = reportMeasure.count.get();
                        if (sizeMethod != null) {
                            size = this.getSizeFromReportMeasure(reportMeasure, sizeMethod, reportView.sizeUnit);
                        }
                    }
                    if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT) {
                        worksheet.getCells().get(sr + rowId, sc + columnId).setValue((Object)count);
                        continue;
                    }
                    if (reportView.summarizeBy == ReportViewSummarizeBy.SIZE) {
                        worksheet.getCells().get(sr + rowId, sc + columnId).setValue((Object)size);
                        continue;
                    }
                    if (reportView.summarizeBy != ReportViewSummarizeBy.COUNT_AND_SIZE) continue;
                    worksheet.getCells().get(sr + rowId, sc + columnId).setValue((Object)count);
                    worksheet.getCells().get(sr + rowId, sc + columnId + horizontalCategories.size() + 3 + 4).setValue((Object)size);
                }
                worksheet.getCells().deleteRow(sr + rowId + 1);
                if (reportView.verticalFieldType2 != ReportViewFieldType.NONE && (n = rowId - previousMainCategoryStart + 1) > 1) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Merging cells from " + previousMainCategoryStart + " count " + n);
                    }
                    worksheet.getCells().merge(sr + previousMainCategoryStart, sc, n, 1);
                    if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Merging cells from " + previousMainCategoryStart + " count " + n);
                        }
                        worksheet.getCells().merge(sr + previousMainCategoryStart, sc + horizontalCategories.size() + 3 + 4, n, 1);
                    }
                }
                ++rowId;
                Object var37_139 = null;
                columnId = 3;
                for (String horizontalCategory : horizontalCategories) {
                    ++columnId;
                    if (reportView.summarizeBy == ReportViewSummarizeBy.SIZE || reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                        if (reportView.processingStage != null) {
                            for (Object[] processingStageDetails : this.processingStages) {
                                String processingStageName = processingStageDetails[0].toString();
                                if (!reportView.processingStage.equals(processingStageName)) continue;
                                SizeMethod sizeMethod = (SizeMethod)((Object)processingStageDetails[2]);
                                break;
                            }
                        } else {
                            for (Object[] processingStageDetails : this.processingStages) {
                                String processingStageName = processingStageDetails[0].toString();
                                if (reportView.horizontalFieldType != ReportViewFieldType.PROCESSING_STAGE || !horizontalCategory.equals(processingStageName)) continue;
                                SizeMethod sizeMethod = (SizeMethod)((Object)processingStageDetails[2]);
                                break;
                            }
                        }
                    }
                    long count = 0L;
                    double size = 0.0;
                    ReportMeasure reportMeasure = reportStats.horizontalTotals.get(horizontalCategory);
                    if (reportMeasure != null) {
                        count = reportMeasure.count.get();
                        if (var37_140 != null) {
                            size = this.getSizeFromReportMeasure(reportMeasure, (SizeMethod)var37_140, reportView.sizeUnit);
                        }
                    }
                    if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT) {
                        worksheet.getCells().get(sr + rowId, sc + columnId).setValue((Object)count);
                        continue;
                    }
                    if (reportView.summarizeBy == ReportViewSummarizeBy.SIZE) {
                        worksheet.getCells().get(sr + rowId, sc + columnId).setValue((Object)size);
                        continue;
                    }
                    if (reportView.summarizeBy != ReportViewSummarizeBy.COUNT_AND_SIZE) continue;
                    worksheet.getCells().get(sr + rowId, sc + columnId).setValue((Object)count);
                    worksheet.getCells().get(sr + rowId, sc + columnId + horizontalCategories.size() + 3 + 4).setValue((Object)size);
                }
                ++columnId;
                ++columnId;
                ReportMeasure reportMeasure = reportStats.totals;
                long count = reportMeasure.count.get();
                double size = 0.0;
                if (var37_140 != null) {
                    size = this.getSizeFromReportMeasure(reportMeasure, (SizeMethod)var37_140, reportView.sizeUnit);
                }
                if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT) {
                    worksheet.getCells().get(sr + rowId, sc + columnId).setValue((Object)count);
                } else if (reportView.summarizeBy == ReportViewSummarizeBy.SIZE) {
                    worksheet.getCells().get(sr + rowId, sc + columnId).setValue((Object)size);
                } else if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                    worksheet.getCells().get(sr + rowId, sc + columnId).setValue((Object)count);
                    worksheet.getCells().get(sr + rowId, sc + columnId + horizontalCategories.size() + 3 + 4).setValue((Object)size);
                }
                ConditionalFormattingCollection conditionalFormattings = worksheet.getConditionalFormattings();
                for (int formattingId = 0; formattingId < conditionalFormattings.getCount(); ++formattingId) {
                    FormatConditionCollection formatConditions = conditionalFormattings.get(formattingId);
                    for (int formatRangeId = 0; formatRangeId < formatConditions.getRangeCount(); ++formatRangeId) {
                        CellArea cellArea = formatConditions.getCellArea(formatRangeId);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Original Format range " + formatRangeId + ": " + cellArea.StartColumn + "," + cellArea.StartRow + " -> " + cellArea.EndColumn + "," + cellArea.EndRow);
                        }
                        if (cellArea.StartColumn <= 2 && cellArea.StartRow <= 3 && cellArea.EndColumn >= 2 && cellArea.EndRow >= 3) {
                            cellArea.EndColumn = 5 + horizontalCategories.size();
                            cellArea.EndRow = 5 + verticalCategories.size();
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Updated Format range " + formatRangeId + ": " + cellArea.StartColumn + "," + cellArea.StartRow + " -> " + cellArea.EndColumn + "," + cellArea.EndRow);
                            }
                        }
                        if (cellArea.StartColumn > 2 + horizontalCategories.size() + 3 + 4 || cellArea.StartRow > 3 || cellArea.EndColumn < 2 + horizontalCategories.size() + 3 + 4 || cellArea.EndRow < 3) continue;
                        cellArea.EndColumn = 5 + horizontalCategories.size() + horizontalCategories.size() + 3 + 4;
                        cellArea.EndRow = 5 + verticalCategories.size();
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("Updated Format range " + formatRangeId + ": " + cellArea.StartColumn + "," + cellArea.StartRow + " -> " + cellArea.EndColumn + "," + cellArea.EndRow);
                    }
                }
                worksheet.getCells().merge(sr, sc, 2, 1);
                worksheet.getCells().merge(sr, sc + 1, 2, 1);
                if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                    worksheet.getCells().merge(sr, sc + horizontalCategories.size() + 3 + 4, 2, 1);
                    worksheet.getCells().merge(sr, sc + 1 + horizontalCategories.size() + 3 + 4, 2, 1);
                }
                if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                    worksheet.getCells().deleteColumn(sc + 2 + horizontalCategories.size() + 3 + 4);
                    worksheet.getCells().deleteColumn(sc + 2 + horizontalCategories.size() + 3 + 4);
                    worksheet.getCells().deleteColumn(sc + 2 + horizontalCategories.size() + 3 + 4 + horizontalCategories.size());
                }
                worksheet.getCells().deleteColumn(sc + 2);
                worksheet.getCells().deleteColumn(sc + 2);
                worksheet.getCells().deleteColumn(sc + 2 + horizontalCategories.size());
                worksheet.getCells().merge(sr, sc + 2, 1, horizontalCategories.size() + 1);
                if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                    worksheet.getCells().merge(sr, sc + 2 + horizontalCategories.size() + 4, 1, horizontalCategories.size() + 1);
                }
                AutoFitterOptions autoFitterOptions = new AutoFitterOptions();
                autoFitterOptions.setAutoFitMergedCells(true);
                autoFitterOptions.setOnlyAuto(true);
                worksheet.autoFitColumns(sc, sc + 3 + horizontalCategories.size(), autoFitterOptions);
                if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                    worksheet.autoFitColumns(sc + 3 + horizontalCategories.size() + 1, sc + 3 + horizontalCategories.size() + 1 + 3 + horizontalCategories.size(), autoFitterOptions);
                }
                int deletedTotals = 0;
                if (reportView.horizontalFieldType == ReportViewFieldType.PROCESSING_STAGE) {
                    worksheet.getCells().deleteColumn(sc + 2 + horizontalCategories.size());
                    ++deletedTotals;
                    if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                        worksheet.getCells().deleteColumn(sc + 2 + horizontalCategories.size() + 3 + horizontalCategories.size());
                    }
                }
                if (reportView.verticalFieldType == ReportViewFieldType.PROCESSING_STAGE) {
                    worksheet.getCells().deleteRow(sr + rowId);
                }
                if (reportView.verticalFieldType2 == ReportViewFieldType.NONE) {
                    worksheet.getCells().deleteColumn(sc);
                    if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                        worksheet.getCells().deleteColumn(sc + horizontalCategories.size() + 3 - deletedTotals);
                    }
                }
                worksheet.getCells().deleteRow(sr + 2);
                worksheet.getCells().deleteRow(sr + 2);
                worksheet.getCells().deleteRow(sr + 2);
            }
            this.stageProcessedItems.incrementAndGet();
        }
        for (TemplateWorksheetName templateWorksheetName : TemplateWorksheetName.values()) {
            try {
                workbook.getWorksheets().removeAt(templateWorksheetName.toString());
            }
            catch (Exception e) {
                LOGGER.error("Cannot remove sheet " + String.valueOf((Object)templateWorksheetName));
            }
        }
        HashSet<String> worksheetNames = new HashSet<String>();
        for (int i = 0; i < workbook.getWorksheets().getCount(); ++i) {
            Worksheet worksheet = workbook.getWorksheets().get(i);
            worksheetNames.add(worksheet.getName());
        }
        Pattern p = Pattern.compile("^__[A-Z0-9_]+__$");
        for (String worksheetName : worksheetNames) {
            Matcher m = p.matcher(worksheetName);
            if (!m.matches()) continue;
            try {
                workbook.getWorksheets().removeAt(worksheetName.toString());
            }
            catch (Exception e) {
                LOGGER.error("Cannot remove sheet " + worksheetName);
            }
        }
        for (Object[] reportViewDetails : this.reportViews) {
            ReportView reportView = (ReportView)reportViewDetails[1];
            try {
                workbook.getWorksheets().removeAt(reportView.templateWorksheetName);
            }
            catch (Exception e) {
                LOGGER.error("Cannot remove sheet " + reportView.templateWorksheetName);
            }
        }
        this.executionContext.getExecutionCustomParameters().remove("{case_name}");
        this.executionContext.getExecutionCustomParameters().remove("{case_folder}");
        workbook.getBuiltInDocumentProperties().setAuthor("Automate Workflow");
        if (this.reportLocation == null) {
            this.reportLocation = "{case_folder}/Reports/{case_name} - Processing Report {date_time}.xlsx";
        }
        try {
            this.reportLocation = this.executionContext.evalParameters(this.reportLocation, this);
            reportFile = new File(this.reportLocation);
            this.reportLocation = reportFile.getAbsolutePath();
            File reportFolder = reportFile.getParentFile();
            if (!reportFolder.exists()) {
                reportFolder.mkdirs();
            }
            LOGGER.info("Saving report to " + reportFile.getAbsolutePath());
            if (reportFile.getAbsolutePath().toLowerCase().endsWith(".pdf")) {
                PdfSaveOptions saveOptions = new PdfSaveOptions();
                saveOptions.setAllColumnsInOnePagePerSheet(true);
                workbook.save(reportFile.getAbsolutePath(), (SaveOptions)saveOptions);
            } else {
                String reportPasswordParameter = "{report_password}";
                String reportPassword = this.executionContext.evalProtectedParameter(reportPasswordParameter);
                if (!reportPassword.equals(reportPasswordParameter)) {
                    this.addExecutionLog(this.iu.getString("ProcessingReportOperation.Log.SettingPassword"));
                    if (reportPassword.length() == 0) {
                        this.addWarning(this.iu.getString("ProcessingReportOperation.Log.BlankPassword"));
                    }
                    workbook.setEncryptionOptions(3, 128);
                    workbook.getSettings().setPassword(reportPassword);
                }
                workbook.save(reportFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            String reportPasswordParameter;
            String reportPassword;
            LOGGER.error("Cannot create report folder", (Throwable)e);
            this.addWarning(e.getLocalizedMessage());
            this.reportLocation = "{case_folder}/Reports/{case_name} - Processing Report {date_time}.xlsx";
            this.reportLocation = this.executionContext.evalParameters(this.reportLocation, this);
            reportFile = new File(this.reportLocation);
            this.reportLocation = reportFile.getAbsolutePath();
            File reportFolder = reportFile.getParentFile();
            if (!reportFolder.exists()) {
                reportFolder.mkdirs();
            }
            if (!(reportPassword = this.executionContext.evalParameters(reportPasswordParameter = "{report_password}", this)).equals(reportPasswordParameter)) {
                this.addExecutionLog(this.iu.getString("ProcessingReportOperation.Log.SettingPassword"));
                if (reportPassword.length() == 0) {
                    this.addWarning(this.iu.getString("ProcessingReportOperation.Log.BlankPassword"));
                }
                workbook.setEncryptionOptions(3, 128);
                workbook.getSettings().setPassword(reportPassword);
            }
            LOGGER.info("Saving report to " + reportFile.getAbsolutePath());
            workbook.save(reportFile.getAbsolutePath());
        }
        try {
            String jsonLocation = this.executionContext.evalParameters("{case_folder}/Stores/Reports/ProcessingReport_{date_time}.json", this);
            File jsonFile = new File(jsonLocation);
            File reportDirectory = jsonFile.getParentFile();
            if (!reportDirectory.exists()) {
                reportDirectory.mkdirs();
            }
            Path path = Paths.get(jsonLocation, new String[0]);
            String serialization = SerializationUtils.toJson((Object)this.reportPersistence);
            FileUtils.writeToFile((String)serialization, (Path)path);
        }
        catch (Throwable t) {
            LOGGER.error("Cannot write Report Persistence", t);
            this.addExecutionLog(this.iu.getString("ProcessingReportOperation.Log.SkippingReportPersistence"));
        }
        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_report_file}", reportFile.getAbsolutePath())));
        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_export_folder}", reportFile.getParentFile().getAbsolutePath())));
    }

    private double getSizeFromReportMeasure(ReportMeasure reportMeasure, SizeMethod sizeMethod, SizeUnit sizeUnit) throws IllegalArgumentException {
        switch (sizeMethod) {
            case FILE_SISE: {
                return reportMeasure.fileSize.doubleValue() / sizeUnit.getValue();
            }
            case AUDITED_SIZE: {
                return reportMeasure.auditedSize.doubleValue() / sizeUnit.getValue();
            }
            case AUDITED_TEXT_SIZE: {
                return (reportMeasure.auditedSize.doubleValue() + reportMeasure.textSize.doubleValue()) / sizeUnit.getValue();
            }
            case AUDITED_ATTACHMENTS_2X: {
                return (reportMeasure.auditedSize.doubleValue() + reportMeasure.attachmentsAuditedSize.doubleValue()) / sizeUnit.getValue();
            }
            case AUDITED_ATTACHMENTS_2X_TEXT_SIZE: {
                return (reportMeasure.auditedSize.doubleValue() + reportMeasure.attachmentsAuditedSize.doubleValue() + reportMeasure.textSize.doubleValue()) / sizeUnit.getValue();
            }
            case TEXT_SIZE: {
                return reportMeasure.textSize.doubleValue() / sizeUnit.getValue();
            }
            case DIGEST_SIZE: {
                return reportMeasure.digestSize.doubleValue() / sizeUnit.getValue();
            }
        }
        throw new IllegalArgumentException(this.iu.getFormattedString("ProcessingReportOperation.Exception.UnsupportedSizeMethod", (Object)sizeMethod));
    }

    private List<String> normalizeCategories(ReportViewFieldType reportViewFieldType, Map<ReportViewProperty, Object> fieldDatesProperties, Set<String> originalCategories) throws IOException {
        return this.normalizeCategories(reportViewFieldType, fieldDatesProperties, originalCategories, null, null);
    }

    private List<String> normalizeCategories(ReportViewFieldType reportViewFieldType, Map<ReportViewProperty, Object> fieldDatesProperties, Set<String> originalCategories, ReportViewFieldType reportViewFieldType1, String verticalCategory1) throws IOException {
        HashSet<Object> categories = new HashSet<Object>();
        categories.addAll(originalCategories);
        if (reportViewFieldType == ReportViewFieldType.TOP_LEVEL_YEAR) {
            int startYear = (Integer)fieldDatesProperties.get((Object)ReportViewProperty.START_YEAR);
            int endYear = (Integer)fieldDatesProperties.get((Object)ReportViewProperty.END_YEAR);
            ExcludeDates excludeDates = (ExcludeDates)((Object)fieldDatesProperties.get((Object)ReportViewProperty.EXCLUDE));
            int effectiveEndYear = endYear;
            if (excludeDates == ExcludeDates.EDGE_DATES_WITH_NO_VALUES) {
                int effectiveStartYear;
                for (effectiveStartYear = startYear; effectiveStartYear != effectiveEndYear && !categories.contains(String.valueOf(effectiveStartYear)); ++effectiveStartYear) {
                }
                while (effectiveStartYear != effectiveEndYear && !categories.contains(String.valueOf(effectiveEndYear))) {
                    --effectiveEndYear;
                }
            }
            if (excludeDates != ExcludeDates.ANY_DATE_WITH_NO_VALUES) {
                for (int year = effectiveStartYear; year <= effectiveEndYear; ++year) {
                    if (categories.contains(String.valueOf(year))) continue;
                    categories.add(String.valueOf(year));
                }
            }
        } else if (reportViewFieldType == ReportViewFieldType.TOP_LEVEL_YEAR_MONTH || reportViewFieldType == ReportViewFieldType.TOP_LEVEL_YEAR_AND_MONTH) {
            int startYear = (Integer)fieldDatesProperties.get((Object)ReportViewProperty.START_YEAR);
            int endYear = (Integer)fieldDatesProperties.get((Object)ReportViewProperty.END_YEAR);
            int startMonth = (Integer)fieldDatesProperties.get((Object)ReportViewProperty.START_MONTH);
            int endMonth = (Integer)fieldDatesProperties.get((Object)ReportViewProperty.END_MONTH);
            ExcludeDates excludeDates = (ExcludeDates)((Object)fieldDatesProperties.get((Object)ReportViewProperty.EXCLUDE));
            int olderThanYear = startYear;
            int olderThanMonth = startMonth - 1;
            if (olderThanMonth == 0) {
                olderThanMonth += 12;
                --olderThanYear;
            }
            int newerThanYear = endYear;
            int newerThanMonth = endMonth + 1;
            if (newerThanMonth == 13) {
                newerThanMonth -= 12;
                ++newerThanYear;
            }
            int effectiveStartYear = startYear;
            int effectiveStartMonth = startMonth;
            int effectiveEndYear = endYear;
            int effectiveEndMonth = endMonth;
            if (excludeDates == ExcludeDates.EDGE_DATES_WITH_NO_VALUES) {
                String key;
                while (effectiveStartYear != effectiveEndYear || effectiveStartMonth != effectiveEndMonth) {
                    key = null;
                    if (reportViewFieldType == ReportViewFieldType.TOP_LEVEL_YEAR_MONTH) {
                        key = effectiveStartYear + "-" + String.format("%02d", effectiveStartMonth);
                    } else if (reportViewFieldType == ReportViewFieldType.TOP_LEVEL_YEAR_AND_MONTH) {
                        key = effectiveStartYear + "\u001f" + String.format("%02d", effectiveStartMonth);
                    }
                    if (categories.contains(key)) break;
                    if (++effectiveStartMonth != 13) continue;
                    effectiveStartMonth = 1;
                    ++effectiveStartYear;
                }
                while (effectiveStartYear != effectiveEndYear || effectiveStartMonth != effectiveEndMonth) {
                    key = null;
                    if (reportViewFieldType == ReportViewFieldType.TOP_LEVEL_YEAR_MONTH) {
                        key = effectiveEndYear + "-" + String.format("%02d", effectiveEndMonth);
                    } else if (reportViewFieldType == ReportViewFieldType.TOP_LEVEL_YEAR_AND_MONTH) {
                        key = effectiveEndYear + "\u001f" + String.format("%02d", effectiveEndMonth);
                    }
                    if (categories.contains(key)) break;
                    if (--effectiveEndMonth != 0) continue;
                    effectiveEndMonth = 12;
                    --effectiveEndYear;
                }
            }
            int currentYear = effectiveStartYear;
            int currentMonth = effectiveStartMonth;
            if (excludeDates != ExcludeDates.ANY_DATE_WITH_NO_VALUES) {
                while (currentYear * 12 + currentMonth <= effectiveEndYear * 12 + effectiveEndMonth) {
                    if (reportViewFieldType == ReportViewFieldType.TOP_LEVEL_YEAR_MONTH) {
                        categories.add(currentYear + "-" + String.format("%02d", currentMonth));
                    } else if (reportViewFieldType == ReportViewFieldType.TOP_LEVEL_YEAR_AND_MONTH) {
                        categories.add(currentYear + "\u001f" + String.format("%02d", currentMonth));
                    }
                    if (++currentMonth != 13) continue;
                    currentMonth = 1;
                    ++currentYear;
                }
            }
        } else if (reportViewFieldType == ReportViewFieldType.CASE_NAME) {
            for (Case currentCase : this.cases) {
                categories.add(currentCase.getName());
            }
        } else if (reportViewFieldType == ReportViewFieldType.CASE_NAME_EVIDENCE_CONTAINER) {
            for (Case currentCase : this.cases) {
                Set evidenceContainers = currentCase.searchUnsorted("mime-type:application/vnd.nuix-evidence");
                for (Item evidenceContainer : evidenceContainers) {
                    categories.add(currentCase.getName() + "\u001f" + evidenceContainer.getName());
                }
            }
        } else if (reportViewFieldType == ReportViewFieldType.EVIDENCE_CONTAINER_CUSTODIAN) {
            for (Case currentCase : this.cases) {
                Set evidenceContainers = currentCase.searchUnsorted("mime-type:application/vnd.nuix-evidence");
                for (Item evidenceContainer : evidenceContainers) {
                    for (String custodian : currentCase.getAllCustodians()) {
                        categories.add(evidenceContainer.getName() + "\u001f" + custodian);
                    }
                }
            }
        } else if (reportViewFieldType == ReportViewFieldType.TAG) {
            String tagName = fieldDatesProperties.get((Object)ReportViewProperty.TAG_NAME).toString();
            while (tagName.endsWith("|")) {
                tagName = tagName.substring(0, tagName.length() - 1);
            }
            HashSet caseTagsWithDelimiter = new HashSet();
            for (String caseTag : this.executionContext.nuixCase.getAllTags()) {
                String caseTagWithDelimiter = caseTag + "|";
                if (!caseTag.startsWith(tagName + "|")) continue;
                categories.add(caseTag.substring(tagName.length() + 1));
            }
        } else if (reportViewFieldType == ReportViewFieldType.IMAGE_HEIGHT || reportViewFieldType == ReportViewFieldType.IMAGE_WIDTH) {
            int upperBound;
            categories.add("[n/a]");
            int lowerBound = 0;
            for (upperBound = lowerBound + 100 - 1; upperBound < 1000; upperBound += 100) {
                categories.add(lowerBound + " - " + upperBound);
                lowerBound += 100;
            }
            lowerBound = 1000;
            for (upperBound = 1999; upperBound < 5000; upperBound += 1000) {
                categories.add(lowerBound + " - " + upperBound);
                lowerBound += 1000;
            }
            categories.add("> 5000");
        }
        ArrayList<String> resultingCategories = new ArrayList<String>();
        resultingCategories.addAll(categories);
        Collections.sort(resultingCategories, String.CASE_INSENSITIVE_ORDER);
        ArrayList<String> itemSetNames = new ArrayList<String>();
        if (reportViewFieldType == ReportViewFieldType.TOP_LEVEL_YEAR || reportViewFieldType == ReportViewFieldType.TOP_LEVEL_YEAR_MONTH || reportViewFieldType == ReportViewFieldType.TOP_LEVEL_YEAR_AND_MONTH) {
            boolean olderPresent = resultingCategories.remove("[older]");
            boolean newerPresent = resultingCategories.remove("[newer]");
            boolean naPresent = resultingCategories.remove("[n/a]");
            if (olderPresent) {
                resultingCategories.add(0, "[older]");
            }
            if (newerPresent) {
                resultingCategories.add("[newer]");
            }
            if (naPresent) {
                resultingCategories.add("[n/a]");
            }
        }
        if (reportViewFieldType == ReportViewFieldType.ITEMSET_ORIGINALS_DUPLICATES || reportViewFieldType == ReportViewFieldType.ITEMSET_ORIGINALS_AND_DUPLICATES) {
            for (ItemSet itemSet : this.executionContext.nuixCase.getAllItemSets()) {
                itemSetNames.add(itemSet.getName());
            }
            Collections.sort(itemSetNames, String.CASE_INSENSITIVE_ORDER);
        }
        if (reportViewFieldType == ReportViewFieldType.ITEMSET_ORIGINALS_DUPLICATES) {
            if (reportViewFieldType1 == null || reportViewFieldType1 != ReportViewFieldType.ITEMSET) {
                resultingCategories.clear();
                resultingCategories.add("[n/a]");
                for (String itemSetName : itemSetNames) {
                    resultingCategories.add(itemSetName + " (Originals)");
                    resultingCategories.add(itemSetName + " (Duplicates)");
                }
            } else {
                resultingCategories.clear();
                if (!verticalCategory1.equals("[n/a]")) {
                    resultingCategories.add(verticalCategory1 + " (Originals)");
                    resultingCategories.add(verticalCategory1 + " (Duplicates)");
                } else {
                    resultingCategories.add("[n/a]");
                }
            }
        }
        if (reportViewFieldType == ReportViewFieldType.ITEMSET_ORIGINALS_AND_DUPLICATES) {
            resultingCategories.clear();
            resultingCategories.add("[n/a]\u001f[n/a]");
            for (String itemSetName : itemSetNames) {
                resultingCategories.add(itemSetName + "\u001fOriginals");
                resultingCategories.add(itemSetName + "\u001fDuplicates");
            }
        }
        if (reportViewFieldType == ReportViewFieldType.PROCESSING_STAGE) {
            resultingCategories.clear();
            for (Object[] processingStageDetails : this.processingStages) {
                String processingStageName = processingStageDetails[0].toString();
                if (this.processingStageNamesExcludedFromOverview.contains(processingStageName)) continue;
                resultingCategories.add(processingStageName);
            }
        }
        if (reportViewFieldType == ReportViewFieldType.IMAGE_HEIGHT || reportViewFieldType == ReportViewFieldType.IMAGE_WIDTH) {
            int upperBound;
            resultingCategories.clear();
            resultingCategories.add("[n/a]");
            int lowerBound = 0;
            for (upperBound = lowerBound + 100 - 1; upperBound < 1000; upperBound += 100) {
                resultingCategories.add(lowerBound + " - " + upperBound);
                lowerBound += 100;
            }
            lowerBound = 1000;
            for (upperBound = 1999; upperBound < 5000; upperBound += 1000) {
                resultingCategories.add(lowerBound + " - " + upperBound);
                lowerBound += 1000;
            }
            resultingCategories.add("> 5000");
        }
        return resultingCategories;
    }

    @Override
    public void stopTriggered() {
        this.stopRequested = true;
    }

    @Override
    protected double getPercentageComplete() {
        double stagePercentageComplete = 0.0;
        if (this.stageTotalItems > 0L) {
            stagePercentageComplete = (this.stageProcessedItems.doubleValue() + this.reportViewProgress) / (double)this.stageTotalItems;
        }
        double percentageComplete = 0.0;
        if (this.stageCount > 0) {
            percentageComplete = ((double)this.stageId + stagePercentageComplete) / (double)this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        if (this.stageId != 0 && this.stageId != this.stageCount - 1 && this.stageProcessedItems != null && this.stageProcessedItems.get() > 0L) {
            result = (String)result + this.iu.getNumeralString("ProcessingReportOperation.Progress.ItemsProcessed", this.stageProcessedItems.get());
        }
        return result;
    }
}

