/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.utils.utilization.consumption.ConsumptionEvent;
import com.nuix.automate.utils.utilization.consumption.ConsumptionPlatformType;
import com.nuix.automate.utils.utilization.consumption.ConsumptionSubType;
import com.nuix.automate.utils.utilization.consumption.ConsumptionType;
import com.nuix.automate.utils.utilization.consumption.ResourceSubType;
import com.nuix.automate.utils.utilization.consumption.ResourceType;
import com.nuix.automate.utils.utilization.consumption.UnitType;
import com.nuix.automate.workflow.core.execution.operations.NuixQueryMimeTypeVolumesUtilizationOperation;
import com.nuix.automate.workflow.core.execution.options.configuration.KeystoreFile;
import com.nuix.automate.workflow.core.licence.NuixLicenceFactory;
import com.nuix.automate.workflow.core.utils.general.ConfigurationParser;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.filetype.MimeType;
import com.nuix.filetype.MimeTypeKind;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import nuix.LoadProcessingJob;
import nuix.Processor;
import nuix.profile.ProcessingProfile;
import nuix.profile.ProcessingProfileBuilder;
import org.joda.time.DateTimeZone;

public abstract class ProcessorMimeTypeVolumesUtilizationOperation
extends NuixQueryMimeTypeVolumesUtilizationOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ProcessorMimeTypeVolumesUtilizationOperation.class);
    public String timeZoneId = null;
    protected transient LoadProcessingJob loadProcessingJob;
    protected transient Processor processor;
    protected transient ProcessingProfileBuilder builder = null;
    protected transient Map<String, Object> builderProcessingSettings = new HashMap<String, Object>();
    protected transient int localWorkersCount;
    public Locale dataLocale;
    private transient boolean remoteWorkersPermanentError = false;
    private transient int remoteWorkersAddedCount = 0;
    private boolean applySemanticSettingsLogged;

    protected ConsumptionType getConsumptionType() {
        return ConsumptionType.DATA_LOADED;
    }

    protected abstract ConsumptionSubType getConsumptionSubType();

    protected void applySemanticSettings(Map<String, Object> properties) {
        if (this.executionContext.nuixVersion.compareTo(new Version("100.11.0")) >= 0) {
            try {
                String semanticServiceUrl = this.executionContext.evalParametersIfSet("{wfn_semantic_service_url}", this);
                String semanticServiceName = this.executionContext.evalParametersIfSet("{wfn_semantic_service_name}", this);
                String textEmbeddingsModel = this.executionContext.evalParametersIfSet("{wfn_semantic_text_model}", this);
                String imageEmbeddingsModel = this.executionContext.evalParametersIfSet("{wfn_semantic_image_model}", this);
                Boolean detectFaces = this.executionContext.evalBooleanParameter("{wfn_semantic_detect_faces}", this);
                String transcriptionModel = this.executionContext.evalParametersIfSet("{wfn_semantic_transcription_model}", this);
                if (semanticServiceUrl.isEmpty()) {
                    if (!this.applySemanticSettingsLogged) {
                        this.addExecutionLog(this.iu.getString("SemanticSearchConfigureOperation.Log.EmbeddedService"));
                    }
                } else {
                    if (!this.applySemanticSettingsLogged) {
                        this.addExecutionLog(this.iu.getFormattedString("SemanticSearchConfigureOperation.Log.SemanticService", (Object)semanticServiceName));
                    }
                    System.setProperty("nuix.storage.djlServingUrl", semanticServiceUrl);
                }
                if (textEmbeddingsModel.isEmpty()) {
                    if (!this.applySemanticSettingsLogged) {
                        this.addExecutionLog(this.iu.getString("SemanticSearchConfigureOperation.Log.TextEmbeddingsDisabled"));
                    }
                    properties.put("textEmbeddingsModel", null);
                } else {
                    if (!this.applySemanticSettingsLogged) {
                        this.addExecutionLog(this.iu.getFormattedString("SemanticSearchConfigureOperation.Log.TextEmbeddingsModel", (Object)textEmbeddingsModel));
                    }
                    properties.put("textEmbeddingsModel", textEmbeddingsModel);
                }
                if (imageEmbeddingsModel.isEmpty()) {
                    if (!this.applySemanticSettingsLogged) {
                        this.addExecutionLog(this.iu.getString("SemanticSearchConfigureOperation.Log.ImageEmbeddingsDisabled"));
                    }
                    properties.put("imageEmbeddingsModel", null);
                } else {
                    if (!this.applySemanticSettingsLogged) {
                        this.addExecutionLog(this.iu.getFormattedString("SemanticSearchConfigureOperation.Log.ImageEmbeddingsModel", (Object)imageEmbeddingsModel));
                    }
                    properties.put("imageEmbeddingsModel", imageEmbeddingsModel);
                }
                if (detectFaces.booleanValue()) {
                    if (!this.applySemanticSettingsLogged) {
                        this.addExecutionLog(this.iu.getFormattedString("SemanticSearchConfigureOperation.Log.DetectFacesEnabled", new Object[0]));
                    }
                    properties.put("detectFaces", true);
                } else {
                    if (!this.applySemanticSettingsLogged) {
                        this.addExecutionLog(this.iu.getString("SemanticSearchConfigureOperation.Log.DetectFacesDisabled"));
                    }
                    properties.put("detectFaces", false);
                }
                if (transcriptionModel.isEmpty()) {
                    if (!this.applySemanticSettingsLogged) {
                        this.addExecutionLog(this.iu.getString("SemanticSearchConfigureOperation.Log.TranscriptionDisabled"));
                    }
                    properties.put("transcriptionModel", null);
                } else {
                    if (!this.applySemanticSettingsLogged) {
                        this.addExecutionLog(this.iu.getFormattedString("SemanticSearchConfigureOperation.Log.TranscriptionModel", (Object)transcriptionModel));
                    }
                    properties.put("transcriptionModel", transcriptionModel);
                }
            }
            catch (ParameterException parameterException) {
                // empty catch block
            }
            this.applySemanticSettingsLogged = true;
        }
    }

    @Override
    public Consumption getOperationConsumption() {
        Consumption consumption = new Consumption();
        ConsumptionEvent consumptionEvent = new ConsumptionEvent();
        consumptionEvent.setConsumptionEventId(UidUtils.getRandom());
        consumptionEvent.setLicenseId(this.executionContext.licenceSession.getLicenceInfo().getId());
        consumptionEvent.setConsumptionStartEpoch(this.startDateTime.getMillis());
        if (this.finishedDateTime != null) {
            consumptionEvent.setConsumptionEndEpoch(this.finishedDateTime.getMillis());
        } else {
            consumptionEvent.setConsumptionEndEpoch(this.startDateTime.getMillis());
        }
        consumptionEvent.setPlatformType(ConsumptionPlatformType.NUIX_ENGINE);
        consumptionEvent.setPlatformId(NuixLicenceFactory.getInstance().getNuixLicenceId());
        consumptionEvent.setConsumptionType(this.getConsumptionType());
        consumptionEvent.setConsumptionSubType(this.getConsumptionSubType());
        consumptionEvent.setUnitType(UnitType.AUDITED_BYTES);
        consumptionEvent.setUnits(this.getVolume(this.executionContext.workflowExecution));
        consumptionEvent.setResourceType(ResourceType.NUIX_ENGINE_CASE_ID);
        consumptionEvent.setResourceId(this.executionContext.nuixCase.getGuid());
        consumptionEvent.setResourceSubType(ResourceSubType.NUIX_WORKER_TYPE);
        consumptionEvent.setResourceSubId(NuixLicenceFactory.getInstance().getNuixLicence().getShortName());
        if (this.executionContext.getEngine() != null) {
            consumptionEvent.setJobId(this.executionContext.getEngine().getJobId());
        }
        consumption.add(consumptionEvent);
        return consumption;
    }

    protected void setWorkerSettings() throws ParameterException {
        try {
            this.executionContext.workflowLocalWorkersCount = Integer.parseInt(this.executionContext.evalParameters("{local_worker_count}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.LocalWorkerCountFromParameter", new Object[]{"{local_worker_count}", this.executionContext.workflowLocalWorkersCount}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.workflowLocalWorkersMemoryMb = Integer.parseInt(this.executionContext.evalParameters("{local_worker_memory}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.LocalWorkerMemoryFromParameter", new Object[]{"{local_worker_memory}", this.executionContext.workflowLocalWorkersMemoryMb}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.workflowBrokerWorkersCount = Integer.parseInt(this.executionContext.evalParameters("{broker_worker_count}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingBrokerWorkerCountFromParameter", new Object[]{"{broker_worker_count}", this.executionContext.workflowBrokerWorkersCount}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.jobBrokerPort = Integer.parseInt(this.executionContext.evalParameters("{job_worker_broker_port}", this));
            this.executionContext.jobBrokerIp = this.executionContext.evalParameters("{job_worker_broker_ip}", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executionContext.workflowLocalWorkersTempFolder = this.executionContext.evalParameters(this.executionContext.workflowLocalWorkersTempFolder, this);
    }

    protected void initializeProcessingProfileBuilder() {
        if (NuixUtils.getProcessingSettingsSetAsProfile(this.executionContext)) {
            LOGGER.info("Nuix version supports setting Processing Settings as Profile");
            this.builder = this.executionContext.nuixUtilities.getProcessingProfileBuilder();
        } else {
            LOGGER.info("Nuix version does not support setting Processing Settings as Profile");
        }
    }

    protected void setTimeZoneSettings() throws ParameterException {
        String timezoneIdParameter = "{data_timezone_id}";
        String evaluatedTimezoneIdParameter = this.executionContext.evalParameters(timezoneIdParameter, this);
        if (!timezoneIdParameter.equals(evaluatedTimezoneIdParameter)) {
            if (evaluatedTimezoneIdParameter.length() > 0) {
                try {
                    DateTimeZone dateTimeZone = DateTimeZone.forID((String)evaluatedTimezoneIdParameter);
                    this.timeZoneId = dateTimeZone.getID();
                    LOGGER.info("Parsed specified timezone " + FormattingUtils.timeZoneToDisplayName((DateTimeZone)dateTimeZone) + " from ID " + timezoneIdParameter);
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.DateTimezoneFromParameter", new Object[]{"{data_timezone_id}", FormattingUtils.timeZoneToDisplayName((DateTimeZone)dateTimeZone)}));
                }
                catch (Exception e) {
                    LOGGER.error("Cannot set timezone " + evaluatedTimezoneIdParameter, (Throwable)e);
                    this.addWarning(this.iu.getFormattedString("AddEvidenceOperation.Log.InvalidDateTimezoneParameter", new Object[]{"{data_timezone_id}", evaluatedTimezoneIdParameter}));
                }
            } else {
                this.timeZoneId = "";
            }
        }
    }

    protected void setLocaleSettings() throws ParameterException {
        String localeLanguage = "{data_locale_language}";
        String evaluatedLocaleLanguage = this.executionContext.evalParameters(localeLanguage, this);
        String localeCountry = "{data_locale_country}";
        String evaluatedLocaleCountry = this.executionContext.evalParameters(localeCountry, this);
        if (!localeLanguage.equals(evaluatedLocaleLanguage) && !localeCountry.equals(evaluatedLocaleCountry) && evaluatedLocaleLanguage.length() > 0 && evaluatedLocaleCountry.length() > 0) {
            this.dataLocale = new Locale(evaluatedLocaleLanguage, evaluatedLocaleCountry);
            LOGGER.info("Parsed locale " + this.dataLocale.toLanguageTag());
            this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.LocaleFromParameters", new Object[]{this.dataLocale.toLanguageTag(), "{data_locale_language}", "{data_locale_country}"}));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setConfigurationProfileSettings() throws ParameterException, IOException {
        String workerSideScript;
        String workerSideScriptParameterName;
        Map<Object, Object> processingSettings = new HashMap();
        ConfigurationParser configurationParser = new ConfigurationParser();
        if (this.executionContext.evalParameters("{wfn_use_configuration_profile}", this).equalsIgnoreCase("true")) {
            processingSettings = configurationParser.getProperties(this.executionContext.nuixVersion);
            this.processor.setParallelProcessingSettings(configurationParser.getParallelProcessingSettings());
        }
        if (!(workerSideScriptParameterName = "{wfn_worker_side_script_file}").equals(workerSideScript = this.executionContext.evalParameters(workerSideScriptParameterName, this))) {
            this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.WorkerSideScript", (Object)workerSideScript));
            this.processor.getProcessingSettings().put("workerItemCallback", String.join((CharSequence)"\r\n", Files.readAllLines(Paths.get(workerSideScript, new String[0]))));
        }
        processingSettings.put("reportProcessingStatus", "physical_files");
        processingSettings.put("calculateAuditedSize", true);
        if (this.executionContext.evalParameters("{wfn_use_configuration_profile}", this).equalsIgnoreCase("true")) {
            Map<String, Map<String, Object>> mimeTypeSettings;
            block41: {
                mimeTypeSettings = configurationParser.getMimeTypeSettings();
                try {
                    void var6_21;
                    if (!processingSettings.containsKey("disabledMimeTypes")) break block41;
                    LOGGER.info("Setting disabled mime-types");
                    Object object = processingSettings.get("disabledMimeTypes");
                    if (object instanceof String[]) {
                        String[] stringArray = (String[])object;
                    } else {
                        String[] stringArray = new String[]{(String)object};
                    }
                    for (void disabledMimeType : var6_21) {
                        if (disabledMimeType.startsWith("kind:")) {
                            String disabledKindId = disabledMimeType.replace("kind:", "");
                            if (this.executionContext.nuixVersion.compareTo(new Version("7.2.0")) < 0) {
                                this.addWarning(this.iu.getFormattedString("AddEvidenceOperation.Warning.CannotDisableKind", new Object[]{disabledKindId, "7.2"}));
                                continue;
                            }
                            LOGGER.info("Parsing disabled kind ID " + disabledKindId);
                            for (MimeType mimeType : NuixUtils.getAllMimeTypes()) {
                                if (!mimeType.getKind().getId().equals(disabledKindId)) continue;
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Handling child mime-type " + mimeType.toString());
                                }
                                if (mimeTypeSettings.containsKey(mimeType.toString())) {
                                    mimeTypeSettings.remove(mimeType.toString());
                                }
                                HashMap<String, Boolean> disabledSetting = new HashMap<String, Boolean>();
                                disabledSetting.put("enabled", Boolean.FALSE);
                                mimeTypeSettings.put(mimeType.toString(), disabledSetting);
                            }
                            continue;
                        }
                        LOGGER.info("Parsing disabled mime-type " + (String)disabledMimeType);
                        if (mimeTypeSettings.containsKey(disabledMimeType)) {
                            mimeTypeSettings.remove(disabledMimeType);
                        }
                        HashMap<String, Boolean> disabledSetting = new HashMap<String, Boolean>();
                        disabledSetting.put("enabled", false);
                        mimeTypeSettings.put((String)disabledMimeType, (Map<String, Object>)disabledSetting);
                    }
                }
                catch (Exception exception) {
                    this.addWarning(this.iu.getFormattedString("AddEvidenceOperation.Warning.ErrorHandlingDisabledMimeTypes", (Object)exception.getLocalizedMessage()));
                    LOGGER.error("Error handling disabled mime-types", (Throwable)exception);
                }
            }
            LOGGER.info("Replacing processor mimeTypeProcessingSettings with those found in ConfigurationProfile");
            for (String string : mimeTypeSettings.keySet()) {
                try {
                    Map currentProcessorSetting = this.processor.getMimeTypeProcessingSettings(string);
                    if (LOGGER.isDebugEnabled()) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Setting mime-type " + string + "  TO " + ((Map)mimeTypeSettings.get(string)).toString());
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("      Current mime-type " + string + "     " + String.valueOf(currentProcessorSetting));
                        }
                    }
                    this.processor.setMimeTypeProcessingSettings(string, (Map)mimeTypeSettings.get(string));
                    if (NuixUtils.getProcessingSettingsSetAsProfile(this.executionContext)) {
                        this.builder = this.builder.withMimeTypeProcessingSettings(string, (Map)mimeTypeSettings.get(string));
                    }
                    currentProcessorSetting = this.processor.getMimeTypeProcessingSettings(string);
                    if (!LOGGER.isDebugEnabled()) continue;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("      Updated mime-type " + string + "  TO " + String.valueOf(currentProcessorSetting));
                    }
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug(" ");
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot set mime-type " + string + " properties.", (Throwable)e);
                }
            }
        }
        LOGGER.info("Applying processing settings");
        for (String string : processingSettings.keySet()) {
            try {
                Object object = processingSettings.get(string);
                String settingType = object != null ? object.getClass().toString() : "n/a";
                LOGGER.info("# Setting:\t" + settingType + "\t" + string + "\t" + String.valueOf(object));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.info("# Error setting key: " + string, (Throwable)illegalArgumentException);
            }
        }
        LOGGER.info("# Finished setting keys");
        String KIND_PREFIX = "kind:";
        if (NuixUtils.getProcessingSettingsSetAsProfile(this.executionContext)) {
            Object object;
            LOGGER.info("Patching disabled mime-types");
            Object object2 = processingSettings.get("disabledMimeTypes");
            if (object2 instanceof String[]) {
                String[] stringArray = (String[])object2;
                HashSet<MimeType> disabledMimeTypesSet = new HashSet<MimeType>();
                for (String disabledMimeType : stringArray) {
                    if (disabledMimeType.startsWith(KIND_PREFIX)) {
                        MimeTypeKind mimeTypeKind = MimeTypeKind.fromId((String)(disabledMimeType = disabledMimeType.substring(KIND_PREFIX.length())));
                        if (mimeTypeKind != null) {
                            for (MimeType mimeType : NuixUtils.getAllMimeTypes()) {
                                if (!mimeType.getKind().getId().equals(mimeTypeKind.getId())) continue;
                                disabledMimeTypesSet.add(mimeType);
                            }
                            continue;
                        }
                        LOGGER.warn("Cannot set unresolvable disabled mime-type kind" + disabledMimeType);
                        continue;
                    }
                    MimeType mimeType = MimeType.fromString((String)disabledMimeType);
                    if (mimeType != null) {
                        disabledMimeTypesSet.add(mimeType);
                        continue;
                    }
                    LOGGER.warn("Cannot set unresolvable disabled mime-type " + disabledMimeType);
                }
                processingSettings.remove("disabledMimeTypes");
                processingSettings.put("disabledMimeTypes", disabledMimeTypesSet);
            }
            if ((object = processingSettings.get("disabledCarvingMimeTypes")) instanceof String[]) {
                String[] disabledMimeTypes = (String[])object;
                HashSet<MimeType> disabledMimeTypesSet = new HashSet<MimeType>();
                for (String disabledMimeType : disabledMimeTypes) {
                    if (disabledMimeType.startsWith(KIND_PREFIX)) {
                        MimeTypeKind mimeTypeKind = MimeTypeKind.fromId((String)(disabledMimeType = disabledMimeType.substring(KIND_PREFIX.length())));
                        if (mimeTypeKind != null) {
                            for (MimeType mimeType2 : NuixUtils.getAllMimeTypes()) {
                                if (!mimeType2.getKind().getId().equals(mimeTypeKind.getId())) continue;
                                disabledMimeTypesSet.add(mimeType2);
                            }
                            continue;
                        }
                        LOGGER.warn("Cannot set unresolvable disabled mime-type kind" + disabledMimeType);
                        continue;
                    }
                    MimeType mimeType = MimeType.fromString((String)disabledMimeType);
                    if (mimeType != null) {
                        disabledMimeTypesSet.add(mimeType);
                        continue;
                    }
                    LOGGER.warn("Cannot set unresolvable disabled mime-type " + disabledMimeType);
                }
                processingSettings.remove("disabledCarvingMimeTypes");
                processingSettings.put("disabledCarvingMimeTypes", disabledMimeTypesSet);
            }
        }
        LOGGER.info("Updating processing settings types");
        for (String string : processingSettings.keySet()) {
            try {
                Object settingValue = processingSettings.get(string);
                String settingType = settingValue != null ? settingValue.getClass().toString() : "n/a";
                LOGGER.info("# Setting:\t" + settingType + "\t" + string + "\t" + String.valueOf(settingValue));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        LOGGER.info("# Finished updating keys");
        this.processor.setProcessingSettings(processingSettings);
    }

    private void copyProfileDecryptionKeys(ProcessingProfile processingProfile) throws IOException {
        if (processingProfile == null || processingProfile.getKeysLocation() == null) {
            return;
        }
        Path processingProfileKeysPath = Paths.get(processingProfile.getKeysLocation(), new String[0]);
        if (!processingProfileKeysPath.toFile().exists()) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(processingProfileKeysPath);){
            for (Path path : stream) {
                if (Files.isDirectory(path, new LinkOption[0]) || !path.getFileName().toString().startsWith(processingProfile.getName() + "-")) continue;
                LOGGER.info("Detected profile decryption key " + path.toString());
                String trimmedFileName = path.getFileName().toString().substring(processingProfile.getName().length() + 1);
                Path destinationFolder = this.executionContext.nuixCase.getLocation().toPath().resolve("Stores").resolve("DecryptionKeys");
                if (!Files.exists(destinationFolder, new LinkOption[0])) {
                    Files.createDirectories(destinationFolder, new FileAttribute[0]);
                }
                Path destinationPath = destinationFolder.resolve(trimmedFileName);
                try {
                    Files.copy(path, destinationPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    LOGGER.error("Cannot copy decryption file", (Throwable)e);
                    this.addWarning(this.iu.getFormattedString("AddEvidence.Warning.CannotSetDecryptionFile", new Object[]{path.toString(), e.getMessage()}));
                }
            }
        }
    }

    protected void setProcessingProfileSettings(Map<String, Object> overwritingParallelProcessingSettings) throws ParameterException, IOException {
        String processingProfileParameterName = "{wfn_processing_profile_name}";
        String processingProfileName = this.executionContext.evalParameters(processingProfileParameterName, this);
        try {
            processingProfileName = this.executionContext.evalParametersIfSet("{processing_profile_name}", this);
            this.addExecutionLog(this.iu.getFormattedString("AddEvidence.Log.SettingProcessingProfile", new Object[]{"{processing_profile_name}", processingProfileName}));
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
        if (!processingProfileParameterName.equals(processingProfileName)) {
            this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.ProcessingProfile", (Object)processingProfileName));
            ProcessingProfile existingProfile = NuixUtils.getProcessingProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, processingProfileName);
            if (existingProfile == null) {
                throw new IOException(this.iu.getFormattedString("ConfigurationOperation.Prerequisites.ProcessingProfileDoesNotExist", (Object)processingProfileName));
            }
            if (NuixUtils.getProcessingSettingsSetAsProfile(this.executionContext)) {
                try {
                    this.builder.withName(existingProfile.getName());
                    LOGGER.info("Copying profile Decryption keys");
                    try {
                        this.copyProfileDecryptionKeys(existingProfile);
                    }
                    catch (IOException ex) {
                        this.addWarning(FormattingUtils.getExceptionPrintableMessage((Exception)ex));
                    }
                    LOGGER.info("Copying user-supplied profile to memory");
                    this.builderProcessingSettings = existingProfile.getProcessingSettings();
                    for (MimeType mimeType : NuixUtils.getAllMimeTypes()) {
                        this.builder = this.builder.withMimeTypeProcessingSettings(mimeType.toString(), existingProfile.getMimeTypeProcessingSettings(mimeType.toString()));
                    }
                    HashMap<String, Object> profileParallelProcessingSettings = new HashMap<String, Object>();
                    profileParallelProcessingSettings.putAll(existingProfile.getParallelProcessingSettings());
                    Map<String, Object> workflowDefinedParallelProcessingSettings = this.getWorkerParallelSettings(overwritingParallelProcessingSettings, false, true);
                    profileParallelProcessingSettings.putAll(workflowDefinedParallelProcessingSettings);
                    profileParallelProcessingSettings.remove("workerBrokerAddress");
                    this.builder = this.builder.withParallelProcessingSettings(profileParallelProcessingSettings);
                    this.builder = this.builder.withPasswordDiscoverySettings(existingProfile.getPasswordDiscoverySettings());
                }
                catch (Exception e) {
                    LOGGER.error("Cannot get profile settings", (Throwable)e);
                    this.addWarning(FormattingUtils.getExceptionPrintableMessage((Exception)e));
                }
            } else {
                try {
                    this.processor.setProcessingProfile(processingProfileName);
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.ProcessingProfile", (Object)processingProfileName));
                }
                catch (Exception e) {
                    LOGGER.error("Cannot set profile", (Throwable)e);
                    throw new IllegalStateException(this.iu.getFormattedString("AddEvidenceOperation.Error.CannotUseProfile", new Object[]{processingProfileName, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}).replace("..", "."));
                }
            }
            try {
                ProcessingProfile profile = NuixUtils.getProcessingProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, processingProfileName);
                if (profile != null) {
                    Object digests = profile.getProcessingSettings().get("digests");
                    this.processor.getProcessingSettings().put("digests", digests);
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot set digests from processing profile", (Throwable)e);
            }
            this.processor.getProcessingSettings().remove("additionalDigests");
            this.processor.getProcessingSettings().put("imageClassificationImageWidth", 299);
            this.processor.getProcessingSettings().put("imageClassificationImageHeight", 299);
            this.processor.getProcessingSettings().put("imageClassificationLabels", "");
            this.builderProcessingSettings.put("imageClassificationImageWidth", 299);
            this.builderProcessingSettings.put("imageClassificationImageHeight", 299);
            this.builderProcessingSettings.put("imageClassificationLabels", "");
        }
    }

    protected void setWorkerParallelSettings() throws IOException {
        this.setWorkerParallelSettings(new HashMap<String, Object>());
    }

    protected Map<String, Object> getWorkerParallelSettings(Map<String, Object> overwritingParallelProcessingSettings, boolean includeProfile, boolean logWorkers) throws IOException {
        HashMap<String, Object> parallelSettings = includeProfile ? this.processor.getParallelProcessingSettings() : new HashMap<String, Object>();
        if (this.executionContext.workflowParallelSettings) {
            LOGGER.info("Setting workflow-defined parallel settings");
            this.localWorkersCount = this.executionContext.workflowLocalWorkersCount;
            if (this.executionContext.workflowLocalWorkersCount == 0) {
                LOGGER.info("Setting runLocalWorkers to false");
                parallelSettings.put("runLocalWorkers", false);
                parallelSettings.put("workerCount", null);
            } else {
                LOGGER.info("Setting runLocalWorkers to true");
                parallelSettings.put("runLocalWorkers", true);
                int effectiveWorkers = Math.min(this.executionContext.nuixUtilities.getLicence().getWorkers(), this.executionContext.workflowLocalWorkersCount);
                parallelSettings.put("workerCount", effectiveWorkers);
                parallelSettings.put("workerMemory", this.executionContext.workflowLocalWorkersMemoryMb);
                if (logWorkers) {
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.LocalWorkers", (Object)effectiveWorkers));
                }
                try {
                    Files.createDirectories(Paths.get(this.executionContext.workflowLocalWorkersTempFolder, new String[0]), new FileAttribute[0]);
                }
                catch (Throwable t) {
                    throw new IOException(this.iu.getString("AddEvidenceOperation.Exception.InvalidWorkerTempFolder"), t);
                }
                parallelSettings.put("workerTemp", this.executionContext.workflowLocalWorkersTempFolder);
            }
        } else if (includeProfile) {
            try {
                parallelSettings.put("runLocalWorkers", this.processor.getProcessingProfile().getParallelProcessingSettings().get("runLocalWorkers"));
                parallelSettings.put("workerCount", this.processor.getProcessingProfile().getParallelProcessingSettings().get("workerCount"));
            }
            catch (Exception e) {
                LOGGER.warn("Cannot get job profile worker count");
            }
            try {
                this.localWorkersCount = (Integer)parallelSettings.get("workerCount");
            }
            catch (Exception e) {
                LOGGER.warn("Cannot determine job profile worker count from parallel settings");
            }
            if (Objects.equals(this.processor.getParallelProcessingSettings().get("runLocalWorkers"), false)) {
                this.localWorkersCount = 0;
                if (this.executionContext.jobBrokerIp == null) {
                    this.executionContext.workflowBrokerWorkersCount = 2;
                    this.executionContext.workflowParallelSettings = true;
                }
            } else if (logWorkers) {
                this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.LocalWorkers", (Object)this.localWorkersCount));
            }
        }
        if (this.executionContext.workflowBrokerWorkersCount > 0) {
            parallelSettings.put("workerBrokerAddress", this.executionContext.workflowBrokerIp + ":" + this.executionContext.workflowBrokerPort);
        }
        parallelSettings.putAll(overwritingParallelProcessingSettings);
        return parallelSettings;
    }

    protected void setWorkerParallelSettings(Map<String, Object> overwritingParallelProcessingSettings) throws IOException {
        Map<String, Object> parallelSettings = this.getWorkerParallelSettings(overwritingParallelProcessingSettings, true, false);
        try {
            try {
                this.processor.setParallelProcessingSettings(parallelSettings);
            }
            catch (Throwable t) {
                throw new IOException(this.iu.getString("AddEvidenceOperation.Exception.CannotSetParallelProcessingSettings"), t);
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Cannot get job profile worker count");
        }
    }

    protected void setDecryptionSettings() throws GeneralSecurityException, ParameterException {
        Object existingProfile;
        String processingProfileParameterName = "{wfn_processing_profile_name}";
        String processingProfileName = this.executionContext.evalParameters(processingProfileParameterName, this);
        try {
            processingProfileName = this.executionContext.evalParametersIfSet("{processing_profile_name}", this);
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
        Map<String, String> passwordDiscoverySettings = new HashMap();
        if (!processingProfileName.equals(processingProfileParameterName) && (existingProfile = NuixUtils.getProcessingProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, processingProfileName)) != null && existingProfile.getPasswordDiscoverySettings() != null) {
            passwordDiscoverySettings = existingProfile.getPasswordDiscoverySettings();
        }
        if (this.executionContext.keystoreList != null) {
            for (KeystoreFile kf : this.executionContext.keystoreList) {
                File keyFile = new File(kf.getKeystoreFilePath());
                HashMap<String, Object> keyParameters = new HashMap<String, Object>();
                if (kf.getKeystoreFilePassword() != null && !kf.getKeystoreFilePassword().equals("")) {
                    keyParameters.put("filePassword", kf.getKeystoreFilePassword());
                }
                if (kf.getKeyPasswords().size() > 0) {
                    keyParameters.put("keyPasswords", kf.getKeyPasswords());
                }
                if (kf.getTarget() != null && !kf.getTarget().equals("")) {
                    keyParameters.put("target", kf.getTarget());
                }
                this.processor.addKeyStore(keyFile, keyParameters);
                if (this.builder == null) continue;
                this.builder = this.builder.addKeyStore(keyFile, keyParameters);
            }
        }
        if (this.executionContext.passwords != null && this.executionContext.passwords.size() > 0) {
            Version requiredNuixVersion = new Version("7.2.0");
            int requiredVersionSatisfied = this.executionContext.nuixVersion.compareTo(requiredNuixVersion);
            if (requiredVersionSatisfied < 0) {
                this.addWarning(this.iu.getFormattedString("AddEvidenceOperation.Warning.CannotUsePasswordSettings", (Object)requiredNuixVersion.toString()));
            } else {
                ArrayList<char[]> passwordList = new ArrayList<char[]>();
                for (String password : this.executionContext.passwords) {
                    passwordList.add(password.toCharArray());
                }
                LOGGER.info("Added " + passwordList.size() + " passwords");
                this.processor.addPasswordList("AutomateWorkflowPasswords", passwordList);
                if (this.builder != null) {
                    this.builder = this.builder.addPasswordList("AutomateWorkflowPasswords", new ArrayList<String>(this.executionContext.passwords));
                }
                passwordDiscoverySettings.put("mode", "word-list");
                passwordDiscoverySettings.put("word-list", "AutomateWorkflowPasswords");
                passwordDiscoverySettings.put("wordList", "AutomateWorkflowPasswords");
            }
        }
        if (this.builder != null) {
            this.builder = this.builder.withPasswordDiscoverySettings(passwordDiscoverySettings);
        }
        this.processor.setPasswordDiscoverySettings(passwordDiscoverySettings);
    }

    protected void applyProcessingProfile() {
        this.applyProcessingProfile(new HashMap<String, Object>());
    }

    protected void applyProcessingProfile(Map<String, Object> processorOverwritingSettings) {
        try {
            this.setDecryptionSettings();
        }
        catch (Exception e) {
            LOGGER.error("Unable to set password settings", (Throwable)e);
        }
        if (NuixUtils.getProcessingSettingsSetAsProfile(this.executionContext)) {
            LOGGER.info("Setting profile");
            if (this.builderProcessingSettings != null) {
                this.builderProcessingSettings.put("reportProcessingStatus", "physical_files");
                this.builderProcessingSettings.put("calculateAuditedSize", true);
                this.applySemanticSettings(this.builderProcessingSettings);
                for (String settingKey : processorOverwritingSettings.keySet()) {
                    this.builderProcessingSettings.put(settingKey, processorOverwritingSettings.get(settingKey));
                }
                this.builder = this.builder.withProcessingSettings(this.builderProcessingSettings);
            }
            ProcessingProfile profile = (ProcessingProfile)this.builder.build();
            this.processor.setProcessingProfileObject(profile);
        } else {
            for (String settingKey : processorOverwritingSettings.keySet()) {
                this.processor.getProcessingSettings().put(settingKey, processorOverwritingSettings.get(settingKey));
            }
        }
        this.processor.getProcessingSettings().put("reportProcessingStatus", "physical_files");
        this.processor.getProcessingSettings().put("calculateAuditedSize", true);
    }

    protected void setProcessingProfileSettingsToProcessor(Map<String, Object> overwritingParallelProcessingSettings) throws ParameterException {
        ProcessingProfile existingProfile;
        String processingProfileParameterName = "{wfn_processing_profile_name}";
        String processingProfileName = this.executionContext.evalParameters(processingProfileParameterName, this);
        try {
            processingProfileName = this.executionContext.evalParametersIfSet("{processing_profile_name}", this);
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
        if (!processingProfileParameterName.equals(processingProfileName) && (existingProfile = NuixUtils.getProcessingProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, processingProfileName)) != null) {
            HashMap<String, Object> profileParallelProcessingSettings;
            if (NuixUtils.getProcessingSettingsSetAsProfile(this.executionContext)) {
                try {
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.ProcessingProfile", (Object)processingProfileName));
                    LOGGER.info("Copying user-supplied profile to memory");
                    this.builderProcessingSettings = existingProfile.getProcessingSettings();
                    for (MimeType mimeType : NuixUtils.getAllMimeTypes()) {
                        this.builder = this.builder.withMimeTypeProcessingSettings(mimeType.toString(), existingProfile.getMimeTypeProcessingSettings(mimeType.toString()));
                    }
                    profileParallelProcessingSettings = new HashMap();
                    profileParallelProcessingSettings.putAll(existingProfile.getParallelProcessingSettings());
                    Map<String, Object> workflowDefinedParallelProcessingSettings = this.getWorkerParallelSettings(overwritingParallelProcessingSettings, false, true);
                    profileParallelProcessingSettings.putAll(workflowDefinedParallelProcessingSettings);
                    this.builder = this.builder.withParallelProcessingSettings(profileParallelProcessingSettings);
                    this.builder = this.builder.withPasswordDiscoverySettings(existingProfile.getPasswordDiscoverySettings());
                }
                catch (Exception e) {
                    LOGGER.error("Cannot get profile settings", (Throwable)e);
                    this.addWarning(FormattingUtils.getExceptionPrintableMessage((Exception)e));
                }
            } else {
                try {
                    this.processor.setProcessingSettings(existingProfile.getProcessingSettings());
                    for (MimeType mimeType : NuixUtils.getAllMimeTypes()) {
                        this.processor.setMimeTypeProcessingSettings(mimeType.toString(), existingProfile.getMimeTypeProcessingSettings(mimeType.toString()));
                    }
                    this.processor.setPasswordDiscoverySettings(existingProfile.getPasswordDiscoverySettings());
                    profileParallelProcessingSettings = new HashMap<String, Object>();
                    profileParallelProcessingSettings.putAll(existingProfile.getParallelProcessingSettings());
                    this.processor.setParallelProcessingSettings(profileParallelProcessingSettings);
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.PartialProcessingProfile", (Object)processingProfileName));
                }
                catch (Exception e) {
                    LOGGER.error("Cannot set profile", (Throwable)e);
                    throw new IllegalStateException(this.iu.getFormattedString("AddEvidenceOperation.Error.CannotUseProfile", new Object[]{processingProfileName, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}).replace("..", "."));
                }
            }
            Object digests = existingProfile.getProcessingSettings().get("digests");
            this.processor.getProcessingSettings().put("digests", digests);
            this.processor.getProcessingSettings().remove("additionalDigests");
            this.processor.getProcessingSettings().put("imageClassificationImageWidth", 299);
            this.processor.getProcessingSettings().put("imageClassificationImageHeight", 299);
            this.processor.getProcessingSettings().put("imageClassificationLabels", "");
            this.builderProcessingSettings.put("imageClassificationImageWidth", 299);
            this.builderProcessingSettings.put("imageClassificationImageHeight", 299);
            this.builderProcessingSettings.put("imageClassificationLabels", "");
        }
    }

    protected void applyProcessingProfileAsProcessorSettings() {
        if (NuixUtils.getProcessingSettingsSetAsProfile(this.executionContext)) {
            LOGGER.info("Setting profile as processor settings");
            if (this.builderProcessingSettings != null) {
                this.builderProcessingSettings.put("reportProcessingStatus", "physical_files");
                this.builderProcessingSettings.put("calculateAuditedSize", true);
                this.builder = this.builder.withProcessingSettings(this.builderProcessingSettings);
            }
            ProcessingProfile profile = (ProcessingProfile)this.builder.build();
            HashMap<String, Object> processingSettings = new HashMap<String, Object>();
            processingSettings.putAll(profile.getProcessingSettings());
            processingSettings.put("imageClassificationImageWidth", 299);
            processingSettings.put("imageClassificationImageHeight", 299);
            processingSettings.put("imageClassificationLabels", "");
            this.applySemanticSettings(processingSettings);
            try {
                this.processor.setProcessingSettings(processingSettings);
                for (MimeType mimeType : NuixUtils.getAllMimeTypes()) {
                    this.processor.setMimeTypeProcessingSettings(mimeType.toString(), profile.getMimeTypeProcessingSettings(mimeType.toString()));
                }
                this.processor.setPasswordDiscoverySettings(profile.getPasswordDiscoverySettings());
                this.processor.setParallelProcessingSettings(profile.getParallelProcessingSettings());
            }
            catch (Exception e) {
                LOGGER.error("Cannot set profile", (Throwable)e);
                throw new IllegalStateException(this.iu.getFormattedString("AddEvidenceOperation.Error.CannotUseProfile", new Object[]{"Automate-Internal", ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}).replace("..", "."));
            }
        }
        this.processor.getProcessingSettings().put("reportProcessingStatus", "physical_files");
        this.processor.getProcessingSettings().put("calculateAuditedSize", true);
    }

    @Override
    public long getItemsProcessed() {
        if (this.loadProcessingJob != null) {
            return this.loadProcessingJob.getItemsProcessed();
        }
        return 0L;
    }
}

