/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.operations.DiscoverLoadDetails;
import com.nuix.automate.workflow.core.execution.operations.PromoteToDiscoverOperationImplementation;
import com.nuix.automate.workflow.core.utils.discover.DocumentMapping;
import com.nuix.automate.workflow.core.utils.discover.responses.ImportJob;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import nuix.Item;
import org.apache.commons.lang3.StringUtils;

public abstract class PromoteToDiscoverFileCopier {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PromoteToDiscoverFileCopier.class);
    PromoteToDiscoverOperationImplementation operation;

    protected abstract void copyFile(String var1, File var2) throws IOException;

    public void copyItemFiles(Item item, ImportJob importJob, DiscoverLoadDetails loadDetails, Map<String, DocumentMapping> documentsMapping) {
        boolean itemFailed = false;
        DocumentMapping documentMapping = documentsMapping.get(item.getGuid());
        if (documentMapping == null) {
            this.operation.failedItems.add(item);
            LOGGER.warn("Item " + item.getGuid() + " does not have a file mapping");
        } else {
            Path exportedPath;
            if (documentMapping.getNativePath() != null) {
                exportedPath = Paths.get(this.operation.exportFolder, "/Part" + loadDetails.exportPart, documentMapping.getNativePath());
                String docIdBasedNativePath = documentMapping.getDocIdBasedNativePath();
                if (this.operation.pagePdf && StringUtils.endsWithIgnoreCase((CharSequence)docIdBasedNativePath, (CharSequence)".pdf")) {
                    Object nativePdfFilePath = docIdBasedNativePath;
                    nativePdfFilePath = ((String)nativePdfFilePath).substring(0, ((String)nativePdfFilePath).length() - ".pdf".length()) + "_Native.pdf";
                    documentMapping.setPdfNativePath((String)nativePdfFilePath);
                    docIdBasedNativePath = documentMapping.getPdfNativePath();
                }
                String destinationKey = (this.operation.exportFolderName + "/" + docIdBasedNativePath).replace("\\", "/");
                try {
                    this.copyFile(destinationKey, exportedPath.toFile());
                }
                catch (IOException e) {
                    this.operation.failedItems.add(item);
                    LOGGER.warn("Cannot copy " + exportedPath.toString() + " to " + destinationKey, (Throwable)e);
                    this.operation.errorCopyingFiles.incrementAndGet();
                    itemFailed = true;
                }
            }
            if (documentMapping.getTextPath() != null) {
                exportedPath = Paths.get(this.operation.exportFolder, "/Part" + loadDetails.exportPart, documentMapping.getTextPath());
                String destinationKey = (this.operation.exportFolderName + "/" + documentMapping.getDocIdBasedTextPath()).replace("\\", "/");
                try {
                    this.copyFile(destinationKey, exportedPath.toFile());
                }
                catch (IOException e) {
                    this.operation.failedItems.add(item);
                    LOGGER.warn("Cannot copy " + exportedPath.toString() + " to " + destinationKey, (Throwable)e);
                    this.operation.errorCopyingFiles.incrementAndGet();
                    itemFailed = true;
                }
            }
            if (documentMapping.getImagePaths() != null) {
                List<String> imagePaths = documentMapping.getImagePaths();
                List<String> docIdBasedPdfPath = documentMapping.getDocIdBasedImagePaths();
                for (int i = 0; i < imagePaths.size(); ++i) {
                    Path exportedPath2 = Paths.get(this.operation.exportFolder, "/Part" + loadDetails.exportPart, imagePaths.get(i));
                    String destinationKey = (this.operation.exportFolderName + "/" + docIdBasedPdfPath.get(i)).replace("\\", "/");
                    try {
                        this.copyFile(destinationKey, exportedPath2.toFile());
                        continue;
                    }
                    catch (IOException e) {
                        this.operation.failedItems.add(item);
                        LOGGER.warn("Cannot copy " + exportedPath2.toString() + " to " + destinationKey, (Throwable)e);
                        this.operation.errorCopyingFiles.incrementAndGet();
                        itemFailed = true;
                    }
                }
            }
            this.operation.loadItemsProcessedInStage.incrementAndGet();
            String stage = "upload_files";
            String mimeType = item.getType().getName();
            this.operation.itemHandled(mimeType, stage, null, itemFailed);
        }
    }
}

