/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.google.gson.JsonSyntaxException;
import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.DummyLogChannel;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.utils.utilization.consumption.ConsumptionEvent;
import com.nuix.automate.utils.utilization.consumption.ConsumptionPlatformType;
import com.nuix.automate.utils.utilization.consumption.ConsumptionType;
import com.nuix.automate.utils.utilization.consumption.ResourceType;
import com.nuix.automate.utils.utilization.consumption.UnitType;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.DiscoverLoadDetails;
import com.nuix.automate.workflow.core.execution.operations.PromoteToDiscoverFileCopier;
import com.nuix.automate.workflow.core.execution.operations.PromoteToDiscoverFileshareFileCopier;
import com.nuix.automate.workflow.core.execution.operations.PromoteToDiscoverOperation;
import com.nuix.automate.workflow.core.execution.operations.PromoteToDiscoverS3FileCopier;
import com.nuix.automate.workflow.core.execution.operations.RemoteWorkerBasedOperation;
import com.nuix.automate.workflow.core.execution.options.export.LegalExportType;
import com.nuix.automate.workflow.core.execution.options.legalexport.ExportScheme;
import com.nuix.automate.workflow.core.execution.options.promotetodiscover.AdditionalField;
import com.nuix.automate.workflow.core.execution.options.promotetodiscover.AdditionalFieldType;
import com.nuix.automate.workflow.core.execution.options.promotetodiscover.DiscoverExportOptions;
import com.nuix.automate.workflow.core.execution.options.usediscovercase.DiscoverFileRepositoryType;
import com.nuix.automate.workflow.core.nuix.loadfile.edrm.Document;
import com.nuix.automate.workflow.core.nuix.loadfile.edrm.ExternalFile;
import com.nuix.automate.workflow.core.nuix.loadfile.edrm.Root;
import com.nuix.automate.workflow.core.nuix.loadfile.edrm.Serializer;
import com.nuix.automate.workflow.core.utils.discover.DiscoverRestClient;
import com.nuix.automate.workflow.core.utils.discover.DocumentMapping;
import com.nuix.automate.workflow.core.utils.discover.responses.ImportJob;
import com.nuix.automate.workflow.core.utils.discover.responses.Job;
import com.nuix.automate.workflow.core.utils.discover.responses.Stage;
import com.nuix.automate.workflow.core.utils.general.ConfigurationParser;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixWorkerUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import nuix.AddedWorkers;
import nuix.BatchExporter;
import nuix.BulkAnnotater;
import nuix.ExportProcessingJob;
import nuix.Item;
import nuix.ItemEventInfo;
import nuix.LicenceException;
import nuix.MetadataItem;
import nuix.MetadataProfile;
import nuix.ParallelProcessingConfigurable;
import nuix.ProcessingJob;
import nuix.ProductionSet;
import nuix.profile.ImagingProfile;
import nuix.profile.ProductionProfile;
import nuix.profile.StamperConfiguration;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class PromoteToDiscoverOperationImplementation
extends PromoteToDiscoverOperation
implements RemoteWorkerBasedOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PromoteToDiscoverOperation.class);
    private transient ImportJob firstImportJob;
    private transient DiscoverRestClient discoverRestClient;
    private transient String hostname;
    private transient String apiToken;
    private transient Set<String> whitelistedCertificateFingerprints;
    private transient int discoverCaseId;
    private transient String apiVersion;
    private transient DiscoverFileRepositoryType fileRepositoryType;
    private transient String windowsFileRepository;
    transient String exportFolderName;
    transient Map<String, Integer> stageNameToId;
    transient Map<String, Integer> loadStageNameToId;
    transient String loadStageName;
    transient Integer loadStageItemsProcessed;
    transient double maxPercentage = 0.0;
    private transient ExportProcessingJob exportProcessingJob;
    private transient double exportPartStartPercentage;
    private transient double exportPartSizePercentage;
    private transient int exportPart;
    private transient int loadPart;
    private transient long failedExportItemCount;
    transient Set<Item> failedItems;
    private transient Set<Item> itemsToUntag;
    private transient long itemsInScopeCount;
    private transient long itemsInProductionSet;
    private transient List<AddedWorkers> addedWorkersList;
    private transient File settingsFile;
    private transient String relativityUsername;
    private transient String relativityPassword;
    private transient String relativityWorkspaceId;
    private transient String relativityFolderId;
    private transient String relativityHostname;
    private transient String relativityEndpointType;
    private transient String relativityImportThreads;
    private transient String relativityImportThreadTimeout;
    private transient String relativityImportThreadRetries;
    private transient String relativityPatchInvalidEntries;
    transient AtomicLong loadItemsProcessedInStage;
    private transient int totalItemsLoadedIntoRelativity;
    private transient Set<Integer> loadItemIdsWithErrors;
    private transient List<Item> itemsInScope;
    private transient Thread loadQueueThread;
    private transient Semaphore loadsPending;
    private transient AtomicLong loadsQueued;
    private transient AtomicLong loadsCompleted;
    private transient BlockingQueue<DiscoverLoadDetails> loadQueue;
    private transient DiscoverLoadDetails currentDiscoverLoadDetails;
    private transient boolean fatalErrorEncountered;
    private transient int workersPendingCount;
    private transient boolean isPaused;
    private transient boolean isProductionProfileExportOptionsUsed;
    private transient String productionProfileExportType;
    private transient ProductionSet productionSet;
    private transient MetadataProfile customMetadataProfile;
    private transient boolean discoverMetadataProfileExpected;
    private transient String currentLoadStage;
    private transient long itemsVolume;
    private transient String evaluatedImportOptions;
    private transient Integer workerMemory = null;
    private transient AtomicInteger addedWorkerCount = new AtomicInteger(0);
    transient AtomicLong errorCopyingFiles;

    public List<Item> getItemsInScope() {
        if (this.itemsInScope != null) {
            return this.itemsInScope;
        }
        return new ArrayList<Item>();
    }

    private void checkNuixVersion() {
        Version desiredNuixVersion = new Version("8.6.0");
        int requiredVersionSatisfied = this.executionContext.nuixVersion.compareTo(desiredNuixVersion);
        this.discoverMetadataProfileExpected = true;
        if (requiredVersionSatisfied < 0) {
            this.addWarning(this.iu.getString("PromoteToDiscoverOperation.Warning.CannotExtractDefaultFields"));
            this.discoverMetadataProfileExpected = false;
        }
    }

    private void bootstrap() throws ParameterException {
        this.exportPartStartPercentage = 0.0;
        this.exportPartSizePercentage = 1.0;
        this.failedExportItemCount = 0L;
        this.loadsPending = new Semaphore(0);
        this.loadsQueued = new AtomicLong(0L);
        this.loadsCompleted = new AtomicLong(0L);
        if (this.exportStandardMetadata.booleanValue()) {
            this.addExecutionLog(this.iu.getString("PromoteToDiscoverOperation.Log.ExportStandardMetadata"));
        }
        if (this.metadataProfileEnabled.booleanValue()) {
            String metadataProfileParameterName = "{metadata_profile}";
            String evaluatedMetadataProfileParameter = this.executionContext.evalParameters(metadataProfileParameterName, this);
            if (!metadataProfileParameterName.equals(evaluatedMetadataProfileParameter)) {
                this.metadataProfile = evaluatedMetadataProfileParameter;
                this.addExecutionLog(this.iu.getFormattedString("PromoteToDiscoverOperation.Log.CustomMetadataProfile", new Object[]{metadataProfileParameterName, this.metadataProfile}));
            } else {
                this.addExecutionLog(this.iu.getFormattedString("PromoteToDiscoverOperation.Log.MetadataProfile", (Object)this.metadataProfile));
            }
            this.customMetadataProfile = NuixUtils.getMetadataProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.metadataProfile);
            if (this.customMetadataProfile == null) {
                this.addWarning(this.iu.getFormattedString("PromoteToDiscoverOperation.Warning.MetadataProfile", (Object)this.metadataProfile));
            }
        }
        ArrayList<String> contentType = new ArrayList<String>();
        if (this.contentNative) {
            contentType.add("Native");
        }
        if (this.contentText) {
            contentType.add("Text");
        }
        this.addExecutionLog(this.iu.getFormattedString("PromoteToDiscoverOperation.Log.Content", (Object)String.join((CharSequence)"; ", contentType)));
        ArrayList<String> pageTypes = new ArrayList<String>();
        if (this.pagePdf) {
            pageTypes.add("PDF");
        }
        if (this.pageNativeAllDocuments) {
            pageTypes.add("Native");
        }
        if (this.pageNativeSlipSheet) {
            pageTypes.add("Native (if PDF slip sheet)");
        }
        this.addExecutionLog(this.iu.getFormattedString("PromoteToDiscoverOperation.Log.Page", (Object)String.join((CharSequence)"; ", pageTypes)));
        try {
            this.executionContext.workflowLocalWorkersCount = Integer.parseInt(this.executionContext.evalParameters("{local_worker_count}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingLocalWorkerCountFromParameter", new Object[]{"{local_worker_count}", this.executionContext.workflowLocalWorkersCount}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.workflowLocalWorkersMemoryMb = Integer.parseInt(this.executionContext.evalParameters("{local_worker_memory}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingLocalWorkerMemoryFromParameter", new Object[]{"{local_worker_memory}", this.executionContext.workflowLocalWorkersMemoryMb}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.workflowBrokerWorkersCount = Integer.parseInt(this.executionContext.evalParameters("{broker_worker_count}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingBrokerWorkerCountFromParameter", new Object[]{"{broker_worker_count}", this.executionContext.workflowBrokerWorkersCount}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.jobBrokerPort = Integer.parseInt(this.executionContext.evalParameters("{job_worker_broker_port}", this));
            this.executionContext.jobBrokerIp = this.executionContext.evalParameters("{job_worker_broker_ip}", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executionContext.workflowLocalWorkersTempFolder = this.executionContext.evalParameters(this.executionContext.workflowLocalWorkersTempFolder, this);
        this.hostname = this.executionContext.evalParameters("{wfn_discover_hostname}", this);
        this.apiToken = this.executionContext.evalProtectedParameter("{wfn_discover_api_token_protected}").trim();
        this.whitelistedCertificateFingerprints = (Set)SerializationUtils.fromJson((String)this.executionContext.evalParameters("{wfn_discover_whitelisted_cert_fingerprints}", this), Set.class);
        this.discoverCaseId = Integer.parseInt(this.executionContext.evalParameters("{discover_case_id}", this));
        this.apiVersion = this.executionContext.evalParameters("{discover_version}", this);
        this.fileRepositoryType = DiscoverFileRepositoryType.valueOf(this.executionContext.evalParameters("{wfn_discover_file_repository_type}", this));
        this.windowsFileRepository = this.executionContext.evalParameters("{wfn_discover_windows_file_repository}", this);
        if (this.runIndexingInDiscover) {
            this.addExecutionLog(this.iu.getString("Options.runIndexingInDiscover"));
        }
        if (this.runDeduplicationInDiscover) {
            this.addExecutionLog(this.iu.getString("Options.runDeduplicationInDiscover"));
        }
        ArrayList<String> loadStageNames = new ArrayList<String>();
        loadStageNames.add("initializeJob");
        loadStageNames.add("mapItemsToFiles");
        loadStageNames.add("copyFiles");
        loadStageNames.add("extractMetadata");
        loadStageNames.add("submitMetadata");
        loadStageNames.add("submitJob");
        if (this.waitForDiscoverJobToFinish) {
            loadStageNames.add("waitForJob");
        }
        this.loadStageNameToId = new HashMap<String, Integer>();
        this.loadStageNameToId = new HashMap<String, Integer>();
        int id = 0;
        for (String stageName : loadStageNames) {
            this.loadStageNameToId.put(stageName, id);
            ++id;
        }
        this.checkNuixVersion();
        this.executionContext.closeAllTabs();
    }

    @Override
    public void startTriggered() throws Exception {
        this.bootstrap();
        this.startTriggerThread = new Thread(() -> {
            try {
                this.description = this.executionContext.evalParameters(this.description, this);
                this.productionSetName = this.executionContext.evalParameters(this.productionSetName, this);
                this.imagingProfile = this.executionContext.evalParameters(this.imagingProfile, this);
                this.productionProfile = this.executionContext.evalParameters(this.productionProfile, this);
                this.productionSet = null;
                for (ProductionSet candidateProductionSet : this.executionContext.nuixCase.getProductionSets()) {
                    if (!candidateProductionSet.getName().equals(this.productionSetName)) continue;
                    this.productionSet = candidateProductionSet;
                    LOGGER.info("Got production set " + String.valueOf(candidateProductionSet));
                    break;
                }
                if (this.productionSet == null) {
                    throw new Exception(this.iu.getFormattedString("General.Exception.ProductionSetNotInCase", (Object)this.productionSetName));
                }
                this.productionSetName = this.productionSet.getName();
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{export_production_set_name}", this.productionSetName)));
                this.level = this.executionContext.evalParameters(this.level, this);
                this.failedItems = new HashSet<Item>();
                this.itemsToUntag = new HashSet<Item>();
                List sortedItemsToExport = new ArrayList();
                LOGGER.info("Getting all items from production set");
                sortedItemsToExport = this.productionSet.getItems();
                this.itemsInProductionSet = sortedItemsToExport.size();
                this.itemsInScopeCount = sortedItemsToExport.size();
                this.addExecutionLog(this.iu.getFormattedString("General.Log.ProductionSetName", (Object)this.productionSetName));
                this.addExecutionLog(this.iu.getNumeralString("General.Log.ProductionSetCount", this.itemsInProductionSet));
                this.itemsInScope = new ArrayList<Item>(sortedItemsToExport);
                this.itemsVolume = this.executionContext.nuixCase.getStatistics().getAuditSize("production-set:\"" + this.productionSetName + "\"");
                this.addExecutionLog(this.iu.getNumeralString("General.Log.SplitExportAt", (long)this.exportSplitAt));
                this.exportFolder = this.executionContext.evalParameters(this.exportFolder, this);
                this.failedItemTagName = this.executionContext.evalParameters(this.failedItemTagName, this);
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_failed_items_tag_name}", this.failedItemTagName)));
                File exportFolderFile = new File(this.exportFolder);
                this.exportFolder = exportFolderFile.getCanonicalPath();
                LOGGER.info("Canonical export folder: " + this.exportFolder);
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_export_folder}", this.exportFolder)));
                if (exportFolderFile.exists() && exportFolderFile.list().length > 0) {
                    LOGGER.error("Folder has " + exportFolderFile.list().length + " items");
                    this.exception = new IOException(this.iu.getFormattedString("General.Exception.FolderNotEmpty", (Object)exportFolderFile.getCanonicalPath()));
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                ArrayList<CallSite> options = new ArrayList<CallSite>();
                if (this.useAdditionalImportOptions) {
                    for (AdditionalField importOption : this.additionalImportOptions) {
                        String optionGraphql;
                        String evaluatedOptionName = this.executionContext.evalParameters(String.valueOf(importOption.getValue()), this);
                        String evaluatedOptionValue = this.executionContext.evalParameters(String.valueOf(importOption.getValue()), this);
                        if (evaluatedOptionName.contains("\"") || evaluatedOptionName.contains(",")) {
                            throw new Exception(this.iu.getString("PromoteToDiscoverOperation.Exception.InvalidCharactersName"));
                        }
                        if (importOption.getType() != AdditionalFieldType.STRING && (evaluatedOptionValue.contains("\"") || evaluatedOptionValue.contains(","))) {
                            throw new Exception(this.iu.getString("PromoteToDiscoverOperation.Exception.InvalidCharactersValue"));
                        }
                        switch (importOption.getType()) {
                            case STRING: {
                                optionGraphql = "       " + evaluatedOptionName + ":" + SerializationUtils.toJson((Object)evaluatedOptionValue) + ",";
                                break;
                            }
                            case ENUM: {
                                optionGraphql = "       " + evaluatedOptionName + ":" + evaluatedOptionValue + ",";
                                break;
                            }
                            case BOOLEAN: {
                                optionGraphql = "       " + evaluatedOptionName + ":" + Boolean.parseBoolean(evaluatedOptionValue) + ",";
                                break;
                            }
                            case NUMBER: {
                                optionGraphql = "       " + evaluatedOptionName + ":" + Integer.parseInt(evaluatedOptionValue) + ",";
                                break;
                            }
                            default: {
                                throw new Exception("Field type " + String.valueOf((Object)importOption.getType()) + " has not been implemented.");
                            }
                        }
                        if (optionGraphql.trim().length() <= 0) continue;
                        options.add((CallSite)((Object)optionGraphql));
                    }
                }
                this.evaluatedImportOptions = String.join((CharSequence)"\n", options);
                this.discoverRestClient = new DiscoverRestClient(this.hostname, this.apiToken, (LogChannel)new DummyLogChannel(), this.whitelistedCertificateFingerprints);
                this.discoverRestClient.setOperation(this);
                this.firstImportJob = this.createImportJob(1);
                LOGGER.info("Exporting in parts");
                int addedForExport = 0;
                this.exportPart = 0;
                while (addedForExport < this.itemsInScope.size()) {
                    boolean messageLogged = false;
                    while (this.loadQueue != null && this.loadQueue.size() > 0) {
                        if (!messageLogged) {
                            LOGGER.info("Pausing export until the batch already available is picked up");
                            messageLogged = true;
                        }
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        Thread.sleep(1000L);
                    }
                    if (messageLogged) {
                        LOGGER.info("Resuming export because load batch was picked up");
                    }
                    ArrayList<Item> partProductionSetItems = new ArrayList<Item>();
                    this.exportPartStartPercentage = (double)addedForExport / (double)this.itemsInScope.size();
                    LOGGER.info("Exported in parts: " + addedForExport + " of " + this.itemsInScope.size());
                    ++this.exportPart;
                    int nextItemId = Math.min(addedForExport + this.exportSplitAt, this.itemsInScope.size());
                    partProductionSetItems.addAll(this.itemsInScope.subList(addedForExport, nextItemId));
                    LOGGER.info("Exporting part from " + addedForExport + " to " + (nextItemId - 1));
                    addedForExport = nextItemId;
                    LOGGER.info("Added to export: " + addedForExport);
                    Item lastItem = null;
                    if (partProductionSetItems.size() > 0) {
                        lastItem = (Item)partProductionSetItems.get(partProductionSetItems.size() - 1);
                    }
                    String lastTlGuid = null;
                    Item lastTopLevelItem = null;
                    if (lastItem != null) {
                        lastTopLevelItem = lastItem.getTopLevelItem();
                    }
                    if (lastTopLevelItem != null) {
                        lastTlGuid = lastTopLevelItem.getGuid();
                    }
                    ((Item)partProductionSetItems.get(partProductionSetItems.size() - 1)).getTopLevelItem().getGuid();
                    LOGGER.info("Last TL Guid: " + lastTlGuid);
                    while (this.itemsInScope.size() > addedForExport) {
                        Item nextItem = this.itemsInScope.get(addedForExport);
                        Item nextItemTopLevel = nextItem.getTopLevelItem();
                        String nextTlGuid = null;
                        if (nextItemTopLevel != null) {
                            nextTlGuid = nextItemTopLevel.getGuid();
                        }
                        LOGGER.info("Next TL Guid: " + nextTlGuid);
                        if (lastTlGuid == null || nextTlGuid == null || !lastTlGuid.equals(nextTlGuid)) break;
                        partProductionSetItems.add(nextItem);
                        LOGGER.info("Adding to export, total: " + ++addedForExport + " of " + this.itemsInScope.size());
                    }
                    double trancheEndPercentage = (double)addedForExport / (double)this.itemsInScope.size();
                    this.exportPartSizePercentage = trancheEndPercentage - this.exportPartStartPercentage;
                    LOGGER.info("Exporting part " + this.exportPart);
                    this.addExecutionLog(this.iu.getNumeralFormattedString("General.Log.ExportFolderParts", (long)partProductionSetItems.size(), new Object[]{this.exportFolder, this.exportPart}));
                    long oldItemsFailedCount = this.failedExportItemCount;
                    this.exportItems(this.exportFolder + "/Part" + this.exportPart, this.productionSet, partProductionSetItems);
                    long itemsFailedInPart = this.failedExportItemCount - oldItemsFailedCount;
                    if (itemsFailedInPart <= 0L) continue;
                    this.addWarning(this.iu.getNumeralFormattedString("PromoteToDiscoverOperation.Warning.FailedExportingPartDetailed", itemsFailedInPart, (Object)this.exportPart));
                }
                LOGGER.info("Exported in parts: " + addedForExport + " of " + this.itemsInScope.size());
                if (!this.stopRequested) {
                    this.waitForLoad();
                    if (this.loadItemIdsWithErrors == null) {
                        this.loadItemIdsWithErrors = new HashSet<Integer>();
                    }
                    if (this.loadItemIdsWithErrors.size() > 0 || this.fatalErrorEncountered) {
                        if (this.fatalErrorEncountered) {
                            this.addWarning(this.iu.getNumeralString("LegalExportOperation.Warning.ItemsMoreCouldNotBeLoaded", (long)this.loadItemIdsWithErrors.size()));
                        } else {
                            this.addWarning(this.iu.getNumeralString("LegalExportOperation.Warning.ItemsCouldNotBeLoaded", (long)this.loadItemIdsWithErrors.size()));
                        }
                        if (this.tagFailedItems.booleanValue()) {
                            for (int lineId : this.loadItemIdsWithErrors) {
                                Item failedItem = this.itemsInScope.get(lineId);
                                if (failedItem == null) continue;
                                this.failedItems.add(failedItem);
                            }
                        }
                    }
                    if (this.tagFailedItems.booleanValue() && this.failedItems.size() > 0) {
                        LOGGER.info("Tagging " + this.failedItems.size() + " items with tag " + this.failedItemTagName);
                        BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                        bulkAnnotater.addTag(this.failedItemTagName, this.failedItems);
                        this.addExecutionLog(this.iu.getNumeralFormattedString("LegalExportOperation.Log.Tagged", (long)this.failedItems.size(), (Object)this.failedItemTagName));
                    }
                    if (this.tagFailedItems.booleanValue() && this.untagSuccessfulItems.booleanValue()) {
                        String query = "tag:\"" + this.failedItemTagName + "\" and production-set:\"" + this.productionSetName + "\"";
                        LOGGER.info("Searching: " + query);
                        Set previouslyTaggedItems = this.executionContext.nuixCase.searchUnsorted(query);
                        this.itemsToUntag = this.executionContext.nuixUtilities.getItemUtility().difference((Collection)previouslyTaggedItems, this.failedItems);
                        if (this.itemsToUntag.size() > 0) {
                            LOGGER.info("Untagging " + this.itemsToUntag.size() + " items with tag " + this.failedItemTagName);
                            BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                            bulkAnnotater.removeTag(this.failedItemTagName, this.itemsToUntag);
                            this.addExecutionLog(this.iu.getNumeralFormattedString("LegalExportOperation.Log.Untagged", (long)this.itemsToUntag.size(), (Object)this.failedItemTagName));
                        }
                    }
                } else {
                    this.trackStopped();
                    return;
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void waitForLoad() {
        if (this.loadQueueThread != null) {
            LOGGER.info("Waiting for Discover load thread to complete, queue size: " + this.loadQueue.size());
            try {
                while (this.loadsCompleted.get() < this.loadsQueued.get()) {
                    LOGGER.info("Load queue: " + this.loadQueue.size() + ", Total queued: " + this.loadsQueued.get() + ", Total completed: " + this.loadsCompleted.get());
                    LOGGER.info("Waiting for a load to complete");
                    this.loadsPending.acquire();
                    LOGGER.info("Finished waiting for load to complete");
                    this.loadsCompleted.incrementAndGet();
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted while waiting for Discover upload to complete");
            }
            LOGGER.info("Load queue: " + this.loadQueue.size() + ", Total queued: " + this.loadsQueued.get() + ", Total completed: " + this.loadsCompleted.get());
            LOGGER.info("Loads completed, interrupting Discover load thread");
            this.loadQueueThread.interrupt();
            try {
                this.loadQueueThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.error("Cannot wait for Discover load thread to complete", (Throwable)e);
            }
        }
        this.loadQueueThread = null;
    }

    private void exportItems(String exportFolder, ProductionSet productionSet, List<Item> items) throws Exception {
        Map<String, Object> productOptions;
        BatchExporter batchExporter = this.executionContext.nuixUtilities.createBatchExporter(exportFolder);
        ArrayList<String> stageNames = new ArrayList<String>();
        stageNames.add("work_queue");
        ConfigurationParser configurationParser = new ConfigurationParser();
        if (this.productionProfile != null && this.productionProfile.length() > 0) {
            ProductionProfile productionProfileObject = NuixUtils.getProductionProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.productionProfile);
            if (productionProfileObject != null) {
                this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.ProductionProfile", (Object)this.productionProfile));
                StamperConfiguration stamperConfiguration = productionProfileObject.getStamperConfiguration();
                Map<String, Object> stamperOptions = NuixUtils.buildStamperOptionsFromStamperConfiguration(stamperConfiguration, this.executionContext.nuixCase);
                productionSet.setStampingOptions(stamperOptions);
            } else {
                LOGGER.warn("Cannot use production profile. Does not exist on system");
                this.addWarning(this.iu.getFormattedString("LegalExportOperation.Warning.CannotUseProductionProfile", (Object)this.iu.getFormattedString("General.Warning.ProfileNotExist", (Object)this.productionProfile)));
            }
        }
        if (this.contentNative || this.pageNativeAllDocuments || this.pageNativeSlipSheet) {
            productOptions = configurationParser.getExportProductProperties(LegalExportType.CONCORDANCE.toString(), "native");
            productOptions.put("naming", "guid");
            if (this.mailTypeEnabled.booleanValue()) {
                productOptions.put("mailFormat", this.mailType.toNuixString());
            }
            if (this.exportSchemeEnabled.booleanValue()) {
                productOptions.put("includeAttachments", this.exportScheme == ExportScheme.LEAVE_ATTACHMENTS_ON_EMAILS);
            }
            batchExporter.addProduct("native", productOptions);
            stageNames.add("native");
            stageNames.add("stored_email_fixup");
        }
        if (this.contentText) {
            productOptions = configurationParser.getExportProductProperties(LegalExportType.CONCORDANCE.toString(), "text");
            productOptions.put("naming", "guid");
            batchExporter.addProduct("text", productOptions);
            stageNames.add("text");
        }
        if (this.pagePdf) {
            productOptions = configurationParser.getExportProductProperties(LegalExportType.CONCORDANCE.toString(), "pdf");
            productOptions.put("naming", "guid");
            batchExporter.addProduct("pdf", productOptions);
            stageNames.add("stamping");
            stageNames.add("pdf");
        }
        stageNames.add("file_naming");
        stageNames.add("set_file_times");
        stageNames.add("digest");
        stageNames.add("load_files");
        this.stageNameToId = new HashMap<String, Integer>();
        int id = 0;
        for (String stageName : stageNames) {
            this.stageNameToId.put(stageName, id);
            ++id;
        }
        HashMap<String, Object> loadFileOptions = new HashMap<String, Object>();
        loadFileOptions.put("metadataProfile", null);
        batchExporter.addLoadFile(LegalExportType.EDRM_XML.toNuixString(), loadFileOptions);
        batchExporter.setParallelProcessingSettings(configurationParser.getParallelProcessingLegalExportSettings());
        NuixWorkerUtils.setWorkerSettings(this.executionContext, this, (ParallelProcessingConfigurable)batchExporter, true);
        this.workerMemory = NuixWorkerUtils.getProcessorWorkerMemory((ParallelProcessingConfigurable)batchExporter);
        if (this.imagingProfile != null && this.imagingProfile.length() > 0) {
            ImagingProfile imagingProfileObject = NuixUtils.getImagingProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.imagingProfile);
            if (imagingProfileObject != null) {
                this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.ImagingProfile", (Object)this.imagingProfile));
                productionSet.setImagingProfileObject(imagingProfileObject);
            } else {
                LOGGER.warn("Cannot use imaging profile. Does not exist on system");
                this.addWarning(this.iu.getFormattedString("LegalExportOperation.Warning.CannotUseImagingProfile", (Object)this.iu.getFormattedString("General.Warning.ProfileNotExist", (Object)this.imagingProfile)));
            }
        }
        batchExporter.whenItemEventOccurs(this::itemProcessed);
        if (productionSet.getItems().size() > 0) {
            if (this.stopRequested) {
                this.trackStopped();
                return;
            }
            this.exportProcessingJob = batchExporter.exportItemsAsync(productionSet, items);
            String processingJobGuid = this.exportProcessingJob.getJobGuid().replace("-", "");
            LOGGER.info("Job Guid: " + processingJobGuid);
            NuixWorkerUtils.addRemoteWorkers(this.executionContext, this, (ProcessingJob)this.exportProcessingJob, this.addedWorkerCount);
            NuixUtils.waitForProcessingJobToComplete((ProcessingJob)this.exportProcessingJob);
            if (this.executionState == ExecutionState.STOPPING) {
                this.trackStopped();
            } else {
                DiscoverLoadDetails loadDetails = new DiscoverLoadDetails(exportFolder, this.exportPart, items, this.exportPartSizePercentage, this.exportPartStartPercentage);
                this.queueDiscoverUpload(loadDetails);
            }
        } else {
            this.addWarning(this.iu.getFormattedString("General.Warning.NoItemsWereFoundInProduction", (Object)this.productionSetName));
            LOGGER.warn("No items were found in production " + this.productionSetName);
        }
        try {
            this.failedExportItemCount += this.exportProcessingJob.getFailedItemCount();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot get job failed items", (Throwable)e);
        }
    }

    private void queueDiscoverUpload(DiscoverLoadDetails loadDetails) {
        if (this.loadQueue == null) {
            LOGGER.info("Queuing first load");
            this.loadQueue = new LinkedBlockingQueue<DiscoverLoadDetails>();
        }
        LOGGER.info("Queuing load " + this.exportPart + " with " + loadDetails.items.size() + " items from " + loadDetails.exportFolder);
        this.loadsQueued.incrementAndGet();
        this.loadQueue.add(loadDetails);
        LOGGER.info("Load queue: " + this.loadQueue.size() + ", Total queued: " + this.loadsQueued.get() + ", Total completed: " + this.loadsCompleted.get());
        if (this.loadQueueThread == null) {
            this.loadQueueThread = new Thread(this::discoverLoadWorker);
            this.loadQueueThread.setName("Automate - Operation " + this.getOperationName() + " - Discover Load Queue");
            this.loadQueueThread.start();
        }
    }

    private ImportJob createImportJob(int exportPart) throws ParameterException, IOException {
        return this.discoverRestClient.importJobCreate(this.discoverCaseId, "Automate " + this.productionSetName + " part " + exportPart, this.description, this.levelStrategy, this.level, this.documentsPerLevel, this.runDeduplicationInDiscover, this.runIndexingInDiscover, this.overwriteExistingFilesInDiscover, this.updateGroupCodingInDiscover, this.documentIdType, this.abortExistingDocId, this.fileRepositoryType, this.useDiscoverDateFormat, this.discoverDateFormat, this.useDocumentIdPrefix, this.documentIdPrefix, this.evaluatedImportOptions);
    }

    private void copyFiles(ImportJob importJob, DiscoverLoadDetails loadDetails, Map<String, DocumentMapping> documentsMapping) throws ParameterException {
        PromoteToDiscoverFileCopier promoteToDiscoverFileCopier;
        if (!(this.contentNative || this.pageNativeAllDocuments || this.pageNativeSlipSheet || this.contentText || this.pagePdf)) {
            return;
        }
        this.errorCopyingFiles = new AtomicLong(0L);
        this.exportFolderName = this.executionContext.evalParameters("{export_production_set_name}_{date_time}", this) + "/Part" + loadDetails.exportPart;
        if (this.fileRepositoryType.equals((Object)DiscoverFileRepositoryType.WINDOWS)) {
            this.addExecutionLog(this.iu.getFormattedString("PromoteToDiscoverOperation.Log.CopyToDiscoverFolder", (Object)this.windowsFileRepository));
            promoteToDiscoverFileCopier = new PromoteToDiscoverFileshareFileCopier(this, this.windowsFileRepository);
        } else if (this.fileRepositoryType.equals((Object)DiscoverFileRepositoryType.AMAZON_S3)) {
            this.addExecutionLog(this.iu.getFormattedString("PromoteToDiscoverOperation.Log.CopyToS3", (Object)importJob.getFileTransferLocationInformation().getBucketName()));
            Regions clientRegion = Regions.fromName((String)importJob.getFileTransferLocationInformation().getRegionEndpoint());
            String bucketName = importJob.getFileTransferLocationInformation().getBucketName();
            BasicSessionCredentials awsCredentials = new BasicSessionCredentials(importJob.getFileTransferLocationInformation().getAccessKey(), importJob.getFileTransferLocationInformation().getSecretAccessKey(), importJob.getFileTransferLocationInformation().getToken());
            AmazonS3 s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials))).withRegion(clientRegion)).build();
            promoteToDiscoverFileCopier = new PromoteToDiscoverS3FileCopier(this, importJob, bucketName, s3Client);
        } else {
            throw new IllegalArgumentException("Unsupported FileRepository " + String.valueOf((Object)this.fileRepositoryType));
        }
        ((Stream)loadDetails.items.stream().parallel()).forEach(item -> {
            if (this.stopRequested) {
                return;
            }
            promoteToDiscoverFileCopier.copyItemFiles((Item)item, importJob, loadDetails, documentsMapping);
        });
        if (this.errorCopyingFiles.get() > 0L) {
            this.addWarning(this.iu.getNumeralFormattedString("PromoteToDiscoverOperation.Warning.FailedCopyingPartDetailed", this.errorCopyingFiles.get(), (Object)loadDetails.exportPart));
        }
    }

    private Map<String, DocumentMapping> getItemsFiles(DiscoverLoadDetails loadDetails) throws IOException {
        String loadfilePath = loadDetails.exportFolder + "/loadfile.xml";
        HashMap<String, DocumentMapping> documentsMapping = new HashMap<String, DocumentMapping>();
        Root loadfileRoot = (Root)Serializer.instance().deserialize(new File(loadfilePath));
        for (Document document : loadfileRoot.getBatch().getDocuments()) {
            DocumentMapping documentMapping = new DocumentMapping();
            documentMapping.setDocId(document.getDocId());
            if (document.getFiles() != null) {
                for (com.nuix.automate.workflow.core.nuix.loadfile.edrm.File file : document.getFiles()) {
                    ExternalFile externalFile = file.getExternalFile();
                    String path = externalFile.getFilePath() + "/" + externalFile.getFileName();
                    Path filePath = Paths.get(loadDetails.exportFolder + "/" + path, new String[0]);
                    if (documentMapping.getGuid() == null) {
                        String[] splits = externalFile.getFileName().split("\\.");
                        String docId = splits[0];
                        documentMapping.setGuid(docId);
                    }
                    if (!filePath.toFile().exists()) {
                        LOGGER.warn("File " + filePath.toFile().getAbsolutePath() + " does not exist");
                        path = null;
                    }
                    switch (file.getFileType()) {
                        case "Native": {
                            documentMapping.setNativePath(path);
                            break;
                        }
                        case "Text": {
                            documentMapping.setTextPath(path);
                            break;
                        }
                        case "Image": {
                            documentMapping.addImagePath(path);
                        }
                    }
                }
                if (documentMapping.getGuid() != null) {
                    documentsMapping.put(documentMapping.getGuid(), documentMapping);
                }
            }
            this.loadItemsProcessedInStage.incrementAndGet();
        }
        return documentsMapping;
    }

    private void extractMetadata(DiscoverLoadDetails loadDetails, Map<String, DocumentMapping> documentsMapping) throws IOException {
        String profileName;
        String profilePath;
        MetadataProfile discoverMetadataProfile;
        block31: {
            discoverMetadataProfile = null;
            profilePath = null;
            profileName = "discover-standard-metadata-" + FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC));
            if (this.exportStandardMetadata.booleanValue()) {
                LOGGER.info("Extracting metadata from Discover Profile");
                profilePath = String.valueOf(this.executionContext.nuixCase.getLocation()) + "/Stores/User Data/Metadata Profiles/" + profileName + ".profile";
                LOGGER.info("Writing temporary profile " + profilePath);
                try (InputStream templateStream = this.getClass().getClassLoader().getResourceAsStream("com/nuix/export/legal/discover/Discover Export.profile");
                     OutputStream outputStream = Files.newOutputStream(Paths.get(profilePath, new String[0]), new OpenOption[0]);){
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = templateStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                    }
                    outputStream.flush();
                    discoverMetadataProfile = this.executionContext.nuixCase.getMetadataProfileStore().getMetadataProfile(profileName);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot get Discover metadata profile", (Throwable)e);
                    if (!this.discoverMetadataProfileExpected) break block31;
                    throw new IOException("Cannot get Discover metadata profile", e);
                }
            }
        }
        LOGGER.info("Evaluating metadata");
        for (Item item : loadDetails.items) {
            boolean itemFailed = false;
            DocumentMapping itemMapping = documentsMapping.get(item.getGuid());
            if (itemMapping == null) {
                itemMapping = new DocumentMapping();
                itemMapping.setGuid(item.getGuid());
                documentsMapping.put(itemMapping.getGuid(), itemMapping);
            }
            HashMap<String, Object> fields = new HashMap<String, Object>();
            itemMapping.setFields(fields);
            if ((this.contentNative || this.pageNativeAllDocuments || this.pageNativeSlipSheet) && itemMapping.getNativePath() == null) {
                this.failedItems.add(item);
                LOGGER.warn("Missing Native file for item " + item.getGuid());
                itemFailed = true;
            }
            if (this.contentText && itemMapping.getTextPath() == null) {
                this.failedItems.add(item);
                LOGGER.warn("Missing Text file for item " + item.getGuid());
                itemFailed = true;
            }
            if (this.pagePdf && itemMapping.getImagePaths() == null) {
                this.failedItems.add(item);
                LOGGER.warn("Missing image files for item " + item.getGuid());
                itemFailed = true;
            }
            if (this.exportStandardMetadata.booleanValue() && discoverMetadataProfile != null) {
                for (MetadataItem metadataItem : discoverMetadataProfile.getMetadata()) {
                    try {
                        fields.put(metadataItem.getName(), this.getMultiValue(metadataItem, item));
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot evaluate metadata " + metadataItem.getName() + " for item " + item.getGuid());
                        this.failedItems.add(item);
                        itemFailed = true;
                    }
                }
            }
            if (this.metadataProfileEnabled.booleanValue() && this.customMetadataProfile != null) {
                for (MetadataItem metadataItem : this.customMetadataProfile.getMetadata()) {
                    try {
                        fields.put(metadataItem.getName(), this.getMultiValue(metadataItem, item));
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot evaluate custom metadata " + metadataItem.getName() + " for item " + item.getGuid());
                        this.failedItems.add(item);
                        itemFailed = true;
                    }
                }
            }
            if (itemFailed) {
                ++loadDetails.failedItems;
            }
            this.loadItemsProcessedInStage.incrementAndGet();
            String stage = "extract_metadata";
            String mimeType = item.getType().getName();
            this.itemHandled(mimeType, stage, null, itemFailed);
        }
        if (this.exportStandardMetadata.booleanValue() && profilePath != null) {
            LOGGER.info("Moving profile profile " + profilePath);
            Files.move(Paths.get(profilePath, new String[0]), Paths.get(loadDetails.exportFolder + "/" + profileName + ".profile", new String[0]), new CopyOption[0]);
        }
    }

    private Object getMultiValue(MetadataItem metadataItem, Item item) {
        try {
            Object unformattedValue = metadataItem.evaluateUnformatted(item);
            if (unformattedValue instanceof Object[]) {
                Object[] array = (Object[])unformattedValue;
                ArrayList<String> multiValue = new ArrayList<String>();
                for (Object value : array) {
                    multiValue.add(String.valueOf(value));
                }
                return multiValue;
            }
            String formattedValue = metadataItem.evaluate(item);
            if (formattedValue.startsWith("[")) {
                try {
                    Object decodedMultiValue = SerializationUtils.fromJson((String)formattedValue);
                    if (decodedMultiValue instanceof Collection) {
                        ArrayList<String> multiValue = new ArrayList<String>();
                        for (Object value : (Collection)decodedMultiValue) {
                            multiValue.add(String.valueOf(value));
                        }
                        return multiValue;
                    }
                }
                catch (JsonSyntaxException e) {
                    return formattedValue;
                }
            }
            return formattedValue;
        }
        catch (Exception e) {
            return FormattingUtils.getExceptionPrintableMessage((Exception)e);
        }
    }

    private void uploadToDiscover(DiscoverLoadDetails loadDetails) throws ParameterException, IOException, InterruptedException {
        ImportJob importJob;
        this.loadStageName = "initializeJob";
        this.loadItemsProcessedInStage = null;
        if (loadDetails.exportPart == 1) {
            if (this.firstImportJob == null) {
                this.firstImportJob = this.createImportJob(1);
            }
            importJob = this.firstImportJob;
        } else {
            importJob = this.createImportJob(loadDetails.exportPart);
        }
        this.loadStageName = "mapItemsToFiles";
        this.loadItemsProcessedInStage = new AtomicLong(0L);
        Map<String, DocumentMapping> documentsMapping = this.getItemsFiles(loadDetails);
        this.loadStageName = "copyFiles";
        this.loadItemsProcessedInStage = new AtomicLong(0L);
        this.copyFiles(importJob, loadDetails, documentsMapping);
        this.loadStageName = "extractMetadata";
        this.loadItemsProcessedInStage = new AtomicLong(0L);
        this.extractMetadata(loadDetails, documentsMapping);
        this.loadStageName = "submitMetadata";
        this.loadItemsProcessedInStage = null;
        DateTimeZone caseDateTimeZone = DateTimeZone.forID((String)this.executionContext.nuixCase.getInvestigationTimeZone());
        DiscoverExportOptions exportOptions = new DiscoverExportOptions(this.contentNative, this.contentText, this.pagePdf, this.pageNativeAllDocuments, this.pageNativeSlipSheet);
        this.loadItemsProcessedInStage = new AtomicLong(0L);
        this.discoverRestClient.addDocumentsForImportJob(this.loadItemsProcessedInStage, this.discoverCaseId, importJob.getRdxJobId(), this.productionSet, loadDetails.items, documentsMapping, this.exportFolderName, loadDetails.exportFolder, this.fileRepositoryType, this.levelStrategy, caseDateTimeZone, exportOptions, this::itemHandled);
        documentsMapping.clear();
        this.loadStageName = "submitJob";
        this.loadItemsProcessedInStage = null;
        int rpfJobId = this.discoverRestClient.submitImportJob(this.discoverCaseId, importJob.getRdxJobId());
        this.addExecutionLog(this.iu.getFormattedString("PromoteToDiscoverOperation.Log.SubmittedJob", (Object)("" + rpfJobId)));
        if (this.waitForDiscoverJobToFinish) {
            this.loadStageName = "waitForJob";
            this.loadItemsProcessedInStage = null;
            this.addExecutionLog(this.iu.getFormattedString("PromoteToDiscoverOperation.Log.WaitForJob", (Object)("" + rpfJobId)));
            while (true) {
                if (this.stopRequested) {
                    return;
                }
                Job jobStatus = this.discoverRestClient.getRpfJobStatus(rpfJobId);
                if (jobStatus.getDateFinished() != null) {
                    LOGGER.info("Job Finished");
                    if (jobStatus.getStatus().startsWith("Succeeded")) {
                        this.addExecutionLog(this.iu.getFormattedString("PromoteToDiscoverOperation.Log.RpfJobSucceeded", (Object)rpfJobId));
                        break;
                    }
                    throw new IOException(this.iu.getFormattedString("PromoteToDiscoverOperation.Log.RpfJobError", new Object[]{rpfJobId, jobStatus.getUserPrintableStatus()}));
                }
                this.currentLoadStage = null;
                for (Stage stage : jobStatus.getStages()) {
                    if (!stage.getStatus().equals("Active")) continue;
                    this.currentLoadStage = stage.getUserPrintableStageName();
                }
                Thread.sleep(1000L);
            }
        }
        this.loadStageName = null;
        this.loadItemsProcessedInStage = null;
    }

    private void cleanUpNativeFiles(DiscoverLoadDetails loadDetails) {
        LOGGER.info("Deleting native files for export part " + loadDetails.exportPart);
        if (this.contentNative || this.pageNativeAllDocuments || this.pageNativeSlipSheet) {
            try {
                FileUtils.deleteDirectory((File)Paths.get(this.exportFolder, "/Part" + loadDetails.exportPart, "NATIVE").toFile());
            }
            catch (IOException e) {
                LOGGER.warn("Cannot delete NATIVE folder", (Throwable)e);
            }
        }
        if (this.contentText) {
            try {
                FileUtils.deleteDirectory((File)Paths.get(this.exportFolder, "/Part" + loadDetails.exportPart, "TEXT").toFile());
            }
            catch (IOException e) {
                LOGGER.warn("Cannot delete TEXT folder", (Throwable)e);
            }
        }
        if (this.pagePdf) {
            try {
                FileUtils.deleteDirectory((File)Paths.get(this.exportFolder, "/Part" + loadDetails.exportPart, "PDF").toFile());
            }
            catch (IOException e) {
                LOGGER.warn("Cannot delete PDF folder", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverLoadWorker() {
        int previousTotalItemsLoadedIntoDiscover = 0;
        block11: while (true) {
            if (this.stopRequested) {
                this.trackStopped();
                return;
            }
            try {
                this.currentDiscoverLoadDetails = this.loadQueue.take();
            }
            catch (InterruptedException e) {
                LOGGER.info("Received interrupt while waiting for queue");
                return;
            }
            this.loadPart = this.currentDiscoverLoadDetails.exportPart;
            try {
                HashSet<String> uploadErrors = new HashSet<String>();
                int effectiveUploadTries = 1;
                if (this.retryFailedExports.booleanValue()) {
                    effectiveUploadTries = this.retryFailedExportsCount + 1;
                }
                int uploadAttempt = 0;
                while (true) {
                    if (uploadAttempt >= effectiveUploadTries) continue block11;
                    Object attemptText = "";
                    if (uploadAttempt > 0) {
                        attemptText = ", retry attempt #" + uploadAttempt;
                    }
                    LOGGER.info("Starting loading part " + this.loadPart + " to Discover" + (String)attemptText);
                    try {
                        this.uploadToDiscover(this.currentDiscoverLoadDetails);
                        previousTotalItemsLoadedIntoDiscover += this.currentDiscoverLoadDetails.items.size();
                        for (String uploadError : uploadErrors) {
                            this.addTransientWarning(uploadError, true);
                        }
                        LOGGER.info("Completed loading part " + this.loadPart + " to Discover" + (String)attemptText);
                        this.cleanUpNativeFiles(this.currentDiscoverLoadDetails);
                        continue block11;
                    }
                    catch (InterruptedException e) {
                        LOGGER.info("Received interrupt while waiting for load to complete");
                        if (this.currentDiscoverLoadDetails.failedItems > 0) {
                            this.addWarning(this.iu.getNumeralFormattedString("PromoteToDiscoverOperation.Warning.FailedUploadingPartDetailed", (long)this.currentDiscoverLoadDetails.failedItems, (Object)this.currentDiscoverLoadDetails.exportPart));
                        }
                        this.currentDiscoverLoadDetails.items.clear();
                        this.currentDiscoverLoadDetails = null;
                        this.loadsPending.release();
                        LOGGER.info("Finished loading part " + this.loadPart + " to Discover");
                        return;
                    }
                    catch (Exception e) {
                        try {
                            if (this.executionState != ExecutionState.STOPPED) {
                                String uploadError;
                                LOGGER.warn("Error loading part " + this.loadPart + " to Discover" + (String)attemptText, (Throwable)e);
                                this.firstImportJob = null;
                                uploadError = this.iu.getFormattedString("PromoteToDiscoverOperation.Warning.LoadingToDiscoverEncounteredError", new Object[]{this.loadPart, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)});
                                uploadErrors.add(uploadError);
                                this.addTransientWarning(uploadError, false);
                                if (uploadAttempt == effectiveUploadTries - 1) {
                                    throw e;
                                }
                            }
                            ++uploadAttempt;
                            continue;
                        }
                        catch (Exception e2) {
                            this.failedItems.addAll(this.currentDiscoverLoadDetails.items);
                            this.currentDiscoverLoadDetails.failedItems = this.currentDiscoverLoadDetails.items.size();
                            continue block11;
                        }
                    }
                    break;
                }
            }
            finally {
                if (this.currentDiscoverLoadDetails.failedItems > 0) {
                    this.addWarning(this.iu.getNumeralFormattedString("PromoteToDiscoverOperation.Warning.FailedUploadingPartDetailed", (long)this.currentDiscoverLoadDetails.failedItems, (Object)this.currentDiscoverLoadDetails.exportPart));
                }
                this.currentDiscoverLoadDetails.items.clear();
                this.currentDiscoverLoadDetails = null;
                this.loadsPending.release();
                LOGGER.info("Finished loading part " + this.loadPart + " to Discover");
                continue;
            }
            break;
        }
    }

    @Override
    protected void stopTriggered() {
        LOGGER.info("Stop triggered");
        Thread thread = new Thread(() -> {
            while (this.executionState == ExecutionState.STOPPING) {
                try {
                    if (this.exportProcessingJob != null) {
                        LOGGER.info("Sending stop command while job is in state " + this.exportProcessingJob.getCurrentStage());
                        this.exportProcessingJob.stop();
                    }
                }
                catch (LicenceException e) {
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot stop job");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        thread.setName("Automate - Operation " + this.getOperationName() + " Stop request");
        thread.start();
    }

    @Override
    public synchronized void updateState() {
        if (this.exportProcessingJob != null) {
            if (!this.isPaused && this.exportProcessingJob.hasPaused()) {
                this.isPaused = true;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", false);
            }
            if (this.isPaused && !this.exportProcessingJob.hasPaused()) {
                this.isPaused = false;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", true);
            }
            if (this.exportProcessingJob.hasFinished() && this.executionState == ExecutionState.STOPPING) {
                this.trackStopped();
            }
        }
    }

    @Override
    protected double getPercentageComplete() {
        double partLoadPercentage;
        double totalExportPercentage;
        block12: {
            double stageExportPercentageComplete;
            double partExportPercentage;
            block11: {
                partExportPercentage = 0.0;
                if (this.exportProcessingJob != null) {
                    try {
                        int stageCount = this.stageNameToId.size();
                        int currentStage = 0;
                        long itemsExported = 0L;
                        long itemsCount = this.exportProcessingJob.getTotalItemCount();
                        String exportStage = this.exportProcessingJob.getCurrentStage().toLowerCase();
                        if (this.stageNameToId.containsKey(exportStage)) {
                            currentStage = this.stageNameToId.get(exportStage);
                        }
                        itemsExported = this.exportProcessingJob.getCurrentStageExportedItemsCount();
                        stageExportPercentageComplete = 0.0;
                        if (itemsCount > 0L) {
                            stageExportPercentageComplete = (double)itemsExported / (double)itemsCount;
                        }
                        partExportPercentage = (stageExportPercentageComplete + (double)currentStage) / (double)stageCount;
                    }
                    catch (Exception e) {
                        if (!LOGGER.isDebugEnabled()) break block11;
                        LOGGER.debug("Cannot get progress.", (Throwable)e);
                    }
                }
            }
            totalExportPercentage = partExportPercentage * this.exportPartSizePercentage + this.exportPartStartPercentage;
            partLoadPercentage = 0.0;
            if (this.loadStageName != null && this.currentDiscoverLoadDetails != null) {
                try {
                    int stageCount = this.loadStageNameToId.size();
                    int currentStage = 0;
                    if (this.loadStageNameToId.containsKey(this.loadStageName)) {
                        currentStage = this.loadStageNameToId.get(this.loadStageName);
                    }
                    int itemsCount = this.currentDiscoverLoadDetails.items.size();
                    stageExportPercentageComplete = 0.0;
                    if (itemsCount > 0 && this.loadItemsProcessedInStage != null) {
                        stageExportPercentageComplete = (double)this.loadItemsProcessedInStage.get() / (double)itemsCount;
                    }
                    partLoadPercentage = (stageExportPercentageComplete + (double)currentStage) / (double)stageCount;
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block12;
                    LOGGER.debug("Cannot get progress.", (Throwable)e);
                }
            }
        }
        double totalLoadPercentage = 0.0;
        if (this.currentDiscoverLoadDetails != null) {
            totalLoadPercentage = partLoadPercentage * this.currentDiscoverLoadDetails.partSizePercentage + this.currentDiscoverLoadDetails.partStartPercentage;
        }
        double percentageComplete = (totalExportPercentage + totalLoadPercentage) / 2.0;
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result;
        block15: {
            result = "";
            double percentageComplete = -1.0;
            percentageComplete = this.getNormalizedPercentageComplete();
            if (!Double.isNaN(percentageComplete)) {
                result = String.format("%.2f%%", percentageComplete * 100.0);
            }
            if (this.exportProcessingJob != null) {
                try {
                    Object exportStage = "";
                    if (!this.exportProcessingJob.hasFinished() || this.executionState == ExecutionState.STOPPED) {
                        if (this.exportPart > 0) {
                            exportStage = this.iu.getFormattedString("General.Progress.Part", (Object)this.exportPart);
                        }
                        try {
                            exportStage = (String)exportStage + FormattingUtils.stageToString((String)this.exportProcessingJob.getCurrentStage().toLowerCase());
                        }
                        catch (Exception e) {
                            exportStage = (String)exportStage + this.iu.getString("General.Progress.Discovering");
                        }
                        exportStage = (String)exportStage + this.iu.getNumeralString("General.Progress.ItemsProcessed", this.exportProcessingJob.getCurrentStageExportedItemsCount());
                    } else {
                        exportStage = "";
                    }
                    if (this.loadStageName != null) {
                        Object loadStage = this.iu.getFormattedString("General.Progress.Part", (Object)this.loadPart);
                        loadStage = (String)loadStage + this.iu.getString("PromoteToDiscover.Progress.Stage." + this.loadStageName);
                        if (this.loadItemsProcessedInStage != null) {
                            loadStage = (String)loadStage + this.iu.getNumeralString("General.Progress.ItemsProcessed", this.loadItemsProcessedInStage.get());
                        }
                        if (this.loadStageName.equals("waitForJob") && this.currentLoadStage != null) {
                            loadStage = (String)loadStage + " " + this.currentLoadStage;
                        }
                        exportStage = ((String)exportStage).length() > 0 ? (String)loadStage + " | " + (String)exportStage : loadStage;
                    }
                    if (((String)result).length() > 0 && ((String)exportStage).length() > 0) {
                        result = (String)result + " / ";
                    }
                    result = (String)result + (String)exportStage;
                }
                catch (Exception e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Cannot get job stage.", (Throwable)e);
                    }
                    break block15;
                }
            }
            String exportStage = this.iu.getString("General.Progress.Initializing");
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + exportStage;
        }
        return result;
    }

    @Override
    public String getUtilizationScopeQuery() {
        Object query = "production-set:\"" + this.productionSetName + "\"";
        query = NuixUtils.addAndQuery((String)query, "has-exclusion:0");
        return query;
    }

    @Override
    public String getProcessingJobGuid() {
        if (this.exportProcessingJob != null) {
            return this.exportProcessingJob.getJobGuid();
        }
        return null;
    }

    public void itemProcessed(ItemEventInfo itemEventInfo) {
        this.trackIncrementVolumeProcessed(itemEventInfo.getItem().getAuditedSize());
        Item processedItem = itemEventInfo.getItem();
        String mimeType = "unknown";
        String pathName = "N/A";
        if (processedItem != null) {
            pathName = String.join((CharSequence)"/", processedItem.getPathNames());
            mimeType = processedItem.getType().getName();
        }
        String stage = itemEventInfo.getStage() == null ? "exported" : itemEventInfo.getStage();
        String translatedStage = this.iu.getString("MimeType.Stage." + stage);
        this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.ExportedStage", new Object[]{translatedStage, pathName}));
        this.trackItemProcessedFailed(mimeType, stage, itemEventInfo.getFailure() != null);
        if (this.tagFailedItems.booleanValue() && itemEventInfo.getFailure() != null) {
            this.failedItems.add(itemEventInfo.getItem());
        }
    }

    public void itemHandled(String mimeType, String stage, String pathName, boolean failure) {
        if (pathName != null) {
            String translatedStage = this.iu.getString("MimeType.Stage." + stage);
            this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.ExportedStage", new Object[]{translatedStage, pathName}));
        }
        if (mimeType != null) {
            this.trackItemProcessedFailed(mimeType, stage, failure);
        }
    }

    @Override
    public Consumption getOperationConsumption() {
        Consumption consumption = new Consumption();
        ConsumptionEvent consumptionEvent = new ConsumptionEvent();
        consumptionEvent.setConsumptionEventId(UidUtils.getRandom());
        consumptionEvent.setLicenseId(this.executionContext.licenceSession.getLicenceInfo().getId());
        consumptionEvent.setConsumptionStartEpoch(this.startDateTime.getMillis());
        if (this.finishedDateTime != null) {
            consumptionEvent.setConsumptionEndEpoch(this.finishedDateTime.getMillis());
        } else {
            consumptionEvent.setConsumptionEndEpoch(this.startDateTime.getMillis());
        }
        consumptionEvent.setPlatformType(ConsumptionPlatformType.NUIX_DISCOVER);
        consumptionEvent.setPlatformId(this.hostname);
        consumptionEvent.setConsumptionType(ConsumptionType.DATA_LOADED);
        consumptionEvent.setUnitType(UnitType.AUDITED_BYTES);
        consumptionEvent.setUnits(this.itemsVolume);
        consumptionEvent.setResourceType(ResourceType.NUIX_DISCOVER_CASE_ID);
        consumptionEvent.setResourceId("" + this.discoverCaseId);
        if (this.executionContext.getEngine() != null) {
            consumptionEvent.setJobId(this.executionContext.getEngine().getJobId());
        }
        consumption.add(consumptionEvent);
        return consumption;
    }

    @Override
    public Integer getWorkerMemory() {
        if (this.executionContext.workflowBrokerWorkersCount <= 0) {
            return null;
        }
        return this.workerMemory;
    }

    @Override
    public Integer getAddedWorkerCount() {
        if (this.addedWorkerCount == null) {
            return 0;
        }
        return this.addedWorkerCount.get();
    }
}

