/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.graphapi.Group;
import com.nuix.automate.utils.models.internal.graphapi.MicrosoftGraphObject;
import com.nuix.automate.utils.models.internal.graphapi.Site;
import com.nuix.automate.utils.models.internal.graphapi.Team;
import com.nuix.automate.utils.models.internal.purview.Custodian;
import com.nuix.automate.utils.models.internal.purview.DataSource;
import com.nuix.automate.utils.models.internal.purview.DataSourceContainerStatus;
import com.nuix.automate.utils.models.internal.purview.DataSourceType;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.PurviewAddCustodialDataSourcesOperation;
import com.nuix.automate.workflow.core.execution.options.purview.CustodialDataSourceSubmission;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.Partitioner;
import org.openimaj.util.parallel.partition.RangePartitioner;

public class PurviewAddCustodialDataSourcesOperationImplementation
extends PurviewAddCustodialDataSourcesOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PurviewAddCustodialDataSourcesOperation.class);
    private transient double stageId;
    private transient double stageCount;
    private transient long stageItems;
    private transient AtomicLong processedItems;

    @Override
    public void startTriggered() {
        this.stageCount = 4.0;
        this.stageId = 0.0;
        this.runStartTriggeredThread(() -> {
            this.initialize();
            this.stageName = this.iu.getString("PurviewAddCustodialDataSourcesOperation.Stage.PreparingCustodialDataSources");
            ArrayList<CustodialDataSourceSubmission> custodialDataSources = new ArrayList<CustodialDataSourceSubmission>();
            if (this.useCustodialDataSourcesFile) {
                this.custodialDataSourcesFileLocation = this.executionContext.evalParameters(this.custodialDataSourcesFileLocation, this);
                this.addExecutionLog(this.iu.getFormattedString("PurviewAddCustodialDataSourcesOperation.Log.CustodialDataSourcesFile", (Object)this.custodialDataSourcesFileLocation));
                custodialDataSources.addAll(this.readCustodialDataSourcesFile(this.custodialDataSourcesFileLocation));
            } else {
                custodialDataSources.addAll(this.custodialDataSources);
            }
            if (custodialDataSources.isEmpty()) {
                this.addWarning(this.iu.getString("PurviewAddCustodialDataSourcesOperation.Log.NoCustodialDataSources"));
                return;
            }
            HashSet<String> userEmails = new HashSet<String>();
            for (CustodialDataSourceSubmission custodialDataSourceSubmission : custodialDataSources) {
                this.normalizeCustodialDataSourceSubmission(custodialDataSourceSubmission);
                if (custodialDataSourceSubmission.getCustodianEmail() != null) {
                    userEmails.add(custodialDataSourceSubmission.getCustodianEmail());
                }
                if (custodialDataSourceSubmission.getType() != DataSourceType.USER || custodialDataSourceSubmission.getValue() == null) continue;
                userEmails.add(custodialDataSourceSubmission.getValue());
            }
            HashMap<String, String> emailToNormalizedEmail = new HashMap<String, String>();
            try {
                LOGGER.info("Normalizing " + userEmails.size() + " user emails");
                emailToNormalizedEmail.putAll(this.purviewRestClient.normalizeUserEmails(userEmails));
            }
            catch (IOException e) {
                LOGGER.error("Error normalizing userEmails", (Throwable)e);
                this.addWarning(this.iu.getFormattedString("PurviewAddCustodialDataSourcesOperation.Warning.CannotNormalizeUserEmails", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
            }
            ConcurrentHashMap.KeySetView custodianEmails = ConcurrentHashMap.newKeySet();
            for (CustodialDataSourceSubmission custodialDataSourceSubmission : custodialDataSources) {
                String userEmail;
                String custodianEmail = custodialDataSourceSubmission.getCustodianEmail();
                if (custodianEmail != null) {
                    String normalizedEmail = emailToNormalizedEmail.getOrDefault(custodianEmail, custodianEmail);
                    custodialDataSourceSubmission.setCustodianEmail(normalizedEmail);
                    custodianEmails.add(normalizedEmail);
                    if (!custodianEmail.equals(normalizedEmail)) {
                        LOGGER.info("Normalized " + custodianEmail + " to " + normalizedEmail);
                    }
                }
                if (custodialDataSourceSubmission.getType() != DataSourceType.USER || (userEmail = custodialDataSourceSubmission.getValue()) == null) continue;
                String normalizedEmail = emailToNormalizedEmail.getOrDefault(userEmail, userEmail);
                custodialDataSourceSubmission.setValue(normalizedEmail);
                if (userEmail.equals(normalizedEmail)) continue;
                LOGGER.info("Normalized " + userEmail + " to " + normalizedEmail);
            }
            ConcurrentHashMap existingCustodians = new ConcurrentHashMap();
            ConcurrentHashMap existingCustodianDataSources = new ConcurrentHashMap();
            ConcurrentHashMap.KeySetView custodiansWithSiteSources = ConcurrentHashMap.newKeySet();
            LOGGER.info("Listing existing case custodians");
            List<Custodian> caseCustodians = this.purviewRestClient.getCustodians(this.purviewCaseId);
            Parallel.forEachPartitioned((Partitioner)new RangePartitioner(caseCustodians, this.parallelThreads), iterator -> {
                while (iterator.hasNext() && !this.stopRequested) {
                    Custodian existingCustodian = (Custodian)iterator.next();
                    LOGGER.info("Existing custodian: " + String.valueOf(existingCustodian));
                    if (!custodianEmails.contains(existingCustodian.getEmail())) continue;
                    ConcurrentHashMap<String, DataSource> existingDataSource = new ConcurrentHashMap<String, DataSource>();
                    existingCustodianDataSources.put(existingCustodian.getEmail(), existingDataSource);
                    existingCustodians.put(existingCustodian.getEmail(), existingCustodian);
                    LOGGER.info("Getting data sources for custodian: " + String.valueOf(existingCustodian));
                    try {
                        for (DataSource dataSource : this.purviewRestClient.getAllDataSourcesForCustodian(this.purviewCaseId, existingCustodian.getId())) {
                            String siteUrl;
                            String value = dataSource.getDataSourceValue();
                            if (value != null) {
                                existingDataSource.put(value, dataSource);
                            }
                            if ((siteUrl = this.getUserUnifiedSourceWebUrl(dataSource)) != null) {
                                existingDataSource.putIfAbsent(siteUrl, dataSource);
                            }
                            if (dataSource.getSourceType() != DataSourceType.SITE) continue;
                            custodiansWithSiteSources.add(existingCustodian.getEmail());
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error getting existing data sources for custodian " + existingCustodian.getEmail(), (Throwable)e);
                    }
                }
            }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
            if (this.stopRequested) {
                throw new WorkflowExecutionStopRequested();
            }
            this.stageId = 1.0;
            this.stageName = this.iu.getString("PurviewAddCustodialDataSourcesOperation.Stage.AddingCustodialDataSources");
            this.stageItems = custodianEmails.size();
            this.processedItems = new AtomicLong();
            this.consumptionCustodianIds = ConcurrentHashMap.newKeySet();
            long custodianExistsCount = existingCustodians.size();
            AtomicLong custodianAddedCount = new AtomicLong();
            AtomicLong custodianActivatedCount = new AtomicLong();
            AtomicLong failedToAddCustodiansCount = new AtomicLong();
            LOGGER.info("Handling new custodians");
            Parallel.forEachPartitioned((Partitioner)new RangePartitioner(custodianEmails, this.parallelThreads), iterator -> {
                while (iterator.hasNext()) {
                    String custodianEmail = (String)iterator.next();
                    try {
                        Custodian custodian;
                        if (existingCustodians.containsKey(custodianEmail)) {
                            custodian = (Custodian)existingCustodians.get(custodianEmail);
                            if (custodian.getStatus() != null) {
                                LOGGER.info("Custodian " + custodianEmail + " exists with status " + String.valueOf(custodian.getStatus()));
                            } else {
                                LOGGER.info("Custodian " + custodianEmail + " exists");
                            }
                            if (custodian.getStatus() == DataSourceContainerStatus.RELEASED) {
                                LOGGER.info("Custodian " + custodianEmail + " activating ...");
                                this.purviewRestClient.activateCustodian(this.purviewCaseId, custodian.getId());
                                custodianActivatedCount.getAndIncrement();
                            }
                        } else {
                            custodian = new Custodian();
                            custodian.setEmail(custodianEmail);
                            LOGGER.info("Custodian " + custodianEmail + " does not exist, creating ...");
                            custodian = this.purviewRestClient.createCustodian(this.purviewCaseId, custodian);
                            existingCustodians.put(custodianEmail, custodian);
                            custodianAddedCount.getAndIncrement();
                        }
                        this.consumptionCustodianIds.add(custodian.getId());
                    }
                    catch (Exception e) {
                        this.addWarning(this.iu.getFormattedString("PurviewAddCustodialDataSourcesOperation.Warning.CannotProcessCustodian", new Object[]{custodianEmail, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                        existingCustodians.remove(custodianEmail);
                        failedToAddCustodiansCount.getAndIncrement();
                    }
                    this.processedItems.getAndIncrement();
                }
            }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
            this.addExecutionLog(this.iu.getNumeralString("PurviewAddCustodialDataSourcesOperation.Log.AddedNewCustodians", custodianAddedCount.get()));
            if (custodianActivatedCount.get() > 0L) {
                this.addExecutionLog(this.iu.getNumeralString("PurviewAddCustodialDataSourcesOperation.Log.ActivatedExistingCustodians", custodianActivatedCount.get()));
            }
            if (custodianExistsCount > 0L) {
                this.addExecutionLog(this.iu.getNumeralString("PurviewAddCustodialDataSourcesOperation.Log.FoundExistingCustodians", custodianExistsCount));
            }
            if (failedToAddCustodiansCount.get() > 0L) {
                this.addExecutionLog(this.iu.getNumeralString("PurviewAddCustodialDataSourcesOperation.Log.FailedToAddCustodians", failedToAddCustodiansCount.get()));
            }
            if (this.stopRequested) {
                throw new WorkflowExecutionStopRequested();
            }
            this.stageId = 2.5;
            this.stageName = this.iu.getString("PurviewAddCustodialDataSourcesOperation.Stage.AddingCustodialDataSources");
            AtomicLong dataSourcesAddedCount = new AtomicLong();
            AtomicLong dataSourcesExistCount = new AtomicLong();
            AtomicLong dataSourcesInvalidCount = new AtomicLong();
            AtomicLong failedToAddDataSourcesCount = new AtomicLong();
            ConcurrentHashMap.KeySetView scopeDataSourceIds = ConcurrentHashMap.newKeySet();
            ConcurrentHashMap.KeySetView scopeDataSourceODataIds = ConcurrentHashMap.newKeySet();
            LOGGER.info("Handling custodial data sources");
            HashMap<String, Map> existingDataSourceValues = new HashMap<String, Map>();
            ListIterator<CustodialDataSourceSubmission> custodialDataSourceIterator = custodialDataSources.listIterator();
            int i = 0;
            while (custodialDataSourceIterator.hasNext()) {
                void var26_31;
                CustodialDataSourceSubmission custodialDataSourceSubmission = (CustodialDataSourceSubmission)custodialDataSourceIterator.next();
                LOGGER.info("Handling Custodial Data Source " + String.valueOf(custodialDataSourceSubmission));
                ++i;
                DataSourceType dataSourceType = custodialDataSourceSubmission.getType();
                String custodianEmail = custodialDataSourceSubmission.getCustodianEmail();
                String string = custodialDataSourceSubmission.getValue();
                boolean invalid = false;
                boolean exists = false;
                if (dataSourceType == null) {
                    this.addWarning(this.iu.getFormattedString("PurviewAddCustodialDataSourcesOperation.Warning.InvalidCustodialDataSourceType", (Object)i));
                    invalid = true;
                }
                if (custodianEmail == null || custodianEmail.trim().isEmpty()) {
                    this.addWarning(this.iu.getFormattedString("PurviewAddCustodialDataSourcesOperation.Warning.InvalidCustodialDataSourceCustodianEmail", (Object)i));
                    invalid = true;
                }
                if (dataSourceType == DataSourceType.UNIFIED_GROUP && !custodialDataSourceSubmission.getIncludeMailbox() && !custodialDataSourceSubmission.getIncludeSite()) {
                    this.addWarning(this.iu.getFormattedString("PurviewAddCustodialDataSourcesOperation.Warning.InvalidCustodialDataSourceIncludedSources", (Object)i));
                    invalid = true;
                }
                if (dataSourceType == DataSourceType.USER && (string == null || string.trim().isEmpty())) {
                    String string2 = custodianEmail;
                }
                if (var26_31 == null || var26_31.trim().isEmpty()) {
                    this.addWarning(this.iu.getFormattedString("PurviewAddCustodialDataSourcesOperation.Warning.InvalidCustodialDataSourceValue", (Object)i));
                    invalid = true;
                }
                if (invalid) {
                    dataSourcesInvalidCount.getAndIncrement();
                } else {
                    String string3 = var26_31.trim();
                    Map custodianDataSourceValues = existingDataSourceValues.computeIfAbsent(custodianEmail.trim(), k -> new HashMap());
                    Set<String> valueSources = (Set)custodianDataSourceValues.get(string3);
                    if (valueSources == null) {
                        valueSources = new HashSet<String>();
                        custodianDataSourceValues.put(string3, valueSources);
                        if (custodialDataSourceSubmission.getIncludeMailbox()) {
                            valueSources.add("mailbox");
                        }
                        if (custodialDataSourceSubmission.getIncludeSite()) {
                            valueSources.add("site");
                        }
                    } else {
                        if (custodialDataSourceSubmission.getIncludeMailbox() && !valueSources.add("mailbox")) {
                            custodialDataSourceSubmission.setIncludeMailbox(false);
                        }
                        if (custodialDataSourceSubmission.getIncludeSite() && !valueSources.add("site")) {
                            custodialDataSourceSubmission.setIncludeSite(false);
                        }
                        if (!custodialDataSourceSubmission.getIncludeMailbox() && !custodialDataSourceSubmission.getIncludeSite()) {
                            exists = true;
                        }
                    }
                }
                if (exists) {
                    dataSourcesExistCount.getAndIncrement();
                }
                if (!invalid && !exists) continue;
                custodialDataSourceIterator.remove();
            }
            HashMap<String, List<Team>> userToTeams = new HashMap<String, List<Team>>();
            boolean errorQueryingAssociatedTeams = false;
            for (CustodialDataSourceSubmission custodialDataSourceSubmission : custodialDataSources) {
                String userEmail;
                if (custodialDataSourceSubmission.getType() != DataSourceType.USER || !this.trackTeamsForAllUserSources && !custodialDataSourceSubmission.getIncludeTeams() || userToTeams.containsKey(userEmail = custodialDataSourceSubmission.getValue())) continue;
                List<Team> teams = null;
                if (!errorQueryingAssociatedTeams) {
                    try {
                        teams = this.purviewRestClient.getUserAssociatedTeams(userEmail);
                    }
                    catch (IOException e) {
                        LOGGER.error("Error querying associated teams for user: " + userEmail, (Throwable)e);
                        this.addWarning(this.iu.getFormattedString("PurviewAddCustodialDataSourcesOperation.Warning.CannotQueryForAllUserTeams", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                        errorQueryingAssociatedTeams = true;
                    }
                }
                if (errorQueryingAssociatedTeams) {
                    teams = this.purviewRestClient.getUserJoinedTeams(userEmail);
                }
                if (teams == null) continue;
                userToTeams.put(userEmail, teams);
            }
            HashMap<String, Set> custodianAssignedTeams = new HashMap<String, Set>();
            custodialDataSourceIterator = custodialDataSources.listIterator();
            while (custodialDataSourceIterator.hasNext()) {
                List teams;
                CustodialDataSourceSubmission custodialDataSourceSubmission = (CustodialDataSourceSubmission)custodialDataSourceIterator.next();
                String custodianEmail = custodialDataSourceSubmission.getCustodianEmail();
                if (custodialDataSourceSubmission.getType() != DataSourceType.USER || !custodialDataSourceSubmission.getIncludeTeams() || (teams = (List)userToTeams.get(custodialDataSourceSubmission.getValue())) == null) continue;
                Set assignedTeams = custodianAssignedTeams.computeIfAbsent(custodianEmail, k -> new HashSet());
                for (Team team : teams) {
                    if (!assignedTeams.add(team.getMail())) continue;
                    CustodialDataSourceSubmission teamDataSourceSubmission = new CustodialDataSourceSubmission(custodianEmail);
                    teamDataSourceSubmission.setValue(team.getMail());
                    teamDataSourceSubmission.setType(DataSourceType.UNIFIED_GROUP);
                    teamDataSourceSubmission.setIncludeMailbox(true);
                    teamDataSourceSubmission.setIncludeSite(true);
                    custodialDataSourceIterator.add(teamDataSourceSubmission);
                }
            }
            this.stageItems = custodialDataSources.size();
            this.processedItems = new AtomicLong();
            for (CustodialDataSourceSubmission custodialDataSourceSubmission : custodialDataSources) {
                block68: {
                    DataSourceType dataSourceType = custodialDataSourceSubmission.getType();
                    String custodianEmail = custodialDataSourceSubmission.getCustodianEmail();
                    String value = custodialDataSourceSubmission.getValue();
                    try {
                        custodianEmail = custodianEmail.trim();
                        if (dataSourceType == DataSourceType.USER && (value == null || value.trim().isEmpty())) {
                            value = custodianEmail;
                        }
                        value = value.trim();
                        Custodian custodian = (Custodian)existingCustodians.get(custodianEmail);
                        if (custodian == null) {
                            LOGGER.warn("Cannot find existing Custodian " + custodianEmail);
                            continue;
                        }
                        if (!existingCustodianDataSources.containsKey(custodianEmail)) {
                            existingCustodianDataSources.put(custodianEmail, new HashMap());
                        }
                        Map existingDataSources = (Map)existingCustodianDataSources.get(custodianEmail);
                        DataSource existingDataSource = (DataSource)existingDataSources.get(value);
                        if (dataSourceType == DataSourceType.USER || dataSourceType == DataSourceType.UNIFIED_GROUP) {
                            String siteUrl;
                            if (!custodialDataSourceSubmission.getIncludeMailbox() && !custodialDataSourceSubmission.getIncludeSite()) break block68;
                            List<String> sources = PurviewAddCustodialDataSourcesOperationImplementation.getMissingIncludedSources(custodialDataSourceSubmission, existingDataSource);
                            if (sources.contains("site")) {
                                DataSource siteSource = null;
                                siteUrl = null;
                                if (custodiansWithSiteSources.contains(custodianEmail) && (siteUrl = this.queryUserUnifiedSourceSiteUrl(dataSourceType, value)) != null && (siteSource = (DataSource)existingDataSources.get(siteUrl)) != null) {
                                    LOGGER.info("Found existing Site source for " + String.valueOf(dataSourceType) + " source " + value + ", removing site from " + String.valueOf(dataSourceType) + " source submission and using existing Site source");
                                }
                                if (siteSource == null && dataSourceType == DataSourceType.USER) {
                                    try {
                                        String upn = this.purviewRestClient.getUserUpn(value);
                                        if (upn != null && !upn.isEmpty() && !value.equals(upn)) {
                                            if (siteUrl == null) {
                                                siteUrl = this.queryUserUnifiedSourceSiteUrl(DataSourceType.USER, value);
                                            }
                                            if (siteUrl != null && !siteUrl.trim().isEmpty()) {
                                                LOGGER.info("Detected difference with email and upn, replacing User source includeSite option with Site source " + siteUrl);
                                                siteSource = new DataSource();
                                                siteSource.setSourceType(DataSourceType.SITE);
                                                siteSource.setSite(new Site());
                                                siteSource.getSite().setWebUrl(siteUrl);
                                                LOGGER.info("Creating Site Source for Custodian " + custodian.getId() + ": " + String.valueOf(siteSource));
                                                siteSource = this.purviewRestClient.createSiteSourceForCustodian(this.purviewCaseId, custodian.getId(), siteSource);
                                                custodiansWithSiteSources.add(custodianEmail);
                                                existingDataSources.put(siteUrl, siteSource);
                                                dataSourcesAddedCount.getAndIncrement();
                                            } else {
                                                LOGGER.info("Removing site source from User data source, could not find personal Site URL for email: " + value);
                                                sources.remove("site");
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        LOGGER.error("Error creating separate Site source for User source", (Throwable)e);
                                        siteSource = null;
                                    }
                                }
                                if (siteSource != null) {
                                    sources.remove("site");
                                    scopeDataSourceIds.add(siteSource.getId());
                                    scopeDataSourceODataIds.add(siteSource.getODataId());
                                }
                            }
                            if (sources.isEmpty()) {
                                if (existingDataSource != null) {
                                    scopeDataSourceIds.add(existingDataSource.getId());
                                    scopeDataSourceODataIds.add(existingDataSource.getODataId());
                                }
                                dataSourcesExistCount.getAndIncrement();
                            } else {
                                DataSource dataSource = new DataSource();
                                dataSource.setSourceType(dataSourceType);
                                dataSource.setIncludedSources(String.join((CharSequence)",", sources));
                                if (dataSourceType == DataSourceType.USER) {
                                    dataSource.setEmail(value);
                                    LOGGER.info("Creating User Source for Custodian " + custodian.getId() + ": " + String.valueOf(dataSource) + " ...");
                                    dataSource = this.purviewRestClient.createUserSourceForCustodian(this.purviewCaseId, custodian.getId(), dataSource);
                                } else {
                                    Group group = new Group(value);
                                    dataSource.setGroup(group);
                                    LOGGER.info("Creating Unified Group Source for Custodian " + custodian.getId() + ": " + String.valueOf(dataSource));
                                    dataSource = this.purviewRestClient.createUnifiedGroupSourceForCustodian(this.purviewCaseId, custodian.getId(), dataSource);
                                    dataSource.setGroup(group);
                                }
                                scopeDataSourceIds.add(dataSource.getId());
                                scopeDataSourceODataIds.add(dataSource.getODataId());
                                existingDataSources.put(value, dataSource);
                                dataSourcesAddedCount.getAndIncrement();
                                if (sources.contains("site") && (siteUrl = this.queryUserUnifiedSourceSiteUrl(dataSourceType, value)) != null) {
                                    existingDataSources.putIfAbsent(siteUrl, dataSource);
                                }
                            }
                            break block68;
                        }
                        if (dataSourceType == DataSourceType.SITE) {
                            if (existingDataSource == null) {
                                DataSource siteSource = new DataSource();
                                siteSource.setSourceType(dataSourceType);
                                siteSource.setSite(new Site());
                                siteSource.getSite().setWebUrl(value);
                                LOGGER.info("Creating Site Source for Custodian " + custodian.getId() + ": " + String.valueOf(siteSource));
                                siteSource = this.purviewRestClient.createSiteSourceForCustodian(this.purviewCaseId, custodian.getId(), siteSource);
                                scopeDataSourceIds.add(siteSource.getId());
                                scopeDataSourceODataIds.add(siteSource.getODataId());
                                custodiansWithSiteSources.add(custodianEmail);
                                existingDataSources.put(value, siteSource);
                                dataSourcesAddedCount.getAndIncrement();
                            } else {
                                if (existingDataSource.getSourceType() != DataSourceType.SITE) {
                                    this.addWarning(this.iu.getFormattedString("PurviewAddCustodialDataSourcesOperation.Warning.SiteSourceExistsAsOtherSource", new Object[]{value, existingDataSource.getSourceType().toLocalizedString(), existingDataSource.getDataSourceValue()}));
                                }
                                scopeDataSourceIds.add(existingDataSource.getId());
                                scopeDataSourceODataIds.add(existingDataSource.getODataId());
                                dataSourcesExistCount.getAndIncrement();
                            }
                        }
                    }
                    catch (Exception e) {
                        this.addWarning(this.iu.getFormattedString("PurviewAddCustodialDataSourcesOperation.Warning.CannotProcessCustodialDataSource", new Object[]{value, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                        failedToAddDataSourcesCount.getAndIncrement();
                    }
                }
                this.processedItems.getAndIncrement();
            }
            this.addExecutionLog(this.iu.getNumeralString("PurviewAddCustodialDataSourcesOperation.Log.AddedCustodialDataSources", dataSourcesAddedCount.get()));
            if (dataSourcesExistCount.get() > 0L) {
                this.addExecutionLog(this.iu.getNumeralString("PurviewAddCustodialDataSourcesOperation.Log.SkippedExistingCustodialDataSources", dataSourcesExistCount.get()));
            }
            if (dataSourcesInvalidCount.get() > 0L) {
                this.addExecutionLog(this.iu.getNumeralString("PurviewAddCustodialDataSourcesOperation.Log.SkippedInvalidCustodialDataSources", dataSourcesInvalidCount.get()));
            }
            if (failedToAddDataSourcesCount.get() > 0L) {
                this.addExecutionLog(this.iu.getNumeralString("PurviewAddCustodialDataSourcesOperation.Log.FailedToAddCustodialDataSources", failedToAddDataSourcesCount.get()));
            }
            HashSet<String> hashSet = new HashSet<String>(existingCustodians.keySet());
            Set<String> scopeCustodianIds = existingCustodians.values().stream().map(MicrosoftGraphObject::getId).collect(Collectors.toSet());
            this.concatenateToCollectionJson("{purview_custodian_ids}", scopeCustodianIds);
            this.concatenateToCollectionJson("{purview_custodian_emails}", hashSet);
            this.concatenateToCollectionJson("{purview_custodial_data_source_ids}", scopeDataSourceIds);
            this.concatenateToCollectionJson("{purview_custodial_data_source_odata_ids}", scopeDataSourceODataIds);
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_user_teams_json}", SerializationUtils.toJson(userToTeams, (boolean)false))));
        });
    }

    private void normalizeCustodialDataSourceSubmission(CustodialDataSourceSubmission custodialDataSourceSubmission) {
        custodialDataSourceSubmission.setCustodianEmail(FormattingUtils.getNonEmptyTrimmedText((String)custodialDataSourceSubmission.getCustodianEmail()));
        custodialDataSourceSubmission.setValue(FormattingUtils.getNonEmptyTrimmedText((String)custodialDataSourceSubmission.getValue()));
    }

    private String getUserUnifiedSourceWebUrl(DataSource dataSource) {
        String siteUrl = null;
        if (dataSource.getIncludedSources() != null && dataSource.getIncludedSources().contains("site") && dataSource.getSourceType() == DataSourceType.UNIFIED_GROUP && dataSource.getGroup() != null) {
            siteUrl = dataSource.getGroup().getWebUrl();
        }
        if (siteUrl == null) {
            siteUrl = dataSource.getSiteWebUrl();
        }
        return this.normalizeSiteUrl(siteUrl);
    }

    private String queryUserUnifiedSourceSiteUrl(DataSourceType dataSourceType, String email) {
        String siteUrl = null;
        try {
            switch (dataSourceType) {
                case USER: {
                    siteUrl = this.purviewRestClient.getUserPersonalSharePointSite(email);
                    break;
                }
                case UNIFIED_GROUP: {
                    siteUrl = this.purviewRestClient.getGroupPersonalSharePointSite(email);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error getting " + String.valueOf(dataSourceType) + " source " + email + " SharePoint site URL", (Throwable)e);
        }
        return this.normalizeSiteUrl(siteUrl);
    }

    private String normalizeSiteUrl(String siteUrl) {
        if (siteUrl != null) {
            if ((siteUrl = siteUrl.trim()).endsWith("/")) {
                siteUrl = siteUrl.substring(0, siteUrl.length() - 1);
            }
            if (siteUrl.isEmpty()) {
                siteUrl = null;
            }
        }
        return siteUrl;
    }

    @NotNull
    private static List<String> getMissingIncludedSources(CustodialDataSourceSubmission custodialDataSourceSubmission, DataSource existingDataSource) {
        boolean mailboxSourceExists = false;
        boolean siteSourceExists = false;
        if (existingDataSource != null) {
            if (existingDataSource.getIncludedSources().contains("mailbox")) {
                mailboxSourceExists = true;
            }
            if (existingDataSource.getIncludedSources().contains("site")) {
                siteSourceExists = true;
            }
        }
        ArrayList<String> sources = new ArrayList<String>();
        if (!mailboxSourceExists && custodialDataSourceSubmission.getIncludeMailbox()) {
            sources.add("mailbox");
        }
        if (!siteSourceExists && custodialDataSourceSubmission.getIncludeSite()) {
            sources.add("site");
        }
        return sources;
    }

    @Override
    protected double getPercentageComplete() {
        double stageProgress = 0.0;
        if (this.processedItems != null && this.stageItems > 0L) {
            stageProgress = (double)this.processedItems.get() / (double)this.stageItems;
        }
        stageProgress *= 1.5;
        double percentageComplete = 0.0;
        if (this.stageCount > 0.0) {
            percentageComplete = (stageProgress + this.stageId) / this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && !this.stageName.isEmpty()) {
            result = (String)result + " / " + this.stageName;
        }
        if (this.stageItems > 0L) {
            if (!((String)result).isEmpty()) {
                result = (String)result + " / ";
            }
            result = this.stageId == 1.0 ? (String)result + this.iu.getNumeralString("PurviewAddCustodialDataSourcesOperation.Progress.CustodianItemsProcessed", this.processedItems.get()) : (String)result + this.iu.getNumeralString("PurviewAddCustodialDataSourcesOperation.Progress.ItemsProcessed", this.processedItems.get());
        }
        return result;
    }
}

