/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.models.internal.purview.EDiscoveryReviewSet;
import com.nuix.automate.utils.models.internal.purview.EDiscoverySearch;
import com.nuix.automate.utils.models.internal.purview.operations.AddToReviewSetOperation;
import com.nuix.automate.utils.models.internal.purview.operations.CaseOperation;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.PurviewAddToReviewSetOperation;
import com.nuix.automate.workflow.core.execution.options.purview.PurviewIdentifierType;
import com.nuix.automate.workflow.core.utils.purview.PurviewObjectDoesNotExistException;
import com.nuix.automate.workflow.core.utils.purview.PurviewOperationException;
import java.util.ArrayList;

public class PurviewAddToReviewSetOperationImplementation
extends PurviewAddToReviewSetOperation {
    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            boolean reviewSetCreated;
            EDiscoveryReviewSet reviewSet;
            block6: {
                this.initialize();
                this.reviewSetIdentifier = this.executionContext.evalParameters(this.reviewSetIdentifier, this);
                this.searchIdentifier = this.executionContext.evalParameters(this.searchIdentifier, this);
                this.stageName = this.iu.getString("PurviewAddToReviewSetOperation.Stage.GettingReviewSet");
                this.percentageComplete = 0.05;
                reviewSet = null;
                reviewSetCreated = false;
                try {
                    reviewSet = this.getReviewSet(this.reviewSetIdentifierType, this.reviewSetIdentifier, true);
                }
                catch (PurviewObjectDoesNotExistException e) {
                    if (this.reviewSetIdentifierType != PurviewIdentifierType.NAME || !this.createReviewSetIfNotExists) break block6;
                    this.stageName = this.iu.getString("PurviewAddToReviewSetOperation.Stage.CreatingReviewSet");
                    this.percentageComplete = 0.1;
                    this.addExecutionLog(this.iu.getString("PurviewAddToReviewSetOperation.Log.CouldNotFindReviewSetCreating"));
                    reviewSet = new EDiscoveryReviewSet();
                    reviewSet.setDisplayName(this.reviewSetIdentifier);
                    reviewSet.setDescription(this.reviewSetDescription);
                    reviewSet = this.purviewRestClient.createReviewSet(this.purviewCaseId, reviewSet);
                    reviewSetCreated = true;
                    this.addExecutionLog(this.iu.getString("PurviewAddToReviewSetOperation.Log.CreatedReviewSet"));
                    this.addExecutionLog(this.iu.getFormattedString("PurviewAddToReviewSetOperation.Log.ReviewSetName", (Object)reviewSet.getDisplayName()));
                    this.addExecutionLog(this.iu.getFormattedString("PurviewAddToReviewSetOperation.Log.ReviewSetId", (Object)reviewSet.getId()));
                }
            }
            if (reviewSet == null) {
                String errorMessage = this.iu.getFormattedString("PurviewOperation.Error.CannotFindReviewSetWith" + this.reviewSetIdentifierType.name(), (Object)this.reviewSetIdentifier);
                throw new PurviewOperationException(errorMessage);
            }
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_review_set_id}", reviewSet.getId())));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_review_set_name}", reviewSet.getDisplayName())));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_review_set_created}", String.valueOf(reviewSetCreated))));
            this.stageName = this.iu.getString("PurviewAddToReviewSetOperation.Stage.GettingSearch");
            this.percentageComplete = 0.15;
            EDiscoverySearch search = this.getSearch(this.searchIdentifierType, this.searchIdentifier);
            this.stageName = this.iu.getString("PurviewAddToReviewSetOperation.Stage.AddingToReviewSet");
            this.percentageComplete = 0.2;
            ArrayList<String> additionalOptions = new ArrayList<String>();
            if (this.allVersions) {
                additionalOptions.add("allVersions");
            }
            if (this.linkedFiles) {
                additionalOptions.add("linkedFiles");
            }
            AddToReviewSetOperation addToReviewSetOperation = this.purviewRestClient.addSearchToReviewSet(this.purviewCaseId, reviewSet.getId(), search.getId(), String.join((CharSequence)",", additionalOptions));
            this.addExecutionLog(this.iu.getFormattedString("PurviewAddToReviewSetOperation.Log.AddToReviewSetOperationId", (Object)addToReviewSetOperation.getId()));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_add_to_review_set_job_id}", addToReviewSetOperation.getId())));
            if (this.waitForCompletion) {
                this.waitForOperationToComplete((CaseOperation)addToReviewSetOperation);
            }
        });
    }
}

