/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.LocalizableEnumUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.models.internal.graphapi.MicrosoftGraphObject;
import com.nuix.automate.utils.models.internal.purview.DataSourceScope;
import com.nuix.automate.utils.models.internal.purview.EDiscoverySearch;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.PurviewAddToSearchOperation;
import com.nuix.automate.workflow.core.execution.options.purview.PurviewIdentifierType;
import com.nuix.automate.workflow.core.utils.purview.PurviewObjectDoesNotExistException;
import com.nuix.automate.workflow.core.utils.purview.PurviewOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PurviewAddToSearchOperationImplementation
extends PurviewAddToSearchOperation {
    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            boolean searchCreated;
            EDiscoverySearch search;
            block25: {
                this.initialize();
                this.searchIdentifier = this.executionContext.evalParameters(this.searchIdentifier, this);
                this.searchDescription = this.executionContext.evalParameters(this.searchDescription, this);
                this.kqlContentQuery = this.executionContext.evalParameters(this.kqlContentQuery, this);
                this.stageName = this.iu.getString("PurviewAddToSearchOperation.Stage.PreparingDataSources");
                this.percentageComplete = 0.1;
                String dataSourceScopes = this.getDataSourceScopes();
                HashSet custodialDataSourceODataIds = new HashSet();
                HashSet nonCustodialDataSourceODataIds = new HashSet();
                if (!this.allTenantMailboxes && !this.allTenantSites) {
                    if (!this.allCaseCustodians && this.useCustodialDataSourceIds) {
                        String custodialDataSourceIdsParam = this.custodialDataSourceIds;
                        this.custodialDataSourceIds = this.executionContext.evalParameters(this.custodialDataSourceIds, this);
                        if (!this.custodialDataSourceIds.equals(custodialDataSourceIdsParam)) {
                            custodialDataSourceODataIds.addAll((Collection)SerializationUtils.fromJson((String)this.custodialDataSourceIds));
                            if (custodialDataSourceODataIds.isEmpty()) {
                                this.addWarning(this.iu.getString("PurviewAddToSearchOperation.Log.NoCustodialDataSources"));
                            }
                        }
                    }
                    if (!this.allCaseNoncustodialDataSources && this.useNonCustodialDataSourceIds) {
                        String nonCustodialDataSourceIdsParam = this.nonCustodialDataSourceIds;
                        this.nonCustodialDataSourceIds = this.executionContext.evalParameters(this.nonCustodialDataSourceIds, this);
                        if (!this.nonCustodialDataSourceIds.equals(nonCustodialDataSourceIdsParam)) {
                            nonCustodialDataSourceODataIds.addAll((Collection)SerializationUtils.fromJson((String)this.nonCustodialDataSourceIds));
                            if (nonCustodialDataSourceODataIds.isEmpty()) {
                                this.addWarning(this.iu.getString("PurviewAddToSearchOperation.Log.NoNonCustodialDataSources"));
                            }
                        }
                    }
                }
                this.stageName = this.iu.getString("PurviewAddToSearchOperation.Stage.GettingSearch");
                this.percentageComplete = 0.3;
                search = null;
                searchCreated = false;
                try {
                    String id;
                    Set existCustodialDataSourceIds;
                    search = this.getSearch(this.searchIdentifierType, this.searchIdentifier, true);
                    this.stageName = this.iu.getString("PurviewAddToSearchOperation.Stage.AddingDataSources");
                    this.percentageComplete = 0.7;
                    EDiscoverySearch searchUpdate = new EDiscoverySearch();
                    searchUpdate.setId(search.getId());
                    searchUpdate.setDataSourceScopes(dataSourceScopes);
                    this.purviewRestClient.updateSearch(this.purviewCaseId, searchUpdate);
                    search.setDataSourceScopes(dataSourceScopes);
                    this.logTranslatedDataSourceScopes(search.getDataSourceScopes());
                    if (!custodialDataSourceODataIds.isEmpty()) {
                        int addedCustodialDataSources = 0;
                        int skippedExistingCustodialDataSources = 0;
                        int failedToAddCustodialDataSources = 0;
                        existCustodialDataSourceIds = this.purviewRestClient.getSearchCustodialDataSources(this.purviewCaseId, search.getId()).stream().map(MicrosoftGraphObject::getId).collect(Collectors.toSet());
                        for (String oDataId : custodialDataSourceODataIds) {
                            try {
                                id = this.getIdFromODataId(oDataId);
                                if (existCustodialDataSourceIds.contains(id)) {
                                    ++skippedExistingCustodialDataSources;
                                    continue;
                                }
                                this.purviewRestClient.addCustodialDataSourceToSearch(this.purviewCaseId, search.getId(), oDataId);
                                ++addedCustodialDataSources;
                            }
                            catch (Exception e) {
                                this.addWarning(this.iu.getFormattedString("PurviewAddToSearchOperation.Warning.CannotProcessCustodialDataSource", new Object[]{oDataId, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                                ++failedToAddCustodialDataSources;
                            }
                        }
                        this.addExecutionLog(this.iu.getNumeralString("PurviewAddToSearchOperation.Log.AddedCustodialDataSources", (long)addedCustodialDataSources));
                        if (skippedExistingCustodialDataSources > 0) {
                            this.addExecutionLog(this.iu.getNumeralString("PurviewAddToSearchOperation.Log.SkippedExistingCustodialDataSources", (long)skippedExistingCustodialDataSources));
                        }
                        if (failedToAddCustodialDataSources > 0) {
                            this.addExecutionLog(this.iu.getNumeralString("PurviewAddToSearchOperation.Log.FailedToAddCustodialDataSources", (long)failedToAddCustodialDataSources));
                        }
                    }
                    if (!nonCustodialDataSourceODataIds.isEmpty()) {
                        int addedNonCustodialDataSources = 0;
                        int skippedExistingNonCustodialDataSources = 0;
                        int failedToAddNonCustodialDataSources = 0;
                        existCustodialDataSourceIds = this.purviewRestClient.getSearchNonCustodialDataSources(this.purviewCaseId, search.getId()).stream().map(MicrosoftGraphObject::getId).collect(Collectors.toSet());
                        for (String oDataId : nonCustodialDataSourceODataIds) {
                            try {
                                id = this.getIdFromODataId(oDataId);
                                if (existCustodialDataSourceIds.contains(id)) {
                                    ++skippedExistingNonCustodialDataSources;
                                    continue;
                                }
                                this.purviewRestClient.addNonCustodialDataSourceToSearch(this.purviewCaseId, search.getId(), oDataId);
                                ++addedNonCustodialDataSources;
                            }
                            catch (Exception e) {
                                this.addWarning(this.iu.getFormattedString("PurviewAddToSearchOperation.Warning.CannotProcessNonCustodialDataSource", new Object[]{oDataId, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                                ++failedToAddNonCustodialDataSources;
                            }
                        }
                        this.addExecutionLog(this.iu.getNumeralString("PurviewAddToSearchOperation.Log.AddedNonCustodialDataSources", (long)addedNonCustodialDataSources));
                        if (skippedExistingNonCustodialDataSources > 0) {
                            this.addExecutionLog(this.iu.getNumeralString("PurviewAddToSearchOperation.Log.SkippedExistingNonCustodialDataSources", (long)skippedExistingNonCustodialDataSources));
                        }
                        if (failedToAddNonCustodialDataSources > 0) {
                            this.addExecutionLog(this.iu.getNumeralString("PurviewAddToSearchOperation.Log.FailedToAddNonCustodialDataSources", (long)failedToAddNonCustodialDataSources));
                        }
                    }
                }
                catch (PurviewObjectDoesNotExistException e) {
                    if (this.searchIdentifierType != PurviewIdentifierType.NAME || !this.createSearchIfNotExists) break block25;
                    this.stageName = this.iu.getString("PurviewAddToSearchOperation.Stage.CreatingSearch");
                    this.percentageComplete = 0.7;
                    this.addExecutionLog(this.iu.getString("PurviewAddToSearchOperation.Log.CouldNotFindSearchCreating"));
                    search = new EDiscoverySearch();
                    search.setDisplayName(this.searchIdentifier);
                    search.setDescription(this.searchDescription);
                    search.setContentQuery(this.kqlContentQuery);
                    search.setDataSourceScopes(dataSourceScopes);
                    search.setCustodianSources(new ArrayList(custodialDataSourceODataIds));
                    search.setNoncustodialSources(new ArrayList(nonCustodialDataSourceODataIds));
                    search = this.purviewRestClient.createSearch(this.purviewCaseId, search);
                    searchCreated = true;
                    this.addExecutionLog(this.iu.getString("PurviewAddToSearchOperation.Log.CreatedSearch"));
                    this.addExecutionLog(this.iu.getFormattedString("PurviewAddToSearchOperation.Log.SearchName", (Object)search.getDisplayName()));
                    this.addExecutionLog(this.iu.getFormattedString("PurviewAddToSearchOperation.Log.SearchId", (Object)search.getId()));
                    this.addExecutionLog(this.iu.getFormattedString("PurviewAddToSearchOperation.Log.KqlContentQuery", (Object)search.getContentQuery()));
                    this.logTranslatedDataSourceScopes(search.getDataSourceScopes());
                    if (!custodialDataSourceODataIds.isEmpty()) {
                        this.addExecutionLog(this.iu.getNumeralString("PurviewAddToSearchOperation.Log.AddedCustodialDataSources", (long)custodialDataSourceODataIds.size()));
                    }
                    if (nonCustodialDataSourceODataIds.isEmpty()) break block25;
                    this.addExecutionLog(this.iu.getNumeralString("PurviewAddToSearchOperation.Log.AddedNonCustodialDataSources", (long)nonCustodialDataSourceODataIds.size()));
                }
            }
            if (search == null) {
                String errorMessage = this.iu.getFormattedString("PurviewOperation.Error.CannotFindSearchWith" + this.searchIdentifierType.name(), (Object)this.searchIdentifier);
                throw new PurviewOperationException(errorMessage);
            }
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_search_id}", search.getId())));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_search_name}", search.getDisplayName())));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_search_created}", String.valueOf(searchCreated))));
        });
    }

    private String getIdFromODataId(String oDataId) {
        String[] idSplit = oDataId.split("/");
        String id = idSplit[idSplit.length - 1];
        int parenthesisIndex = id.indexOf("(");
        if (parenthesisIndex >= 0) {
            id = id.substring(parenthesisIndex).replaceAll("[(')]", "");
        }
        return id;
    }

    private void logTranslatedDataSourceScopes(String dataSourceScopes) {
        if (dataSourceScopes != null && !dataSourceScopes.trim().isEmpty()) {
            String translatedDataSourceScopes = Arrays.stream(dataSourceScopes.split(",")).map(sourceScope -> LocalizableEnumUtils.getLocalizedString((Enum)DataSourceScope.forValue((String)sourceScope))).collect(Collectors.joining(", "));
            this.addExecutionLog(this.iu.getFormattedString("PurviewAddToSearchOperation.Log.DataSourceScopes", (Object)translatedDataSourceScopes));
        }
    }

    @NotNull
    private String getDataSourceScopes() {
        ArrayList<String> dataSourceScopes = new ArrayList<String>();
        if (this.allTenantMailboxes || this.allTenantSites) {
            if (this.allTenantMailboxes) {
                dataSourceScopes.add("allTenantMailboxes");
            }
            if (this.allTenantSites) {
                dataSourceScopes.add("allTenantSites");
            }
        } else {
            if (this.allCaseCustodians) {
                dataSourceScopes.add("allCaseCustodians");
            }
            if (this.allCaseNoncustodialDataSources) {
                dataSourceScopes.add("allCaseNoncustodialDataSources");
            }
        }
        return String.join((CharSequence)",", dataSourceScopes);
    }
}

