/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameters;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.PurviewOperation;
import com.nuix.automate.workflow.core.execution.operations.PurviewUseCaseOperation;
import com.nuix.automate.workflow.core.execution.options.purview.PurviewIdentifierType;
import java.util.List;

@FormFieldRow(name="reviewSetIdentifierRow", children={"reviewSetIdentifierType", "reviewSetIdentifier"})
@OperationMetadata(alias=OperationAlias.PURVIEW_CREATE_REVIEW_SET_QUERY, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"MICROSOFT_PURVIEW"}), @OperationTag(name="Category", value={"CULLING"})})
@OperationParameters(value={@OperationParameter(label="reviewSetQueryId", parameter="{purview_review_set_query_id}"), @OperationParameter(label="reviewSetQueryName", parameter="{purview_review_set_query_name}"), @OperationParameter(label="reviewSetQueryCreated", parameter="{purview_review_set_query_created}")})
@OperationLicenseModule(module=ModuleType.PURVIEW_COLLECTIONS)
public class PurviewCreateReviewSetQueryOperation
extends PurviewOperation {
    @FormField
    @ExcludeFromPrintableOptions
    public PurviewIdentifierType reviewSetIdentifierType = PurviewIdentifierType.ID;
    @FormField
    public String reviewSetIdentifier = "{purview_review_set_id}";
    @FormField
    public String reviewSetQueryName;
    @FormField(componentType=FieldComponentType.TEXTAREA, rowSize=2, placeholder="(Author=\"edisons\")")
    public String kqlContentQuery;
    @FormField
    public boolean updateIfExists = true;

    @Override
    public String getOperationName() {
        return this.iu.getString("PurviewCreateReviewSetQueryOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (!this.enableFieldOverwrite) {
            if (this.reviewSetIdentifierType == null || this.reviewSetIdentifier == null || this.reviewSetIdentifier.trim().isEmpty()) {
                prerequisites.add(this.iu.getString("PurviewCreateReviewSetQueryOperation.Prerequisites.ReviewSetIdentifierRequired"));
            }
            if (this.reviewSetQueryName == null || this.reviewSetQueryName.trim().isEmpty()) {
                prerequisites.add(this.iu.getString("PurviewCreateReviewSetQueryOperation.Prerequisites.ReviewSetQueryNameRequired"));
            }
            if (this.kqlContentQuery == null || this.kqlContentQuery.trim().isEmpty()) {
                prerequisites.add(this.iu.getString("PurviewCreateReviewSetQueryOperation.Prerequisites.KqlContentQueryRequired"));
            }
        }
        prerequisites.addAll(this.getMissingRequiredOperations(PurviewUseCaseOperation.class));
        return prerequisites;
    }
}

