/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.utils.utilization.consumption.ConsumptionEvent;
import com.nuix.automate.utils.utilization.consumption.ConsumptionPlatformType;
import com.nuix.automate.utils.utilization.consumption.ConsumptionType;
import com.nuix.automate.utils.utilization.consumption.ResourceSubType;
import com.nuix.automate.utils.utilization.consumption.ResourceType;
import com.nuix.automate.utils.utilization.consumption.UnitType;
import com.nuix.automate.workflow.core.execution.operations.PurviewOperation;
import java.io.IOException;
import java.util.Set;

public abstract class PurviewCustodianOperation
extends PurviewOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PurviewCustodianOperation.class);
    protected Set<String> consumptionCustodianIds;

    @Override
    public Consumption getOperationConsumption() {
        if (this.consumptionCustodianIds != null && this.consumptionCustodianIds.size() > 0) {
            Consumption consumption = new Consumption();
            ConsumptionEvent consumptionEvent = new ConsumptionEvent();
            consumptionEvent.setConsumptionEventId(UidUtils.getRandom());
            consumptionEvent.setLicenseId(this.executionContext.licenceSession.getLicenceInfo().getId());
            consumptionEvent.setConsumptionStartEpoch(this.startDateTime.getMillis());
            if (this.finishedDateTime != null) {
                consumptionEvent.setConsumptionEndEpoch(this.finishedDateTime.getMillis());
            } else {
                consumptionEvent.setConsumptionEndEpoch(this.startDateTime.getMillis());
            }
            consumptionEvent.setPlatformType(ConsumptionPlatformType.MICROSOFT_PURVIEW);
            try {
                consumptionEvent.setPlatformId(this.purviewRestClient.getTenant());
            }
            catch (IOException e) {
                LOGGER.error("Cannot get Microsoft Purview tenant", (Throwable)e);
            }
            consumptionEvent.setConsumptionType(ConsumptionType.CUSTODIAN_USED);
            consumptionEvent.setUnitType(UnitType.CUSTODIANS);
            consumptionEvent.setResourceType(ResourceType.PURVIEW_CASE_ID);
            consumptionEvent.setResourceId(this.purviewCaseId);
            consumptionEvent.setResourceSubType(ResourceSubType.CUSTODIAN_IDS);
            consumptionEvent.setResourceSubId(SerializationUtils.toJson(this.consumptionCustodianIds));
            if (this.executionContext.getEngine() != null) {
                consumptionEvent.setJobId(this.executionContext.getEngine().getJobId());
            }
            consumption.addConsumptionEvents(consumptionEvent, this.consumptionCustodianIds);
            return consumption;
        }
        LOGGER.warn("Purview custodian operation " + String.valueOf(this) + " does not have custodians");
        return null;
    }
}

