/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.PurviewOperation;
import com.nuix.automate.workflow.core.execution.operations.PurviewUseCaseOperation;
import com.nuix.automate.workflow.core.execution.options.purview.PurviewIdentifierType;
import java.util.List;

@FormFieldRows(value={@FormFieldRow(name="exportJobIdentifierRow", children={"exportJobIdentifierType", "exportJobIdentifier"}), @FormFieldRow(name="retryFailedDownloadsRow", children={"retryFailedDownloads", "retryAttempts"})})
@OperationMetadata(alias=OperationAlias.PURVIEW_DOWNLOAD_EXPORT, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"MICROSOFT_PURVIEW"}), @OperationTag(name="Category", value={"EXPORT"})})
@OperationLicenseModule(module=ModuleType.PURVIEW_COLLECTIONS)
public class PurviewDownloadExportOperation
extends PurviewOperation {
    @FormField
    @ExcludeFromPrintableOptions
    public PurviewIdentifierType exportJobIdentifierType = PurviewIdentifierType.ID;
    @FormField
    public String exportJobIdentifier = "{purview_export_job_id}";
    @FormField
    public String downloadLocation;
    @FormField
    public boolean retryFailedDownloads = true;
    @FormField(enableOn={@OnField(name="retryFailedDownloads")}, positionLabel=@PositionLabel(right="retries"))
    public int retryAttempts = 10;
    @FormField
    public boolean skipZipFileCountCheck = false;

    @Override
    public String getOperationName() {
        return this.iu.getString("PurviewDownloadExportOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (!this.enableFieldOverwrite) {
            if (this.exportJobIdentifierType == null || this.exportJobIdentifier == null || this.exportJobIdentifier.trim().isEmpty()) {
                prerequisites.add(this.iu.getString("PurviewDownloadExportOperation.Prerequisites.ExportJobIdentifierRequired"));
            }
            if (this.downloadLocation == null || this.downloadLocation.trim().isEmpty()) {
                prerequisites.add(this.iu.getString("PurviewDownloadExportOperation.Prerequisites.DownloadLocationRequired"));
            }
        }
        prerequisites.addAll(this.getMissingRequiredOperations(PurviewUseCaseOperation.class));
        return prerequisites;
    }
}

