/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.WsRsRestClientFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.purview.ExportFileMetadata;
import com.nuix.automate.utils.models.internal.purview.operations.ExportOperation;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.PurviewDownloadExportOperation;
import com.nuix.automate.workflow.core.utils.purview.PurviewOperationException;
import com.nuix.automate.workflow.core.utils.purview.PurviewRestException;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipFile;
import org.apache.commons.io.input.BoundedInputStream;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.openimaj.util.parallel.Parallel;

public class PurviewDownloadExportOperationImplementation
extends PurviewDownloadExportOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PurviewDownloadExportOperation.class);
    private static final int BUFFER_SIZE = 65536;
    private transient int fileCount;
    private transient AtomicInteger zipFilesCount;
    private transient long totalSize;
    private transient AtomicInteger filesFinishedCount;
    private transient AtomicLong sizeWritten;
    private transient AtomicLong downloadSpeed;
    private transient AtomicBoolean atomicStopRequested;

    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            this.initialize();
            this.exportJobIdentifier = this.executionContext.evalParameters(this.exportJobIdentifier, this);
            this.downloadLocation = this.executionContext.evalParameters(this.downloadLocation, this);
            this.stageName = this.iu.getString("PurviewDownloadExportOperation.Stage.GettingExportJob");
            this.percentageComplete = 0.0;
            ExportOperation exportOperation = this.getExportJob(this.exportJobIdentifierType, this.exportJobIdentifier);
            if (exportOperation == null) {
                String errorMessage = this.iu.getFormattedString("PurviewDownloadExportOperation.Error.CannotFindExportJobWith" + this.exportJobIdentifierType.name(), (Object)this.exportJobIdentifier);
                throw new PurviewOperationException(errorMessage);
            }
            this.addExecutionLog(this.iu.getFormattedString("PurviewDownloadExportOperation.Log.ExportJobId", new Object[]{exportOperation.getOutputName(), exportOperation.getId()}));
            if (this.stopRequested) {
                throw new WorkflowExecutionStopRequested();
            }
            if (!exportOperation.isFinished()) {
                throw new PurviewOperationException(this.iu.getFormattedString("PurviewDownloadExportOperation.Error.ExportNotFinishedCannotDownload", new Object[]{exportOperation.getOutputName(), exportOperation.getStatus().toLocalizedString()}));
            }
            this.fileCount = exportOperation.getExportFileMetadata().size();
            this.totalSize = exportOperation.getExportFileMetadata().stream().mapToLong(ExportFileMetadata::getSize).sum();
            this.addExecutionLog(this.iu.getFormattedString("PurviewDownloadExportOperation.Log.FileCount", (Object)this.fileCount));
            this.addExecutionLog(this.iu.getFormattedString("PurviewDownloadExportOperation.Log.TotalSize", (Object)FormattingUtils.sizeToDisplaySize((long)this.totalSize)));
            this.stageName = this.iu.getString("PurviewDownloadExportOperation.Stage.DownloadingExport");
            this.percentageComplete = 0.1;
            Path downloadLocationPath = Paths.get(this.downloadLocation, new String[0]);
            if (Files.notExists(downloadLocationPath, new LinkOption[0])) {
                LOGGER.info("Download location does not exist, creating required directories");
                Files.createDirectories(downloadLocationPath, new FileAttribute[0]);
            }
            if (!FileUtils.isDirectoryEmpty((Path)downloadLocationPath)) {
                throw new PurviewOperationException(this.iu.getFormattedString("PurviewDownloadExportOperation.Error.DownloadLocationNotEmpty", (Object)this.downloadLocation));
            }
            this.addExecutionLog(this.iu.getFormattedString("PurviewDownloadExportOperation.Log.DownloadLocation", (Object)this.downloadLocation));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_export_job_download_location}", this.downloadLocation)));
            this.atomicStopRequested = new AtomicBoolean();
            this.filesFinishedCount = new AtomicInteger();
            this.sizeWritten = new AtomicLong();
            this.zipFilesCount = new AtomicInteger();
            this.downloadSpeed = new AtomicLong();
            AtomicBoolean complete = new AtomicBoolean();
            ConcurrentHashMap.KeySetView errors = ConcurrentHashMap.newKeySet();
            Thread downloadThread = new Thread(() -> {
                ConcurrentHashMap downloadObservers = new ConcurrentHashMap();
                AtomicLong lastUpdateMillis = new AtomicLong();
                ScheduledExecutorService observerThreadPool = Executors.newScheduledThreadPool(1);
                observerThreadPool.scheduleWithFixedDelay(() -> {
                    long totalRead = 0L;
                    for (DownloadObserver downloadObserver : downloadObservers.values()) {
                        if (downloadObserver.getDone()) continue;
                        totalRead += downloadObserver.run();
                    }
                    long currentMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                    long duration = (currentMillis - lastUpdateMillis.get()) / 1000L;
                    this.downloadSpeed.set(totalRead / duration);
                    lastUpdateMillis.set(currentMillis);
                }, 5L, 5L, TimeUnit.SECONDS);
                observerThreadPool.scheduleWithFixedDelay(new Operation.CheckUsableSpaceTask(downloadLocationPath), 0L, 30L, TimeUnit.SECONDS);
                try {
                    long startMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                    lastUpdateMillis.set(startMillis);
                    Parallel.forEach((Iterable)exportOperation.getExportFileMetadata(), fileMetadata -> {
                        if (fileMetadata.getSize() == 0L) {
                            this.addWarning(this.iu.getFormattedString("PurviewDownloadExportOperation.Warning.FileSizeZero", (Object)fileMetadata.getFileName()));
                        } else {
                            Path filePath = downloadLocationPath.resolve(fileMetadata.getFileName());
                            DownloadObserver downloadObserver = new DownloadObserver(fileMetadata.getFileName(), 300L);
                            downloadObservers.put(fileMetadata.getFileName(), downloadObserver);
                            int attempt = 0;
                            HashSet<String> transientWarnings = new HashSet<String>();
                            while (true) {
                                if (++attempt == 1) {
                                    LOGGER.info("Starting download for file " + String.valueOf(filePath));
                                } else {
                                    LOGGER.info("Retrying (" + attempt + ") download for file " + String.valueOf(filePath));
                                }
                                try (InputStream exportInputStream = this.getExportDownloadInputStream((ExportFileMetadata)fileMetadata);){
                                    FileChannel fileChannel = FileChannel.open(filePath, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                                    try {
                                        BoundedInputStream downloadInputStream = ((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(exportInputStream)).get();
                                        downloadObserver.setDownloadInputStream(downloadInputStream);
                                        try {
                                            FileUtils.writeWithSeparateWriteThread((FileChannel)fileChannel, (ReadableByteChannel)Channels.newChannel((InputStream)downloadInputStream), (int)65536);
                                            fileChannel.force(true);
                                            this.filesFinishedCount.getAndIncrement();
                                        }
                                        finally {
                                            downloadObserver.finish();
                                        }
                                        if (fileMetadata.getFileName().toLowerCase().endsWith(".zip")) {
                                            if (!this.skipZipFileCountCheck) {
                                                ZipFile zipFile = new ZipFile(filePath.toFile());
                                                this.addExecutionLog(fileMetadata.getFileName() + " has " + zipFile.stream().count() + " files");
                                                zipFile.close();
                                            } else {
                                                this.addExecutionLog(this.iu.getFormattedString("PurviewDownloadExportOperation.Log.ZipFileCountSkipped", (Object)fileMetadata.getFileName()));
                                            }
                                            this.zipFilesCount.incrementAndGet();
                                        }
                                        for (String transientWarning : transientWarnings) {
                                            this.addTransientWarning(transientWarning, true);
                                        }
                                        if (fileChannel == null) break;
                                    }
                                    catch (Throwable throwable) {
                                        if (fileChannel != null) {
                                            try {
                                                fileChannel.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    fileChannel.close();
                                }
                                catch (Exception e) {
                                    LOGGER.error("Could not download file, " + fileMetadata.getFileName(), (Throwable)e);
                                    if (!this.atomicStopRequested.get() && this.retryFailedDownloads && attempt <= this.retryAttempts) {
                                        Thread.interrupted();
                                        if (downloadObserver.getError() == null) {
                                            String transientWarning = this.iu.getFormattedString("PurviewDownloadExportOperation.Warning.ErrorDownloadingFileRetrying", (Object)fileMetadata.getFileName());
                                            transientWarnings.add(transientWarning);
                                            this.addTransientWarning(transientWarning, false);
                                        }
                                        try {
                                            Files.deleteIfExists(filePath);
                                        }
                                        catch (IOException ex) {
                                            LOGGER.error("Error deleting failed file", (Throwable)e);
                                        }
                                        continue;
                                    }
                                    errors.add(this.iu.getFormattedString("PurviewDownloadExportOperation.Error.CouldNotDownloadFile", new Object[]{fileMetadata.getFileName(), ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                                }
                                break;
                            }
                        }
                    });
                    this.logDownloadSpeed(startMillis, this.sizeWritten.get());
                }
                finally {
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_download_zip_count}", String.valueOf(this.zipFilesCount.get()))));
                    observerThreadPool.shutdownNow();
                    complete.set(true);
                }
            });
            downloadThread.setName("Automate - Purview Download Thread");
            downloadThread.start();
            while (!complete.get()) {
                if (this.stopRequested) {
                    this.atomicStopRequested.set(true);
                }
                Thread.sleep(5000L);
            }
            if (!errors.isEmpty()) {
                throw new PurviewOperationException(String.join((CharSequence)"\n", errors));
            }
        });
    }

    private InputStream getExportDownloadInputStream(ExportFileMetadata exportFileMetadata) throws IOException {
        String downloadToken = this.purviewRestClient.getPurviewDownloadToken();
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Authorization", (Object)("Bearer " + downloadToken));
        headers.add((Object)"X-AllowWithAADToken", (Object)"true");
        LOGGER.info("Download URL: " + exportFileMetadata.getDownloadUrl());
        LOGGER.info("Download token length: " + downloadToken.length());
        Response response = WsRsRestClientFactory.getClient((String)(this.getOperationName() + "-" + exportFileMetadata.getFileName() + "-" + DateTime.now().getMillis())).target(exportFileMetadata.getDownloadUrl()).request(new String[]{"application/octet-stream"}).headers((MultivaluedMap)headers).get();
        if (response.getStatus() != 200) {
            response.bufferEntity();
            String responseString = (String)response.readEntity(String.class);
            String errorMessage = "HTTP/" + response.getStatus() + " " + responseString;
            throw new PurviewRestException(errorMessage);
        }
        return (InputStream)response.getEntity();
    }

    @Override
    protected double getPercentageComplete() {
        double percentage = this.percentageComplete;
        if (this.totalSize > 0L) {
            double percentageScale = 1.0 - percentage;
            percentage = percentageScale * ((double)this.sizeWritten.get() / (double)this.totalSize);
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentage = Math.min(percentage, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentage = Math.max(percentage, 1.0E-4);
        }
        return percentage;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && !this.stageName.isEmpty()) {
            result = (String)result + " / " + this.stageName;
        }
        if (this.downloadSpeed != null) {
            if (!((String)result).isEmpty()) {
                result = (String)result + " / ";
            }
            result = (String)result + FormattingUtils.sizeToDisplaySize((long)this.downloadSpeed.get()) + "/s";
        }
        if (this.fileCount > 0) {
            if (!((String)result).isEmpty()) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("PurviewDownloadExportOperation.Progress.FileDownloaded", (long)this.filesFinishedCount.get());
        }
        return result;
    }

    private class DownloadObserver {
        final String fileName;
        final Thread writeThread = Thread.currentThread();
        BoundedInputStream downloadInputStream;
        long count;
        boolean done;
        final long throwAfterNSecondsFrozen;
        long lastReadUpdateMillis;
        String error;

        DownloadObserver(String fileName, long throwAfterNSecondsFrozen) {
            this.fileName = fileName;
            this.throwAfterNSecondsFrozen = throwAfterNSecondsFrozen;
        }

        public long run() {
            return this.run(true);
        }

        public long run(boolean interruptWriteThreadIfFrozen) {
            if (PurviewDownloadExportOperationImplementation.this.atomicStopRequested.get()) {
                this.writeThread.interrupt();
                return 0L;
            }
            long prevCount = this.count;
            this.count = this.downloadInputStream.getCount();
            long read = this.count - prevCount;
            PurviewDownloadExportOperationImplementation.this.sizeWritten.getAndUpdate(prev -> prev + read);
            long currentMillis = System.currentTimeMillis();
            if (read != 0L || this.lastReadUpdateMillis == 0L) {
                this.lastReadUpdateMillis = currentMillis;
                if (read != 0L) {
                    this.clearError();
                }
            } else if (interruptWriteThreadIfFrozen && (currentMillis - this.lastReadUpdateMillis) / 1000L > this.throwAfterNSecondsFrozen) {
                this.error = PurviewDownloadExportOperationImplementation.this.iu.getFormattedString("DownloadObserver.Warning.DetectedFrozenFileProgress", (Object)this.fileName);
                PurviewDownloadExportOperationImplementation.this.addTransientWarning(this.error, false);
                this.writeThread.interrupt();
            }
            return read;
        }

        public void setDownloadInputStream(BoundedInputStream bin) {
            this.downloadInputStream = bin;
            this.done = false;
            this.lastReadUpdateMillis = 0L;
            if (this.count > 0L) {
                PurviewDownloadExportOperationImplementation.this.sizeWritten.getAndUpdate(prev -> prev - this.count);
                this.count = 0L;
            }
        }

        public void clearError() {
            if (this.error != null) {
                PurviewDownloadExportOperationImplementation.this.addTransientWarning(this.error, true);
                this.error = null;
            }
        }

        public void finish() {
            this.run(false);
            this.done = true;
        }

        public boolean getDone() {
            return this.done;
        }

        public String getError() {
            return this.error;
        }
    }
}

