/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.internal.purview.EDiscoverySearch;
import com.nuix.automate.utils.models.internal.purview.operations.CaseOperation;
import com.nuix.automate.utils.models.internal.purview.operations.EstimateOperation;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.PurviewEstimateSearchStatisticsOperation;

public class PurviewEstimateSearchStatisticsOperationImplementation
extends PurviewEstimateSearchStatisticsOperation {
    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            this.initialize();
            this.searchIdentifier = this.executionContext.evalParameters(this.searchIdentifier, this);
            this.stageName = this.iu.getString("PurviewEstimateSearchStatisticsOperation.Stage.GettingSearch");
            this.percentageComplete = 0.1;
            EDiscoverySearch search = this.getSearch(this.searchIdentifierType, this.searchIdentifier);
            this.stageName = this.iu.getString("PurviewEstimateSearchStatisticsOperation.Stage.EstimatingStatistics");
            this.percentageComplete = 0.2;
            EstimateOperation estimateOperation = this.purviewRestClient.estimateSearchStatistics(this.purviewCaseId, search.getId());
            this.addExecutionLog(this.iu.getFormattedString("PurviewEstimateSearchStatisticsOperation.Log.EstimateOperationId", (Object)estimateOperation.getId()));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_estimate_statistics_job_id}", estimateOperation.getId())));
            if (this.waitForCompletion) {
                String indexedItemCount = (estimateOperation = (EstimateOperation)this.waitForOperationToComplete((CaseOperation)estimateOperation)).getIndexedItemCount() == null ? "0" : String.valueOf(estimateOperation.getIndexedItemCount());
                long indexedItemSize = estimateOperation.getIndexedItemsSize() == null ? 0L : estimateOperation.getIndexedItemsSize();
                String unIndexedItemCount = estimateOperation.getUnindexedItemCount() == null ? "0" : String.valueOf(estimateOperation.getUnindexedItemCount());
                long unIndexedItemSize = estimateOperation.getUnindexedItemsSize() == null ? 0L : estimateOperation.getUnindexedItemsSize();
                String mailboxCount = estimateOperation.getMailboxCount() == null ? "0" : String.valueOf(estimateOperation.getMailboxCount());
                String siteCount = estimateOperation.getSiteCount() == null ? "0" : String.valueOf(estimateOperation.getSiteCount());
                this.addExecutionLog(this.iu.getFormattedString("PurviewEstimateSearchStatisticsOperation.Log.IndexedItemCount", (Object)indexedItemCount));
                this.addExecutionLog(this.iu.getFormattedString("PurviewEstimateSearchStatisticsOperation.Log.IndexedItemSize", (Object)FormattingUtils.sizeToDisplaySize((long)indexedItemSize)));
                this.addExecutionLog(this.iu.getFormattedString("PurviewEstimateSearchStatisticsOperation.Log.UnIndexedItemCount", (Object)unIndexedItemCount));
                this.addExecutionLog(this.iu.getFormattedString("PurviewEstimateSearchStatisticsOperation.Log.UnIndexedItemSize", (Object)FormattingUtils.sizeToDisplaySize((long)unIndexedItemSize)));
                this.addExecutionLog(this.iu.getFormattedString("PurviewEstimateSearchStatisticsOperation.Log.MailBoxCount", (Object)mailboxCount));
                this.addExecutionLog(this.iu.getFormattedString("PurviewEstimateSearchStatisticsOperation.Log.SiteCount", (Object)siteCount));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_estimate_statistics_indexed_item_count}", indexedItemCount)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_estimate_statistics_indexed_item_size}", String.valueOf(indexedItemSize))));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_estimate_statistics_unindexed_item_count}", unIndexedItemCount)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_estimate_statistics_unindexed_item_size}", String.valueOf(unIndexedItemSize))));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_estimate_statistics_mailbox_count}", mailboxCount)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_estimate_statistics_site_count}", siteCount)));
            }
        });
    }
}

