/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroups;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.purview.SearchExportEmailFormat;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.PurviewOperation;
import com.nuix.automate.workflow.core.execution.operations.PurviewUseCaseOperation;
import com.nuix.automate.workflow.core.execution.options.purview.PurviewIdentifierType;
import java.util.List;

@FormFieldRow(name="searchIdentifierRow", children={"searchIdentifierType", "searchIdentifier"})
@FormFieldGroups(value={@FormFieldGroup(name="includeItemsGroup", children={"includeSearchHits", "includePartiallyIndexedFromResponsiveLocations", "includePartiallyIndexedFromNonResponsiveLocations"}), @FormFieldGroup(name="additionalOptionsGroup", children={"collectTeamsAndYammerConversations", "collectCloudAttachments", "collectAllDocumentVersions", "collectSubfolderContents", "collectListAttachments", "splitSource", "includeFolderAndPath", "friendlyName", "condensePaths"})})
@OperationMetadata(alias=OperationAlias.PURVIEW_EXPORT_SEARCH, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"MICROSOFT_PURVIEW"}), @OperationTag(name="Category", value={"EXPORT"})})
@OperationLicenseModule(module=ModuleType.PURVIEW_COLLECTIONS_ADVANCED)
public class PurviewExportSearchOperation
extends PurviewOperation {
    @FormField
    @ExcludeFromPrintableOptions
    public PurviewIdentifierType searchIdentifierType = PurviewIdentifierType.ID;
    @FormField
    public String searchIdentifier = "{purview_search_id}";
    @FormField
    public String exportName;
    @FormField(componentType=FieldComponentType.TEXTAREA, required=false)
    @ExcludeFromPrintableOptions
    public String exportDescription;
    @FormField
    public boolean includeSearchHits = true;
    @FormField
    public boolean includePartiallyIndexedFromResponsiveLocations;
    @FormField
    public boolean includePartiallyIndexedFromNonResponsiveLocations;
    @FormField
    public boolean collectTeamsAndYammerConversations;
    @FormField
    public boolean collectCloudAttachments;
    @FormField
    public boolean collectAllDocumentVersions;
    @FormField
    public boolean collectSubfolderContents;
    @FormField
    public boolean collectListAttachments;
    @FormField(componentType=FieldComponentType.RADIO_BUTTON)
    public SearchExportEmailFormat emailExportFormat = SearchExportEmailFormat.PST;
    @FormField(enableOn={@OnField(name="emailExportFormat", value={"MSG", "PST"})})
    public boolean splitSource = true;
    @FormField(enableOn={@OnField(name="emailExportFormat", value={"MSG", "PST"})})
    public boolean includeFolderAndPath = true;
    @FormField(enableOn={@OnField(name="emailExportFormat", value={"MSG", "PST"})})
    public boolean friendlyName = true;
    @FormField(enableOn={@OnField(name="emailExportFormat", value={"MSG", "PST"})})
    public boolean condensePaths = true;
    @FormField
    public boolean waitForCompletion = true;

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (!this.enableFieldOverwrite) {
            if (this.searchIdentifierType == null || this.searchIdentifier == null || this.searchIdentifier.trim().isEmpty()) {
                prerequisites.add(this.iu.getString("PurviewExportSearchOperation.Prerequisites.SearchIdentifierRequired"));
            }
            if (this.exportName == null || this.exportName.trim().isEmpty()) {
                prerequisites.add(this.iu.getString("PurviewExportSearchOperation.Prerequisites.ExportNameRequired"));
            }
            if (!(this.includeSearchHits || this.includePartiallyIndexedFromResponsiveLocations || this.includePartiallyIndexedFromNonResponsiveLocations)) {
                prerequisites.add(this.iu.getString("PurviewExportSearchOperation.Prerequisites.MissingExportItemsToInclude"));
            }
            if (this.emailExportFormat == null) {
                prerequisites.add(this.iu.getString("PurviewExportSearchOperation.Prerequisites.ExportFormatRequired"));
            }
        }
        prerequisites.addAll(this.getMissingRequiredOperations(PurviewUseCaseOperation.class));
        return prerequisites;
    }
}

