/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.purview.EDiscoverySearch;
import com.nuix.automate.utils.models.internal.purview.EDiscoverySearchExport;
import com.nuix.automate.utils.models.internal.purview.operations.CaseOperation;
import com.nuix.automate.utils.models.internal.purview.operations.ExportOperation;
import com.nuix.automate.utils.models.internal.purview.operations.SearchExportOperation;
import com.nuix.automate.workflow.core.execution.operations.PurviewExportSearchOperation;
import java.util.HashSet;

public class PurviewExportSearchOperationImplementation
extends PurviewExportSearchOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PurviewExportSearchOperation.class);

    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            this.initialize();
            this.searchIdentifier = this.executionContext.evalParameters(this.searchIdentifier, this);
            this.exportName = this.executionContext.evalParameters(this.exportName, this);
            this.exportDescription = this.executionContext.evalParameters(this.exportDescription, this);
            this.stageName = this.iu.getString("PurviewExportSearchOperation.Stage.GettingSearch");
            this.percentageComplete = 0.1;
            EDiscoverySearch search = this.getSearch(this.searchIdentifierType, this.searchIdentifier);
            EDiscoverySearchExport export = new EDiscoverySearchExport();
            export.setDisplayName(this.exportName);
            export.setDescription(this.exportDescription);
            export.setExportFormat(this.emailExportFormat);
            export.setExportCriteria(this.buildExportCriteria());
            export.setExportLocation(this.buildExportPartiallyIndexedItemLocations());
            export.setAdditionalOptions(this.buildExportAdditionalOptions());
            this.stageName = this.iu.getString("PurviewExportSearchOperation.Stage.Exporting");
            this.percentageComplete = 0.2;
            SearchExportOperation exportOperation = this.purviewRestClient.exportSearch(this.purviewCaseId, search.getId(), export);
            this.addExecutionLog(this.iu.getFormattedString("PurviewExportSearchOperation.Log.ExportOperationId", (Object)exportOperation.getId()));
            if (this.waitForCompletion) {
                exportOperation = (SearchExportOperation)this.waitForOperationToComplete((CaseOperation)exportOperation);
            }
            this.setExportOperationBuiltInParameters((ExportOperation)exportOperation);
        });
    }

    private String buildExportCriteria() {
        HashSet<String> exportCriteria = new HashSet<String>();
        if (this.includeSearchHits) {
            exportCriteria.add("searchHits");
        }
        if (this.includePartiallyIndexedFromResponsiveLocations || this.includePartiallyIndexedFromNonResponsiveLocations) {
            exportCriteria.add("partiallyIndexed");
        }
        return String.join((CharSequence)", ", exportCriteria);
    }

    private String buildExportPartiallyIndexedItemLocations() {
        HashSet<String> exportLocation = new HashSet<String>();
        if (this.includePartiallyIndexedFromResponsiveLocations) {
            exportLocation.add("responsiveLocations");
        }
        if (this.includePartiallyIndexedFromNonResponsiveLocations) {
            exportLocation.add("nonresponsiveLocations");
        }
        if (exportLocation.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)", ", exportLocation);
    }

    private String buildExportAdditionalOptions() {
        HashSet<String> additionalOptions = new HashSet<String>();
        if (this.collectTeamsAndYammerConversations) {
            additionalOptions.add("teamsAndYammerConversations");
        }
        if (this.collectCloudAttachments) {
            additionalOptions.add("cloudAttachments");
        }
        if (this.collectAllDocumentVersions) {
            additionalOptions.add("allDocumentVersions");
        }
        if (this.collectSubfolderContents) {
            additionalOptions.add("subfolderContents");
        }
        if (this.collectListAttachments) {
            additionalOptions.add("listAttachments");
        }
        if (this.splitSource) {
            additionalOptions.add("splitSource");
        }
        if (this.includeFolderAndPath) {
            additionalOptions.add("includeFolderAndPath");
        }
        if (this.friendlyName) {
            additionalOptions.add("friendlyName");
        }
        if (this.condensePaths) {
            additionalOptions.add("condensePaths");
        }
        if (additionalOptions.isEmpty()) {
            additionalOptions.add("none");
        }
        return String.join((CharSequence)", ", additionalOptions);
    }
}

