/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.purview.Custodian;
import com.nuix.automate.utils.models.internal.purview.DataSource;
import com.nuix.automate.utils.models.internal.purview.NonCustodialDataSource;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.PurviewQueryObjectsOperation;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.Partitioner;
import org.openimaj.util.parallel.partition.RangePartitioner;

public class PurviewQueryObjectsOperationImplementation
extends PurviewQueryObjectsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PurviewQueryObjectsOperation.class);
    private transient double stageId;
    private transient double stageCount;

    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            this.stageCount = 3.0;
            this.initialize();
            List<Custodian> caseCustodians = null;
            this.stageId = 0.0;
            if (this.custodians || this.custodialDataSources) {
                LOGGER.info("Getting case custodians");
                this.stageName = this.iu.getString("PurviewQueryObjectsOperation.Stage.QueryingCustodians");
                caseCustodians = this.purviewRestClient.getCustodians(this.purviewCaseId);
                this.addExecutionLog(this.iu.getNumeralFormattedString("PurviewQueryObjectsOperation.Log.FoundCustodians", (long)caseCustodians.size(), new Object[0]));
            }
            if (this.custodians) {
                HashMap<String, Custodian> custodianMap = new HashMap<String, Custodian>();
                for (Custodian custodian : caseCustodians) {
                    custodianMap.put(custodian.getId(), custodian);
                }
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_custodians}", SerializationUtils.toJson(custodianMap))));
            }
            this.stageId = 1.0;
            if (this.custodialDataSources) {
                LOGGER.info("Getting case custodial data sources");
                this.stageName = this.iu.getString("PurviewQueryObjectsOperation.Stage.QueryingCustodialDataSources");
                ConcurrentHashMap custodialDataSourcesMap = new ConcurrentHashMap();
                AtomicLong dataSourcesCount = new AtomicLong();
                Parallel.forEachPartitioned((Partitioner)new RangePartitioner(caseCustodians, this.parallelThreads), iterator -> {
                    while (iterator.hasNext() && !this.stopRequested) {
                        Custodian custodian = (Custodian)iterator.next();
                        LOGGER.info("Getting data sources for custodian: " + custodian.getEmail());
                        ConcurrentHashMap<String, DataSource> dataSources = new ConcurrentHashMap<String, DataSource>();
                        custodialDataSourcesMap.put(custodian.getId(), dataSources);
                        try {
                            for (DataSource dataSource : this.purviewRestClient.getAllDataSourcesForCustodian(this.purviewCaseId, custodian.getId())) {
                                String key = dataSource.getId();
                                if (key == null) {
                                    key = dataSource.getDataSourceValue();
                                }
                                if (key == null) continue;
                                dataSources.put(key, dataSource);
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Error getting data sources for custodian: " + custodian.getEmail(), (Throwable)e);
                        }
                        dataSourcesCount.addAndGet(dataSources.size());
                    }
                }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                this.addExecutionLog(this.iu.getNumeralFormattedString("PurviewQueryObjectsOperation.Log.FoundCustodialDataSources", dataSourcesCount.get(), new Object[0]));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_custodial_data_sources}", SerializationUtils.toJson(custodialDataSourcesMap))));
            }
            this.stageId = 2.0;
            if (this.nonCustodialDataSources) {
                LOGGER.info("Getting case non-custodial data sources");
                this.stageName = this.iu.getString("PurviewQueryObjectsOperation.Stage.QueryingNonCustodialDataSources");
                ConcurrentHashMap<String, NonCustodialDataSource> nonCustodialDataSourcesMap = new ConcurrentHashMap<String, NonCustodialDataSource>();
                for (NonCustodialDataSource nonCustodialDataSource : this.purviewRestClient.getNonCustodialDataSources(this.purviewCaseId)) {
                    String key = nonCustodialDataSource.getId();
                    if (key == null) continue;
                    nonCustodialDataSourcesMap.put(key, nonCustodialDataSource);
                }
                this.addExecutionLog(this.iu.getNumeralFormattedString("PurviewQueryObjectsOperation.Log.FoundNonCustodialDataSources", (long)nonCustodialDataSourcesMap.size(), new Object[0]));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_non_custodial_data_sources}", SerializationUtils.toJson(nonCustodialDataSourcesMap))));
            }
        });
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.stageCount > 0.0) {
            percentageComplete = this.stageId / this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }
}

