/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.models.internal.graphapi.MicrosoftGraphObject;
import com.nuix.automate.utils.models.internal.purview.NonCustodialDataSource;
import com.nuix.automate.utils.models.internal.purview.operations.CaseOperation;
import com.nuix.automate.utils.models.internal.purview.operations.HoldOperation;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.PurviewRemoveHoldFromNonCustodialDataSourcesOperation;
import com.nuix.automate.workflow.core.execution.options.purview.DataSourceInputType;
import com.nuix.automate.workflow.core.execution.options.purview.NonCustodialDataSourceSubmission;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class PurviewRemoveHoldFromNonCustodialDataSourcesOperationImplementation
extends PurviewRemoveHoldFromNonCustodialDataSourcesOperation {
    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            HoldOperation removeHoldOperation;
            this.initialize();
            this.stageName = this.iu.getString("PurviewRemoveHoldFromNonCustodialDataSourcesOperation.Stage.PreparingNonCustodialDataSources");
            this.percentageComplete = 0.0;
            if (this.inputType == DataSourceInputType.ALL_CASE) {
                removeHoldOperation = this.purviewRestClient.removeHoldFromNonCustodialDataSources(this.purviewCaseId, null);
                this.addExecutionLog(this.iu.getString("PurviewRemoveHoldFromNonCustodialDataSourcesOperation.Log.RemovedHoldFromAllNonCustodialDataSources"));
            } else {
                int nonCustodialDataSourcesNotFoundCount;
                List<NonCustodialDataSource> caseNonCustodialDataSources = this.purviewRestClient.getNonCustodialDataSources(this.purviewCaseId);
                HashSet<String> nonCustodialDataSourceIds = new HashSet<String>();
                switch (this.inputType) {
                    case FILE: {
                        Set nonCustodialDataSourceValues = this.readNonCustodialDataSourcesFile(this.nonCustodialDataSourcesFileLocation).stream().map(NonCustodialDataSourceSubmission::getValue).collect(Collectors.toSet());
                        for (NonCustodialDataSource nonCustodialDataSource : caseNonCustodialDataSources) {
                            String dataSourceValue = null;
                            if (nonCustodialDataSource.getDataSource() != null) {
                                dataSourceValue = nonCustodialDataSource.getDataSource().getDataSourceValue();
                            }
                            if (dataSourceValue == null || !nonCustodialDataSourceValues.remove(dataSourceValue = dataSourceValue.trim())) continue;
                            nonCustodialDataSourceIds.add(nonCustodialDataSource.getId());
                        }
                        nonCustodialDataSourcesNotFoundCount = nonCustodialDataSourceValues.size();
                        break;
                    }
                    case IDS_JSON: {
                        this.nonCustodialDataSourceIdsJson = this.executionContext.evalParameters(this.nonCustodialDataSourceIdsJson, this);
                        nonCustodialDataSourceIds.addAll((Collection)SerializationUtils.fromJson((String)this.nonCustodialDataSourceIdsJson));
                        int nonCustodialDataSourceIdsSize = nonCustodialDataSourceIds.size();
                        Set caseNonCustodialDataSourceIds = caseNonCustodialDataSources.stream().map(MicrosoftGraphObject::getId).collect(Collectors.toSet());
                        nonCustodialDataSourceIds.retainAll(caseNonCustodialDataSourceIds);
                        nonCustodialDataSourcesNotFoundCount = nonCustodialDataSourceIdsSize - nonCustodialDataSourceIds.size();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Data source input type not supported");
                    }
                }
                if (nonCustodialDataSourcesNotFoundCount > 0) {
                    this.addExecutionLog(this.iu.getNumeralString("PurviewRemoveHoldFromNonCustodialDataSourcesOperation.Log.NonCustodialDataSourcesNotFound", (long)nonCustodialDataSourcesNotFoundCount));
                }
                if (nonCustodialDataSourceIds.isEmpty()) {
                    this.addWarning(this.iu.getString("PurviewRemoveHoldFromNonCustodialDataSourcesOperation.Log.NoNonCustodialDataSources"));
                    return;
                }
                removeHoldOperation = this.purviewRestClient.removeHoldFromNonCustodialDataSources(this.purviewCaseId, nonCustodialDataSourceIds);
                this.addExecutionLog(this.iu.getNumeralString("PurviewRemoveHoldFromNonCustodialDataSourcesOperation.Log.RemovedHoldFromNonCustodialDataSources", (long)nonCustodialDataSourceIds.size()));
            }
            this.stageName = this.iu.getString("PurviewRemoveHoldFromNonCustodialDataSourcesOperation.Stage.RemovingHold");
            this.percentageComplete = 0.2;
            if (removeHoldOperation != null) {
                this.addExecutionLog(this.iu.getFormattedString("PurviewRemoveHoldFromNonCustodialDataSourcesOperation.Log.HoldOperationId", (Object)removeHoldOperation.getId()));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_remove_hold_to_non_custodial_data_sources_job_id}", removeHoldOperation.getId())));
                if (this.stopRequested) {
                    throw new WorkflowExecutionStopRequested();
                }
                if (this.waitForCompletion) {
                    this.waitForOperationToComplete((CaseOperation)removeHoldOperation);
                }
            } else {
                this.addExecutionLog(this.iu.getString("PurviewRemoveHoldFromNonCustodialDataSourcesOperation.Log.HoldOperationNotCreated"));
            }
        });
    }
}

