/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.internal.purview.ExportFileMetadata;
import com.nuix.automate.utils.models.internal.purview.operations.CaseOperation;
import com.nuix.automate.utils.models.internal.purview.operations.CaseOperationStatus;
import com.nuix.automate.utils.models.internal.purview.operations.ExportOperation;
import com.nuix.automate.workflow.core.execution.operations.PurviewSetExportOperation;
import com.nuix.automate.workflow.core.utils.purview.PurviewOperationException;

public class PurviewSetExportOperationImplementation
extends PurviewSetExportOperation {
    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            this.initialize();
            this.exportJobIdentifier = this.executionContext.evalParameters(this.exportJobIdentifier, this);
            this.stageName = this.iu.getString("PurviewSetExportOperation.Stage.GettingExportJob");
            this.percentageComplete = 0.1;
            ExportOperation exportOperation = this.getExportJob(this.exportJobIdentifierType, this.exportJobIdentifier);
            if (exportOperation == null) {
                String errorMessage = this.iu.getFormattedString("PurviewSetExportOperation.Error.CannotFindExportJobWith" + this.exportJobIdentifierType.name(), (Object)this.exportJobIdentifier);
                throw new PurviewOperationException(errorMessage);
            }
            this.addExecutionLog(this.iu.getFormattedString("PurviewSetExportOperation.Log.ExportJobId", new Object[]{exportOperation.getOutputName(), exportOperation.getId()}));
            if (this.waitForCompletion) {
                this.stageName = this.iu.getString("PurviewSetExportOperation.Stage.WaitingForExport");
                this.percentageComplete = 0.6;
                exportOperation = (ExportOperation)this.waitForOperationToComplete((CaseOperation)exportOperation);
            }
            this.setExportOperationBuiltInParameters(exportOperation);
            if (exportOperation.getStatus() == CaseOperationStatus.SUCCEEDED) {
                int fileCount = exportOperation.getExportFileMetadata().size();
                long totalSize = exportOperation.getExportFileMetadata().stream().mapToLong(ExportFileMetadata::getSize).sum();
                this.addExecutionLog(this.iu.getFormattedString("PurviewSetExportOperation.Log.FileCount", (Object)fileCount));
                this.addExecutionLog(this.iu.getFormattedString("PurviewSetExportOperation.Log.TotalSize", (Object)FormattingUtils.sizeToDisplaySize((long)totalSize)));
            }
        });
    }
}

