/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.models.internal.purview.EDiscoveryCase;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.PurviewUseCaseOperation;
import com.nuix.automate.workflow.core.execution.options.purview.PurviewIdentifierType;
import com.nuix.automate.workflow.core.utils.purview.PurviewObjectDoesNotExistException;
import com.nuix.automate.workflow.core.utils.purview.PurviewOperationException;

public class PurviewUseCaseOperationImplementation
extends PurviewUseCaseOperation {
    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            boolean caseCreated;
            EDiscoveryCase purviewCase;
            block9: {
                this.initializePurviewRestClient();
                this.caseIdentifier = this.executionContext.evalParameters(this.caseIdentifier, this);
                this.caseExternalId = this.executionContext.evalParameters(this.caseExternalId, this);
                this.caseDescription = this.executionContext.evalParameters(this.caseDescription, this);
                this.stageName = this.iu.getString("PurviewUseCaseOperation.Stage.GettingCase");
                this.percentageComplete = 0.3;
                purviewCase = null;
                caseCreated = false;
                try {
                    switch (this.caseIdentifierType) {
                        case ID: {
                            purviewCase = this.purviewRestClient.getCaseForId(this.caseIdentifier);
                            break;
                        }
                        case NAME: {
                            purviewCase = this.purviewRestClient.getCaseForName(this.caseIdentifier);
                            break;
                        }
                        case NAME_REGEX: {
                            purviewCase = this.purviewRestClient.getCaseForNameRegex(this.caseIdentifier);
                        }
                    }
                    this.addExecutionLog(this.iu.getFormattedString("PurviewUseCaseOperation.Log.FoundExistingCase", new Object[]{purviewCase.getDisplayName(), purviewCase.getId()}));
                }
                catch (PurviewObjectDoesNotExistException e) {
                    if (this.caseIdentifierType != PurviewIdentifierType.NAME || !this.createCaseIfNotExists) break block9;
                    this.stageName = this.iu.getString("PurviewUseCaseOperation.Stage.CreatingCase");
                    this.percentageComplete = 0.6;
                    this.addExecutionLog(this.iu.getString("PurviewUseCaseOperation.Log.CouldNotFindCaseCreating"));
                    purviewCase = new EDiscoveryCase();
                    purviewCase.setDisplayName(this.caseIdentifier);
                    purviewCase.setExternalId(this.caseExternalId);
                    purviewCase.setDescription(this.caseDescription);
                    purviewCase = this.purviewRestClient.createCase(purviewCase);
                    caseCreated = true;
                    this.addExecutionLog(this.iu.getString("PurviewUseCaseOperation.Log.CreatedCase"));
                    this.addExecutionLog(this.iu.getFormattedString("PurviewUseCaseOperation.Log.CaseName", (Object)purviewCase.getDisplayName()));
                    this.addExecutionLog(this.iu.getFormattedString("PurviewUseCaseOperation.Log.CaseId", (Object)purviewCase.getId()));
                }
            }
            if (purviewCase == null) {
                String errorMessage = this.iu.getFormattedString("PurviewUseCaseOperation.Error.CannotFindCaseWith" + this.caseIdentifierType.name(), (Object)this.caseIdentifier);
                throw new PurviewOperationException(errorMessage);
            }
            this.addExecutionLog(this.iu.getFormattedString("PurviewUseCaseOperation.Log.CaseStatus", (Object)purviewCase.getStatus().getValue()));
            if (purviewCase.getExternalId() != null && !purviewCase.getExternalId().trim().isEmpty()) {
                this.addExecutionLog(this.iu.getFormattedString("PurviewUseCaseOperation.Log.CaseNumber", (Object)purviewCase.getExternalId()));
            }
            String caseOverviewUrl = "https://compliance.microsoft.com/advancedediscovery/cases/v2/" + purviewCase.getId() + "?casename=" + purviewCase.getDisplayName();
            this.addExecutionLog(this.iu.getFormattedString("PurviewUseCaseOperation.Log.CaseOverviewUrl", (Object)caseOverviewUrl));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_case_id}", purviewCase.getId())));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_case_name}", purviewCase.getDisplayName())));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_case_status}", purviewCase.getStatus().getValue())));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_case_created}", String.valueOf(caseCreated))));
        });
    }
}

