/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.QueryFromSqlOperation;
import com.nuix.automate.workflow.core.execution.options.general.MetadataMatchHeader;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.sql.SqlUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Item;
import nuix.ItemCustomMetadataMap;
import nuix.ProductionSetItem;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class QueryFromSqlOperationImplementation
extends QueryFromSqlOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(QueryFromSqlOperation.class);
    private transient Connection connection;
    private transient String effectiveCsvPath;
    private transient BufferedWriter bufferedWriter;
    private transient long itemsInScope;
    private transient Map<String, Object[]> indexedRows;
    private transient String[] header;
    private transient String stageName;
    private transient long stageItems;
    private transient AtomicLong processedItems;
    private transient long exportedItems;
    private transient int stageId;
    private transient int stageCount;

    @Override
    protected void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.instance = this.executionContext.evalParameters(this.instance, this);
        this.domain = this.executionContext.evalParameters(this.domain, this);
        this.username = this.executionContext.evalParameters(this.username, this);
        this.password = this.executionContext.evalProtectedParameter(this.password);
        this.databaseName = this.executionContext.evalParameters(this.databaseName, this);
        this.sqlServerName = this.executionContext.evalParameters(this.sqlServerName, this);
        this.sqlQuery = this.executionContext.evalParameters(this.sqlQuery, this);
        this.stageCount = 2;
        if (this.resultsOutputCustomMetadata) {
            ++this.stageCount;
        }
        if (this.resultsOutputCsv) {
            ++this.stageCount;
        }
        this.stageItems = 0L;
        this.processedItems = new AtomicLong();
        this.exportedItems = 0L;
        this.startTriggerThread = new Thread(() -> {
            block23: {
                try {
                    this.stageId = 1;
                    this.stageName = this.iu.getString("QueryFromSqlOperation.Stage.ConnectingToSql");
                    this.connection = SqlUtils.createConnection(this.sqlPlatform, this.sqlServerName, this.port, this.instance, this.domain, this.databaseName, this.sqlEncryption, this.username, this.password, this.executionContext, this);
                    try {
                        PreparedStatement statement = this.connection.prepareStatement(this.sqlQuery);
                        ResultSet resultSet = statement.executeQuery();
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        int columnCount = resultSetMetaData.getColumnCount();
                        this.stageId = 2;
                        this.stageName = this.iu.getString("QueryFromSqlOperation.Stage.QueryingDataFromSql");
                        this.header = new String[columnCount];
                        for (int j = 1; j <= columnCount; ++j) {
                            this.header[j - 1] = resultSetMetaData.getColumnName(j);
                        }
                        this.indexedRows = new HashMap<String, Object[]>();
                        while (resultSet.next()) {
                            Object[] row = new Object[columnCount];
                            for (int i = 1; i <= columnCount; ++i) {
                                row[i - 1] = resultSet.getObject(i);
                            }
                            this.indexedRows.put(row[0].toString(), row);
                        }
                        this.itemsInScope = this.indexedRows.size();
                        this.addExecutionLog(this.iu.getNumeralString("QueryFromSqlOperation.Log.QueriedRows", this.itemsInScope));
                        this.connection.close();
                    }
                    catch (Exception e) {
                        this.addWarning(this.iu.getString("QueryFromSqlOperation.Warning.UnableToParseSqlData"));
                        throw e;
                    }
                    if (this.resultsOutputCustomMetadata) {
                        this.stageId = 3;
                        this.stageName = this.iu.getString("QueryFromSqlOperation.Stage.AssigningMetadata");
                        if (this.header.length < 2) {
                            throw new Exception(this.iu.getString("QueryFromSqlOperation.Exception.MetadataFileMustContainTwoColumn"));
                        }
                        if (!this.header[0].equalsIgnoreCase("guid") && !this.header[0].equalsIgnoreCase("docid")) {
                            throw new Exception(this.iu.getString("QueryFromSqlOperation.Exception.FirstColumnMustBeGUID"));
                        }
                        if (this.header[0].equalsIgnoreCase("docid") && this.executionContext.nuixVersion.compareTo(new Version("7.4.0")) < 0) {
                            this.addWarning(this.iu.getNumeralString("QueryFromSqlOperation.Warning.ItemsSkipped", this.itemsInScope - 1L));
                        }
                        this.addExecutionLog(this.iu.getFormattedString("QueryFromSqlOperation.Log.ScopeQuery", (Object)this.scope));
                        Set itemsToUpdate = this.executionContext.nuixCase.searchUnsorted(this.scope);
                        this.stageItems = itemsToUpdate.size();
                        this.addExecutionLog(this.iu.getNumeralString("QueryFromSqlOperation.Log.ScopeCount", this.stageItems));
                        FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner((Iterable)itemsToUpdate, ItemsUtils.getPartitionerChunkSize(256, this));
                        try {
                            Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                                if (this.stopRequested) {
                                    throw new WorkflowExecutionStopRequested();
                                }
                                while (iterator.hasNext()) {
                                    Item itemToUpdate = (Item)iterator.next();
                                    if (this.stopRequested) {
                                        throw new WorkflowExecutionStopRequested();
                                    }
                                    this.updateItemCustomMetadata(itemToUpdate);
                                }
                            }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                        }
                        catch (WorkflowExecutionStopRequested e) {
                            this.trackStopped();
                            return;
                        }
                        catch (Exception e) {
                            LOGGER.warn("Exception thrown while processing items", (Throwable)e);
                        }
                    }
                    if (!this.resultsOutputCsv) break block23;
                    this.stageId = 4;
                    this.stageName = this.iu.getString("QueryFromSqlOperation.Stage.WritingCsv");
                    LOGGER.info("Unpacking path: " + this.resultsCsvPath);
                    this.effectiveCsvPath = this.executionContext.evalParameters(this.resultsCsvPath, this);
                    this.addExecutionLog(this.iu.getFormattedString("QueryFromSqlOperation.Log.OutputCSV", (Object)this.effectiveCsvPath));
                    try {
                        File outputFile = new File(this.effectiveCsvPath);
                        if (!outputFile.getParentFile().exists()) {
                            outputFile.getParentFile().mkdirs();
                        }
                        this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
                        this.bufferedWriter.write("\ufeff");
                        this.effectiveCsvPath = outputFile.getAbsolutePath();
                    }
                    catch (IOException e1) {
                        LOGGER.error("Cannot create file at default location.", (Throwable)e1);
                        throw e1;
                    }
                    try {
                        this.writeCsvHeader();
                        for (String key : this.indexedRows.keySet()) {
                            this.writeToCsv(key);
                        }
                        this.bufferedWriter.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot write data to output file", (Throwable)e);
                        throw e;
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("Operation unchecked exception", e);
                    try {
                        if (this.connection != null && !this.connection.isClosed()) {
                            this.connection.close();
                        }
                    }
                    catch (SQLException e2) {
                        LOGGER.warn("Unable to close connection to database");
                    }
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
            }
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void updateItemCustomMetadataMap(ItemCustomMetadataMap itemCustomMetadataMap, String fieldName, String additionalValue) {
        TreeSet<String> previousValues = new TreeSet<String>();
        if (itemCustomMetadataMap.containsKey((Object)fieldName)) {
            String[] splits;
            String previousValuesString = (String)itemCustomMetadataMap.get((Object)fieldName);
            for (String split : splits = previousValuesString.split("; ")) {
                if (split.length() <= 0) continue;
                previousValues.add(split);
            }
        }
        previousValues.add(additionalValue);
        String result = FormattingUtils.join(previousValues, (String)"; ", (int)10000);
        itemCustomMetadataMap.put((Object)fieldName, (Object)result);
    }

    private void updateItemCustomMetadata(Item itemToUpdate) {
        ItemCustomMetadataMap itemCustomMetadataMap = itemToUpdate.getCustomMetadata();
        String itemGuid = itemToUpdate.getGuid();
        Object[] row = null;
        if (this.metadataMatchHeader == MetadataMatchHeader.GUID) {
            row = this.indexedRows.get(itemGuid);
        } else if (this.metadataMatchHeader == MetadataMatchHeader.DocIDs && this.executionContext.nuixVersion.compareTo(new Version("7.4.0")) >= 0) {
            Set productionSetItems = itemToUpdate.getProductionSetItems();
            for (ProductionSetItem productionSetItem : productionSetItems) {
                String key = productionSetItem.getDocumentNumber().toString();
                if (!this.indexedRows.containsKey(key)) continue;
                row = this.indexedRows.get(key);
                break;
            }
        }
        if (row != null) {
            for (int i = 1; i <= this.header.length - 1; ++i) {
                String columnName = this.header[i];
                if (this.appendToPreviousMetadata) {
                    this.updateItemCustomMetadataMap(itemCustomMetadataMap, columnName, row[i].toString());
                    continue;
                }
                itemCustomMetadataMap.put((Object)columnName, row[i]);
            }
        }
        this.processedItems.incrementAndGet();
    }

    private void writeCsvHeader() throws IOException {
        this.bufferedWriter.write(String.join((CharSequence)",", this.header));
        this.bufferedWriter.write("\n");
    }

    private void writeToCsv(String key) throws IOException {
        Object[] row = this.indexedRows.get(key);
        CharSequence[] csvEncodedRow = new String[this.header.length];
        if (row != null) {
            for (int i = 0; i < this.header.length; ++i) {
                Object value = row[i];
                csvEncodedRow[i] = value != null ? FormattingUtils.encodeForCsv((String)row[i].toString()) : "";
            }
            this.bufferedWriter.write(String.join((CharSequence)",", csvEncodedRow));
            this.bufferedWriter.write("\n");
            ++this.exportedItems;
        }
    }

    @Override
    protected void stopTriggered() {
        this.stopRequested = true;
    }

    @Override
    protected double getPercentageComplete() {
        if (this.itemsInScope == 0L) {
            return 1.0E-4;
        }
        double result = 1.0E-4;
        if (this.resultsOutputCustomMetadata && this.resultsOutputCsv) {
            if (this.stageId == 3) {
                result = (double)this.processedItems.get() * 0.9 / (double)this.stageItems;
            } else if (this.stageId == 4) {
                result = (double)this.processedItems.get() * 0.9 / (double)this.stageItems + (double)this.exportedItems * 0.1 / (double)this.itemsInScope;
            }
        } else if (this.resultsOutputCustomMetadata) {
            result = (double)this.processedItems.get() / (double)this.stageItems;
        } else if (this.resultsOutputCsv) {
            result = (double)this.exportedItems / (double)this.itemsInScope;
        }
        return Math.max(1.0E-4, Math.min(result, 0.9999));
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (((String)result).length() > 0) {
            result = (String)result + " / ";
        }
        result = (String)result + this.stageName;
        if (this.stageId == 3) {
            result = (String)result + " " + this.iu.getNumeralString("QueryFromSqlOperation.Progress.ItemsProcessed", this.processedItems.get());
        }
        return result;
    }
}

