/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.RelativityApplyWorkspaceGroupPermissionsOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceGroupPermissions;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.io.File;
import java.util.List;
import java.util.Set;

public class RelativityApplyWorkspaceGroupPermissionsOperationImplementation
extends RelativityApplyWorkspaceGroupPermissionsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityApplyWorkspaceGroupPermissionsOperationImplementation.class);
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                this.groupIdentifier = this.executionContext.evalParameters(this.groupIdentifier, this);
                this.permissionsJson = this.executionContext.evalParameters(this.permissionsJson, this);
                Long relativityWorkspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                this.stageName = this.iu.getString("RelativityApplyWorkspaceGroupPermissionsOperation.Stage.GettingWorkspaceGroup");
                this.percentageComplete = 0.25;
                if (this.usePermissionsFile) {
                    if (this.permissionsFileName == null) {
                        this.permissionsFileName = "";
                    }
                    this.permissionsFileName = this.executionContext.evalParameters(this.permissionsFileName, this);
                    this.permissionsJson = FileUtils.readFileWithAutodetectEncoding((File)new File(this.permissionsFileName));
                    this.addExecutionLog(this.iu.getFormattedString("RelativityApplyWorkspaceGroupPermissionsOperation.Info.PermissionsFile", (Object)this.permissionsFileName));
                }
                Long groupArtifactId = 0L;
                List<EligibleObject> eligibleGroups = this.relativityRestClient.queryEligibleGroups(null);
                EligibleObject eligibleGroup = RelativityUtils.getInstance().filterEligibleObject(this.groupIdentifier, this.groupIdentifierType, eligibleGroups, RelativityFieldType.GROUP);
                if (eligibleGroup == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityApplyWorkspaceGroupPermissionsOperation.Exception.MissingGroup", (Object)String.valueOf(this.groupIdentifier)));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityApplyWorkspaceGroupPermissionsOperation.Info.GroupIdentifier", (Object)String.valueOf(this.groupIdentifier)));
                groupArtifactId = eligibleGroup.getArtifactId();
                WorkspaceGroupPermissions permissions = this.relativityRestClient.getWorkspaceGroupPermissions(relativityWorkspaceArtifactId, groupArtifactId);
                if (permissions == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityApplyWorkspaceGroupPermissionsOperation.Exception.WorkspaceDoesNotContainGroup", (Object)String.valueOf(this.groupIdentifier)));
                }
                this.stageName = this.iu.getString("RelativityApplyWorkspaceGroupPermissionsOperation.Stage.SettingsWorkspaceGroupPermissions");
                this.percentageComplete = 0.75;
                try {
                    WorkspaceGroupPermissions copyPermissions = (WorkspaceGroupPermissions)SerializationUtils.fromJson((String)this.permissionsJson, WorkspaceGroupPermissions.class);
                    permissions = RelativityUtils.getInstance().copyPermissions(permissions, copyPermissions);
                    Set<String> missingPermissions = RelativityUtils.getInstance().resolveMissingWorkspaceGroupPermissions(permissions, copyPermissions);
                    if (missingPermissions.size() > 0) {
                        for (String permissionName : missingPermissions) {
                            this.addWarning(this.iu.getFormattedString("RelativityApplyWorkspaceGroupPermissionsOperation.Warning.UnableToAssignPermission", new Object[]{permissionName, String.valueOf(this.groupIdentifier)}));
                        }
                    }
                }
                catch (Exception e) {
                    throw new Exception(this.iu.getFormattedString("RelativityApplyWorkspaceGroupPermissionsOperation.Exception.InvalidJson", (Object)e.getMessage()));
                }
                this.relativityRestClient.setWorkspaceGroupPermissions(relativityWorkspaceArtifactId, permissions);
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

