/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.aspose.cells.Cell;
import com.aspose.cells.CellsException;
import com.aspose.cells.FindOptions;
import com.aspose.cells.LoadOptions;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.aspose.cells.Workbook;
import com.aspose.cells.Worksheet;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.RelativityApplyWorkspaceOverwrittenPermissionsOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.GroupPermission;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ItemLevelPermissionInfo;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ItemLevelPermissionObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.OverwrittenPermissionRow;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.OverwrittenPermissionRowAction;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.OverwrittenPermissionTypeResult;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.OverwrittenPermissionsResult;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityOverwrittenPermissionsNewObjectBehavior;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityPermissionsMatchBy;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceGroup;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceGroupPermissions;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceGroups;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceObjectType;
import com.nuix.automate.workflow.core.execution.options.report.TemplateWorksheetName;
import com.nuix.automate.workflow.core.utils.general.AsposeUtils;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class RelativityApplyWorkspaceOverwrittenPermissionsOperationImplementation
extends RelativityApplyWorkspaceOverwrittenPermissionsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityApplyWorkspaceOverwrittenPermissionsOperation.class);
    private transient double percentageComplete;
    private transient String stageName;
    private transient int totalStages;
    private transient int stageId;
    private transient String stageItemName;
    private transient long stageItems;
    private transient AtomicLong stageItemsProcessed;
    private transient List<OverwrittenPermissionRow> rows;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                this.rows = new ArrayList<OverwrittenPermissionRow>();
                this.stageId = 0;
                this.totalStages = 1;
                Long workspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                this.overwrittenPermissionsJson = this.executionContext.evalParameters(this.overwrittenPermissionsJson, this);
                if (this.useOverwrittenPermissionFile) {
                    if (this.overwrittenPermissionsFile == null) {
                        this.overwrittenPermissionsFile = "";
                    }
                    this.overwrittenPermissionsFile = this.executionContext.evalParameters(this.overwrittenPermissionsFile, this);
                    this.overwrittenPermissionsJson = FileUtils.readFileWithAutodetectEncoding((File)new File(this.overwrittenPermissionsFile));
                    this.addExecutionLog(this.iu.getFormattedString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Info.PermissionsFile", (Object)this.overwrittenPermissionsFile));
                }
                this.stageName = this.iu.getString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Stage.PreparingWorkspace");
                ++this.stageId;
                HashSet<Long> seenArtifactIds = new HashSet<Long>();
                this.stageItemsProcessed = new AtomicLong();
                this.stageItems = 0L;
                HashSet<WorkspaceGroup> groupsToIgnore = null;
                HashMap excludedItems = new HashMap();
                Map<Object, Object> groupIdToArtifactId = new HashMap();
                if (this.excludedObjects.size() > 0) {
                    for (Object[] row : this.excludedObjects) {
                        String typeName = row[0].toString();
                        String objectName = row[1].toString();
                        typeName = this.executionContext.evalParameters(typeName, this);
                        objectName = this.executionContext.evalParameters(objectName, this);
                        if (!excludedItems.containsKey(typeName)) {
                            excludedItems.put(typeName, new HashSet());
                        }
                        ((Set)excludedItems.get(typeName)).add(objectName);
                    }
                }
                try {
                    OverwrittenPermissionsResult copyOverwrittenPermissions = (OverwrittenPermissionsResult)SerializationUtils.fromJson((String)this.overwrittenPermissionsJson, OverwrittenPermissionsResult.class);
                    List<WorkspaceObjectType> targetWorkspaceObjectTypes = this.relativityRestClient.queryObjectTypes(workspaceArtifactId);
                    this.totalStages += copyOverwrittenPermissions.getResults().size();
                    if (this.writeReport) {
                        ++this.totalStages;
                    }
                    for (OverwrittenPermissionTypeResult templateObjectType : copyOverwrittenPermissions.getResults()) {
                        ++this.stageId;
                        this.addExecutionLog(this.iu.getFormattedString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Info.SettingOverwrittenPermissions", (Object)templateObjectType.getTypeName()));
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        try {
                            ItemLevelPermissionInfo targetItem;
                            Object templateGroup2;
                            boolean objectTypeExistsInTarget = false;
                            for (WorkspaceObjectType workspaceObjectType : targetWorkspaceObjectTypes) {
                                if (!workspaceObjectType.getName().equals(templateObjectType.getTypeName())) continue;
                                objectTypeExistsInTarget = true;
                                break;
                            }
                            if (!objectTypeExistsInTarget) {
                                this.addWarning(this.iu.getFormattedString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Warning.ObjectTypeNotInTarget", new Object[]{templateObjectType.getTypeName()}));
                                continue;
                            }
                            if (groupsToIgnore == null) {
                                groupsToIgnore = new HashSet<WorkspaceGroup>();
                                HashSet<WorkspaceGroup> templateWorkspaceGroups = new HashSet<WorkspaceGroup>();
                                for (ItemLevelPermissionObject item : templateObjectType.getObjects()) {
                                    if (item.getGroupPermissions() == null || item.getGroupPermissions().size() <= 0) continue;
                                    for (GroupPermission permission : item.getGroupPermissions()) {
                                        templateWorkspaceGroups.add(new WorkspaceGroup(permission.getGroupName(), permission.getGroupId()));
                                    }
                                }
                                groupIdToArtifactId = this.relativityRestClient.getWorkspaceGroupsWithArtifactIds(workspaceArtifactId);
                                for (Object templateGroup2 : templateWorkspaceGroups) {
                                    if (groupIdToArtifactId.containsValue(templateGroup2)) continue;
                                    groupsToIgnore.add((WorkspaceGroup)templateGroup2);
                                    this.addWarning(this.iu.getFormattedString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Warning.GroupNotInTarget", (Object)((WorkspaceGroup)templateGroup2).getName()));
                                }
                            }
                            this.stageItems = templateObjectType.getObjects().size();
                            this.stageItemName = templateObjectType.getTypeName();
                            this.stageItemsProcessed.set(0L);
                            Map<Long, ItemLevelPermissionInfo> targetItems = this.relativityRestClient.getItemLevelPermissionInfo(workspaceArtifactId, templateObjectType.getTypeId(), templateObjectType.getTypeName());
                            this.addExecutionLog(this.iu.getNumeralFormattedString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Info.ChildrenObjectResult", (long)targetItems.size(), new Object[]{templateObjectType.getTypeName()}));
                            HashMap<String, Long> hashMap = new HashMap<String, Long>();
                            templateGroup2 = targetItems.entrySet().iterator();
                            while (templateGroup2.hasNext()) {
                                Map.Entry entry = (Map.Entry)templateGroup2.next();
                                hashMap.put(((ItemLevelPermissionInfo)entry.getValue()).getName(), (Long)entry.getKey());
                            }
                            List<ItemLevelPermissionObject> templatePermissions = templateObjectType.getObjects();
                            for (ItemLevelPermissionObject templateItem : templatePermissions) {
                                boolean containsArtifactId;
                                if (this.stopRequested) {
                                    this.trackStopped();
                                    return;
                                }
                                targetItem = null;
                                if (this.matchBy == RelativityPermissionsMatchBy.ARTIFACT_ID_NAME) {
                                    containsArtifactId = targetItems.containsKey(templateItem.getArtifactId());
                                    if (containsArtifactId && targetItems.get(templateItem.getArtifactId()).getName().equals(templateItem.getName())) {
                                        targetItem = targetItems.get(templateItem.getArtifactId());
                                    }
                                } else {
                                    containsArtifactId = targetItems.containsKey(templateItem.getArtifactId());
                                    if (containsArtifactId && targetItems.get(templateItem.getArtifactId()).getName().equals(templateItem.getName())) {
                                        targetItem = targetItems.get(templateItem.getArtifactId());
                                    } else if (hashMap.containsKey(templateItem.getName())) {
                                        targetItem = targetItems.get(hashMap.get(templateItem.getName()));
                                    }
                                }
                                if (excludedItems.containsKey(templateObjectType.getTypeName()) && ((Set)excludedItems.get(templateObjectType.getTypeName())).contains(templateItem.getName())) {
                                    this.addOverwrittenTemplateRow(templateObjectType, templateItem, targetItem, OverwrittenPermissionRowAction.SKIPPED, null);
                                    if (targetItem != null) {
                                        seenArtifactIds.add(targetItem.getArtifactId());
                                    }
                                    this.stageItemsProcessed.addAndGet(1L);
                                    continue;
                                }
                                if (targetItem != null) {
                                    Set<String> missingPermissions;
                                    WorkspaceGroupPermissions permissionsResult;
                                    WorkspaceGroupPermissions dstPermissions;
                                    WorkspaceGroupPermissions srcPermissions;
                                    WorkspaceGroup realGroup;
                                    WorkspaceGroup group;
                                    Object updatedItemGroups;
                                    seenArtifactIds.add(targetItem.getArtifactId());
                                    if (templateItem.getGroupPermissions() != null && targetItem.isOverridePermissions()) {
                                        try {
                                            this.relativityRestClient.setItemLevelSecurity(targetItem.getArtifactId(), workspaceArtifactId, false);
                                            this.relativityRestClient.setItemLevelSecurity(targetItem.getArtifactId(), workspaceArtifactId, true);
                                            HashSet<Long> templateGroupArtifactIds = new HashSet<Long>();
                                            for (GroupPermission groupPermission : templateItem.getGroupPermissions()) {
                                                templateGroupArtifactIds.add(groupPermission.getGroupId());
                                            }
                                            updatedItemGroups = this.relativityRestClient.getItemGroups(targetItem.getArtifactId(), workspaceArtifactId, false);
                                            Iterator<WorkspaceGroup> iterator = ((WorkspaceGroups)updatedItemGroups).getWorkspaceGroups().iterator();
                                            while (iterator.hasNext()) {
                                                realGroup = (WorkspaceGroup)groupIdToArtifactId.get((group = iterator.next()).getArtifactId());
                                                group.setEnabled(realGroup != null && templateGroupArtifactIds.contains(realGroup.getArtifactId()));
                                                group.setName(null);
                                            }
                                            this.relativityRestClient.setItemGroups(targetItem.getArtifactId(), workspaceArtifactId, (WorkspaceGroups)updatedItemGroups);
                                            for (GroupPermission groupPermission : templateItem.getGroupPermissions()) {
                                                srcPermissions = groupPermission.getOverwrittenPermissions();
                                                dstPermissions = this.relativityRestClient.getItemPermissions(targetItem.getArtifactId(), groupPermission.getGroupId(), workspaceArtifactId);
                                                if (dstPermissions == null) continue;
                                                permissionsResult = RelativityUtils.getInstance().copyPermissions(dstPermissions, srcPermissions);
                                                missingPermissions = RelativityUtils.getInstance().resolveMissingWorkspaceGroupPermissions(dstPermissions, srcPermissions);
                                                if (missingPermissions.size() > 0) {
                                                    this.addWarning(this.iu.getNumeralFormattedString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Warning.UnableToAssignPermission", (long)missingPermissions.size(), new Object[]{String.join((CharSequence)", ", missingPermissions), "'" + targetItem.getName() + "'", String.valueOf(groupPermission.getGroupId())}));
                                                }
                                                this.relativityRestClient.setItemPermissions(targetItem.getArtifactId(), workspaceArtifactId, permissionsResult);
                                            }
                                            this.addOverwrittenTemplateRow(templateObjectType, templateItem, targetItem, OverwrittenPermissionRowAction.APPLIED_PERMISSIONS, null);
                                        }
                                        catch (IOException e) {
                                            LOGGER.error("Failed to apply overwritten permissions", (Throwable)e);
                                            this.addWarning(this.iu.getFormattedString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Warning.FailedToSetOverwrittenPermissions", new Object[]{templateObjectType.getTypeName(), targetItem.getName(), String.valueOf(targetItem.getArtifactId()), e.getMessage()}));
                                            this.addOverwrittenTemplateRow(templateObjectType, templateItem, targetItem, OverwrittenPermissionRowAction.FAILED_TO_APPLY_PERMISSIONS, e.getMessage());
                                        }
                                        this.stageItemsProcessed.addAndGet(1L);
                                        continue;
                                    }
                                    if (templateItem.getGroupPermissions() != null && !targetItem.isOverridePermissions()) {
                                        try {
                                            this.relativityRestClient.setItemLevelSecurity(targetItem.getArtifactId(), workspaceArtifactId, true);
                                            HashSet<Long> templateGroupArtifactIds = new HashSet<Long>();
                                            for (GroupPermission groupPermission : templateItem.getGroupPermissions()) {
                                                templateGroupArtifactIds.add(groupPermission.getGroupId());
                                            }
                                            updatedItemGroups = this.relativityRestClient.getItemGroups(targetItem.getArtifactId(), workspaceArtifactId, false);
                                            Iterator<WorkspaceGroup> iterator = ((WorkspaceGroups)updatedItemGroups).getWorkspaceGroups().iterator();
                                            while (iterator.hasNext()) {
                                                realGroup = (WorkspaceGroup)groupIdToArtifactId.get((group = iterator.next()).getArtifactId());
                                                group.setEnabled(realGroup != null && templateGroupArtifactIds.contains(realGroup.getArtifactId()));
                                                group.setName(null);
                                            }
                                            this.relativityRestClient.setItemGroups(targetItem.getArtifactId(), workspaceArtifactId, (WorkspaceGroups)updatedItemGroups);
                                            for (GroupPermission groupPermission : templateItem.getGroupPermissions()) {
                                                srcPermissions = groupPermission.getOverwrittenPermissions();
                                                dstPermissions = this.relativityRestClient.getItemPermissions(targetItem.getArtifactId(), groupPermission.getGroupId(), workspaceArtifactId);
                                                if (dstPermissions == null) continue;
                                                permissionsResult = RelativityUtils.getInstance().copyPermissions(dstPermissions, srcPermissions);
                                                missingPermissions = RelativityUtils.getInstance().resolveMissingWorkspaceGroupPermissions(dstPermissions, srcPermissions);
                                                if (missingPermissions.size() > 0) {
                                                    this.addWarning(this.iu.getNumeralFormattedString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Warning.UnableToAssignPermission", (long)missingPermissions.size(), new Object[]{String.join((CharSequence)", ", missingPermissions), "'" + targetItem.getName() + "'", String.valueOf(groupPermission.getGroupId())}));
                                                }
                                                this.relativityRestClient.setItemPermissions(targetItem.getArtifactId(), workspaceArtifactId, permissionsResult);
                                            }
                                            this.addOverwrittenTemplateRow(templateObjectType, templateItem, targetItem, OverwrittenPermissionRowAction.APPLIED_PERMISSIONS, null);
                                        }
                                        catch (IOException e) {
                                            LOGGER.error("Failed to apply overwritten permissions", (Throwable)e);
                                            this.addWarning(this.iu.getFormattedString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Warning.FailedToSetOverwrittenPermissions", new Object[]{templateObjectType.getTypeName(), targetItem.getName(), String.valueOf(targetItem.getArtifactId()), e.getMessage()}));
                                            this.addOverwrittenTemplateRow(templateObjectType, templateItem, targetItem, OverwrittenPermissionRowAction.FAILED_TO_APPLY_PERMISSIONS, e.getMessage());
                                        }
                                        this.stageItemsProcessed.addAndGet(1L);
                                        continue;
                                    }
                                    if (templateItem.getGroupPermissions() == null && targetItem.isOverridePermissions()) {
                                        try {
                                            this.relativityRestClient.setItemLevelSecurity(targetItem.getArtifactId(), workspaceArtifactId, false);
                                            this.addOverwrittenTemplateRow(templateObjectType, templateItem, targetItem, OverwrittenPermissionRowAction.RESET, null);
                                        }
                                        catch (IOException e) {
                                            LOGGER.error("Failed to apply overwritten permissions", (Throwable)e);
                                            this.addWarning(this.iu.getFormattedString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Warning.UnableToSetItemLevelSecurity", new Object[]{templateObjectType.getTypeName(), targetItem.getName(), String.valueOf(targetItem.getArtifactId()), e.getMessage()}));
                                            this.addOverwrittenTemplateRow(templateObjectType, templateItem, targetItem, OverwrittenPermissionRowAction.FAILED_TO_RESET, e.getMessage());
                                        }
                                        this.stageItemsProcessed.addAndGet(1L);
                                        continue;
                                    }
                                    this.addOverwrittenTemplateRow(templateObjectType, templateItem, targetItem, OverwrittenPermissionRowAction.NO_ACTION, null);
                                    this.stageItemsProcessed.addAndGet(1L);
                                    continue;
                                }
                                this.addOverwrittenTemplateRow(templateObjectType, templateItem, null, OverwrittenPermissionRowAction.NO_ACTION, null);
                                this.stageItemsProcessed.addAndGet(1L);
                            }
                            for (Long key : targetItems.keySet()) {
                                if (this.stopRequested) {
                                    this.trackStopped();
                                    return;
                                }
                                if (seenArtifactIds.contains(key)) continue;
                                ++this.stageItems;
                                targetItem = targetItems.get(key);
                                if (this.newObjectsBehavior == RelativityOverwrittenPermissionsNewObjectBehavior.REMOVE_INHERITED_PERMISSION && targetItem.isOverridePermissions()) {
                                    try {
                                        WorkspaceGroups itemGroups = this.relativityRestClient.getItemGroups(targetItem.getArtifactId(), workspaceArtifactId, false);
                                        for (WorkspaceGroup workspaceGroup : itemGroups.getWorkspaceGroups()) {
                                            workspaceGroup.setEnabled(false);
                                            workspaceGroup.setName(null);
                                        }
                                        this.relativityRestClient.setItemGroups(targetItem.getArtifactId(), workspaceArtifactId, itemGroups);
                                        this.relativityRestClient.setItemLevelSecurity(targetItem.getArtifactId(), workspaceArtifactId, false);
                                        this.addOverwrittenTemplateRow(templateObjectType, targetItem, OverwrittenPermissionRowAction.RESET, null);
                                    }
                                    catch (IOException e) {
                                        LOGGER.error("Failed to reset inherited permissions", (Throwable)e);
                                        this.addWarning(this.iu.getFormattedString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Warning.UnableToSetItemLevelSecurity", new Object[]{templateObjectType.getTypeName(), targetItem.getName(), String.valueOf(targetItem.getArtifactId()), e.getMessage()}));
                                        this.addOverwrittenTemplateRow(templateObjectType, targetItem, OverwrittenPermissionRowAction.FAILED_TO_RESET, e.getMessage());
                                    }
                                } else {
                                    this.addOverwrittenTemplateRow(templateObjectType, targetItem, OverwrittenPermissionRowAction.NO_ACTION, null);
                                }
                                this.stageItemsProcessed.addAndGet(1L);
                            }
                        }
                        catch (IOException e) {
                            LOGGER.error("Unexpected error while getting objects for type " + templateObjectType.getTypeName(), (Throwable)e);
                            this.addWarning(this.iu.getFormattedString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Exception.UnexpectedObjectTypeError", new Object[]{templateObjectType.getTypeName(), e.getMessage()}));
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Invalid JSON", (Throwable)e);
                    throw new IOException(this.iu.getFormattedString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Exception.InvalidJson", (Object)e.getMessage()));
                }
                this.stageItemName = null;
                this.stageItemsProcessed.set(0L);
                this.stageItems = 0L;
                if (this.writeReport) {
                    this.stageName = this.iu.getString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Stage.WritingReport");
                    ++this.stageId;
                    this.writeReportFile();
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void addOverwrittenTemplateRow(OverwrittenPermissionTypeResult type, ItemLevelPermissionObject templateObject, ItemLevelPermissionInfo targetObject, OverwrittenPermissionRowAction action, String exception) {
        this.rows.add(new OverwrittenPermissionRow(type, templateObject, targetObject, action, exception));
    }

    private void addOverwrittenTemplateRow(OverwrittenPermissionTypeResult type, ItemLevelPermissionInfo object, OverwrittenPermissionRowAction action, String exception) {
        this.rows.add(new OverwrittenPermissionRow(type, object, action, exception));
    }

    public void writeReportFile() throws Exception {
        String[] headers;
        int templateWorksheetIndex;
        Object buffer;
        AsposeUtils.applyAsposeCellsLicense();
        LoadOptions loadOptions = new LoadOptions(6);
        File templateFile = null;
        if (this.customReportTemplatePath.length() > 0 && !(templateFile = new File(this.customReportTemplatePath)).exists()) {
            LOGGER.error("Cannot find report template file " + templateFile.getAbsolutePath());
            this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.CouldNotFindReportTemplate", (Object)templateFile.getAbsoluteFile()));
        }
        if (templateFile == null || !templateFile.exists()) {
            templateFile = this.executionContext.getReportTemplate();
            LOGGER.info("Cannot find report template file " + templateFile.getAbsolutePath() + ". Creating default file");
            File templateFolder = templateFile.getParentFile();
            if (!templateFolder.exists()) {
                LOGGER.info("Creating folder " + templateFolder.getAbsolutePath());
                templateFolder.mkdirs();
            }
            try (InputStream templateStream = this.getClass().getResourceAsStream("/reports/template.xlsx");
                 OutputStream outputStream = Files.newOutputStream(templateFile.toPath(), new OpenOption[0]);){
                int bytesRead;
                buffer = new byte[1024];
                while ((bytesRead = templateStream.read((byte[])buffer)) != -1) {
                    outputStream.write((byte[])buffer, 0, bytesRead);
                }
                templateStream.close();
                outputStream.flush();
            }
        }
        Workbook workbook = new Workbook(templateFile.getAbsolutePath(), loadOptions);
        for (int worksheetId = 0; worksheetId < workbook.getWorksheets().getCount(); ++worksheetId) {
            Worksheet worksheet = workbook.getWorksheets().get(worksheetId);
            LOGGER.info("Pre-processing worksheet " + worksheet.getName());
            buffer = this.executionContext.getParameterNames().iterator();
            while (buffer.hasNext()) {
                String placeholder = (String)buffer.next();
                try {
                    FindOptions findOptions = new FindOptions();
                    findOptions.setLookAtType(3);
                    findOptions.setLookInType(1);
                    Cell matchingCell = null;
                    while ((matchingCell = worksheet.getCells().find((Object)placeholder, matchingCell, findOptions)) != null) {
                        String unpackedPlaceholder = this.executionContext.evalParameters(placeholder, this);
                        if (placeholder.equals("{date_spreadsheet}") || placeholder.equals("{date_time_spreadsheet}")) {
                            matchingCell.setValue((Object)Calendar.getInstance());
                        } else if (placeholder.equals("{time_spreadsheet}")) {
                            matchingCell.setValue((Object)new Date());
                        } else {
                            matchingCell.setValue((Object)unpackedPlaceholder);
                        }
                        LOGGER.info("Searching for " + placeholder + ", got " + String.valueOf(matchingCell));
                    }
                }
                catch (Exception e) {
                    LOGGER.info("Cannot unpack placeholder " + placeholder, (Throwable)e);
                }
            }
        }
        String treeSizeWorksheetName = TemplateWorksheetName.TEMPLATE_RELATIVITY_OVERWRITTEN_PERMISSIONS.toString();
        try {
            templateWorksheetIndex = workbook.getWorksheets().addCopy(treeSizeWorksheetName);
        }
        catch (CellsException e) {
            this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.TemplateFileNoWorksheetNamed", (Object)treeSizeWorksheetName));
            return;
        }
        Worksheet worksheet = workbook.getWorksheets().get(templateWorksheetIndex);
        worksheet.setName(this.iu.getString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Report.OverwrittenPermissionsReport"));
        int sr = 0;
        int sc = 0;
        FindOptions findOptions = new FindOptions();
        findOptions.setLookAtType(0);
        findOptions.setLookInType(1);
        Cell matchingCell = null;
        matchingCell = worksheet.getCells().find((Object)"__START__", matchingCell, findOptions);
        if (matchingCell != null) {
            sr = matchingCell.getRow();
            sc = matchingCell.getColumn();
        }
        matchingCell = null;
        matchingCell = worksheet.getCells().find((Object)"{view_name}", matchingCell, findOptions);
        if (matchingCell != null) {
            matchingCell.setValue((Object)this.iu.getString("RelativityExportSavedSearchOperation.Report.SavedSearchResults"));
        }
        int rowId = 3;
        int columnId = 0;
        int processedItems = 0;
        for (String header : headers = new String[]{this.iu.getString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Report.TypeIdHeader"), this.iu.getString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Report.TypeNameHeader"), this.iu.getString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Report.TemplateIdHeader"), this.iu.getString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Report.TargetIdHeader"), this.iu.getString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Report.ObjectNameHeader"), this.iu.getString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Report.ExistInTemplateHeader"), this.iu.getString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Report.TemplateOverridesSecurityHeader"), this.iu.getString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Report.ExistInTargetHeader"), this.iu.getString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Report.TargetOverridesSecurityHeader"), this.iu.getString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Report.ActionHeader")}) {
            worksheet.getCells().get(sr, sc + columnId).setValue((Object)header);
            ++columnId;
        }
        String translatedYes = this.iu.getString("General.Yes");
        String translatedNo = this.iu.getString("General.No");
        for (OverwrittenPermissionRow result : this.rows) {
            boolean isFirstRow;
            if (this.stopRequested) {
                throw new WorkflowExecutionStopRequested();
            }
            worksheet.getCells().insertRow(sr + ++rowId);
            int isLastRow = processedItems == this.rows.size() - 1 ? 1 : 0;
            boolean bl = isFirstRow = processedItems == 0;
            if (isFirstRow) {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 1, sr + rowId);
            } else if (isLastRow == 0) {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 2, sr + rowId);
            } else {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 3, sr + rowId);
            }
            worksheet.getCells().get(sr + rowId, sc).setValue((Object)result.getTypeId());
            worksheet.getCells().get(sr + rowId, sc + 1).setValue((Object)result.getTypeName());
            if (result.getTemplateObjectId() != -1L) {
                worksheet.getCells().get(sr + rowId, sc + 2).setValue((Object)result.getTemplateObjectId());
            } else {
                worksheet.getCells().get(sr + rowId, sc + 2).setValue((Object)"N/A");
            }
            if (result.getTargetObjectId() != -1L) {
                worksheet.getCells().get(sr + rowId, sc + 3).setValue((Object)result.getTargetObjectId());
            } else {
                worksheet.getCells().get(sr + rowId, sc + 3).setValue((Object)"N/A");
            }
            worksheet.getCells().get(sr + rowId, sc + 4).setValue((Object)result.getObjectName());
            worksheet.getCells().get(sr + rowId, sc + 5).setValue((Object)(result.isPresentInTemplate() ? translatedYes : translatedNo));
            if (result.getTemplateObjectId() != -1L) {
                worksheet.getCells().get(sr + rowId, sc + 6).setValue((Object)(result.isTemplateOverridesSecurity() ? translatedYes : translatedNo));
            } else {
                worksheet.getCells().get(sr + rowId, sc + 6).setValue((Object)"N/A");
            }
            worksheet.getCells().get(sr + rowId, sc + 7).setValue((Object)(result.isPresentInTarget() ? translatedYes : translatedNo));
            if (result.getTargetObjectId() != -1L) {
                worksheet.getCells().get(sr + rowId, sc + 8).setValue((Object)(result.isTargetOverridesSecurity() ? translatedYes : translatedNo));
            } else {
                worksheet.getCells().get(sr + rowId, sc + 8).setValue((Object)"N/A");
            }
            if (!result.getAction().equals((Object)OverwrittenPermissionRowAction.NO_ACTION)) {
                String actionColumnData = result.getAction().toString();
                worksheet.getCells().get(sr + rowId, sc + 9).setValue((Object)actionColumnData);
            }
            if (result.getException() != null && !result.getException().trim().equals("")) {
                worksheet.getCells().get(sr + rowId, sc + 10).setValue((Object)result.getException());
            }
            ++processedItems;
        }
        worksheet.getCells().deleteRow(sr + 1);
        worksheet.getCells().deleteRow(sr + 1);
        worksheet.getCells().deleteRow(sr + 1);
        for (TemplateWorksheetName templateWorksheetName : TemplateWorksheetName.values()) {
            try {
                workbook.getWorksheets().removeAt(templateWorksheetName.toString());
            }
            catch (Exception e) {
                LOGGER.error("Cannot remove sheet " + String.valueOf((Object)templateWorksheetName));
            }
        }
        workbook.getBuiltInDocumentProperties().setAuthor("Automate Workflow");
        this.reportLocation = this.executionContext.evalParameters(this.reportLocation, this);
        File reportFile = new File(this.reportLocation);
        this.reportLocation = reportFile.getAbsolutePath();
        File reportFolder = reportFile.getParentFile();
        if (!reportFolder.exists()) {
            reportFolder.mkdirs();
        }
        LOGGER.info("Saving report to " + reportFile.getAbsolutePath());
        if (reportFile.getAbsolutePath().toLowerCase().endsWith(".pdf")) {
            PdfSaveOptions saveOptions = new PdfSaveOptions();
            saveOptions.setAllColumnsInOnePagePerSheet(true);
            workbook.save(reportFile.getAbsolutePath(), (SaveOptions)saveOptions);
        } else {
            String reportPasswordParameter = "{report_password}";
            String reportPassword = this.executionContext.evalParameters(reportPasswordParameter, this);
            if (!reportPassword.equals(reportPasswordParameter)) {
                this.addExecutionLog(this.iu.getString("ProcessingReportOperation.Log.SettingPassword"));
                if (reportPassword.length() == 0) {
                    this.addWarning(this.iu.getString("ProcessingReportOperation.Log.BlankPassword"));
                }
                workbook.setEncryptionOptions(3, 128);
                workbook.getSettings().setPassword(reportPassword);
            }
            workbook.save(reportFile.getAbsolutePath());
        }
        this.addExecutionLog(this.iu.getFormattedString("RelativityExportSavedSearchOperation.Info.ReportLocation", (Object)reportFile.getAbsolutePath()));
        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_report_file}", reportFile.getAbsolutePath())));
    }

    @Override
    protected double getPercentageComplete() {
        if (this.stageId == 1) {
            return 0.05;
        }
        double stagePercentageComplete = 0.0;
        if (this.stageItemName != null && this.stageItems > 0L) {
            stagePercentageComplete = this.stageItemsProcessed.doubleValue() / (double)this.stageItems;
        }
        double percentageComplete = 0.0;
        if (this.stageId > 0) {
            percentageComplete = ((double)this.stageId + stagePercentageComplete) / (double)this.totalStages * 0.95;
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageItemName != null && this.stageItemName.length() > 0) {
            result = (String)result + "/ " + this.iu.getFormattedString("RelativityApplyWorkspaceOverwrittenPermissionsOperation.Stage.SettingItemPermissions", (Object)this.stageItemName);
        } else if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

