/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.RelativityCreateGroupOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RelativityCreateGroupOperationImplementation
extends RelativityCreateGroupOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityCreateGroupOperation.class);
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                Long relativityClientArtifactId = Long.parseLong(this.executionContext.evalProtectedParameter("{relativity_client_id}"));
                if (this.executionContext.evalParameters("{case_or_workspace_name}", this).equals("{case_or_workspace_name}")) {
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{case_or_workspace_name}", "Admin Workspace")));
                }
                if (this.useGroupSettingsFile) {
                    if (this.groupSettingsFileName == null) {
                        this.groupSettingsFileName = "";
                    }
                    this.groupSettingsFileName = this.executionContext.evalParameters(this.groupSettingsFileName, this);
                    this.groupSettings = FileUtils.loadVariableColumnTsv((File)new File(this.groupSettingsFileName));
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateGroupOperation.Info.GroupSettingsFile", (Object)this.groupSettingsFileName));
                }
                ArrayList<RelativityGroup> evaluatedGroups = new ArrayList<RelativityGroup>();
                for (Object[] group : this.groupSettings) {
                    String groupName = (String)group[0];
                    String groupKeywords = (String)group[1];
                    String groupNotes = (String)group[2];
                    groupName = this.executionContext.evalParameters(groupName, this);
                    groupKeywords = this.executionContext.evalParameters(groupKeywords, this);
                    groupNotes = this.executionContext.evalParameters(groupNotes, this);
                    RelativityGroup evaluatedRelativityGroup = new RelativityGroup(groupName, groupKeywords, groupNotes);
                    evaluatedGroups.add(evaluatedRelativityGroup);
                }
                this.stageName = this.iu.getString("RelativityCreateGroupOperation.Stage.CreatingGroups");
                this.percentageComplete = 0.25;
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateGroupOperation.Log.GroupsToCreate", (Object)evaluatedGroups.size()));
                LOGGER.info("Groups to create " + evaluatedGroups.size());
                List<EligibleObject> clientGroupsList = this.relativityRestClient.queryEligibleGroups(relativityClientArtifactId);
                HashMap<String, EligibleObject> groups = new HashMap<String, EligibleObject>();
                for (EligibleObject eligibleGroup : clientGroupsList) {
                    groups.put(eligibleGroup.getName(), eligibleGroup);
                }
                this.percentageComplete = 0.5;
                for (RelativityGroup group : evaluatedGroups) {
                    if (!groups.containsKey(group.getName())) {
                        Long createdGroupArtifactId = this.relativityRestClient.createGroup(group.getName(), relativityClientArtifactId, group.getKeywords(), group.getNotes());
                        EligibleObject createdGroup = new EligibleObject();
                        createdGroup.setName(group.getName());
                        createdGroup.setArtifactId(createdGroupArtifactId);
                        groups.put(group.getName(), createdGroup);
                        this.addExecutionLog(this.iu.getFormattedString("RelativityCreateGroupOperation.Log.CreatedGroup", new Object[]{group.getName(), String.valueOf(((EligibleObject)groups.get(group.getName())).getArtifactId())}));
                        LOGGER.info("Created group " + group.getName() + " with artifact ID " + createdGroupArtifactId);
                        continue;
                    }
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateGroupOperation.Log.GroupExisted", new Object[]{group.getName(), String.valueOf(((EligibleObject)groups.get(group.getName())).getArtifactId())}));
                    LOGGER.info("Group " + group.getName() + " already exists");
                }
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

