/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.RelativityIdentifierType;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.RelativityCreateUsersOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityBasicUser;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityLoginProfile;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityUser;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SecuredObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RelativityCreateUsersOperationImplementation
extends RelativityCreateUsersOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityCreateUsersOperationImplementation.class);
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                Long relativityClientArtifactId = Long.parseLong(this.executionContext.evalProtectedParameter("{relativity_client_id}"));
                if (this.executionContext.evalParameters("{case_or_workspace_name}", this).equals("{case_or_workspace_name}")) {
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{case_or_workspace_name}", "Admin Workspace")));
                }
                this.userIdentifier = this.executionContext.evalParameters(this.userIdentifier, this);
                this.stageName = this.iu.getString("RelativityCreateUsersOperation.Stage.GettingTemplateUser");
                this.percentageComplete = 0.25;
                Long templateUserArtifactId = -1L;
                if (this.userIdentifierType == RelativityIdentifierType.ARTIFACT_ID) {
                    try {
                        templateUserArtifactId = Long.parseLong(this.userIdentifier);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(this.iu.getFormattedString("RelativityCreateUsersOperation.Exception.InvalidArtifactId", (Object)this.userIdentifier));
                    }
                }
                List<RelativityBasicUser> relativityBasicUsers = this.relativityRestClient.queryUsers();
                for (RelativityBasicUser basicUser : relativityBasicUsers) {
                    switch (this.userIdentifierType) {
                        case NAME: {
                            if (!basicUser.getFullName().equals(this.userIdentifier)) break;
                            templateUserArtifactId = basicUser.getArtifactId();
                            break;
                        }
                        default: {
                            if (!basicUser.getEmail().equals(this.userIdentifier)) break;
                            templateUserArtifactId = basicUser.getArtifactId();
                        }
                    }
                    if (templateUserArtifactId == -1L) continue;
                    break;
                }
                if (templateUserArtifactId == -1L) {
                    throw new IOException(this.iu.getFormattedString("RelativityCreateUsersOperation.Exception.UserDoesNotExist", (Object)this.userIdentifier));
                }
                RelativityUser templateUser = this.relativityRestClient.getRelativityUserProperties(templateUserArtifactId);
                RelativityLoginProfile templateLoginProfile = this.relativityRestClient.getUserLoginProfile(templateUserArtifactId);
                this.stageName = this.iu.getString("RelativityCreateUsersOperation.Stage.PreparingUsers");
                this.percentageComplete = 0.5;
                SecuredObject client = new SecuredObject();
                client.setSecured(false);
                HashMap<String, Object> artifact = new HashMap<String, Object>();
                artifact.put("ArtifactID", relativityClientArtifactId);
                client.setValue(artifact);
                if (this.useUserSettingsFile) {
                    if (this.userSettingsFileName == null) {
                        this.userSettingsFileName = "";
                    }
                    this.userSettingsFileName = this.executionContext.evalParameters(this.userSettingsFileName, this);
                    this.userSettings = FileUtils.loadVariableColumnDetectFormatFile((File)new File(this.userSettingsFileName));
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateUsersOperation.Log.UserSettingsFile", (Object)this.userSettingsFileName));
                }
                HashMap<String, String> emailLoginMethodMap = new HashMap<String, String>();
                ArrayList<RelativityUser> evaluatedUsers = new ArrayList<RelativityUser>();
                boolean skippedHeader = false;
                for (Object user : this.userSettings) {
                    String email = (String)user[0];
                    String firstName = (String)user[1];
                    String lastName = (String)user[2];
                    String keywords = (String)user[3];
                    String notes = (String)user[4];
                    String loginMethodIdentifier = (String)user[5];
                    email = this.executionContext.evalParameters(email, this);
                    firstName = this.executionContext.evalParameters(firstName, this);
                    lastName = this.executionContext.evalParameters(lastName, this);
                    keywords = this.executionContext.evalParameters(keywords, this);
                    notes = this.executionContext.evalParameters(notes, this);
                    loginMethodIdentifier = this.executionContext.evalParameters(loginMethodIdentifier, this);
                    if (!skippedHeader && !email.contains("@")) {
                        skippedHeader = true;
                        continue;
                    }
                    RelativityUser evaluatedRelativityUser = new RelativityUser(templateUser, client);
                    evaluatedRelativityUser.setEmailAddress(email);
                    evaluatedRelativityUser.setFirstName(firstName);
                    evaluatedRelativityUser.setLastName(lastName);
                    evaluatedRelativityUser.setKeywords(keywords);
                    evaluatedRelativityUser.setNotes(notes);
                    emailLoginMethodMap.put(email, loginMethodIdentifier);
                    evaluatedUsers.add(evaluatedRelativityUser);
                }
                this.stageName = this.iu.getString("RelativityCreateUsersOperation.Stage.AddingUsers");
                this.percentageComplete = 0.75;
                HashMap<Long, String> artifactIdEmailMap = new HashMap<Long, String>();
                for (RelativityUser evaluatedUser : evaluatedUsers) {
                    RelativityUser createdUser = null;
                    try {
                        createdUser = this.relativityRestClient.createUser(evaluatedUser);
                        this.addExecutionLog(this.iu.getFormattedString("RelativityCreateUsersOperation.Log.CreatedUser", new Object[]{createdUser.getEmailAddress(), createdUser.getArtifactId()}));
                        artifactIdEmailMap.put(Long.parseLong(createdUser.getArtifactId()), createdUser.getEmailAddress());
                    }
                    catch (Exception e) {
                        this.addWarning(this.iu.getFormattedString("RelativityCreateUsersOperation.Warning.UnableToCreateUser", new Object[]{evaluatedUser.getEmailAddress(), e.getMessage()}));
                    }
                    if (createdUser == null) continue;
                    try {
                        RelativityLoginProfile profile = new RelativityLoginProfile(templateLoginProfile, Long.parseLong(createdUser.getArtifactId()), createdUser.getEmailAddress(), (String)emailLoginMethodMap.get(createdUser.getEmailAddress()));
                        this.relativityRestClient.setUserLoginProfile(profile, Long.parseLong(createdUser.getArtifactId()));
                    }
                    catch (Exception e) {
                        this.addWarning(this.iu.getFormattedString("RelativityCreateUsersOperation.Warning.UnableToApplyLoginSettings", new Object[]{evaluatedUser.getEmailAddress(), e.getMessage()}));
                    }
                }
                if (this.sendInvitationEmail) {
                    this.stageName = this.iu.getString("RelativityCreateUsersOperation.Stage.SendingInvitation");
                    this.percentageComplete = 0.95;
                    Map<Long, String> artifactIdErrorMap = this.relativityRestClient.sendEmailInvitationLink(artifactIdEmailMap.keySet());
                    if (artifactIdErrorMap != null) {
                        for (Long artifactId : artifactIdErrorMap.keySet()) {
                            this.addWarning(this.iu.getFormattedString("RelativityCreateUsersOperation.Warning.UnableToSendInvitation", new Object[]{artifactIdEmailMap.get(artifactId), artifactIdErrorMap.get(artifactId)}));
                        }
                    }
                }
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

