/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.security.WinDPAPIEncyptor;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.workflow.core.execution.operations.RelativityCsvOverlayOperation;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RelativityCsvOverlayOperationImplementation
extends RelativityCsvOverlayOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityCsvOverlayOperation.class);
    private transient long linesInScope;
    private transient Set<Integer> lineIdsFailed;
    private transient AtomicInteger itemsLoadedMetadata = new AtomicInteger();
    private transient String relativityUsername;
    private transient String relativityPassword;
    private transient String relativityWorkspaceId;
    private transient String relativityHostname;
    private transient String relativityEndpointType;
    private transient String relativityImportThreads;
    private transient String relativityImportThreadTimeout;
    private transient String relativityImportThreadRetries;
    private transient String relativityPatchInvalidEntries;
    private transient Process relativityLoadProcess;
    private transient File settingsFile;
    private transient Thread readStandardOutputThread;
    private transient Thread readStandardErrorThread;

    @Override
    public void startTriggered() throws Exception {
        this.overlayLocation = this.executionContext.evalParameters(this.overlayLocation, this);
        File exportLocationFile = new File(this.overlayLocation);
        if (!exportLocationFile.exists()) {
            throw new FileNotFoundException(this.iu.getFormattedString("RelativityCsvOverlayOperation.Exception.FileNotFound", (Object)exportLocationFile.getAbsoluteFile()));
        }
        this.relativityUsername = this.executionContext.evalParameters("{wfn_relativity_username}", this);
        this.relativityWorkspaceId = this.executionContext.evalParameters("{relativity_workspace_id}", this);
        this.relativityMappingLocation = this.executionContext.evalParameters(this.relativityMappingLocation, this);
        this.relativityHostname = this.executionContext.evalParameters("{wfn_relativity_hostname}", this);
        this.relativityEndpointType = this.executionContext.evalParameters("{wfn_relativity_endpoint_type}", this);
        this.relativityImportThreads = this.executionContext.evalParameters("{wfn_relativity_import_threads}", this);
        this.relativityImportThreadTimeout = this.executionContext.evalParameters("{wfn_relativity_import_thread_timeout}", this);
        this.relativityImportThreadRetries = this.executionContext.evalParameters("{wfn_relativity_import_thread_retries}", this);
        this.relativityPatchInvalidEntries = this.executionContext.evalParameters("{wfn_relativity_patch_invalid_entries}", this);
        this.relativityPassword = this.executionContext.evalProtectedParameter("{wfn_relativity_password}");
        try {
            this.relativityPassword = new WinDPAPIEncyptor().encrypt(this.relativityPassword);
        }
        catch (IOException e) {
            LOGGER.warn("Cannot encrypt password", (Throwable)e);
        }
        this.itemsLoadedMetadata = new AtomicInteger(0);
        this.startTriggerThread = new Thread(() -> {
            try {
                this.lineIdsFailed = new HashSet<Integer>();
                this.settingsFile = FileUtils.createTempFile((String)"AutomateRelativitySettings", (String)".json");
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.settingsFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
                String settings = "{\"OverwriteMode\":\"Overlay\",\"SendEmailOnCompletion\":\"False\",\"TextFieldIsFilePath\":\"True\"}";
                LOGGER.info("Relativity settings: " + settings);
                bufferedWriter.write(settings);
                bufferedWriter.close();
                this.loadOverlay(this.overlayLocation);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Skipping deletion of temporary settings file " + String.valueOf(this.settingsFile));
                }
                if (this.lineIdsFailed.size() > 0) {
                    this.addWarning(this.iu.getNumeralString("RelativityCsvOverlayOperation.Warning.OverlayNotFullyLoaded", (long)this.lineIdsFailed.size()));
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Aborting operation");
                this.stopLoad();
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                String message = ExceptionUtils.getExceptionPrintableMessage((Throwable)e);
                if (message != null && this.relativityPassword != null) {
                    message = message.replace(this.relativityPassword, Parameter.MASKED_VALUE);
                }
                this.exception = new Exception(message);
                this.executionState = ExecutionState.ERROR;
                return;
            }
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void readOutputStream(BufferedReader standardInputReader) throws IOException {
        String line;
        String notMapped = "[NOT MAPPED";
        String ignoreNotMapped = "Source field [parent folder identifier]";
        Pattern progressPattern = Pattern.compile("\\[Progress Info: ?(\\d+)");
        Pattern errorLinePattern = Pattern.compile("error: line: (\\d+)");
        Pattern totalLinesPattern = Pattern.compile("Loadfile records count: (\\d+)");
        Pattern transferModePattern = Pattern.compile("Status - Created transfer client '([^\\']+)' using a best-fit strategy.");
        boolean transferModePatternPrinted = false;
        int lineNumber = 0;
        boolean enableVerboseLogging = Boolean.parseBoolean(System.getProperty("automate.relativity.verbose_logging"));
        while ((line = standardInputReader.readLine()) != null) {
            Matcher transferModeMatcher;
            Matcher totalRecordsMatcher;
            Matcher errorMatcher;
            Matcher progressMatcher;
            if (enableVerboseLogging || lineNumber < 1000) {
                LOGGER.info(line);
                if (++lineNumber == 1000 && !enableVerboseLogging) {
                    LOGGER.info("Relativity verbose logging is disabled, to enable verbose logging use the command-line flag -Dautomate.relativity.verbose_logging=true");
                }
            }
            if ((progressMatcher = progressPattern.matcher(line)).find()) {
                try {
                    this.itemsLoadedMetadata.set(Math.max(this.itemsLoadedMetadata.get(), Integer.parseInt(progressMatcher.group(1))));
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot extract progress from line", (Throwable)e);
                }
            }
            if ((errorMatcher = errorLinePattern.matcher(line)).find()) {
                try {
                    int lineId = Integer.parseInt(errorMatcher.group(1));
                    this.lineIdsFailed.add(lineId);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot extract line with error", (Throwable)e);
                }
            }
            if (line.startsWith("Unhandled Exception:") || line.startsWith("exception:")) {
                this.addWarning(line);
            }
            if (line.startsWith("Loadfile records count:") && (totalRecordsMatcher = totalLinesPattern.matcher(line)).find()) {
                try {
                    if (this.linesInScope == 0L) {
                        this.linesInScope = Long.parseLong(totalRecordsMatcher.group(1));
                        this.addExecutionLog(this.iu.getNumeralString("RelativityCsvOverlayOperation.Log.LinesCount", this.linesInScope));
                    } else {
                        LOGGER.warn("Duplicate records in overlay found in line " + line);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot extract lines in scope", (Throwable)e);
                }
            }
            if (!transferModePatternPrinted && (transferModeMatcher = transferModePattern.matcher(line)).find()) {
                this.addExecutionLog(this.iu.getFormattedString("RelativityCsvOverlayOperation.Log.RelativityTransferMode", (Object)transferModeMatcher.group(1)));
                transferModePatternPrinted = true;
            }
            if (!line.contains("[NOT MAPPED") || line.contains("Source field [parent folder identifier]")) continue;
            this.addTransientWarning(line, false);
        }
    }

    private void readErrorStream(BufferedReader errorReader) throws IOException {
        String line;
        while ((line = errorReader.readLine()) != null) {
            if (line.trim().length() > 0 && !line.startsWith(" ")) {
                this.addWarning(line);
            }
            LOGGER.warn(line);
        }
    }

    private void loadOverlay(String overlayLocation) throws IOException, InterruptedException, ParameterException {
        this.addExecutionLog(this.iu.getFormattedString("RelativityCsvOverlayOperation.Log.OverlayLocation", (Object)overlayLocation));
        String relativityServiceEndpoint = this.executionContext.evalParameters("{wfn_relativity_service_endpoint}", this);
        String relativityClientVersion = this.executionContext.evalParameters("{wfn_relativity_client_version}", this);
        ThirdPartyAuthenticationMethod authenticationMethod = ThirdPartyAuthenticationMethod.USERNAME_PASSWORD;
        String authenticationMethodString = this.executionContext.evalParameters("{wfn_relativity_authentication_method}", this);
        try {
            authenticationMethod = ThirdPartyAuthenticationMethod.valueOf((String)authenticationMethodString);
            if (authenticationMethod == ThirdPartyAuthenticationMethod.OIDC_AUTHORIZATION_CODE) {
                this.relativityUsername = "none";
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse authentication method with value " + String.valueOf(authenticationMethodString) + " for relativity", (Throwable)e);
        }
        CharSequence[] relativityClientCommandArray = new String[]{"\"" + RelativityUtils.getRelativityClientPath(relativityClientVersion) + "\"", "import", this.relativityEndpointType + "://" + this.relativityHostname + relativityServiceEndpoint, this.relativityUsername, "\"" + this.relativityPassword + "\"", "\"" + (this.relativityMappingLocation.length() > 0 ? this.relativityMappingLocation : "none") + "\"", "\"" + this.settingsFile.getAbsolutePath() + "\"", "\"" + overlayLocation + "\"", this.relativityWorkspaceId, "0", this.relativityImportThreads, this.relativityImportThreadTimeout, this.relativityImportThreadRetries, this.relativityPatchInvalidEntries};
        String commandLine = String.join((CharSequence)" ", relativityClientCommandArray);
        LOGGER.info("Running: " + commandLine.replace(this.relativityPassword, "[password]"));
        this.relativityLoadProcess = Runtime.getRuntime().exec((String[])relativityClientCommandArray);
        BufferedReader standardInputReader = new BufferedReader(new InputStreamReader(this.relativityLoadProcess.getInputStream()));
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(this.relativityLoadProcess.getErrorStream()));
        this.readStandardOutputThread = new Thread(() -> {
            try {
                this.readOutputStream(standardInputReader);
            }
            catch (IOException e) {
                LOGGER.error("Cannot read standard output stream", (Throwable)e);
                this.addWarning(e.getLocalizedMessage());
            }
            finally {
                try {
                    standardInputReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot close stream", (Throwable)e);
                }
            }
        });
        this.readStandardOutputThread.setName("Automate Relativity Standard Output Thread");
        this.readStandardOutputThread.start();
        this.readStandardErrorThread = new Thread(() -> {
            try {
                this.readErrorStream(errorReader);
            }
            catch (IOException e) {
                LOGGER.error("Cannot read standard error stream", (Throwable)e);
                this.addWarning(e.getLocalizedMessage());
            }
            finally {
                try {
                    errorReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot close stream", (Throwable)e);
                }
            }
        });
        this.readStandardErrorThread.setName("Automate Relativity Standard Error Thread");
        this.readStandardErrorThread.start();
        this.relativityLoadProcess.waitFor();
    }

    @Override
    public void stopTriggered() {
        LOGGER.info("Stop triggered");
        Thread thread = new Thread(() -> {
            while (this.executionState == ExecutionState.STOPPING) {
                this.stopLoad();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        thread.setName("Automate - Operation " + this.getOperationName() + " Stop request");
        thread.start();
    }

    private void stopLoad() {
        if (this.relativityLoadProcess != null) {
            LOGGER.info("Attempting to destroy Relativity load process");
            try {
                this.relativityLoadProcess.destroyForcibly();
            }
            catch (Exception e) {
                LOGGER.error("Cannot destroy Relativity load process", (Throwable)e);
            }
            if (!this.relativityLoadProcess.isAlive()) {
                this.trackStopped();
            }
        }
    }

    @Override
    protected double getPercentageComplete() {
        if (this.linesInScope == 0L) {
            return 1.0E-4;
        }
        double result = (double)this.itemsLoadedMetadata.get() / (double)this.linesInScope;
        return result;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (((String)result).length() > 0) {
            result = (String)result + " / ";
        }
        if (this.linesInScope == 0L) {
            result = (String)result + this.iu.getString("RelativityCsvOverlayOperation.Progress.ParsingOverlay");
        } else if (this.itemsLoadedMetadata != null) {
            result = (String)result + this.iu.getNumeralString("RelativityCsvOverlayOperation.Progress.LoadingItems", (long)this.itemsLoadedMetadata.get());
        }
        return result;
    }
}

