/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.RelativityDeleteSavedSearchOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.DeleteSavedSearchStrategy;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.io.IOException;
import java.util.List;

public class RelativityDeleteSavedSearchOperationImplementation
extends RelativityDeleteSavedSearchOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityDeleteSavedSearchOperation.class);
    private transient double percentageComplete;
    private transient String stageName;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                this.savedSearchIdentifier = this.executionContext.evalParameters(this.savedSearchIdentifier, this);
                Long workspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                this.stageName = this.iu.getString("RelativityDeleteSavedSearchOperation.Stage.DeletingSavedSearch");
                this.percentageComplete = 0.25;
                this.addExecutionLog(this.iu.getFormattedString("RelativityDeleteSavedSearchOperation.Log.DeleteStrategy", (Object)this.deleteStrategy.toString()));
                List<EligibleObject> eligibleSearches = this.relativityRestClient.querySearchesForWorkspace(workspaceArtifactId);
                if (this.deleteStrategy == DeleteSavedSearchStrategy.ALL_SEARCHES) {
                    int totalSearches = eligibleSearches.size();
                    int searchesProcessed = 0;
                    int searchesDeleted = 0;
                    int searchesErrored = 0;
                    this.addExecutionLog(this.iu.getFormattedString("RelativityDeleteSavedSearchOperation.Log.SavedSearchesCount", (Object)eligibleSearches.size()));
                    for (EligibleObject search : eligibleSearches) {
                        try {
                            this.relativityRestClient.deleteSavedSearch(workspaceArtifactId, search.getArtifactId());
                            this.addExecutionLog(this.iu.getFormattedString("RelativityDeleteSavedSearchOperation.Log.DeletedSavedSearch", new Object[]{search.getName(), String.valueOf(search.getArtifactId())}));
                            ++searchesDeleted;
                        }
                        catch (IOException e) {
                            LOGGER.error("Failed to delete saved search", (Throwable)e);
                            this.addWarning(this.iu.getFormattedString("RelativityDeleteSavedSearchOperation.Warning.FailedToDeleteSavedSearch", new Object[]{search.getName(), String.valueOf(search.getArtifactId()), e.getMessage()}));
                            ++searchesErrored;
                        }
                        this.stageName = this.iu.getFormattedString("RelativityDeleteSavedSearchOperation.Stage.DeletingSavedSearchDetailed", new Object[]{String.valueOf(++searchesProcessed), String.valueOf(totalSearches)});
                        this.percentageComplete = 0.25 + (double)searchesProcessed / (double)totalSearches * 0.75;
                    }
                    if (searchesDeleted > 0) {
                        this.addExecutionLog(this.iu.getFormattedString("RelativityDeleteSavedSearchOperation.Log.DeleteSavedSearchCount", (Object)searchesDeleted));
                    }
                    if (searchesErrored > 0) {
                        this.addWarning(this.iu.getNumeralString("RelativityDeleteSavedSearchOperation.Warning.ErroredSavedSearch", (long)searchesErrored));
                    }
                } else {
                    EligibleObject eligibleSearch = RelativityUtils.getInstance().filterEligibleObject(this.savedSearchIdentifier, this.savedSearchIdentifierType, eligibleSearches, RelativityFieldType.SAVED_SEARCH);
                    if (eligibleSearch == null) {
                        throw new Exception(this.iu.getFormattedString("RelativityDeleteSavedSearchOperation.Exception.MissingSavedSearch", new Object[]{String.valueOf(this.savedSearchIdentifier)}));
                    }
                    this.relativityRestClient.deleteSavedSearch(workspaceArtifactId, eligibleSearch.getArtifactId());
                    this.addExecutionLog(this.iu.getFormattedString("RelativityDeleteSavedSearchOperation.Log.DeletedSavedSearch", new Object[]{eligibleSearch.getName(), String.valueOf(eligibleSearch.getArtifactId())}));
                }
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

