/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.RelativityDeleteScriptOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.util.List;

public class RelativityDeleteScriptOperationImplementation
extends RelativityDeleteScriptOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityDeleteScriptOperation.class);
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                Long relativityWorkspaceId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                this.percentageComplete = 0.25;
                this.scriptIdentifier = this.executionContext.evalParameters(this.scriptIdentifier, this);
                this.stageName = this.iu.getString("RelativityDeleteScriptOperation.Stage.DeletingScript");
                List<EligibleObject> eligibleScripts = this.relativityRestClient.queryEligibleScripts(relativityWorkspaceId);
                EligibleObject eligibleScript = RelativityUtils.getInstance().filterEligibleObject(this.scriptIdentifier, this.scriptIdentifierType, eligibleScripts, RelativityFieldType.SCRIPT);
                if (eligibleScript == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityDeleteScriptOperation.Exception.MissingScript", new Object[]{this.scriptIdentifier}));
                }
                this.relativityRestClient.deleteScript(relativityWorkspaceId, eligibleScript.getArtifactId());
                this.addExecutionLog(this.iu.getFormattedString("RelativityDeleteScriptOperation.Log.DeletedScript", (Object)this.scriptIdentifier));
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

