/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.aspose.cells.Cell;
import com.aspose.cells.CellsException;
import com.aspose.cells.FindOptions;
import com.aspose.cells.LoadOptions;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.aspose.cells.Workbook;
import com.aspose.cells.Worksheet;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.RelativityExportSavedSearchOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SavedSearchDetails;
import com.nuix.automate.workflow.core.execution.options.report.TemplateWorksheetName;
import com.nuix.automate.workflow.core.utils.general.AsposeUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class RelativityExportSavedSearchOperationImplementation
extends RelativityExportSavedSearchOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityExportSavedSearchOperation.class);
    private transient double percentageComplete;
    private transient String stageName;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                Long workspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                this.stageName = this.iu.getString("RelativityExportSavedSearchOperation.Stage.GettingSavedSearches");
                this.percentageComplete = 0.1;
                List<EligibleObject> eligibleSearches = this.relativityRestClient.querySearchesForWorkspace(workspaceArtifactId);
                if (eligibleSearches.size() == 0) {
                    this.addWarning(this.iu.getString("RelativityExportSavedSearchOperation.Warning.NoSearches"));
                    this.trackFinished();
                    return;
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityExportSavedSearchOperation.Info.SearchesCount", (Object)eligibleSearches.size()));
                Map<Long, String> absoluteContainerPaths = this.relativityRestClient.resolveSearchContainerPaths(workspaceArtifactId);
                this.stageName = this.iu.getString("RelativityExportSavedSearchOperation.Stage.ExportingSavedSearches");
                this.percentageComplete = 0.3;
                ArrayList<SavedSearchDetails> rows = new ArrayList<SavedSearchDetails>();
                StringBuilder csv = new StringBuilder();
                csv.append(this.iu.getString("RelativityExportSavedSearchOperation.Report.FolderHeader")).append(",").append(this.iu.getString("RelativityExportSavedSearchOperation.Report.NameHeader")).append(",").append(this.iu.getString("RelativityExportSavedSearchOperation.Report.QueryHeader")).append(",").append(this.iu.getString("RelativityExportSavedSearchOperation.Report.ScopeHeader")).append(",").append(this.iu.getString("RelativityExportSavedSearchOperation.Report.ScopeFolders")).append(",").append(this.iu.getString("RelativityExportSavedSearchOperation.Report.FieldsHeader")).append(",").append(this.iu.getString("RelativityExportSavedSearchOperation.Report.SortsHeader")).append("\r\n");
                int searchesExported = 0;
                for (EligibleObject search : eligibleSearches) {
                    String folder;
                    SavedSearchDetails savedSearch = null;
                    try {
                        savedSearch = this.relativityRestClient.readSavedSearch(workspaceArtifactId, search.getArtifactId(), absoluteContainerPaths);
                    }
                    catch (Exception e) {
                        savedSearch = this.relativityRestClient.readSavedSearch(workspaceArtifactId, search.getArtifactId(), absoluteContainerPaths, false);
                        this.addWarning(this.iu.getFormattedString("RelativityExportSavedSearchOperation.Warning.FailedToGenerateQuery", new Object[]{search.getName(), String.valueOf(search.getArtifactId())}));
                        savedSearch.setSavedSearchQuery("[INVALID]");
                    }
                    String string = folder = savedSearch.getFolder() == null ? "" : savedSearch.getFolder();
                    if (folder.length() > 0) {
                        folder = folder.replace("\\", "\\\\");
                    }
                    String name = savedSearch.getName().replace("\\", "\\\\");
                    ArrayList<String> scopeFolders = new ArrayList<String>();
                    for (String scopeFolder : savedSearch.getScopeFolders()) {
                        scopeFolders.add(scopeFolder.replace("\\", "\\\\"));
                    }
                    csv.append(FormattingUtils.encodeForCsv((String)folder)).append(",").append(FormattingUtils.encodeForCsv((String)name)).append(",").append(FormattingUtils.encodeForCsv((String)savedSearch.getSavedSearchQuery())).append(",").append(FormattingUtils.encodeForCsv((String)savedSearch.getScope().name())).append(",").append(FormattingUtils.encodeForCsv((String)String.join((CharSequence)",", scopeFolders))).append(",").append(FormattingUtils.encodeForCsv((String)String.join((CharSequence)",", savedSearch.getFieldNames()))).append(",").append(FormattingUtils.encodeForCsv((String)String.join((CharSequence)",", savedSearch.getSortingFields()))).append("\r\n");
                    ++searchesExported;
                    if (this.writeReport) {
                        rows.add(savedSearch);
                    }
                    this.stageName = this.iu.getFormattedString("RelativityExportSavedSearchOperation.Stage.ExportingSavedSearchesDetail", new Object[]{searchesExported, eligibleSearches.size()});
                    this.percentageComplete = 0.3 + (double)searchesExported / (double)eligibleSearches.size() * 0.6;
                }
                FileUtils.writeToFile((StringBuilder)csv, (Path)Paths.get(this.savedSearchExportLocation, new String[0]));
                this.addExecutionLog(this.iu.getFormattedString("RelativityExportSavedSearchOperation.Info.ResultsLocation", (Object)this.savedSearchExportLocation));
                this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_saved_searches_file}", this.savedSearchExportLocation)));
                if (this.writeReport) {
                    this.stageName = this.iu.getString("RelativityExportSavedSearchOperation.Stage.GeneratingReport");
                    this.percentageComplete = 0.9;
                    this.writeReportFile(rows);
                }
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    public void writeReportFile(List<SavedSearchDetails> lines) throws Exception {
        int templateWorksheetIndex;
        Object buffer;
        lines.sort(Comparator.comparing(SavedSearchDetails::getName, String.CASE_INSENSITIVE_ORDER));
        lines.sort(Comparator.comparing(SavedSearchDetails::getFolder, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER)));
        AsposeUtils.applyAsposeCellsLicense();
        LoadOptions loadOptions = new LoadOptions(6);
        File templateFile = null;
        if (this.customReportTemplatePath.length() > 0 && !(templateFile = new File(this.customReportTemplatePath)).exists()) {
            LOGGER.error("Cannot find report template file " + templateFile.getAbsolutePath());
            this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.CouldNotFindReportTemplate", (Object)templateFile.getAbsoluteFile()));
        }
        if (templateFile == null || !templateFile.exists()) {
            templateFile = this.executionContext.getReportTemplate();
            LOGGER.info("Cannot find report template file " + templateFile.getAbsolutePath() + ". Creating default file");
            File templateFolder = templateFile.getParentFile();
            if (!templateFolder.exists()) {
                LOGGER.info("Creating folder " + templateFolder.getAbsolutePath());
                templateFolder.mkdirs();
            }
            try (InputStream templateStream = this.getClass().getResourceAsStream("/reports/template.xlsx");
                 OutputStream outputStream = Files.newOutputStream(templateFile.toPath(), new OpenOption[0]);){
                int bytesRead;
                buffer = new byte[1024];
                while ((bytesRead = templateStream.read((byte[])buffer)) != -1) {
                    outputStream.write((byte[])buffer, 0, bytesRead);
                }
                templateStream.close();
                outputStream.flush();
            }
        }
        Workbook workbook = new Workbook(templateFile.getAbsolutePath(), loadOptions);
        for (int worksheetId = 0; worksheetId < workbook.getWorksheets().getCount(); ++worksheetId) {
            Worksheet worksheet = workbook.getWorksheets().get(worksheetId);
            LOGGER.info("Pre-processing worksheet " + worksheet.getName());
            buffer = this.executionContext.getParameterNames().iterator();
            while (buffer.hasNext()) {
                String placeholder = (String)buffer.next();
                try {
                    FindOptions findOptions = new FindOptions();
                    findOptions.setLookAtType(3);
                    findOptions.setLookInType(1);
                    Cell matchingCell = null;
                    while ((matchingCell = worksheet.getCells().find((Object)placeholder, matchingCell, findOptions)) != null) {
                        String unpackedPlaceholder = this.executionContext.evalParameters(placeholder, this);
                        if (placeholder.equals("{date_spreadsheet}") || placeholder.equals("{date_time_spreadsheet}")) {
                            matchingCell.setValue((Object)Calendar.getInstance());
                        } else if (placeholder.equals("{time_spreadsheet}")) {
                            matchingCell.setValue((Object)new Date());
                        } else {
                            matchingCell.setValue((Object)unpackedPlaceholder);
                        }
                        LOGGER.info("Searching for " + placeholder + ", got " + String.valueOf(matchingCell));
                    }
                }
                catch (Exception e) {
                    LOGGER.info("Cannot unpack placeholder " + placeholder, (Throwable)e);
                }
            }
        }
        String treeSizeWorksheetName = TemplateWorksheetName.TEMPLATE_RELATIVITY_EXPORT_SAVED_SEARCHES.toString();
        try {
            templateWorksheetIndex = workbook.getWorksheets().addCopy(treeSizeWorksheetName);
        }
        catch (CellsException e) {
            this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.TemplateFileNoWorksheetNamed", (Object)treeSizeWorksheetName));
            return;
        }
        Worksheet worksheet = workbook.getWorksheets().get(templateWorksheetIndex);
        worksheet.setName(this.iu.getString("RelativityExportSavedSearchOperation.Report.SavedSearchResults"));
        int sr = 0;
        int sc = 0;
        FindOptions findOptions = new FindOptions();
        findOptions.setLookAtType(0);
        findOptions.setLookInType(1);
        Cell matchingCell = null;
        matchingCell = worksheet.getCells().find((Object)"__START__", matchingCell, findOptions);
        if (matchingCell != null) {
            sr = matchingCell.getRow();
            sc = matchingCell.getColumn();
        }
        matchingCell = null;
        matchingCell = worksheet.getCells().find((Object)"{view_name}", matchingCell, findOptions);
        if (matchingCell != null) {
            matchingCell.setValue((Object)this.iu.getString("RelativityExportSavedSearchOperation.Report.SavedSearchResults"));
        }
        int rowId = 3;
        int columnId = 0;
        int processedItems = 0;
        String[] headers = new String[]{this.iu.getString("RelativityExportSavedSearchOperation.Report.FolderHeader"), this.iu.getString("RelativityExportSavedSearchOperation.Report.NameHeader"), this.iu.getString("RelativityExportSavedSearchOperation.Report.QueryHeader"), this.iu.getString("RelativityExportSavedSearchOperation.Report.ScopeHeader"), this.iu.getString("RelativityExportSavedSearchOperation.Report.ScopeFolders"), this.iu.getString("RelativityExportSavedSearchOperation.Report.FieldsHeader"), this.iu.getString("RelativityExportSavedSearchOperation.Report.SortsHeader")};
        for (String header : headers) {
            worksheet.getCells().get(sr, sc + columnId).setValue((Object)header);
            ++columnId;
        }
        for (SavedSearchDetails result : lines) {
            boolean isFirstRow;
            if (this.stopRequested) {
                throw new WorkflowExecutionStopRequested();
            }
            worksheet.getCells().insertRow(sr + ++rowId);
            int isLastRow = processedItems == lines.size() - 1 ? 1 : 0;
            boolean bl = isFirstRow = processedItems == 0;
            if (isFirstRow) {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 1, sr + rowId);
            } else if (isLastRow == 0) {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 2, sr + rowId);
            } else {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 3, sr + rowId);
            }
            worksheet.getCells().get(sr + rowId, sc).setValue((Object)result.getFolder());
            worksheet.getCells().get(sr + rowId, sc + 1).setValue((Object)result.getName());
            worksheet.getCells().get(sr + rowId, sc + 2).setValue((Object)result.getSavedSearchQuery());
            worksheet.getCells().get(sr + rowId, sc + 3).setValue((Object)result.getScope().toString());
            worksheet.getCells().get(sr + rowId, sc + 4).setValue((Object)String.join((CharSequence)",", result.getScopeFolders()));
            worksheet.getCells().get(sr + rowId, sc + 5).setValue((Object)String.join((CharSequence)",", result.getFieldNames()));
            worksheet.getCells().get(sr + rowId, sc + 6).setValue((Object)String.join((CharSequence)",", result.getSortingFields()));
            ++processedItems;
        }
        worksheet.getCells().deleteRow(sr + 1);
        worksheet.getCells().deleteRow(sr + 1);
        worksheet.getCells().deleteRow(sr + 1);
        for (TemplateWorksheetName templateWorksheetName : TemplateWorksheetName.values()) {
            try {
                workbook.getWorksheets().removeAt(templateWorksheetName.toString());
            }
            catch (Exception e) {
                LOGGER.error("Cannot remove sheet " + String.valueOf((Object)templateWorksheetName));
            }
        }
        workbook.getBuiltInDocumentProperties().setAuthor("Automate Workflow");
        this.reportLocation = this.executionContext.evalParameters(this.reportLocation, this);
        File reportFile = new File(this.reportLocation);
        this.reportLocation = reportFile.getAbsolutePath();
        File reportFolder = reportFile.getParentFile();
        if (!reportFolder.exists()) {
            reportFolder.mkdirs();
        }
        LOGGER.info("Saving report to " + reportFile.getAbsolutePath());
        if (reportFile.getAbsolutePath().toLowerCase().endsWith(".pdf")) {
            PdfSaveOptions saveOptions = new PdfSaveOptions();
            saveOptions.setAllColumnsInOnePagePerSheet(true);
            workbook.save(reportFile.getAbsolutePath(), (SaveOptions)saveOptions);
        } else {
            String reportPasswordParameter = "{report_password}";
            String reportPassword = this.executionContext.evalParameters(reportPasswordParameter, this);
            if (!reportPassword.equals(reportPasswordParameter)) {
                this.addExecutionLog(this.iu.getString("ProcessingReportOperation.Log.SettingPassword"));
                if (reportPassword.length() == 0) {
                    this.addWarning(this.iu.getString("ProcessingReportOperation.Log.BlankPassword"));
                }
                workbook.setEncryptionOptions(3, 128);
                workbook.getSettings().setPassword(reportPassword);
            }
            workbook.save(reportFile.getAbsolutePath());
        }
        this.addExecutionLog(this.iu.getFormattedString("RelativityExportSavedSearchOperation.Info.ReportLocation", (Object)reportFile.getAbsolutePath()));
        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_report_file}", reportFile.getAbsolutePath())));
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

