/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRadioButtonGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.RadioButtonValue;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.RelativityIdentifierType;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ConfigureRelativityConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RelativityOperation;
import com.nuix.automate.workflow.core.execution.operations.RelativitySetWorkspaceOperation;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldRadioButtonGroup(name="useObjectsFileRadioButtonGroup", radioButton="useObjectsFile", values={@RadioButtonValue(value="false", component="objects"), @RadioButtonValue(value="true", component="objectsFile")})
@FormFieldRow(name="objectTypeIdentifierRow", children={"objectTypeIdentifierType", "objectTypeIdentifier"})
@OperationMetadata(alias=OperationAlias.RELATIVITY_LOAD_DYNAMIC_OBJECTS, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"RELATIVITY"}), @OperationTag(name="Category", value={"LOAD"})})
@OperationLicenseModule(module=ModuleType.RELATIVITY_ADVANCED)
public class RelativityLoadDynamicObjectsOperation
extends RelativityOperation {
    @FormField(allowedValues={"ARTIFACT_ID", "NAME", "NAME_LIKE"})
    public RelativityIdentifierType objectTypeIdentifierType;
    @FormField
    public String objectTypeIdentifier;
    @FormField
    public boolean loadObjectsInWorkspace;
    @FormField
    public boolean useObjectsFile;
    @FormField(enableOn={@OnField(name="useObjectsFile")})
    public String objectsFile;
    @FormField(componentType=FieldComponentType.SCRIPT_PANE, scriptLanguage="text", enableOn={@OnField(name="useObjectsFile", value={"false"})})
    public String objects;

    public RelativityLoadDynamicObjectsOperation() {
        this.requiresCase = false;
        this.objectTypeIdentifier = "";
        this.objectTypeIdentifierType = RelativityIdentifierType.NAME;
        this.objectsFile = "";
        this.loadObjectsInWorkspace = true;
        this.objects = "Name\tDate\nExample\t{date_time}";
        this.useObjectsFile = false;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("RelativityLoadCustomObjectsOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedSetRelativityWorkspaceOperation = false;
        boolean detectedConfigureRelativityConnectionOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof ConfigureRelativityConnectionOperation) {
                detectedConfigureRelativityConnectionOperation = true;
            }
            if (o instanceof RelativitySetWorkspaceOperation) {
                detectedSetRelativityWorkspaceOperation = true;
            }
            if (o == this) break;
        }
        if (!detectedConfigureRelativityConnectionOperation) {
            prerequisites.add(this.iu.getString("ConfigureRelativityConnectionOperation.Prerequisites.Missing"));
        }
        if (this.loadObjectsInWorkspace && !detectedSetRelativityWorkspaceOperation) {
            prerequisites.add(this.iu.getString("RelativitySetWorkspaceOperation.Prerequisites.Missing"));
        }
        if (this.objectTypeIdentifier == null || this.objectTypeIdentifier.trim().equals("")) {
            prerequisites.add(this.iu.getString("RelativityLoadCustomObjectsOperation.Prerequisites.ObjectTypeIdentifierMissing"));
        }
        if (this.useObjectsFile && (this.objectsFile == null || this.objectsFile.trim().equals(""))) {
            prerequisites.add(this.iu.getString("RelativityLoadCustomObjectsOperation.Prerequisites.CsvPathMissing"));
        }
        if (!this.useObjectsFile && (this.objects == null || this.objects.trim().equals(""))) {
            prerequisites.add(this.iu.getString("RelativityLoadCustomObjectsOperation.Prerequisites.MissingObjects"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

