/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.RelativityIdentifierType;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ConfigureRelativityConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RelativityOperation;
import com.nuix.automate.workflow.core.execution.operations.RelativitySetWorkspaceOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.ExistingAnalyticJobAction;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityAnalyticIndexAction;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityIndexType;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldRow(name="analyticIdentifierRow", children={"analyticIndexIdentifierType", "analyticIndexIdentifier"})
@OperationMetadata(alias=OperationAlias.RELATIVITY_MANAGE_ANALYTIC_INDEX, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"RELATIVITY"}), @OperationTag(name="Category", value={"SEARCH", "MANAGEMENT"})})
@OperationLicenseModule(module=ModuleType.RELATIVITY_ADVANCED)
public class RelativityManageAnalyticIndexOperation
extends RelativityOperation {
    @FormField
    public String analyticIndexIdentifier;
    @FormField(allowedValues={"ARTIFACT_ID", "NAME", "NAME_REGEX"})
    public RelativityIdentifierType analyticIndexIdentifierType;
    @FormField(allowedValues={"CONCEPTUAL", "CLASSIFICATION"})
    public RelativityIndexType indexType;
    @FormField
    public ExistingAnalyticJobAction existingJobAction;
    @FormField
    public RelativityAnalyticIndexAction analyticIndexAction;
    @FormField
    public boolean waitForCompletion;

    public RelativityManageAnalyticIndexOperation() {
        this.requiresCase = false;
        this.analyticIndexIdentifier = "";
        this.analyticIndexIdentifierType = RelativityIdentifierType.NAME;
        this.analyticIndexAction = RelativityAnalyticIndexAction.FULL_POPULATION;
        this.indexType = RelativityIndexType.CONCEPTUAL;
        this.existingJobAction = ExistingAnalyticJobAction.SKIP;
        this.waitForCompletion = true;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("RelativityManageAnalyticIndexOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        boolean invalidClassificationAction;
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedConfigureRelativityConnectionOperation = false;
        boolean detectedSetRelativityWorkspaceOperationOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof ConfigureRelativityConnectionOperation) {
                detectedConfigureRelativityConnectionOperation = true;
            }
            if (o instanceof RelativitySetWorkspaceOperation) {
                detectedSetRelativityWorkspaceOperationOperation = true;
            }
            if (o == this) break;
        }
        if (!detectedConfigureRelativityConnectionOperation) {
            prerequisites.add(this.iu.getString("ConfigureRelativityConnectionOperation.Prerequisites.Missing"));
        }
        if (!detectedSetRelativityWorkspaceOperationOperation) {
            prerequisites.add(this.iu.getString("RelativitySetWorkspaceOperation.Prerequisites.Missing"));
        }
        if (this.analyticIndexIdentifier == null || this.analyticIndexIdentifier.trim().equals("")) {
            prerequisites.add(this.iu.getString("RelativityManageAnalyticIndexOperation.Prerequisites.MissingAnalyticIdentifier"));
        }
        boolean bl = invalidClassificationAction = this.indexType == RelativityIndexType.CLASSIFICATION && EnumSet.of(RelativityAnalyticIndexAction.BUILD_INDEX, RelativityAnalyticIndexAction.ACTIVATE, RelativityAnalyticIndexAction.DEACTIVATE).contains((Object)this.analyticIndexAction);
        if (invalidClassificationAction) {
            prerequisites.add(this.iu.getFormattedString("RelativityManageAnalyticIndexOperation.Prerequisites.InvalidAction", new Object[]{this.indexType.toString(), this.analyticIndexAction.toString()}));
        }
        if (this.indexType != null && this.indexType != RelativityIndexType.CLASSIFICATION && this.indexType != RelativityIndexType.CONCEPTUAL) {
            prerequisites.add(this.iu.getFormattedString("RelativityManageAnalyticIndexOperation.Exception.InvalidIndexType", (Object)this.indexType.toString()));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

