/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldColumn;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRadioButtonGroup;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.RadioButtonValue;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.RelativityIdentifierType;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ConfigureRelativityConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RelativityOperation;
import com.nuix.automate.workflow.core.execution.operations.RelativitySetClientOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityUserAction;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldRadioButtonGroup(name="useUserSettingsFileRadioButtonGroup", radioButton="useUserSettingsFile", values={@RadioButtonValue(value="false", component="userSettings"), @RadioButtonValue(value="true", component="userSettingsFileName")})
@OperationMetadata(alias=OperationAlias.RELATIVITY_MANAGE_USERS, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"RELATIVITY"}), @OperationTag(name="Category", value={"PERMISSIONS"})})
@OperationLicenseModule(module=ModuleType.RELATIVITY_ADVANCED)
public class RelativityManageUsersOperation
extends RelativityOperation {
    @FormField(allowedValues={"ARTIFACT_ID", "NAME", "EMAIL"})
    public RelativityIdentifierType userIdentifierType;
    @FormField(allowedValues={"DELETE"})
    public RelativityUserAction userAction;
    @FormField
    public boolean useUserSettingsFile;
    @FormField(enableOn={@OnField(name="useUserSettingsFile")})
    public String userSettingsFileName;
    @FormField(label="users", enableOn={@OnField(name="useUserSettingsFile", value={"false"})}, columnFields={@FormFieldColumn(label="userIdentifier")})
    @ExcludeFromPrintableOptions
    public List<Object[]> userSettings;

    public boolean getDisplayUserSettingsFileName() {
        return this.useUserSettingsFile;
    }

    public RelativityManageUsersOperation() {
        this.requiresCase = false;
        this.userIdentifierType = RelativityIdentifierType.NAME;
        this.userAction = RelativityUserAction.DELETE;
        this.userSettings = new ArrayList<Object[]>();
        this.useUserSettingsFile = false;
        this.userSettingsFileName = null;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("RelativityManageUsersOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedSetRelativityClientOperation = false;
        boolean detectedConfigureRelativityConnectionOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof ConfigureRelativityConnectionOperation) {
                detectedConfigureRelativityConnectionOperation = true;
            }
            if (o instanceof RelativitySetClientOperation) {
                detectedSetRelativityClientOperation = true;
            }
            if (o == this) break;
        }
        if (!detectedConfigureRelativityConnectionOperation) {
            prerequisites.add(this.iu.getString("ConfigureRelativityConnectionOperation.Prerequisites.Missing"));
        }
        if (!detectedSetRelativityClientOperation) {
            prerequisites.add(this.iu.getString("Relativity.Prerequisites.MissingClient"));
        }
        if (!(this.useUserSettingsFile || this.userSettings != null && this.userSettings.size() != 0)) {
            prerequisites.add(this.iu.getString("RelativityManageUsersOperation.Prerequisites.MissingUsers"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

