/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.RelativityQueryWorkspaceGroupPermissionsOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceGroupPermissions;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class RelativityQueryWorkspaceGroupPermissionsOperationImplementation
extends RelativityQueryWorkspaceGroupPermissionsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityQueryWorkspaceGroupPermissionsOperationImplementation.class);
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                Long relativityWorkspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                this.groupIdentifier = this.executionContext.evalParameters(this.groupIdentifier, this);
                this.permissionsOutputFile = this.executionContext.evalParameters(this.permissionsOutputFile, this);
                this.stageName = this.iu.getString("RelativityQueryWorkspaceGroupPermissionsOperation.Stage.QueryingPermissions");
                this.percentageComplete = 0.25;
                Long groupArtifactId = 0L;
                List<EligibleObject> eligibleGroups = this.relativityRestClient.queryEligibleGroups(null);
                EligibleObject eligibleGroup = RelativityUtils.getInstance().filterEligibleObject(this.groupIdentifier, this.groupIdentifierType, eligibleGroups, RelativityFieldType.GROUP);
                if (eligibleGroup == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityQueryWorkspaceGroupPermissionsOperation.Exception.MissingGroup", (Object)String.valueOf(this.groupIdentifier)));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityQueryWorkspaceGroupPermissionsOperation.Info.GroupIdentifier", (Object)String.valueOf(this.groupIdentifier)));
                groupArtifactId = eligibleGroup.getArtifactId();
                WorkspaceGroupPermissions permissions = this.relativityRestClient.getWorkspaceGroupPermissions(relativityWorkspaceArtifactId, groupArtifactId);
                if (permissions == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityQueryWorkspaceGroupPermissionsOperation.Exception.WorkspaceDoesNotContainGroup", (Object)String.valueOf(this.groupIdentifier)));
                }
                permissions.setArtifactID(null);
                permissions.setGroupID(null);
                permissions.setLastModified(null);
                this.stageName = this.iu.getString("RelativityQueryWorkspaceGroupPermissionsOperation.Stage.WritingPermissions");
                this.percentageComplete = 0.75;
                String permissionsJsonString = SerializationUtils.toJson((Object)permissions, (boolean)false);
                this.addExecutionLog(this.iu.getFormattedString("RelativityQueryWorkspaceGroupPermissionsOperation.Info.PermissionsOutputFile", (Object)this.permissionsOutputFile));
                File file = new File(this.permissionsOutputFile);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                FileUtils.writeStringToFile((File)file, (String)permissionsJsonString, (Charset)StandardCharsets.UTF_8);
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_group_permissions_file}", this.permissionsOutputFile)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_export_folder}", new File(this.permissionsOutputFile).getParentFile().getAbsolutePath())));
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

