/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.RelativityRunImagingSetOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ExistingImagingJobAction;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ImagingJobStopResult;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ImagingSetStatus;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.util.List;

public class RelativityRunImagingSetOperationImplementation
extends RelativityRunImagingSetOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityRunImagingSetOperation.class);
    private transient double percentageComplete;
    private transient String stageName;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                block19: {
                    this.initializeRelativityClient(false);
                    this.assertRelativityInstanceLicensed();
                    this.imagingSetIdentifier = this.executionContext.evalParameters(this.imagingSetIdentifier, this);
                    Long workspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                    this.stageName = this.iu.getString("RelativityRunImagingSetOperation.Stage.GettingImagingSet");
                    this.percentageComplete = 0.1;
                    List<EligibleObject> eligibleImagingSets = this.relativityRestClient.queryImagingSets(workspaceArtifactId, this.imagingSetIdentifierType, this.imagingSetIdentifier);
                    EligibleObject eligibleImagingSet = RelativityUtils.getInstance().filterAllEligibleObject(this.imagingSetIdentifier, this.imagingSetIdentifierType, eligibleImagingSets, RelativityFieldType.IMAGING_SET);
                    if (eligibleImagingSet == null) {
                        throw new Exception(this.iu.getFormattedString("RelativityRunImagingSetOperation.Exception.MissingImagingSet", (Object)String.valueOf(this.imagingSetIdentifier)));
                    }
                    this.addExecutionLog(this.iu.getFormattedString("RelativityRunImagingSetOperation.Info.ImagingSet", (Object)(eligibleImagingSet.getName() + ":" + eligibleImagingSet.getArtifactId())));
                    Long imagingSetArtifactId = eligibleImagingSet.getArtifactId();
                    this.addExecutionLog(this.iu.getFormattedString("RelativityRunImagingSetOperation.Info.ExistingImagingJobAction", (Object)this.existingImagingJobAction.toString()));
                    ImagingSetStatus currentImagingSetStatus = this.relativityRestClient.getImagingSetStatus(workspaceArtifactId, imagingSetArtifactId);
                    boolean jobIsRunning = false;
                    if (currentImagingSetStatus != null && (currentImagingSetStatus.getJobExists().booleanValue() || currentImagingSetStatus.getStatus().equals("Submitting"))) {
                        jobIsRunning = true;
                        if (this.existingImagingJobAction == ExistingImagingJobAction.STOP) {
                            this.addExecutionLog(this.iu.getString("RelativityRunImagingSetOperation.Info.JobIsRunningStopping"));
                            ImagingJobStopResult imagingJobStopResult = this.relativityRestClient.stopImagingJob(workspaceArtifactId, currentImagingSetStatus.getJobArtifactId());
                            if (!imagingJobStopResult.getSuccess().booleanValue()) {
                                if (imagingJobStopResult.getErrorMessage() != null && !imagingJobStopResult.getErrorMessage().trim().equals("")) {
                                    throw new Exception(this.iu.getFormattedString("RelativityRunImagingSetOperation.Exception.ErrorStopping", (Object)imagingJobStopResult.getErrorMessage()));
                                }
                                throw new Exception(this.iu.getString("RelativityRunImagingSetOperation.Exception.UnexpectedErrorStopping"));
                            }
                            this.addExecutionLog(this.iu.getString("RelativityRunImagingSetOperation.Info.StoppedImagingJob"));
                            jobIsRunning = false;
                        } else {
                            this.addExecutionLog(this.iu.getString("RelativityRunImagingSetOperation.Info.JobIsRunningSkipping"));
                        }
                    }
                    if (!jobIsRunning) {
                        this.stageName = this.iu.getString("RelativityRunImagingSetOperation.Stage.RunningImagingSet");
                        this.percentageComplete = 0.25;
                        if (this.qcEnabled) {
                            this.addExecutionLog(this.iu.getString("RelativityRunImagingSetOperation.Info.QcEnabled"));
                        }
                        Long imagingSetJobId = this.relativityRestClient.runImagingSet(workspaceArtifactId, imagingSetArtifactId, this.qcEnabled);
                        this.addExecutionLog(this.iu.getFormattedString("RelativityRunImagingSetOperation.Info.ImagingSetJobId", new Object[]{String.valueOf(imagingSetJobId)}));
                    }
                    ImagingSetStatus status = null;
                    if (this.waitForCompletion) {
                        this.addExecutionLog(this.iu.getString("RelativityRunImagingSetOperation.Info.WaitForCompletion"));
                        int iter = 0;
                        while (true) {
                            if (this.stopRequested) {
                                throw new WorkflowExecutionStopRequested();
                            }
                            status = this.relativityRestClient.getImagingSetStatus(workspaceArtifactId, imagingSetArtifactId);
                            if (status != null) {
                                if (status.getNumberOfDocuments() == null) continue;
                                if (iter == 0) {
                                    this.addExecutionLog(this.iu.getFormattedString("RelativityRunImagingSetOperation.Info.DocumentsCount", (Object)status.getNumberOfDocuments()));
                                }
                                if (!status.getJobExists().booleanValue()) {
                                    this.addExecutionLog(this.iu.getFormattedString("RelativityRunImagingSetOperation.Info.CompletedWithState", (Object)status.getJobStatus()));
                                    if (status.getNumberOfDocumentsSkipped() > 0) {
                                        this.addExecutionLog(this.iu.getFormattedString("RelativityRunImagingSetOperation.Info.SkippedDocumentsCount", (Object)status.getNumberOfDocumentsSkipped()));
                                    }
                                    if (status.getNumberOfDocumentsErrored() > 0) {
                                        this.addWarning(this.iu.getNumeralString("RelativityRunImagingSetOperation.Warning.ErrorDocumentsCount", (long)status.getNumberOfDocumentsErrored().intValue()));
                                    }
                                    break block19;
                                }
                                int totalDocumentsProcessed = status.getNumberOfDocumentsCompleted() + status.getNumberOfDocumentsSkipped() + status.getNumberOfDocumentsErrored() + status.getNumberOfDocumentsWaiting();
                                double documentsPercentage = (double)totalDocumentsProcessed / (double)status.getNumberOfDocuments().intValue() * 0.75;
                                this.stageName = this.iu.getFormattedString("RelativityRunImagingSetOperation.Stage.RunningImagingSetCount", new Object[]{totalDocumentsProcessed, status.getNumberOfDocuments()});
                                this.percentageComplete = 0.25 + documentsPercentage;
                                ++iter;
                            }
                            Thread.sleep(1000L);
                        }
                    }
                    status = this.relativityRestClient.getImagingSetStatus(workspaceArtifactId, imagingSetArtifactId);
                    if (status != null) {
                        this.addExecutionLog(this.iu.getFormattedString("RelativityRunImagingSetOperation.Info.DocumentsCount", (Object)status.getNumberOfDocuments()));
                    }
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

