/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.RelativityRunProductionSetOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.productions.RelativityProductionSetProgress;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.productions.RelativityProductionSetStatus;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.productions.RunProductionSetActionType;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RelativityRunProductionSetOperationImplementation
extends RelativityRunProductionSetOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityRunProductionSetOperation.class);
    private transient double percentageComplete;
    private transient String stageName;
    private transient Set<String> finishedJobStates = new HashSet<String>();

    @Override
    protected void startTriggered() throws Exception {
        this.finishedJobStates.add("Staging Error");
        this.finishedJobStates.add("Produced");
        this.finishedJobStates.add("Error");
        this.finishedJobStates.add("Produced With Errors");
        this.finishedJobStates.add("Error Starting Production");
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                Long workspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                this.stageName = this.iu.getString("RelativityRunProductionSetOperation.Stage.GettingProductionSet");
                this.percentageComplete = 0.1;
                List<EligibleObject> eligibleProductionSets = this.relativityRestClient.queryProductionSets(workspaceArtifactId, this.productionSetIdentifierType, this.productionSetIdentifier);
                EligibleObject eligibleProductionSet = RelativityUtils.getInstance().filterAllEligibleObject(this.productionSetIdentifier, this.productionSetIdentifierType, eligibleProductionSets, RelativityFieldType.PRODUCTION_SET);
                if (eligibleProductionSet == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityRunProductionSetOperation.Exception.MissingProductionSet", (Object)String.valueOf(this.productionSetIdentifier)));
                }
                Long productionSetArtifactId = eligibleProductionSet.getArtifactId();
                this.addExecutionLog(this.iu.getFormattedString("RelativityRunProductionSetOperation.Info.ProductionIdentifier", new Object[]{eligibleProductionSet.getName(), String.valueOf(eligibleProductionSet.getArtifactId())}));
                this.addExecutionLog(this.iu.getFormattedString("RelativityRunProductionSetOperation.Info.RunAction", (Object)this.runProductionSetActionType.toString()));
                RelativityProductionSetStatus status = this.relativityRestClient.getProductionSetStatus(workspaceArtifactId, productionSetArtifactId);
                if (status.getJobStatus().equals("Running")) {
                    throw new Exception(this.iu.getFormattedString("RelativityRunProductionSetOperation.Exception.ExistingProductionJob", (Object)eligibleProductionSet.getName()));
                }
                this.percentageComplete = 0.25;
                this.stageName = this.runProductionSetActionType == RunProductionSetActionType.STAGE || this.runProductionSetActionType == RunProductionSetActionType.STAGE_AND_RUN ? this.iu.getString("RelativityRunProductionSetOperation.Stage.StagingProduction") : this.iu.getString("RelativityRunProductionSetOperation.Stage.RunningProductionSet");
                boolean didJobStart = this.relativityRestClient.runProductionJobAction(workspaceArtifactId, productionSetArtifactId, this.runProductionSetActionType);
                RelativityProductionSetProgress progress = this.relativityRestClient.getProductionSetProgress(workspaceArtifactId, productionSetArtifactId);
                if (didJobStart && this.waitForCompletion) {
                    this.addExecutionLog(this.iu.getString("RelativityRunProductionSetOperation.Info.WaitForCompletion"));
                    int iter = 0;
                    while (true) {
                        if (this.stopRequested) {
                            throw new WorkflowExecutionStopRequested();
                        }
                        progress = this.relativityRestClient.getProductionSetProgress(workspaceArtifactId, productionSetArtifactId);
                        if (progress != null) {
                            int totalImagesBranded = progress.getImagesBranded() + progress.getImagesWithErrors();
                            if (iter == 0) {
                                if (progress.getTotalImages() != 0) {
                                    this.addExecutionLog(this.iu.getFormattedString("RelativityRunProductionSetOperation.Info.TotalImages", (Object)String.valueOf(progress.getTotalImages())));
                                }
                                if (progress.getTotalDocuments() != 0) {
                                    this.addExecutionLog(this.iu.getFormattedString("RelativityRunProductionSetOperation.Info.TotalDocuments", (Object)String.valueOf(progress.getTotalDocuments())));
                                }
                                iter = 2;
                            }
                            if (progress.getTotalImages() > 0) {
                                this.stageName = this.iu.getFormattedString("RelativityRunProductionSetOperation.Stage.RunningProductionSetDetailed", new Object[]{totalImagesBranded, progress.getTotalImages()});
                            }
                            this.percentageComplete = 0.25 + (double)totalImagesBranded / (double)progress.getTotalDocuments().intValue() * 0.75;
                            if (this.finishedJobStates.contains(progress.getStatus())) break;
                        }
                        Thread.sleep(1000L);
                    }
                    if (progress.getStatus() != null && !progress.getStatus().trim().equals("")) {
                        if (progress.getStatus().contains("Error") || progress.getStatus().contains("error")) {
                            status = this.relativityRestClient.getProductionSetStatus(workspaceArtifactId, productionSetArtifactId);
                            if (status.getLastRunError() != null && !status.getLastRunError().trim().equals("")) {
                                throw new Exception(status.getLastRunError());
                            }
                            throw new Exception(this.iu.getFormattedString("RelativityRunProductionSetOperation.Exception.ProductionFailed", (Object)progress.getStatus()));
                        }
                        this.addExecutionLog(this.iu.getFormattedString("RelativityRunProductionSetOperation.Info.ProductionFinishedWithStatus", (Object)progress.getStatus()));
                    }
                    if (progress.getBeginBates() != null && !progress.getBeginBates().trim().equals("")) {
                        this.addExecutionLog(this.iu.getFormattedString("RelativityRunProductionSetOperation.Info.BeginBates", (Object)progress.getBeginBates()));
                    }
                    if (progress.getEndBates() != null && !progress.getEndBates().trim().equals("")) {
                        this.addExecutionLog(this.iu.getFormattedString("RelativityRunProductionSetOperation.Info.EndBates", (Object)progress.getEndBates()));
                    }
                    if (progress.getDocumentsWithImages() != null && progress.getDocumentsWithImages() != 0) {
                        this.addExecutionLog(this.iu.getFormattedString("RelativityRunProductionSetOperation.Info.DocsWithImages", (Object)String.valueOf(progress.getDocumentsWithImages())));
                    }
                    if (progress.getDocumentsWithNatives() != null && progress.getDocumentsWithNatives() != 0) {
                        this.addExecutionLog(this.iu.getFormattedString("RelativityRunProductionSetOperation.Info.DocsWithNatives", (Object)String.valueOf(progress.getDocumentsWithNatives())));
                    }
                    if (progress.getDocumentsWithPlaceHolders() != null && progress.getDocumentsWithPlaceHolders() != 0) {
                        this.addExecutionLog(this.iu.getFormattedString("RelativityRunProductionSetOperation.Info.DocsWithPlaceholders", (Object)String.valueOf(progress.getDocumentsWithPlaceHolders())));
                    }
                    if (progress.getDocumentsWithRedactions() != null && progress.getDocumentsWithRedactions() != 0) {
                        this.addExecutionLog(this.iu.getFormattedString("RelativityRunProductionSetOperation.Info.DocsWithRedactions", (Object)String.valueOf(progress.getDocumentsWithRedactions())));
                    }
                    if (progress.getImageSizeInGb() != null && progress.getImageSizeInGb().floatValue() != 0.0f) {
                        String size = String.format("%.2f", progress.getImageSizeInGb());
                        this.addExecutionLog(this.iu.getFormattedString("RelativityRunProductionSetOperation.Info.TotalImageSizeGB", (Object)size));
                    }
                    if (progress.getProductionRunDate() != null && !progress.getProductionRunDate().trim().equals("")) {
                        this.addExecutionLog(this.iu.getFormattedString("RelativityRunProductionSetOperation.Info.RunDate", (Object)progress.getProductionRunDate()));
                    }
                }
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

