/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.RelativityIdentifierType;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ConfigureRelativityConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RelativityOperation;
import com.nuix.automate.workflow.core.execution.operations.RelativitySetWorkspaceOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RunSavedSearchOption;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldRows(value={@FormFieldRow(name="searchContainerIdentifierRow", children={"searchContainerIdentifierType", "searchContainerIdentifier"}, visibleOn={@OnField(name="runOptions", value={"SEARCH_CONTAINER"})}), @FormFieldRow(name="savedSearchIdentifierRow", children={"savedSearchIdentifierType", "savedSearchIdentifier"}, visibleOn={@OnField(name="runOptions", value={"SINGLE"})})})
@FormFieldGroup(name="reportingGroup", children={"writeReport", "reportLocation", "customReportTemplatePath"})
@OperationMetadata(alias=OperationAlias.RELATIVITY_RUN_SAVED_SEARCH, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"RELATIVITY"}), @OperationTag(name="Category", value={"SEARCH"})})
@OperationParameter(label="queryRetrieveResultsJson", parameter="{relativity_run_saved_search_results_json}")
@OperationLicenseModule(module=ModuleType.RELATIVITY_ADVANCED)
public class RelativityRunSavedSearchOperation
extends RelativityOperation {
    @FormField
    public RunSavedSearchOption runOptions;
    @FormField(allowedValues={"ARTIFACT_ID", "NAME", "NAME_REGEX"})
    public RelativityIdentifierType searchContainerIdentifierType;
    @FormField
    public String searchContainerIdentifier;
    @FormField(allowedValues={"ARTIFACT_ID", "NAME", "NAME_REGEX"})
    public RelativityIdentifierType savedSearchIdentifierType;
    @FormField
    public String savedSearchIdentifier;
    @FormField
    public boolean writeReport;
    @FormField(enableOn={@OnField(name="writeReport")})
    public String reportLocation;
    @FormField(required=false, enableOn={@OnField(name="writeReport")})
    public String customReportTemplatePath;

    public boolean getDisplaySearchContainerIdentifierType() {
        return this.runOptions == RunSavedSearchOption.SEARCH_CONTAINER;
    }

    public boolean getDisplaySearchContainerIdentifier() {
        return this.runOptions == RunSavedSearchOption.SEARCH_CONTAINER;
    }

    public boolean getDisplaySavedSearchIdentifierType() {
        return this.runOptions == RunSavedSearchOption.SINGLE;
    }

    public boolean getDisplaySavedSearchIdentifier() {
        return this.runOptions == RunSavedSearchOption.SINGLE;
    }

    public boolean getDisplayReportLocation() {
        return this.writeReport;
    }

    public boolean getDisplayCustomReportTemplatePath() {
        return this.writeReport;
    }

    public RelativityRunSavedSearchOperation() {
        this.requiresCase = false;
        this.runOptions = RunSavedSearchOption.WORKSPACE;
        this.searchContainerIdentifierType = RelativityIdentifierType.NAME;
        this.searchContainerIdentifier = "";
        this.savedSearchIdentifierType = RelativityIdentifierType.NAME;
        this.savedSearchIdentifier = "";
        this.writeReport = false;
        this.reportLocation = "";
        this.customReportTemplatePath = "";
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("RelativityRunSavedSearchOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedConfigureRelativityConnectionOperation = false;
        boolean detectedSetRelativityWorkspaceOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof ConfigureRelativityConnectionOperation) {
                detectedConfigureRelativityConnectionOperation = true;
            }
            if (o instanceof RelativitySetWorkspaceOperation) {
                detectedSetRelativityWorkspaceOperation = true;
            }
            if (o == this) break;
        }
        if (!detectedConfigureRelativityConnectionOperation) {
            prerequisites.add(this.iu.getString("ConfigureRelativityConnectionOperation.Prerequisites.Missing"));
        }
        if (!detectedSetRelativityWorkspaceOperation) {
            prerequisites.add(this.iu.getString("RelativitySetWorkspaceOperation.Prerequisites.Missing"));
        }
        if (this.runOptions == RunSavedSearchOption.SINGLE && (this.savedSearchIdentifier == null || this.savedSearchIdentifier.trim().equals(""))) {
            prerequisites.add(this.iu.getString("RelativityRunSavedSearchOperation.Prerequisites.MissingSavedSearchIdentifier"));
        }
        if (this.runOptions == RunSavedSearchOption.SEARCH_CONTAINER && (this.searchContainerIdentifier == null || this.searchContainerIdentifier.trim().equals(""))) {
            prerequisites.add(this.iu.getString("RelativityRunSavedSearchOperation.Prerequisites.MissingSearchContainerIdentifier"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

