/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldColumn;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.RelativityIdentifierType;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ConfigureRelativityConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RelativityOperation;
import com.nuix.automate.workflow.core.execution.operations.RelativitySetWorkspaceOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceIdentifierType;
import com.nuix.automate.workflow.core.execution.options.relativityscript.RelativityScriptExportType;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import com.nuix.automate.workflow.core.utils.general.OsUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldRow(name="scriptIdentifierRow", children={"scriptIdentifierType", "scriptIdentifier"})
@FormFieldGroup(name="outputGroup", children={"writeOutput", "outputLocation", "customOutputTemplatePath"})
@OperationMetadata(alias=OperationAlias.RELATIVITY_RUN_SCRIPT, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"RELATIVITY"}), @OperationTag(name="Category", value={"SCRIPT"})})
@OperationParameter(label="queryRetrieveRelativityScriptError", parameter="{last_relativity_script_error}")
@OperationLicenseModule(module=ModuleType.RELATIVITY_ADVANCED)
public class RelativityRunScriptOperation
extends RelativityOperation {
    @FormField(allowedValues={"ARTIFACT_ID", "NAME", "NAME_REGEX"})
    public RelativityIdentifierType scriptIdentifierType;
    @FormField
    public String scriptIdentifier;
    @FormField(allowedValues={"CURRENT_WORKSPACE", "ADMIN_WORKSPACE"})
    public WorkspaceIdentifierType scriptLocation;
    public Boolean runScriptInWorkspace;
    @FormField(required=false, columnFields={@FormFieldColumn(label="inputId"), @FormFieldColumn(label="value")})
    public List<Object[]> parameterValues;
    public RelativityScriptExportType exportType;
    public String exportPath;
    @FormField
    public boolean writeOutput;
    @FormField(enableOn={@OnField(name="writeOutput")})
    public String outputLocation;
    @FormField(required=false, enableOn={@OnField(name="writeOutput")})
    public String customOutputTemplatePath;

    public boolean getDisplayOutputLocation() {
        return this.writeOutput;
    }

    public boolean getDisplayCustomOutputTemplatePath() {
        return this.writeOutput;
    }

    public RelativityRunScriptOperation() {
        this.requiresCase = false;
        this.scriptIdentifierType = RelativityIdentifierType.NAME;
        this.scriptIdentifier = "";
        this.scriptLocation = WorkspaceIdentifierType.CURRENT_WORKSPACE;
        this.exportType = RelativityScriptExportType.CSV;
        this.exportPath = OsUtils.getOsWindows() ? "C:\\Temp\\RelativityScriptOutput.csv" : "/tmp/RelativityScriptOutput.csv";
        this.parameterValues = new ArrayList<Object[]>();
        this.writeOutput = false;
        this.outputLocation = "";
        this.customOutputTemplatePath = "";
    }

    @Override
    public void normalize() {
        super.normalize();
        if (this.exportPath != null && !this.exportPath.trim().equals("") && this.outputLocation.trim().equals("")) {
            this.writeOutput = true;
            this.outputLocation = this.exportPath;
        }
        if (this.runScriptInWorkspace != null) {
            this.scriptLocation = this.runScriptInWorkspace != false ? WorkspaceIdentifierType.CURRENT_WORKSPACE : WorkspaceIdentifierType.ADMIN_WORKSPACE;
        }
        this.runScriptInWorkspace = null;
        this.exportPath = null;
        this.exportType = null;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("RelativityScriptOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedConfigureRelativityConnectionOperation = false;
        boolean detectedSetRelativityWorkspaceOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof ConfigureRelativityConnectionOperation) {
                detectedConfigureRelativityConnectionOperation = true;
            }
            if (o instanceof RelativitySetWorkspaceOperation) {
                detectedSetRelativityWorkspaceOperation = true;
            }
            if (o == this) break;
        }
        if (!detectedConfigureRelativityConnectionOperation) {
            prerequisites.add(this.iu.getString("ConfigureRelativityConnectionOperation.Prerequisites.Missing"));
        }
        if (!detectedSetRelativityWorkspaceOperation && this.scriptLocation == WorkspaceIdentifierType.CURRENT_WORKSPACE) {
            prerequisites.add(this.iu.getString("RelativitySetWorkspaceOperation.Prerequisites.Missing"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

